/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.control;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.arguments.AccessIndexedArgumentNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorRejectNode;
import com.oracle.truffle.js.nodes.control.AsyncGeneratorResolveNode;
import com.oracle.truffle.js.nodes.control.TryCatchNode;
import com.oracle.truffle.js.nodes.function.InternalCallNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.nodes.promise.NewPromiseCapabilityNode;
import com.oracle.truffle.js.nodes.promise.PerformPromiseThenNode;
import com.oracle.truffle.js.nodes.promise.PromiseResolveNode;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSFrameUtil;
import com.oracle.truffle.js.runtime.JavaScriptRootNode;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.JSAsyncGeneratorObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSFunctionData;
import com.oracle.truffle.js.runtime.builtins.JSFunctionObject;
import com.oracle.truffle.js.runtime.builtins.JSPromiseObject;
import com.oracle.truffle.js.runtime.objects.AsyncGeneratorRequest;
import com.oracle.truffle.js.runtime.objects.Completion;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.PromiseCapabilityRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.util.ArrayDeque;

public class AsyncGeneratorResumeNextNode
extends JavaScriptBaseNode {
    @Node.Child
    private JSFunctionCallNode callPromiseResolveNode;
    @Node.Child
    private PerformPromiseThenNode performPromiseThenNode;
    @Node.Child
    private NewPromiseCapabilityNode newPromiseCapabilityNode;
    @Node.Child
    private AsyncGeneratorResolveNode asyncGeneratorResolveNode;
    @Node.Child
    private AsyncGeneratorRejectNode asyncGeneratorRejectNode;
    @Node.Child
    private PropertySetNode setGeneratorNode;
    @Node.Child
    private PromiseResolveNode promiseResolveNode;
    @Node.Child
    private TryCatchNode.GetErrorObjectNode getErrorObjectNode;
    private final ConditionProfile abruptProf = ConditionProfile.create();
    protected final JSContext context;
    static final HiddenKey RETURN_PROCESSOR_GENERATOR = new HiddenKey("Generator");

    protected AsyncGeneratorResumeNextNode(JSContext context2) {
        this.context = context2;
        this.asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(context2);
    }

    public static AsyncGeneratorResumeNextNode create(JSContext context2) {
        return new WithCall(context2);
    }

    public static AsyncGeneratorResumeNextNode createTailCall(JSContext context2) {
        return new AsyncGeneratorResumeNextNode(context2);
    }

    public final Object execute(VirtualFrame frame, JSAsyncGeneratorObject generator) {
        AsyncGeneratorRequest next;
        JSFunction.AsyncGeneratorState state;
        while (true) {
            state = generator.getAsyncGeneratorState();
            assert (state != JSFunction.AsyncGeneratorState.Executing);
            if (state == JSFunction.AsyncGeneratorState.AwaitingReturn) {
                return Undefined.instance;
            }
            ArrayDeque<AsyncGeneratorRequest> queue = generator.getAsyncGeneratorQueue();
            if (queue.isEmpty()) {
                return Undefined.instance;
            }
            next = queue.peekFirst();
            if (this.abruptProf.profile(next.isAbruptCompletion())) {
                if (state == JSFunction.AsyncGeneratorState.SuspendedStart) {
                    state = JSFunction.AsyncGeneratorState.Completed;
                    generator.setAsyncGeneratorState(state);
                }
                if (state != JSFunction.AsyncGeneratorState.Completed) break;
                if (next.isReturn()) {
                    JSPromiseObject promise;
                    this.enterReturnBranch();
                    generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.AwaitingReturn);
                    try {
                        promise = this.promiseResolve(next.getCompletionValue());
                    }
                    catch (AbstractTruffleException e) {
                        this.asyncGeneratorRejectBrokenPromise(frame, generator, e);
                        continue;
                    }
                    JSFunctionObject onFulfilled = this.createAsyncGeneratorReturnProcessorFulfilledFunction(generator);
                    JSFunctionObject onRejected = this.createAsyncGeneratorReturnProcessorRejectedFunction(generator);
                    PromiseCapabilityRecord throwawayCapability = this.newThrowawayCapability();
                    this.performPromiseThenNode.execute(promise, onFulfilled, onRejected, throwawayCapability);
                    return Undefined.instance;
                }
                assert (next.isThrow());
                this.enterThrowBranch();
                this.asyncGeneratorRejectNode.performReject(frame, generator, next.getCompletionValue());
                continue;
            }
            if (state != JSFunction.AsyncGeneratorState.Completed) break;
            this.asyncGeneratorResolveNode.performResolve(frame, generator, Undefined.instance, true);
        }
        assert (state == JSFunction.AsyncGeneratorState.SuspendedStart || state == JSFunction.AsyncGeneratorState.SuspendedYield);
        generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Executing);
        return this.performResumeNext(generator, next.getCompletion());
    }

    private JSPromiseObject promiseResolve(Object value2) {
        if (this.context.usePromiseResolve()) {
            if (this.promiseResolveNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.promiseResolveNode = this.insert(PromiseResolveNode.create(this.context));
            }
            return (JSPromiseObject)this.promiseResolveNode.execute(this.getRealm().getPromiseConstructor(), value2);
        }
        if (this.callPromiseResolveNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callPromiseResolveNode = this.insert(JSFunctionCallNode.createCall());
        }
        PromiseCapabilityRecord promiseCapability = this.newPromiseCapability();
        this.callPromiseResolveNode.executeCall(JSArguments.createOneArg(Undefined.instance, promiseCapability.getResolve(), value2));
        return (JSPromiseObject)promiseCapability.getPromise();
    }

    protected Object performResumeNext(JSAsyncGeneratorObject generator, Completion completion) {
        return completion;
    }

    private void enterReturnBranch() {
        if (this.performPromiseThenNode == null || this.setGeneratorNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.performPromiseThenNode = this.insert(PerformPromiseThenNode.create(this.context));
            this.setGeneratorNode = this.insert(PropertySetNode.createSetHidden(RETURN_PROCESSOR_GENERATOR, this.context));
        }
    }

    private PromiseCapabilityRecord newPromiseCapability() {
        if (this.newPromiseCapabilityNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.newPromiseCapabilityNode = this.insert(NewPromiseCapabilityNode.create(this.context));
        }
        return this.newPromiseCapabilityNode.executeDefault();
    }

    private PromiseCapabilityRecord newThrowawayCapability() {
        if (this.context.getEcmaScriptVersion() >= 10) {
            return null;
        }
        PromiseCapabilityRecord throwawayCapability = this.newPromiseCapability();
        ((JSPromiseObject)throwawayCapability.getPromise()).setIsHandled(true);
        return throwawayCapability;
    }

    private void enterThrowBranch() {
        if (this.asyncGeneratorRejectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.asyncGeneratorRejectNode = this.insert(AsyncGeneratorRejectNode.create());
        }
    }

    private void asyncGeneratorRejectBrokenPromise(VirtualFrame frame, JSAsyncGeneratorObject generator, AbstractTruffleException exception) {
        if (this.getErrorObjectNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getErrorObjectNode = this.insert(TryCatchNode.GetErrorObjectNode.create(this.context));
        }
        this.enterThrowBranch();
        generator.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Completed);
        Object error = this.getErrorObjectNode.execute(exception);
        this.asyncGeneratorRejectNode.performReject(frame, generator, error);
    }

    private JSFunctionObject createAsyncGeneratorReturnProcessorFulfilledFunction(JSDynamicObject generator) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncGeneratorReturnFulfilled, c -> AsyncGeneratorResumeNextNode.createAsyncGeneratorReturnProcessorFulfilledImpl(c));
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setGeneratorNode.setValue(function, generator);
        return function;
    }

    private static JSFunctionData createAsyncGeneratorReturnProcessorFulfilledImpl(JSContext context2) {
        class AsyncGeneratorReturnFulfilledRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode valueNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private AsyncGeneratorResolveNode asyncGeneratorResolveNode = AsyncGeneratorResolveNode.create(this.val$context);
            @Node.Child
            private PropertyGetNode getGenerator = PropertyGetNode.createGetHidden(RETURN_PROCESSOR_GENERATOR, this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncGeneratorReturnFulfilledRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                JSAsyncGeneratorObject generatorObject = (JSAsyncGeneratorObject)this.getGenerator.getValue(functionObject);
                generatorObject.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Completed);
                Object value2 = this.valueNode.execute(frame);
                return this.asyncGeneratorResolveNode.execute(frame, generatorObject, value2, true);
            }
        }
        return JSFunctionData.createCallOnly(context2, new AsyncGeneratorReturnFulfilledRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private JSFunctionObject createAsyncGeneratorReturnProcessorRejectedFunction(JSDynamicObject generator) {
        JSFunctionData functionData = this.context.getOrCreateBuiltinFunctionData(JSContext.BuiltinFunctionKey.AsyncGeneratorReturnRejected, c -> AsyncGeneratorResumeNextNode.createAsyncGeneratorReturnProcessorRejectedImpl(c));
        JSFunctionObject function = JSFunction.create(this.getRealm(), functionData);
        this.setGeneratorNode.setValue(function, generator);
        return function;
    }

    private static JSFunctionData createAsyncGeneratorReturnProcessorRejectedImpl(JSContext context2) {
        class AsyncGeneratorReturnRejectedRootNode
        extends JavaScriptRootNode {
            @Node.Child
            private JavaScriptNode reasonNode = AccessIndexedArgumentNode.create(0);
            @Node.Child
            private AsyncGeneratorRejectNode asyncGeneratorRejectNode = AsyncGeneratorRejectNode.create();
            @Node.Child
            private PropertyGetNode getGenerator = PropertyGetNode.createGetHidden(RETURN_PROCESSOR_GENERATOR, this.val$context);
            final /* synthetic */ JSContext val$context;

            AsyncGeneratorReturnRejectedRootNode(JSContext jSContext) {
                this.val$context = jSContext;
            }

            @Override
            public Object execute(VirtualFrame frame) {
                JSFunctionObject functionObject = JSFrameUtil.getFunctionObject(frame);
                JSAsyncGeneratorObject generatorObject = (JSAsyncGeneratorObject)this.getGenerator.getValue(functionObject);
                generatorObject.setAsyncGeneratorState(JSFunction.AsyncGeneratorState.Completed);
                Object reason = this.reasonNode.execute(frame);
                return this.asyncGeneratorRejectNode.execute(frame, generatorObject, reason);
            }
        }
        return JSFunctionData.createCallOnly(context2, new AsyncGeneratorReturnRejectedRootNode(context2).getCallTarget(), 1, Strings.EMPTY_STRING);
    }

    private static class WithCall
    extends AsyncGeneratorResumeNextNode {
        @Node.Child
        private InternalCallNode callNode = InternalCallNode.create();

        protected WithCall(JSContext context2) {
            super(context2);
        }

        @Override
        protected Object performResumeNext(JSAsyncGeneratorObject generator, Completion completion) {
            CallTarget generatorTarget = generator.getAsyncGeneratorTarget();
            MaterializedFrame generatorContext = generator.getAsyncGeneratorContext();
            this.callNode.execute(generatorTarget, JSArguments.createResumeArguments(generatorContext, generator, completion));
            return Undefined.instance;
        }
    }
}

