/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.intl;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNode;
import com.oracle.truffle.js.nodes.intl.CoerceOptionsToObjectNodeGen;
import com.oracle.truffle.js.nodes.intl.GetBooleanOptionNode;
import com.oracle.truffle.js.nodes.intl.GetStringOptionNode;
import com.oracle.truffle.js.nodes.intl.InitializeCollatorNodeGen;
import com.oracle.truffle.js.nodes.intl.JSToCanonicalizedLocaleListNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollator;
import com.oracle.truffle.js.runtime.builtins.intl.JSCollatorObject;
import com.oracle.truffle.js.runtime.util.IntlUtil;
import java.util.MissingResourceException;

public abstract class InitializeCollatorNode
extends JavaScriptBaseNode {
    private final JSContext context;
    @Node.Child
    JSToCanonicalizedLocaleListNode toCanonicalizedLocaleListNode;
    @Node.Child
    CoerceOptionsToObjectNode coerceOptionsToObjectNode;
    @Node.Child
    GetStringOptionNode getUsageOption;
    @Node.Child
    GetStringOptionNode getLocaleMatcherOption;
    @Node.Child
    GetStringOptionNode getCollationOption;
    @Node.Child
    GetBooleanOptionNode getNumericOption;
    @Node.Child
    GetStringOptionNode getCaseFirstOption;
    @Node.Child
    GetStringOptionNode getSensitivityOption;
    @Node.Child
    GetBooleanOptionNode getIgnorePunctuationOption;
    private final BranchProfile errorBranch = BranchProfile.create();

    protected InitializeCollatorNode(JSContext context2) {
        this.context = context2;
        this.toCanonicalizedLocaleListNode = JSToCanonicalizedLocaleListNode.create(context2);
        this.coerceOptionsToObjectNode = CoerceOptionsToObjectNodeGen.create(context2);
        this.getUsageOption = GetStringOptionNode.create(context2, IntlUtil.KEY_USAGE, new String[]{"sort", "search"}, "sort");
        this.getLocaleMatcherOption = GetStringOptionNode.create(context2, IntlUtil.KEY_LOCALE_MATCHER, new String[]{"lookup", "best fit"}, "best fit");
        this.getCollationOption = GetStringOptionNode.create(context2, IntlUtil.KEY_COLLATION, null, null);
        this.getNumericOption = GetBooleanOptionNode.create(context2, IntlUtil.KEY_NUMERIC, null);
        this.getCaseFirstOption = GetStringOptionNode.create(context2, IntlUtil.KEY_CASE_FIRST, new String[]{"upper", "lower", "false"}, null);
        this.getSensitivityOption = GetStringOptionNode.create(context2, IntlUtil.KEY_SENSITIVITY, new String[]{"base", "accent", "case", "variant"}, null);
        this.getIgnorePunctuationOption = GetBooleanOptionNode.create(context2, IntlUtil.KEY_IGNORE_PUNCTUATION, false);
    }

    public abstract JSCollatorObject executeInit(JSCollatorObject var1, Object var2, Object var3);

    public static InitializeCollatorNode createInitalizeCollatorNode(JSContext context2) {
        return InitializeCollatorNodeGen.create(context2);
    }

    @Specialization
    public JSCollatorObject initializeCollator(JSCollatorObject collatorObj, Object localesArg, Object optionsArg) {
        try {
            JSCollator.InternalState state = JSCollator.getInternalState(collatorObj);
            String[] locales = this.toCanonicalizedLocaleListNode.executeLanguageTags(localesArg);
            Object options = this.coerceOptionsToObjectNode.execute(optionsArg);
            String usage = this.getUsageOption.executeValue(options);
            String optLocaleMatcher = this.getLocaleMatcherOption.executeValue(options);
            String optco = this.getCollationOption.executeValue(options);
            if (optco != null) {
                IntlUtil.validateUnicodeLocaleIdentifierType(optco, this.errorBranch);
            }
            Boolean optkn = this.getNumericOption.executeValue(options);
            String optkf = this.getCaseFirstOption.executeValue(options);
            String sensitivity = this.getSensitivityOption.executeValue(options);
            boolean ignorePunctuation = this.getIgnorePunctuationOption.executeValue(options);
            JSCollator.initializeCollator(this.context, state, locales, usage, optLocaleMatcher, optco, optkn, optkf, sensitivity, ignorePunctuation);
        }
        catch (MissingResourceException e) {
            this.errorBranch.enter();
            throw Errors.createICU4JDataError(e);
        }
        return collatorObj;
    }
}

