/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.RegexBodyNode;
import com.oracle.truffle.regex.RegexLanguage;
import com.oracle.truffle.regex.RegexProfile;
import com.oracle.truffle.regex.RegexSource;
import com.oracle.truffle.regex.result.RegexResult;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorEntryNode;

public class TRegexLazyCaptureGroupsRootNode
extends RegexBodyNode {
    @Node.Child
    private TRegexExecutorEntryNode entryNode;
    @Node.Child
    private DirectCallNode findStartCallNode;
    private final RegexProfile.TracksRegexProfile profiler;
    private final CallTarget findStartCallTarget;

    public TRegexLazyCaptureGroupsRootNode(RegexLanguage language, RegexSource source, TRegexExecutorEntryNode captureGroupNode, RegexProfile.TracksRegexProfile profiler, CallTarget findStartCallTarget) {
        super(language, source);
        this.entryNode = this.insert(captureGroupNode);
        this.profiler = profiler;
        this.findStartCallTarget = findStartCallTarget;
        if (findStartCallTarget != null) {
            this.findStartCallNode = this.insert(DirectCallNode.create(findStartCallTarget));
        }
    }

    @Override
    public final Void execute(VirtualFrame frame) {
        Object[] args = frame.getArguments();
        assert (args.length == 1);
        RegexResult receiver = (RegexResult)args[0];
        int start2 = this.findStartCallTarget != null ? (int)((Long)this.findStartCallNode.call(receiver)).longValue() : receiver.getStart();
        int[] result2 = (int[])this.entryNode.execute(frame, receiver.getInput(), receiver.getFromIndex(), start2, receiver.getEnd());
        if (CompilerDirectives.inInterpreter()) {
            RegexProfile profile = this.profiler.getRegexProfile();
            profile.profileCaptureGroupAccess(result2[1] - result2[0], result2[1] - (receiver.getFromIndex() + 1));
        }
        receiver.setResult(result2);
        return null;
    }

    @Override
    protected String getEngineLabel() {
        return "TRegex cg";
    }
}

