/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.shadowed.com.ibm.icu.impl.breakiter;

import java.text.CharacterIterator;
import org.graalvm.shadowed.com.ibm.icu.impl.Assert;
import org.graalvm.shadowed.com.ibm.icu.impl.breakiter.DictionaryMatcher;
import org.graalvm.shadowed.com.ibm.icu.text.UCharacterIterator;
import org.graalvm.shadowed.com.ibm.icu.util.BytesTrie;

class BytesDictionaryMatcher
extends DictionaryMatcher {
    private final byte[] characters;
    private final int transform;

    public BytesDictionaryMatcher(byte[] chars, int transform2) {
        this.characters = chars;
        Assert.assrt((transform2 & 0x7F000000) == 0x1000000);
        this.transform = transform2;
    }

    private int transform(int c) {
        if (c == 8205) {
            return 255;
        }
        if (c == 8204) {
            return 254;
        }
        int delta = c - (this.transform & 0x1FFFFF);
        if (delta < 0 || 253 < delta) {
            return -1;
        }
        return delta;
    }

    @Override
    public int matches(CharacterIterator text_, int maxLength, int[] lengths, int[] count_, int limit, int[] values) {
        UCharacterIterator text2 = UCharacterIterator.getInstance(text_);
        BytesTrie bt = new BytesTrie(this.characters, 0);
        int c = text2.nextCodePoint();
        if (c == -1) {
            return 0;
        }
        BytesTrie.Result result2 = bt.first(this.transform(c));
        int numChars = 1;
        int count = 0;
        while (true) {
            if (result2.hasValue()) {
                if (count < limit) {
                    if (values != null) {
                        values[count] = bt.getValue();
                    }
                    lengths[count] = numChars;
                    ++count;
                }
                if (result2 == BytesTrie.Result.FINAL_VALUE) {
                    break;
                }
            } else if (result2 == BytesTrie.Result.NO_MATCH) break;
            if (numChars >= maxLength || (c = text2.nextCodePoint()) == -1) break;
            ++numChars;
            result2 = bt.next(this.transform(c));
        }
        count_[0] = count;
        return numChars;
    }

    @Override
    public int getType() {
        return 0;
    }
}

