/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.github.ultimate.features.log;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.github.ultimate.features.i18n.GithubUltimateBundle;
import com.intellij.vcs.github.ultimate.features.log.GHLogCommitStatusManager;
import com.intellij.vcs.github.ultimate.features.log.GitHubCommitStatus;
import com.intellij.vcs.github.ultimate.features.log.GitHubCommitStatusService;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusPresentation;
import com.intellij.vcs.log.ui.frame.VcsCommitExternalStatusProvider;
import com.intellij.vcs.log.ui.table.column.util.VcsLogExternalStatusColumnService;
import com.intellij.vcs.log.util.VcsLogUtil;
import git4idea.GitVcs;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001!B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001e\u0010\u0014\u001a\u00020\n2\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0002H\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020 H\u0014R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u000bR\u001e\u0010\f\u001a\f0\u0006\u00a2\u0006\u0002\b\r\u00a2\u0006\u0002\b\u000eX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\bR\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\""}, d2={"Lcom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatusProvider;", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusProvider$WithColumn;", "Lcom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatus;", "<init>", "()V", "id", "", "getId", "()Ljava/lang/String;", "isColumnEnabledByDefault", "", "()Z", "columnName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getColumnName", "service", "Lcom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatusService;", "getService", "()Lcom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatusService;", "isColumnAvailable", "project", "Lcom/intellij/openapi/project/Project;", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPresentation", "Lcom/intellij/vcs/log/ui/frame/VcsCommitExternalStatusPresentation;", "status", "getExternalStatusColumnService", "Lcom/intellij/vcs/log/ui/table/column/util/VcsLogExternalStatusColumnService;", "getStubStatus", "Lcom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatus$NotLoaded;", "Companion", "intellij.vcs.github.ultimate.features"})
@SourceDebugExtension(value={"SMAP\nGitHubCommitStatusProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitHubCommitStatusProvider.kt\ncom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatusProvider\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n40#2,3:204\n31#3,2:207\n19#4:209\n1#5:210\n*S KotlinDebug\n*F\n+ 1 GitHubCommitStatusProvider.kt\ncom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatusProvider\n*L\n48#1:204,3\n52#1:207,2\n56#1:209\n*E\n"})
public final class GitHubCommitStatusProvider
extends VcsCommitExternalStatusProvider.WithColumn<GitHubCommitStatus> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final boolean isColumnEnabledByDefault;
    @NotNull
    private final String columnName;
    @NotNull
    private static final String ID = "GitHub.CommitStatus";

    public GitHubCommitStatusProvider() {
        this.id = ID;
        this.isColumnEnabledByDefault = true;
        String string = GithubUltimateBundle.message("vcs.log.github.commit.status.column.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        this.columnName = string;
    }

    @NotNull
    public String getId() {
        return this.id;
    }

    protected boolean isColumnEnabledByDefault() {
        return this.isColumnEnabledByDefault;
    }

    @NotNull
    protected String getColumnName() {
        return this.columnName;
    }

    private final GitHubCommitStatusService getService() {
        boolean $i$f$service = false;
        Class<GitHubCommitStatusService> serviceClass$iv = GitHubCommitStatusService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        return (GitHubCommitStatusService)((Object)object);
    }

    public boolean isColumnAvailable(@NotNull Project project, @NotNull Collection<? extends VirtualFile> roots) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(roots, (String)"roots");
        if (!VcsLogUtil.isProjectLogForVcs((Project)project, roots, (AbstractVcs)((AbstractVcs)GitVcs.getInstance((Project)project)))) {
            return false;
        }
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GHLogCommitStatusManager> serviceClass$iv = GHLogCommitStatusManager.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((GHLogCommitStatusManager)object).isColumnAvailable(project);
    }

    @Nullable
    public VcsCommitExternalStatusPresentation getPresentation(@NotNull Project project, @NotNull GitHubCommitStatus status) {
        VcsCommitExternalStatusPresentation vcsCommitExternalStatusPresentation;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)status, (String)"status");
        GitHubCommitStatus $this$asSafely$iv = status;
        boolean $i$f$asSafely = false;
        GitHubCommitStatus gitHubCommitStatus = $this$asSafely$iv;
        if (!(gitHubCommitStatus instanceof GitHubCommitStatus.Loaded)) {
            gitHubCommitStatus = null;
        }
        GitHubCommitStatus.Loaded loaded = (GitHubCommitStatus.Loaded)gitHubCommitStatus;
        if (loaded != null) {
            GitHubCommitStatus.Loaded loaded2 = loaded;
            GitHubCommitStatusService gitHubCommitStatusService = this.getService();
            GitHubCommitStatus.Loaded p0 = loaded2;
            boolean bl = false;
            vcsCommitExternalStatusPresentation = gitHubCommitStatusService.createPresentation(p0);
        } else {
            vcsCommitExternalStatusPresentation = null;
        }
        return vcsCommitExternalStatusPresentation;
    }

    @NotNull
    protected VcsLogExternalStatusColumnService<GitHubCommitStatus> getExternalStatusColumnService() {
        return this.getService();
    }

    @NotNull
    protected GitHubCommitStatus.NotLoaded getStubStatus() {
        return GitHubCommitStatus.NotLoaded.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/vcs/github/ultimate/features/log/GitHubCommitStatusProvider$Companion;", "", "<init>", "()V", "ID", "", "intellij.vcs.github.ultimate.features"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

