/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.collaboration.ui.SimpleEventListener;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.EventDispatcher;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ObservableProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListUpdatesChecker;
import org.jetbrains.plugins.github.util.GithubUtil;
import org.jetbrains.plugins.github.util.NonReusableEmptyProgressIndicator;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 .2\u00020\u0001:\u0001.B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010#\u001a\u00020$H\u0016J\u0012\u0010%\u001a\u0004\u0018\u00010\u001f2\u0006\u0010&\u001a\u00020\u001dH\u0002J\b\u0010'\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020$H\u0016J\u001e\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020+2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020$0-H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u0015\u0012\f\u0012\n \u000f*\u0004\u0018\u00010\u000e0\u000e0\r\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00128V@RX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0018\u0010\u0019\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010 \u001a\u0004\u0018\u00010\u001f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListETagUpdateChecker;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "<init>", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GHRepositoryPath;)V", "outdatedEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/collaboration/ui/SimpleEventListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "<set-?>", "", "outdated", "getOutdated", "()Z", "setOutdated", "(Z)V", "outdated$delegate", "Lkotlin/properties/ObservableProperty;", "scheduler", "Ljava/util/concurrent/ScheduledFuture;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "value", "", "lastETag", "setLastETag", "(Ljava/lang/String;)V", "start", "", "loadListETag", "indicator", "stop", "dispose", "addOutdatedStateChangeListener", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function0;", "Companion", "intellij.vcs.github"})
public final class GHPRListETagUpdateChecker
implements GHPRListUpdatesChecker {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GithubServerPath serverPath;
    @NotNull
    private final GHRepositoryPath repoPath;
    @NotNull
    private final EventDispatcher<SimpleEventListener> outdatedEventDispatcher;
    @NotNull
    private final ObservableProperty outdated$delegate;
    @Nullable
    private ScheduledFuture<?> scheduler;
    @Nullable
    private ProgressIndicator progressIndicator;
    @Nullable
    private volatile String lastETag;
    @NotNull
    private static final String REFRESH_SECONDS_KEY = "github.pr.list.automatic.refresh.seconds";

    public GHPRListETagUpdateChecker(@NotNull ProgressManager progressManager, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GithubServerPath serverPath, @NotNull GHRepositoryPath repoPath) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
        this.progressManager = progressManager;
        this.requestExecutor = requestExecutor;
        this.serverPath = serverPath;
        this.repoPath = repoPath;
        EventDispatcher eventDispatcher = EventDispatcher.create(SimpleEventListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.outdatedEventDispatcher = eventDispatcher;
        this.outdated$delegate = GithubUtil.Delegates.INSTANCE.observableField(false, this.outdatedEventDispatcher);
    }

    @Override
    public boolean getOutdated() {
        return (Boolean)this.outdated$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private void setOutdated(boolean bl) {
        this.outdated$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    private final void setLastETag(String value) {
        String current = this.lastETag;
        ActionsKt.runInEdt$default(null, () -> GHPRListETagUpdateChecker._set_lastETag_$lambda$0(this, current, value), (int)1, null);
        this.lastETag = value;
    }

    @Override
    public void start() {
        if (this.scheduler == null) {
            long secondsBetweenRefreshes = Registry.Companion.get(REFRESH_SECONDS_KEY).asInteger();
            NonReusableEmptyProgressIndicator indicator = new NonReusableEmptyProgressIndicator();
            this.progressIndicator = (ProgressIndicator)indicator;
            this.scheduler = JobScheduler.getScheduler().scheduleWithFixedDelay(() -> GHPRListETagUpdateChecker.start$lambda$1(this, indicator), secondsBetweenRefreshes, secondsBetweenRefreshes, TimeUnit.SECONDS);
        }
    }

    private final String loadListETag(ProgressIndicator indicator) {
        return (String)this.progressManager.runProcess(() -> GHPRListETagUpdateChecker.loadListETag$lambda$2(this, indicator), indicator);
    }

    @Override
    public void stop() {
        ScheduledFuture<?> scheduledFuture = this.scheduler;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        this.scheduler = null;
        ProgressIndicator progressIndicator = this.progressIndicator;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        this.progressIndicator = (ProgressIndicator)new NonReusableEmptyProgressIndicator();
        this.setLastETag(null);
    }

    public void dispose() {
        block1: {
            ScheduledFuture<?> scheduledFuture = this.scheduler;
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            ProgressIndicator progressIndicator = this.progressIndicator;
            if (progressIndicator == null) break block1;
            progressIndicator.cancel();
        }
    }

    @Override
    public void addOutdatedStateChangeListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        SimpleEventListener.Companion.addDisposableListener(this.outdatedEventDispatcher, disposable, listener2);
    }

    private static final Unit _set_lastETag_$lambda$0(GHPRListETagUpdateChecker this$0, String $current, String $value) {
        this$0.setOutdated($current != null && $value != null && !Intrinsics.areEqual((Object)$current, (Object)$value));
        return Unit.INSTANCE;
    }

    private static final void start$lambda$1(GHPRListETagUpdateChecker this$0, NonReusableEmptyProgressIndicator $indicator) {
        try {
            this$0.setLastETag(this$0.loadListETag((ProgressIndicator)$indicator));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static final String loadListETag$lambda$2(GHPRListETagUpdateChecker this$0, ProgressIndicator $indicator) {
        return this$0.requestExecutor.execute($indicator, GithubApiRequests.Repos.PullRequests.getListETag(this$0.serverPath, this$0.repoPath));
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GHPRListETagUpdateChecker.class, "outdated", "getOutdated()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListETagUpdateChecker$Companion;", "", "<init>", "()V", "REFRESH_SECONDS_KEY", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

