/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import git4idea.DialogManager;
import git4idea.branch.GitRebaseParams;
import git4idea.config.GitVersion;
import git4idea.history.GitHistoryTraverser;
import git4idea.history.GitHistoryTraverserImpl;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSquashedCommitsMessage;
import git4idea.rebase.interactive.CantRebaseUsingLogException;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogEditorHandler;
import git4idea.rebase.interactive.GitRebaseEntryGeneratedUsingLog;
import git4idea.rebase.interactive.dialog.GitInteractiveRebaseDialog;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a$\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0000\u001a\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\tH\u0000\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getEntriesUsingLog", "", "Lgit4idea/rebase/interactive/GitRebaseEntryGeneratedUsingLog;", "repository", "Lgit4idea/repo/GitRepository;", "commit", "Lcom/intellij/vcs/log/VcsShortCommitDetails;", "logData", "Lcom/intellij/vcs/log/data/VcsLogData;", "interactivelyRebaseUsingLog", "", "startInteractiveRebase", "editorHandler", "Lgit4idea/rebase/GitRebaseEditorHandler;", "getRebaseUpstreamFor", "Lgit4idea/branch/GitRebaseParams$RebaseUpstream;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitInteractiveRebaseUsingLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitInteractiveRebaseUsingLog.kt\ngit4idea/rebase/interactive/GitInteractiveRebaseUsingLogKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1755#2,3:181\n1557#2:184\n1628#2,3:185\n*S KotlinDebug\n*F\n+ 1 GitInteractiveRebaseUsingLog.kt\ngit4idea/rebase/interactive/GitInteractiveRebaseUsingLogKt\n*L\n57#1:181,3\n61#1:184\n61#1:185,3\n*E\n"})
public final class GitInteractiveRebaseUsingLogKt {
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final List<GitRebaseEntryGeneratedUsingLog> getEntriesUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit, @NotNull VcsLogData logData) throws CantRebaseUsingLogException {
        void $this$mapTo$iv$iv;
        boolean bl;
        List details;
        block8: {
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
            Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
            Project project = repository.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            GitHistoryTraverser traverser = new GitHistoryTraverserImpl(project, logData);
            details = new ArrayList();
            try {
                VirtualFile virtualFile = repository.getRoot();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
                GitHistoryTraverser.traverse$default(traverser, virtualFile, null, null, (arg_0, arg_1) -> GitInteractiveRebaseUsingLogKt.getEntriesUsingLog$lambda$1(traverser, commit, details, arg_0, arg_1), 6, null);
            }
            catch (VcsException e) {
                throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNRESOLVED_HASH);
            }
            if (!Intrinsics.areEqual((Object)((VcsCommitMetadata)CollectionsKt.last((List)details)).getId(), (Object)commit.getId())) {
                throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.UNEXPECTED_HASH);
            }
            Iterable $this$any$iv = details;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VcsCommitMetadata detail = (VcsCommitMetadata)element$iv;
                    boolean bl2 = false;
                    String string = detail.getSubject();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubject(...)");
                    if (!GitSquashedCommitsMessage.INSTANCE.isAutosquashCommitMessage(string)) continue;
                    bl = true;
                    break block8;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.FIXUP_SQUASH);
        }
        Iterable $this$map$iv = details;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            VcsCommitMetadata vcsCommitMetadata = (VcsCommitMetadata)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(new GitRebaseEntryGeneratedUsingLog((VcsCommitMetadata)it));
        }
        return CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
    }

    public static final void interactivelyRebaseUsingLog(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit, @NotNull VcsLogData logData) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Intrinsics.checkNotNullParameter((Object)logData, (String)"logData");
        Project project = repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile virtualFile = repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        VirtualFile root = virtualFile;
        String string = GitBundle.message("rebase.progress.indicator.preparing.title", new Object[0]);
        new Task.Backgroundable(project2, repository, commit, logData, root, string){
            private List<GitRebaseEntryGeneratedUsingLog> generatedEntries;
            final /* synthetic */ Project $project;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ VcsLogData $logData;
            final /* synthetic */ VirtualFile $root;
            {
                this.$project = $project;
                this.$repository = $repository;
                this.$commit = $commit;
                this.$logData = $logData;
                this.$root = $root;
                super($project, $super_call_param$1);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                try {
                    this.generatedEntries = GitInteractiveRebaseUsingLogKt.getEntriesUsingLog(this.$repository, this.$commit, this.$logData);
                }
                catch (CantRebaseUsingLogException e) {
                    GitInteractiveRebaseUsingLogKt.access$getLOG$p().warn("Couldn't use log for rebasing: " + e.getMessage());
                }
            }

            public void onSuccess() {
                List<GitRebaseEntryGeneratedUsingLog> list = this.generatedEntries;
                if (list != null) {
                    List<GitRebaseEntryGeneratedUsingLog> list2 = list;
                    Project project = this.$project;
                    VirtualFile virtualFile = this.$root;
                    GitRepository gitRepository = this.$repository;
                    VcsShortCommitDetails vcsShortCommitDetails = this.$commit;
                    List<GitRebaseEntryGeneratedUsingLog> entries = list2;
                    boolean bl = false;
                    GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog> dialog = new GitInteractiveRebaseDialog<GitRebaseEntryGeneratedUsingLog>(project, virtualFile, entries);
                    DialogManager.show(dialog);
                    if (dialog.isOK()) {
                        GitInteractiveRebaseUsingLogKt.startInteractiveRebase(gitRepository, vcsShortCommitDetails, new GitInteractiveRebaseUsingLogEditorHandler(gitRepository, entries, dialog.getModel()));
                    }
                } else {
                    GitInteractiveRebaseUsingLogKt.startInteractiveRebase$default(this.$repository, this.$commit, null, 4, null);
                }
            }
        }.queue();
    }

    public static final void startInteractiveRebase(@NotNull GitRepository repository, @NotNull VcsShortCommitDetails commit, @Nullable GitRebaseEditorHandler editorHandler) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        Project project = repository.getProject();
        String string = GitBundle.message("rebase.progress.indicator.title", new Object[0]);
        new Task.Backgroundable(commit, repository, editorHandler, project, string){
            final /* synthetic */ VcsShortCommitDetails $commit;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ GitRebaseEditorHandler $editorHandler;
            {
                this.$commit = $commit;
                this.$repository = $repository;
                this.$editorHandler = $editorHandler;
                super($super_call_param$1, $super_call_param$2);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitRebaseParams.RebaseUpstream base = GitInteractiveRebaseUsingLogKt.getRebaseUpstreamFor(this.$commit);
                GitVersion gitVersion = this.$repository.getVcs().getVersion();
                Intrinsics.checkNotNullExpressionValue((Object)gitVersion, (String)"getVersion(...)");
                GitRebaseParams params = GitRebaseParams.Companion.editCommits$default(GitRebaseParams.Companion, gitVersion, base, this.$editorHandler, false, null, 16, null);
                GitRebaseUtils.rebase(this.$repository.getProject(), CollectionsKt.listOf((Object)this.$repository), params, indicator);
            }
        }.queue();
    }

    public static /* synthetic */ void startInteractiveRebase$default(GitRepository gitRepository, VcsShortCommitDetails vcsShortCommitDetails, GitRebaseEditorHandler gitRebaseEditorHandler, int n, Object object) {
        if ((n & 4) != 0) {
            gitRebaseEditorHandler = null;
        }
        GitInteractiveRebaseUsingLogKt.startInteractiveRebase(gitRepository, vcsShortCommitDetails, gitRebaseEditorHandler);
    }

    @NotNull
    public static final GitRebaseParams.RebaseUpstream getRebaseUpstreamFor(@NotNull VcsShortCommitDetails commit) {
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        if (commit.getParents().isEmpty()) {
            return GitRebaseParams.RebaseUpstream.Root.INSTANCE;
        }
        if (commit.getParents().size() == 1) {
            List list = commit.getParents();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
            Object object = CollectionsKt.single((List)list);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"single(...)");
            return new GitRebaseParams.RebaseUpstream.Commit((Hash)object);
        }
        List list = commit.getParents();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getParents(...)");
        LOG.warn(new Throwable("Unexpected rebase of a merge commit: " + commit + ", parents: " + CollectionsKt.joinToString$default((Iterable)list, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)));
        List list2 = commit.getParents();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParents(...)");
        Object object = CollectionsKt.first((List)list2);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
        return new GitRebaseParams.RebaseUpstream.Commit((Hash)object);
    }

    private static final Unit getEntriesUsingLog$lambda$1$lambda$0(List $details, VcsCommitMetadata metadata) {
        Intrinsics.checkNotNullParameter((Object)metadata, (String)"metadata");
        $details.add(metadata);
        return Unit.INSTANCE;
    }

    private static final boolean getEntriesUsingLog$lambda$1(GitHistoryTraverser $traverser, VcsShortCommitDetails $commit, List $details, GitHistoryTraverser.Traverse $this$traverse, GitHistoryTraverser.TraverseCommitInfo traverseCommitInfo) {
        Hash hash;
        Intrinsics.checkNotNullParameter((Object)$this$traverse, (String)"$this$traverse");
        Intrinsics.checkNotNullParameter((Object)traverseCommitInfo, (String)"<destruct>");
        int commitId = traverseCommitInfo.component1();
        List<Integer> parents = traverseCommitInfo.component2();
        if (parents.size() == 1) {
            $this$traverse.loadMetadataLater(commitId, (Function1<? super VcsCommitMetadata, Unit>)((Function1)arg_0 -> GitInteractiveRebaseUsingLogKt.getEntriesUsingLog$lambda$1$lambda$0($details, arg_0)));
            hash = $traverser.toHash(commitId);
        } else {
            throw new CantRebaseUsingLogException(CantRebaseUsingLogException.Reason.MERGE);
        }
        return !Intrinsics.areEqual((Object)hash, (Object)$commit.getId());
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    static {
        Logger logger = Logger.getInstance((String)"Git.Interactive.Rebase.Using.Log");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

