/*
 * Decompiled with CFR 0.152.
 */
package git4idea.repo;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.GitSilentFileAdder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsFileListenerContextHelper;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u0012H\u0002J\b\u0010\u001f\u001a\u00020\u0014H\u0016J\u0016\u0010 \u001a\u00020\u00142\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u0018\u0010\r\u001a\n \u000b*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lgit4idea/repo/GitSilentFileAdderImpl;", "Lcom/intellij/openapi/GitSilentFileAdder;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "gitVcs", "Lgit4idea/GitVcs;", "Lorg/jetbrains/annotations/NotNull;", "vcsManager", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "kotlin.jvm.PlatformType", "Lcom/intellij/openapi/vcs/ProjectLevelVcsManager;", "vcsFileListenerContextHelper", "Lcom/intellij/openapi/vcs/VcsFileListenerContextHelper;", "Lcom/intellij/openapi/vcs/VcsFileListenerContextHelper;", "pendingAddition", "", "Lcom/intellij/openapi/vcs/FilePath;", "markFileForAdding", "", "path", "", "isDirectory", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Ljava/io/File;", "Ljava/nio/file/Path;", "addFile", "filePath", "finish", "addToVcs", "filePaths", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitSilentFileAdderProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitSilentFileAdderProvider.kt\ngit4idea/repo/GitSilentFileAdderImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,90:1\n15#2:91\n*S KotlinDebug\n*F\n+ 1 GitSilentFileAdderProvider.kt\ngit4idea/repo/GitSilentFileAdderImpl\n*L\n86#1:91\n*E\n"})
public final class GitSilentFileAdderImpl
implements GitSilentFileAdder {
    @NotNull
    private final Project project;
    @NotNull
    private final GitVcs gitVcs;
    private final ProjectLevelVcsManager vcsManager;
    private final VcsFileListenerContextHelper vcsFileListenerContextHelper;
    @NotNull
    private final Set<FilePath> pendingAddition;

    public GitSilentFileAdderImpl(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        GitVcs gitVcs = GitVcs.getInstance(this.project);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitVcs), (String)"getInstance(...)");
        this.gitVcs = gitVcs;
        this.vcsManager = ProjectLevelVcsManager.getInstance((Project)this.project);
        this.vcsFileListenerContextHelper = VcsFileListenerContextHelper.getInstance((Project)this.project);
        this.pendingAddition = new HashSet();
    }

    public void markFileForAdding(@NotNull String path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FilePath filePath = VcsUtil.getFilePath((String)path, (boolean)isDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        this.addFile(filePath);
    }

    public void markFileForAdding(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isInLocalFileSystem()) {
            FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            this.addFile(filePath);
        }
    }

    public void markFileForAdding(@NotNull File file, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FilePath filePath = VcsUtil.getFilePath((File)file, (boolean)isDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        this.addFile(filePath);
    }

    public void markFileForAdding(@NotNull Path path, boolean isDirectory) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FilePath filePath = VcsUtil.getFilePath((Path)path, (boolean)isDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
        this.addFile(filePath);
    }

    private final void addFile(FilePath filePath) {
        VcsRoot vcsRoot = this.vcsManager.getVcsRootObjectFor(filePath);
        if (vcsRoot == null || !Intrinsics.areEqual((Object)vcsRoot.getVcs(), (Object)((Object)this.gitVcs))) {
            return;
        }
        if (filePath.isDirectory()) {
            this.vcsFileListenerContextHelper.ignoreAddedRecursive((Collection)CollectionsKt.listOf((Object)filePath));
        } else {
            this.vcsFileListenerContextHelper.ignoreAdded((Collection)CollectionsKt.listOf((Object)filePath));
        }
        this.pendingAddition.add(filePath);
    }

    public void finish() {
        this.vcsFileListenerContextHelper.clearContext();
        List filesToAdd = CollectionsKt.toList((Iterable)this.pendingAddition);
        this.pendingAddition.clear();
        BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)this.project), () -> GitSilentFileAdderImpl.finish$lambda$0(this, filesToAdd));
    }

    private final void addToVcs(Collection<? extends FilePath> filePaths) {
        Map<VirtualFile, List<FilePath>> map2 = GitUtil.sortFilePathsByGitRoot(this.project, filePaths);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"sortFilePathsByGitRoot(...)");
        Map<VirtualFile, List<FilePath>> map3 = map2;
        for (Map.Entry<VirtualFile, List<FilePath>> entry : map3.entrySet()) {
            VirtualFile root = entry.getKey();
            List<FilePath> rootPaths = entry.getValue();
            try {
                GitFileUtils.addPaths(this.project, root, (Collection<? extends FilePath>)rootPaths);
                VcsDirtyScopeManager.getInstance((Project)this.project).filePathsDirty((Collection)rootPaths, null);
            }
            catch (VcsException e) {
                boolean $i$f$logger = false;
                Logger logger = Logger.getInstance(GitSilentFileAdderImpl.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.warn((Throwable)e);
            }
        }
    }

    private static final void finish$lambda$0(GitSilentFileAdderImpl this$0, List $filesToAdd) {
        this$0.addToVcs($filesToAdd);
    }
}

