/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ex.commit;

import com.intellij.openapi.project.Project;
import com.intellij.vcs.commit.AbstractCommitMessagePolicy;
import com.intellij.vcs.commit.CommitMessage;
import com.intellij.vcs.commit.CommitMessageUi;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0013H\u0016J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\b\u001a\u00020\tX\u0094D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\rX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/vcs/ex/commit/ChunkCommitMessagePolicy;", "Lcom/intellij/vcs/commit/AbstractCommitMessagePolicy;", "project", "Lcom/intellij/openapi/project/Project;", "commitMessageUi", "Lcom/intellij/vcs/commit/CommitMessageUi;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/commit/CommitMessageUi;)V", "clearMessageAfterCommit", "", "getClearMessageAfterCommit", "()Z", "delayedMessagesProvidersSupport", "", "getDelayedMessagesProvidersSupport", "()Ljava/lang/Void;", "getNewCommitMessage", "Lcom/intellij/vcs/commit/CommitMessage;", "cleanupStoredMessage", "", "dispose", "saveTempChunkCommitMessage", "commitMessage", "", "intellij.platform.vcs.impl"})
final class ChunkCommitMessagePolicy
extends AbstractCommitMessagePolicy {
    private final boolean clearMessageAfterCommit;
    @Nullable
    private final Void delayedMessagesProvidersSupport;

    public ChunkCommitMessagePolicy(@NotNull Project project, @NotNull CommitMessageUi commitMessageUi) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)commitMessageUi, (String)"commitMessageUi");
        super(project, commitMessageUi);
        this.clearMessageAfterCommit = true;
    }

    @Override
    protected boolean getClearMessageAfterCommit() {
        return this.clearMessageAfterCommit;
    }

    @Nullable
    protected Void getDelayedMessagesProvidersSupport() {
        return this.delayedMessagesProvidersSupport;
    }

    @Override
    @NotNull
    protected CommitMessage getNewCommitMessage() {
        String string = this.getVcsConfiguration().getTempChunkCommitMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempChunkCommitMessage(...)");
        return new CommitMessage(string, false, 2, null);
    }

    @Override
    protected void cleanupStoredMessage() {
        this.saveTempChunkCommitMessage("");
    }

    @Override
    public void dispose() {
    }

    public final void saveTempChunkCommitMessage(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        this.getVcsConfiguration().saveTempChunkCommitMessage(commitMessage);
    }
}

