/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.sass.include;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.css.CssImportLikeElement;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.include.AbstractCssFileIncludeProvider;
import com.intellij.psi.impl.include.FileIncludeInfo;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.text.CharArrayUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.sass.SASSFileType;
import org.jetbrains.plugins.sass.SASSLanguage;
import org.jetbrains.plugins.scss.SCSSFileType;
import org.jetbrains.plugins.scss.psi.SassScssForwardAtRule;
import org.jetbrains.plugins.scss.psi.SassScssUseAtRule;

public class SassScssFileIncludeProvider
extends AbstractCssFileIncludeProvider {
    private static final String SASS_EXT = "sass";
    private static final String SCSS_EXT = "scss";

    public int getVersion() {
        return 1;
    }

    @NotNull
    public String getId() {
        return "SASS/SCSS";
    }

    public boolean acceptFile(@NotNull VirtualFile file) {
        if (file == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(0);
        }
        return FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SASSFileType.SASS) || FileTypeRegistry.getInstance().isFileOfType(file, (FileType)SCSSFileType.SCSS);
    }

    public void registerFileTypesUsedForIndexing(@NotNull Consumer<? super FileType> fileTypeSink) {
        if (fileTypeSink == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(1);
        }
        fileTypeSink.consume((Object)SASSFileType.SASS);
        fileTypeSink.consume((Object)SCSSFileType.SCSS);
    }

    protected void handleImportLikeElement(@NotNull CssImportLikeElement element, @NotNull VirtualFile hostFile, @NotNull List<FileIncludeInfo> result) {
        CssString uriElement;
        if (element == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(2);
        }
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(3);
        }
        if (result == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(4);
        }
        if (element instanceof SassScssUseAtRule) {
            uriElement = ((SassScssUseAtRule)element).getTargetUrl();
        } else if (element instanceof SassScssForwardAtRule) {
            uriElement = ((SassScssForwardAtRule)element).getTargetUrl();
        } else {
            return;
        }
        if (uriElement == null) {
            return;
        }
        String hostFileExt = StringUtil.notNullize((String)hostFile.getExtension());
        String uri = uriElement.getValue();
        String uriExt = FileUtilRt.getExtension((String)uri);
        this.addImports(result, hostFile, hostFileExt, uri, uriExt);
    }

    protected boolean hasImports(@NotNull CharSequence hostFileText) {
        if (hostFileText == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(5);
        }
        return super.hasImports(hostFileText) || CharArrayUtil.indexOf((CharSequence)hostFileText, (CharSequence)"@use", (int)0) >= 0 || CharArrayUtil.indexOf((CharSequence)hostFileText, (CharSequence)"@forward", (int)0) >= 0;
    }

    protected void addImports(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String hostFileExt, @NotNull String importUri, @NotNull String importUriExt) {
        if (result == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(6);
        }
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(7);
        }
        if (hostFileExt == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(8);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(9);
        }
        if (importUriExt == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(10);
        }
        if (SASS_EXT.equalsIgnoreCase(importUriExt) || SCSS_EXT.equalsIgnoreCase(importUriExt)) {
            SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri);
        } else {
            VirtualFile dir = SassScssFileIncludeProvider.resolveImport(hostFile, importUri);
            if (dir != null && dir.isDirectory()) {
                for (VirtualFile childFile : dir.getChildren()) {
                    String path;
                    String fileName = childFile.getName();
                    if (!ArrayUtil.contains((String)fileName, (String[])new String[]{"_index.scss", "index.scss", "_index.sass", "index.sass"}) || (path = SassScssFileIncludeProvider.getRelativePath(hostFile.getParent(), childFile)) == null) continue;
                    result.add(new FileIncludeInfo(path));
                    break;
                }
            }
            if (!SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + ".scss")) {
                SassScssFileIncludeProvider.tryAddImport(result, hostFile, importUri + ".sass");
            }
        }
    }

    @NotNull
    protected Language getLanguage() {
        SASSLanguage sASSLanguage = SASSLanguage.INSTANCE;
        if (sASSLanguage == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(11);
        }
        return sASSLanguage;
    }

    private static boolean tryAddImport(@NotNull List<FileIncludeInfo> result, @NotNull VirtualFile hostFile, @NotNull String importUri) {
        String path;
        if (result == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(12);
        }
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(13);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(14);
        }
        VirtualFile file = SassScssFileIncludeProvider.resolveImport(hostFile, importUri);
        VirtualFile hostFileDir = hostFile.getParent();
        if (file != null && hostFileDir != null && (path = SassScssFileIncludeProvider.getRelativePath(hostFileDir, file)) != null) {
            result.add(new FileIncludeInfo(path));
            return true;
        }
        return false;
    }

    @Nullable
    private static String getRelativePath(@NotNull VirtualFile hostFileDir, @NotNull VirtualFile importedFile) {
        VirtualFile commonAncestor;
        if (hostFileDir == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(15);
        }
        if (importedFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(16);
        }
        if ((commonAncestor = VfsUtilCore.getCommonAncestor((VirtualFile)hostFileDir, (VirtualFile)importedFile)) == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        VirtualFile dir = hostFileDir;
        while (!commonAncestor.equals(dir)) {
            buffer.append("../");
            if ((dir = dir.getParent()) != null) continue;
            return null;
        }
        buffer.append(VfsUtilCore.getRelativePath((VirtualFile)importedFile, (VirtualFile)commonAncestor, (char)'/'));
        return buffer.toString();
    }

    @Nullable
    private static VirtualFile resolveImport(@NotNull VirtualFile hostFile, @NotNull String importUri) {
        String systemIndependentImportUri;
        VirtualFile importedFile;
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(17);
        }
        if (importUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(18);
        }
        if ((importedFile = SassScssFileIncludeProvider.findFile(hostFile, systemIndependentImportUri = FileUtil.toSystemIndependentName((String)importUri))) != null && importedFile.isValid()) {
            return importedFile;
        }
        String partialImportUri = SassScssFileIncludeProvider.createPartialImportUri(systemIndependentImportUri);
        VirtualFile partialImportedFile = SassScssFileIncludeProvider.findFile(hostFile, partialImportUri);
        if (partialImportedFile != null && partialImportedFile.isValid()) {
            return partialImportedFile;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findFile(@NotNull VirtualFile hostFile, @NotNull String systemIndependentImportUri) {
        if (hostFile == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(19);
        }
        if (systemIndependentImportUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(20);
        }
        if (FileUtil.isAbsolutePlatformIndependent((String)systemIndependentImportUri)) {
            return hostFile.getFileSystem().findFileByPath(systemIndependentImportUri);
        }
        VirtualFile hostFileDir = hostFile.getParent();
        if (hostFileDir == null) {
            return null;
        }
        return hostFileDir.findFileByRelativePath(systemIndependentImportUri);
    }

    private static String createPartialImportUri(@NotNull String systemIndependentImportUri) {
        int pos;
        if (systemIndependentImportUri == null) {
            SassScssFileIncludeProvider.$$$reportNull$$$0(21);
        }
        if ((pos = systemIndependentImportUri.lastIndexOf(47)) == -1) {
            return "_" + systemIndependentImportUri;
        }
        String baseName = systemIndependentImportUri.substring(pos + 1);
        String dirName = systemIndependentImportUri.substring(0, pos);
        return dirName + "/_" + baseName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTypeSink";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: 
            case 13: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 4: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileText";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileExt";
                break;
            }
            case 9: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importUri";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importUriExt";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFileDir";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importedFile";
                break;
            }
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "systemIndependentImportUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/sass/include/SassScssFileIncludeProvider";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "registerFileTypesUsedForIndexing";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleImportLikeElement";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasImports";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "addImports";
                break;
            }
            case 11: {
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "tryAddImport";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveImport";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findFile";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPartialImportUri";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11 -> new IllegalStateException(string);
        };
    }
}

