/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleService;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.jetbrains.python.console.PydevConsoleExecuteActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\nH\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleActionHandler;", "Lcom/intellij/execution/console/BaseConsoleExecuteActionHandler;", "jupyterConsoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "restartConsoleAction", "", "consoleView", "runExecuteAction", "Lcom/intellij/execution/console/LanguageConsoleView;", "copyToHistoryAndExecute", "console", "execute", "text", "", "intellij.jupyter.py"})
@SourceDebugExtension(value={"SMAP\nJupyterConsoleActionHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterConsoleActionHandler.kt\ncom/intellij/jupyter/py/jupyterConsole/JupyterConsoleActionHandler\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,31:1\n40#2,3:32\n*S KotlinDebug\n*F\n+ 1 JupyterConsoleActionHandler.kt\ncom/intellij/jupyter/py/jupyterConsole/JupyterConsoleActionHandler\n*L\n11#1:32,3\n*E\n"})
public final class JupyterConsoleActionHandler
extends BaseConsoleExecuteActionHandler {
    @NotNull
    private final JupyterConsoleView jupyterConsoleView;

    public JupyterConsoleActionHandler(@NotNull JupyterConsoleView jupyterConsoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)jupyterConsoleView), (String)"jupyterConsoleView");
        super(false);
        this.jupyterConsoleView = jupyterConsoleView;
    }

    public final void restartConsoleAction(@NotNull JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        boolean $i$f$service = false;
        Class<JupyterConsoleService> serviceClass$iv = JupyterConsoleService.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
        }
        JupyterConsoleService service = (JupyterConsoleService)object;
        service.removeConsoleViewContent(consoleView);
        service.showConsoleViewContent(consoleView.getProject(), consoleView.getRealNotebookVirtualFile());
    }

    public void runExecuteAction(@NotNull LanguageConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)consoleView, (String)"consoleView");
        Document doc = this.jupyterConsoleView.getEditorDocument();
        RangeMarker rangeMarker = doc.createRangeMarker(doc.getTextLength(), doc.getTextLength());
        Intrinsics.checkNotNullExpressionValue((Object)rangeMarker, (String)"createRangeMarker(...)");
        RangeMarker endMarker = rangeMarker;
        endMarker.setGreedyToLeft(false);
        endMarker.setGreedyToRight(true);
        PydevConsoleExecuteActionHandler.Companion.deleteString(doc, endMarker);
        this.copyToHistoryAndExecute(consoleView);
    }

    private final void copyToHistoryAndExecute(LanguageConsoleView console) {
        super.runExecuteAction(console);
    }

    protected void execute(@NotNull String text, @NotNull LanguageConsoleView console) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)console, (String)"console");
        this.jupyterConsoleView.executeCode(text, (Editor)console.getConsoleEditor());
    }
}

