/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.py.jupyterConsole;

import com.intellij.execution.console.BaseConsoleExecuteActionHandler;
import com.intellij.execution.console.ConsoleExecuteAction;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.JupyterProjectUtilKt;
import com.intellij.jupyter.py.jupyterConsole.JupyterConsoleView;
import com.intellij.jupyter.py.jupyterConsole.actions.JupyterConsoleRestartAction;
import com.intellij.jupyter.py.jupyterConsole.actions.JupyterConsoleSaveDocumentAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0006\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\fH\u0002J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u001dJ\b\u0010\u001e\u001a\u00020\u0014H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u00020\u000eX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsolePanel;", "Lcom/intellij/openapi/ui/SimpleToolWindowPanel;", "Lcom/intellij/openapi/Disposable;", "consoleView", "Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;", "<init>", "(Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsoleView;)V", "notebookFile", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "executeAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "actionsPanel", "Ljavax/swing/JPanel;", "content", "Lcom/intellij/ui/content/Content;", "getContent", "()Lcom/intellij/ui/content/Content;", "setContent", "(Lcom/intellij/ui/content/Content;)V", "setMainPanel", "", "jupyterEditorPanel", "Ljavax/swing/JComponent;", "createContent", "createActionsGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "createActionToolBar", "toggleToolbarVisibility", "show", "", "dispose", "Companion", "intellij.jupyter.py"})
public final class JupyterConsolePanel
extends SimpleToolWindowPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JupyterConsoleView consoleView;
    @NotNull
    private final BackedNotebookVirtualFile notebookFile;
    @NotNull
    private final AnAction executeAction;
    @NotNull
    private final JPanel actionsPanel;
    public Content content;
    @NotNull
    private static final String NAME = "JupyterConsolePanel";

    public JupyterConsolePanel(@NotNull JupyterConsoleView consoleView) {
        Intrinsics.checkNotNullParameter((Object)((Object)consoleView), (String)"consoleView");
        super(true);
        this.consoleView = consoleView;
        this.notebookFile = this.consoleView.getRealNotebookVirtualFile();
        this.executeAction = (AnAction)new ConsoleExecuteAction((LanguageConsoleView)this.consoleView, (BaseConsoleExecuteActionHandler)this.consoleView.getMyJupyterConsoleActionHandler());
        this.actionsPanel = new JPanel(new BorderLayout());
        String[] stringArray = new String[]{"control ENTER", "shift ENTER"};
        this.executeAction.registerCustomShortcutSet((ShortcutSet)CustomShortcutSet.fromString((String[])stringArray), this.consoleView.getConsoleEditor().getComponent());
        this.add(this.actionsPanel, "West");
    }

    @NotNull
    public final Content getContent() {
        Content content = this.content;
        if (content != null) {
            return content;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"content");
        return null;
    }

    public final void setContent(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"<set-?>");
        this.content = content;
    }

    public final void setMainPanel(@NotNull JComponent jupyterEditorPanel) {
        Intrinsics.checkNotNullParameter((Object)jupyterEditorPanel, (String)"jupyterEditorPanel");
        this.add(jupyterEditorPanel, "Center");
    }

    @NotNull
    public final Content createContent() {
        ContentFactory contentFactory = ContentFactory.getInstance();
        Object object = JupyterProjectUtilKt.getRelativePathFromProjectRoot((VirtualFile)this.notebookFile.getFile(), (Project)this.consoleView.getProject());
        if (object == null || (object = object.toString()) == null) {
            String string = this.notebookFile.getFile().getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        Object relativePath = object;
        Object[] objectArray = new Object[]{relativePath};
        Content content = contentFactory.createContent((JComponent)((Object)this), JupyterBundle.message((String)"tab.title.JupyterConsole", (Object[])objectArray), true);
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        Content content2 = content;
        content2.setComponent((JComponent)((Object)this));
        content2.setShouldDisposeContent(true);
        Disposer.register((Disposable)this, (Disposable)((Disposable)content2));
        this.setContent(content2);
        return content2;
    }

    private final DefaultActionGroup createActionsGroup() {
        JupyterConsoleRestartAction jupyterConsoleRestartAction;
        JupyterConsoleRestartAction $this$createActionsGroup_u24lambda_u240 = jupyterConsoleRestartAction = new JupyterConsoleRestartAction(this.consoleView);
        boolean bl = false;
        $this$createActionsGroup_u24lambda_u240.registerCustomShortcutSet(ActionUtil.getShortcutSet((String)"Rerun"), this.consoleView.getConsoleEditor().getComponent());
        JupyterConsoleRestartAction consoleRestartAction = jupyterConsoleRestartAction;
        List actions = new ArrayList();
        actions.add(this.executeAction);
        actions.add(consoleRestartAction);
        AnAction anAction = this.consoleView.getHistoryController().getBrowseHistory();
        Intrinsics.checkNotNullExpressionValue((Object)anAction, (String)"getBrowseHistory(...)");
        actions.add(anAction);
        actions.add(new JupyterConsoleSaveDocumentAction(this.consoleView));
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        toolbarActions.addAll((Collection)actions);
        return toolbarActions;
    }

    private final JPanel createActionToolBar() {
        JPanel jPanel;
        ActionToolbar actionToolbar;
        ActionManager actionManager = ActionManager.getInstance();
        ActionToolbar $this$createActionToolBar_u24lambda_u241 = actionToolbar = actionManager.createActionToolbar(NAME, (ActionGroup)this.createActionsGroup(), false);
        boolean bl = false;
        $this$createActionToolBar_u24lambda_u241.setTargetComponent(this.consoleView.getConsoleEditor().getComponent());
        $this$createActionToolBar_u24lambda_u241.getComponent().setBorder(IdeBorderFactory.createBorder((Color)JBColor.border(), (int)4));
        ActionToolbar actionToolbar2 = actionToolbar;
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar2, (String)"apply(...)");
        ActionToolbar actionsToolbar = actionToolbar2;
        JPanel $this$createActionToolBar_u24lambda_u242 = jPanel = new JPanel(new BorderLayout());
        boolean bl2 = false;
        $this$createActionToolBar_u24lambda_u242.add((Component)actionsToolbar.getComponent(), "West");
        return jPanel;
    }

    public final void toggleToolbarVisibility(boolean show) {
        this.actionsPanel.removeAll();
        if (show) {
            this.actionsPanel.add((Component)this.createActionToolBar(), "West");
        }
        this.actionsPanel.revalidate();
        this.actionsPanel.repaint();
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.consoleView));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/py/jupyterConsole/JupyterConsolePanel$Companion;", "", "<init>", "()V", "NAME", "", "intellij.jupyter.py"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

