/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui;

import com.intellij.ide.ui.LafManager;
import com.intellij.ide.ui.laf.UIThemeLookAndFeelInfo;
import com.intellij.ui.JBColor;
import java.awt.Color;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\tH\u0004J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0004J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0007H\u0004\u00a8\u0006\u0011"}, d2={"Lcom/intellij/profiler/ui/ProfilerColors;", "", "<init>", "()V", "color", "Ljava/awt/Color;", "name", "", "rgb", "", "darkRGB", "hcRGB", "colorProvider", "Lkotlin/Function0;", "Lcom/intellij/ui/JBColor;", "exact", "propertyName", "intellij.profiler.common"})
public abstract class ProfilerColors {
    @NotNull
    protected final Color color(@NotNull String name, int rgb, int darkRGB, int hcRGB) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.color(name, new Color(rgb), new Color(darkRGB), new Color(hcRGB));
    }

    @NotNull
    protected final Color color(@NotNull String name, @NotNull Color rgb, @NotNull Color darkRGB, @NotNull Color hcRGB) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)rgb, (String)"rgb");
        Intrinsics.checkNotNullParameter((Object)darkRGB, (String)"darkRGB");
        Intrinsics.checkNotNullParameter((Object)hcRGB, (String)"hcRGB");
        return this.color(name, (Function0<? extends JBColor>)((Function0)() -> ProfilerColors.color$lambda$1(rgb, hcRGB, darkRGB)));
    }

    private final Color color(String name, Function0<? extends JBColor> colorProvider) {
        Color color = UIManager.getColor(name);
        if (color == null) {
            Object object = colorProvider.invoke();
            JBColor it = (JBColor)object;
            boolean bl = false;
            UIManager.put(name, it);
            color = (Color)object;
        }
        return color;
    }

    @NotNull
    protected final JBColor exact(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        JBColor jBColor = JBColor.namedColor((String)propertyName);
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"namedColor(...)");
        return jBColor;
    }

    private static final Color color$lambda$1$lambda$0(Color $rgb, Color $hcRGB, Color $darkRGB) {
        Color color;
        if (JBColor.isBright()) {
            color = $rgb;
        } else {
            UIThemeLookAndFeelInfo uIThemeLookAndFeelInfo = LafManager.getInstance().getCurrentUIThemeLookAndFeel();
            color = Intrinsics.areEqual((Object)(uIThemeLookAndFeelInfo != null ? uIThemeLookAndFeelInfo.getId() : null), (Object)"JetBrainsHighContrastTheme") ? $hcRGB : $darkRGB;
        }
        return color;
    }

    private static final JBColor color$lambda$1(Color $rgb, Color $hcRGB, Color $darkRGB) {
        JBColor jBColor = JBColor.lazy(() -> ProfilerColors.color$lambda$1$lambda$0($rgb, $hcRGB, $darkRGB));
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"lazy(...)");
        return jBColor;
    }
}

