/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs.codeStyle;

import com.intellij.application.options.codeStyle.properties.AbstractCodeStylePropertyMapper;
import com.intellij.application.options.codeStyle.properties.CodeStylePropertyAccessor;
import com.intellij.application.options.codeStyle.properties.GeneralCodeStylePropertyMapper;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.typescript.formatter.TypeScriptCodeStyleSettings;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.prettierjs.PrettierBundle;
import com.intellij.prettierjs.PrettierConfig;
import com.intellij.prettierjs.PrettierConfigUtilKt;
import com.intellij.prettierjs.PrettierConfiguration;
import com.intellij.prettierjs.PrettierLanguageService;
import com.intellij.prettierjs.PrettierUtil;
import com.intellij.prettierjs.codeStyle.HtmlPrettierCodeStyleConfigurator;
import com.intellij.prettierjs.codeStyle.JsPrettierCodeStyleConfigurator;
import com.intellij.prettierjs.codeStyle.PrettierCodeStyleConfigurator;
import com.intellij.prettierjs.codeStyle.PrettierCodeStyleSettingsModifierKt;
import com.intellij.prettierjs.codeStyle.PrettierCodeStyleStatusBarUIContributor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.modifier.CodeStyleSettingsModifier;
import com.intellij.psi.codeStyle.modifier.CodeStyleStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.util.LineSeparator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000f\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0007H\u0016J\u0018\u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0002J\u0018\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleSettingsModifier;", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleSettingsModifier;", "<init>", "()V", "modifySettings", "", "settings", "Lcom/intellij/psi/codeStyle/modifier/TransientCodeStyleSettings;", "psiFile", "Lcom/intellij/psi/PsiFile;", "mayOverrideSettingsOf", "project", "Lcom/intellij/openapi/project/Project;", "getDisablingFunction", "Ljava/util/function/Consumer;", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "getName", "", "getStatusBarUiContributor", "Lcom/intellij/psi/codeStyle/modifier/CodeStyleStatusBarUIContributor;", "transientSettings", "doModifySettings", "getAdvancedCodeStyleConfigurators", "", "Lcom/intellij/prettierjs/codeStyle/PrettierCodeStyleConfigurator;", "applyBasicPrettierMappings", "prettierConfig", "Lcom/intellij/prettierjs/PrettierConfig;", "getAllMappers", "", "Lcom/intellij/application/options/codeStyle/properties/AbstractCodeStylePropertyMapper;", "intellij.prettierJS"})
@SourceDebugExtension(value={"SMAP\nPrettierCodeStyleSettingsModifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PrettierCodeStyleSettingsModifier.kt\ncom/intellij/prettierjs/codeStyle/PrettierCodeStyleSettingsModifier\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,131:1\n62#2,5:132\n62#2,5:137\n1863#3,2:142\n1557#3:144\n1628#3,3:145\n*S KotlinDebug\n*F\n+ 1 PrettierCodeStyleSettingsModifier.kt\ncom/intellij/prettierjs/codeStyle/PrettierCodeStyleSettingsModifier\n*L\n73#1:132,5\n77#1:137,5\n104#1:142,2\n125#1:144\n125#1:145,3\n*E\n"})
final class PrettierCodeStyleSettingsModifier
implements CodeStyleSettingsModifier {
    public boolean modifySettings(@NotNull TransientCodeStyleSettings settings, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        VirtualFile file = psiFile.getVirtualFile();
        if (project2.isDisposed()) {
            return false;
        }
        if (!PrettierConfiguration.getInstance(project2).getCodeStyleSettingsModifierEnabled()) {
            return false;
        }
        if (!PrettierUtil.isFormattingAllowedForFile(project2, file)) {
            return false;
        }
        if (!PrettierUtil.checkNodeAndPackage(psiFile, null, PrettierUtil.NOOP_ERROR_HANDLER)) {
            return false;
        }
        return this.doModifySettings(settings, psiFile);
    }

    public boolean mayOverrideSettingsOf(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return PrettierConfiguration.getInstance(project).getCodeStyleSettingsModifierEnabled();
    }

    @Nullable
    public Consumer<CodeStyleSettings> getDisablingFunction(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return arg_0 -> PrettierCodeStyleSettingsModifier.getDisablingFunction$lambda$0(project, arg_0);
    }

    @NotNull
    public String getName() {
        String string = PrettierBundle.message("prettier.code.style.display.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @Nullable
    public CodeStyleStatusBarUIContributor getStatusBarUiContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        Intrinsics.checkNotNullParameter((Object)transientSettings, (String)"transientSettings");
        return new PrettierCodeStyleStatusBarUIContributor();
    }

    private final boolean doModifySettings(TransientCodeStyleSettings settings, PsiFile psiFile) {
        Throwable e$iv;
        Logger $this$debug_u24default$iv;
        PrettierConfig prettierConfig2;
        PrettierLanguageService.ResolveConfigResult resolveConfigResult = (PrettierLanguageService.ResolveConfigResult)CoroutinesKt.runBlockingCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super PrettierLanguageService.ResolveConfigResult>, Object>(psiFile, null){
            int label;
            final /* synthetic */ PsiFile $psiFile;
            {
                this.$psiFile = $psiFile;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = PrettierConfigUtilKt.resolveConfigForFile(this.$psiFile, (Continuation<? super PrettierLanguageService.ResolveConfigResult>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super PrettierLanguageService.ResolveConfigResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
        if (resolveConfigResult == null || (prettierConfig2 = resolveConfigResult.config) == null) {
            return false;
        }
        PrettierConfig prettierConfig3 = prettierConfig2;
        boolean changedBasic = this.applyBasicPrettierMappings(settings, prettierConfig3);
        boolean changedAdvanced = false;
        for (PrettierCodeStyleConfigurator configurator : this.getAdvancedCodeStyleConfigurators()) {
            if (configurator.isApplied((CodeStyleSettings)settings, psiFile, prettierConfig3)) continue;
            configurator.applySettings((CodeStyleSettings)settings, psiFile, prettierConfig3);
            changedAdvanced = true;
        }
        if (changedBasic || changedAdvanced) {
            $this$debug_u24default$iv = PrettierCodeStyleSettingsModifierKt.access$getLOG();
            e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                Logger logger = $this$debug_u24default$iv;
                boolean bl = false;
                logger.debug("Modified for " + psiFile.getName(), e$iv);
            }
            return true;
        }
        $this$debug_u24default$iv = PrettierCodeStyleSettingsModifierKt.access$getLOG();
        e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("No changes for " + psiFile.getName(), e$iv);
        }
        return false;
    }

    private final List<PrettierCodeStyleConfigurator> getAdvancedCodeStyleConfigurators() {
        Object[] objectArray = new PrettierCodeStyleConfigurator[]{new HtmlPrettierCodeStyleConfigurator(), new JsPrettierCodeStyleConfigurator<TypeScriptCodeStyleSettings>(TypeScriptCodeStyleSettings.class), new JsPrettierCodeStyleConfigurator<JSCodeStyleSettings>(JSCodeStyleSettings.class)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    private final boolean applyBasicPrettierMappings(TransientCodeStyleSettings settings, PrettierConfig prettierConfig2) {
        boolean changed = false;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"indent_size", (Object)String.valueOf(prettierConfig2.tabWidth)), TuplesKt.to((Object)"tab_width", (Object)String.valueOf(prettierConfig2.tabWidth)), TuplesKt.to((Object)"continuation_indent_size", (Object)String.valueOf(prettierConfig2.tabWidth)), TuplesKt.to((Object)"indent_style", (Object)(prettierConfig2.useTabs ? "tab" : "space")), TuplesKt.to((Object)"visual_guides", (Object)String.valueOf(prettierConfig2.printWidth))};
        Map basicPropertyMap = MapsKt.mapOf((Pair[])pairArray);
        Iterable $this$forEach$iv = this.getAllMappers(settings);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LineSeparator lineSep;
            CodeStylePropertyAccessor accessor;
            AbstractCodeStylePropertyMapper mapper = (AbstractCodeStylePropertyMapper)element$iv;
            boolean bl = false;
            for (Map.Entry entry : basicPropertyMap.entrySet()) {
                CodeStylePropertyAccessor it;
                String propertyName = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (mapper.getAccessor(propertyName) == null) continue;
                boolean bl2 = false;
                changed |= it.setFromString(value);
            }
            if (mapper.getAccessor("end_of_line") == null) continue;
            boolean bl3 = false;
            if (prettierConfig2.lineSeparator == null) continue;
            boolean bl4 = false;
            changed |= accessor.setFromString(StringUtil.toLowerCase((String)lineSep.name()));
        }
        return changed;
    }

    /*
     * WARNING - void declaration
     */
    private final Collection<AbstractCodeStylePropertyMapper> getAllMappers(TransientCodeStyleSettings settings) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Set set;
        Set $this$getAllMappers_u24lambda_u248 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        List list = LanguageCodeStyleSettingsProvider.getAllProviders();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllProviders(...)");
        Iterable iterable = list;
        Set set2 = $this$getAllMappers_u24lambda_u248;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LanguageCodeStyleSettingsProvider languageCodeStyleSettingsProvider = (LanguageCodeStyleSettingsProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            AbstractCodeStylePropertyMapper abstractCodeStylePropertyMapper = it.getPropertyMapper((CodeStyleSettings)settings);
            Intrinsics.checkNotNullExpressionValue((Object)abstractCodeStylePropertyMapper, (String)"getPropertyMapper(...)");
            collection.add(abstractCodeStylePropertyMapper);
        }
        set2.addAll((List)destination$iv$iv);
        $this$getAllMappers_u24lambda_u248.add(new GeneralCodeStylePropertyMapper((CodeStyleSettings)settings));
        return SetsKt.build((Set)set);
    }

    private static final void getDisablingFunction$lambda$0(Project $project, CodeStyleSettings settings) {
        PrettierConfiguration.getInstance((Project)$project).getState().codeStyleSettingsModifierEnabled = false;
        CodeStyleSettingsManager.getInstance((Project)$project).notifyCodeStyleSettingsChanged();
    }
}

