/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.util;

import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.builder.FigureBuildInfo;
import org.jetbrains.letsPlot.core.plot.builder.GeomLayer;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgComponent;
import org.jetbrains.letsPlot.core.plot.builder.PlotSvgRoot;
import org.jetbrains.letsPlot.core.plot.builder.assemble.PlotAssembler;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.FigureLayoutInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.figure.plot.PlotFigureLayoutInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u001d\u001a\u00020\u001eH\u0016JX\u0010\u001f\u001a\u00020 2N\u0010!\u001aJ\u0012\u001f\u0012\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u000b0\u000b\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u001f\u0012\u001d\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b('\u0012\u0004\u0012\u00020\u00070\"H\u0016J\u0010\u0010(\u001a\u00020\u00002\u0006\u0010)\u001a\u00020\tH\u0016J\b\u0010*\u001a\u00020\u0000H\u0016J\u0014\u0010+\u001a\u00020\u00002\n\b\u0002\u0010,\u001a\u0004\u0018\u00010\tH\u0002J\u0010\u0010-\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010.\u001a\u00020\u00012\u0006\u0010/\u001a\u000200H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0016R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/letsPlot/core/util/PlotFigureBuildInfo;", "Lorg/jetbrains/letsPlot/core/plot/builder/FigureBuildInfo;", "plotAssembler", "Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler;", "processedPlotSpec", "", "", "", "bounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "computationMessages", "", "(Lorg/jetbrains/letsPlot/core/plot/builder/assemble/PlotAssembler;Ljava/util/Map;Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;Ljava/util/List;)V", "_layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/plot/PlotFigureLayoutInfo;", "getBounds", "()Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "getComputationMessages", "()Ljava/util/List;", "containsLiveMap", "", "getContainsLiveMap", "()Z", "isComposite", "layoutInfo", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/FigureLayoutInfo;", "getLayoutInfo", "()Lorg/jetbrains/letsPlot/core/plot/builder/layout/figure/FigureLayoutInfo;", "liveMapCursorServiceConfig", "createSvgRoot", "Lorg/jetbrains/letsPlot/core/plot/builder/PlotSvgRoot;", "injectLiveMapProvider", "", "f", "Lkotlin/Function2;", "Lorg/jetbrains/letsPlot/core/plot/builder/GeomLayer;", "Lkotlin/ParameterName;", "name", "tiles", "spec", "layoutedByGeomBounds", "geomBounds", "layoutedByOuterSize", "makeCopy", "newBounds", "withBounds", "withPreferredSize", "size", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-stem"})
@SourceDebugExtension(value={"SMAP\nPlotFigureBuildInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PlotFigureBuildInfo.kt\norg/jetbrains/letsPlot/core/util/PlotFigureBuildInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,108:1\n1#2:109\n*E\n"})
public final class PlotFigureBuildInfo
implements FigureBuildInfo {
    @NotNull
    private final PlotAssembler plotAssembler;
    @NotNull
    private final Map<String, Object> processedPlotSpec;
    @NotNull
    private final DoubleRectangle bounds;
    @NotNull
    private final List<String> computationMessages;
    private final boolean isComposite;
    private final boolean containsLiveMap;
    private PlotFigureLayoutInfo _layoutInfo;
    private Object liveMapCursorServiceConfig;

    public PlotFigureBuildInfo(@NotNull PlotAssembler plotAssembler, @NotNull Map<String, ? extends Object> processedPlotSpec, @NotNull DoubleRectangle bounds, @NotNull List<String> computationMessages) {
        Intrinsics.checkNotNullParameter((Object)plotAssembler, (String)"plotAssembler");
        Intrinsics.checkNotNullParameter(processedPlotSpec, (String)"processedPlotSpec");
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        Intrinsics.checkNotNullParameter(computationMessages, (String)"computationMessages");
        this.plotAssembler = plotAssembler;
        this.processedPlotSpec = processedPlotSpec;
        this.bounds = bounds;
        this.computationMessages = computationMessages;
        this.containsLiveMap = this.plotAssembler.getContainsLiveMap();
    }

    @Override
    @NotNull
    public DoubleRectangle getBounds() {
        return this.bounds;
    }

    @Override
    @NotNull
    public List<String> getComputationMessages() {
        return this.computationMessages;
    }

    @Override
    public boolean isComposite() {
        return this.isComposite;
    }

    @Override
    public boolean getContainsLiveMap() {
        return this.containsLiveMap;
    }

    @Override
    @NotNull
    public FigureLayoutInfo getLayoutInfo() {
        PlotFigureLayoutInfo plotFigureLayoutInfo = this._layoutInfo;
        if (plotFigureLayoutInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_layoutInfo");
            plotFigureLayoutInfo = null;
        }
        return plotFigureLayoutInfo;
    }

    @Override
    public void injectLiveMapProvider(@NotNull Function2<? super List<? extends List<? extends GeomLayer>>, ? super Map<String, ? extends Object>, ? extends Object> f) {
        Intrinsics.checkNotNullParameter(f, (String)"f");
        if (this.getContainsLiveMap()) {
            List<List<GeomLayer>> listOfTiles = this.plotAssembler.getGeomTiles().coreLayersByTile();
            this.liveMapCursorServiceConfig = f.invoke(listOfTiles, this.processedPlotSpec);
        }
    }

    @Override
    @NotNull
    public PlotSvgRoot createSvgRoot() {
        Object object;
        if (!(this._layoutInfo != null)) {
            boolean bl = false;
            String string = "Plot figure is not layouted.";
            throw new IllegalStateException(string.toString());
        }
        PlotFigureLayoutInfo plotFigureLayoutInfo = this._layoutInfo;
        if (plotFigureLayoutInfo == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"_layoutInfo");
            plotFigureLayoutInfo = null;
        }
        PlotSvgComponent plotSvgComponent = this.plotAssembler.createPlot(plotFigureLayoutInfo);
        if (this.getContainsLiveMap()) {
            object = this.liveMapCursorServiceConfig;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"liveMapCursorServiceConfig");
                object = Unit.INSTANCE;
            }
        } else {
            object = null;
        }
        return new PlotSvgRoot(plotSvgComponent, object, this.getBounds().getOrigin());
    }

    @Override
    @NotNull
    public PlotFigureBuildInfo withBounds(@NotNull DoubleRectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)bounds, (String)"bounds");
        return Intrinsics.areEqual((Object)bounds, (Object)this.getBounds()) ? this : this.makeCopy(bounds);
    }

    @Override
    @NotNull
    public PlotFigureBuildInfo layoutedByOuterSize() {
        PlotFigureBuildInfo plotFigureBuildInfo;
        DoubleVector outerSize = this.getBounds().getDimension();
        PlotFigureLayoutInfo layoutInfo = this.plotAssembler.layoutByOuterSize(outerSize);
        PlotFigureBuildInfo $this$layoutedByOuterSize_u24lambda_u241 = plotFigureBuildInfo = PlotFigureBuildInfo.makeCopy$default(this, null, 1, null);
        boolean bl = false;
        $this$layoutedByOuterSize_u24lambda_u241._layoutInfo = layoutInfo;
        return plotFigureBuildInfo;
    }

    @Override
    @NotNull
    public PlotFigureBuildInfo layoutedByGeomBounds(@NotNull DoubleRectangle geomBounds) {
        PlotFigureBuildInfo plotFigureBuildInfo;
        Intrinsics.checkNotNullParameter((Object)geomBounds, (String)"geomBounds");
        PlotFigureLayoutInfo layoutInfo = this.plotAssembler.layoutByGeomSize(geomBounds.getDimension());
        DoubleVector oldCenter = geomBounds.getCenter();
        DoubleVector newCenter = layoutInfo.getGeomAreaBounds().getCenter();
        DoubleVector delta = newCenter.subtract(oldCenter);
        DoubleVector newOrigin = this.getBounds().getOrigin().subtract(delta);
        DoubleVector newSize = layoutInfo.getFigureLayoutedBounds().getDimension();
        DoubleRectangle newBounds = new DoubleRectangle(newOrigin, newSize);
        PlotFigureBuildInfo $this$layoutedByGeomBounds_u24lambda_u242 = plotFigureBuildInfo = this.makeCopy(newBounds);
        boolean bl = false;
        $this$layoutedByGeomBounds_u24lambda_u242._layoutInfo = layoutInfo;
        return plotFigureBuildInfo;
    }

    private final PlotFigureBuildInfo makeCopy(DoubleRectangle newBounds) {
        DoubleRectangle doubleRectangle = newBounds;
        if (doubleRectangle == null) {
            doubleRectangle = this.getBounds();
        }
        PlotFigureBuildInfo newBuildInfo = new PlotFigureBuildInfo(this.plotAssembler, this.processedPlotSpec, doubleRectangle, this.getComputationMessages());
        if (this.liveMapCursorServiceConfig != null) {
            Object object = this.liveMapCursorServiceConfig;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"liveMapCursorServiceConfig");
                object = Unit.INSTANCE;
            }
            newBuildInfo.liveMapCursorServiceConfig = object;
        }
        return newBuildInfo;
    }

    static /* synthetic */ PlotFigureBuildInfo makeCopy$default(PlotFigureBuildInfo plotFigureBuildInfo, DoubleRectangle doubleRectangle, int n, Object object) {
        if ((n & 1) != 0) {
            doubleRectangle = null;
        }
        return plotFigureBuildInfo.makeCopy(doubleRectangle);
    }

    @Override
    @NotNull
    public FigureBuildInfo withPreferredSize(@NotNull DoubleVector size2) {
        Intrinsics.checkNotNullParameter((Object)size2, (String)"size");
        return new PlotFigureBuildInfo(this.plotAssembler, this.processedPlotSpec, new DoubleRectangle(DoubleVector.Companion.getZERO(), size2), this.getComputationMessages());
    }
}

