/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.model.specification;

import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SingleRootFileViewProvider;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.swagger.core.SwSpecificationType;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.index.OpenapiSpecificationContentIndexKt;
import com.intellij.swagger.core.index.SwIndexUtilsKt;
import com.intellij.swagger.core.index.SwLexerBasedSpecificationRecognitionKt;
import com.intellij.swagger.core.model.SwSecondarySpecificationModelComputationKt;
import com.intellij.swagger.core.model.SwUserDefinedSpecifications;
import com.intellij.swagger.core.model.specification.SwSpecificationFile;
import com.intellij.swagger.core.model.specification.SwaggerFileHelperKt;
import com.intellij.swagger.core.model.specification.asyncapi.AsyncapiSpecificationFile;
import com.intellij.swagger.core.model.specification.openapi.v3.Openapi3LightSpecificationFile;
import com.intellij.swagger.core.model.specification.openapi.v31.Openapi31LightSpecificationFile;
import com.intellij.swagger.core.model.specification.swagger.v2.Swagger2LightSpecificationFile;
import com.intellij.swagger.core.traverser.SwTreeUtil;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLFileType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J2\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u0012J0\u0010\u0014\u001a\u0004\u0018\u00010\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u0013J4\u0010\u0019\u001a\u0004\u0018\u00010\f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0017\u001a\u00020\u00132\b\b\u0002\u0010\u0018\u001a\u00020\u0013J\u0018\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001d\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001eJ%\u0010\u001f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b J\u0015\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b#J\u001d\u0010$\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010%\u001a\u00020&H\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b)J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R-\u0010\u0004\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 \b*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/swagger/core/model/specification/SwaggerFileHelper;", "", "<init>", "()V", "SPECIFICATION_TYPE_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/swagger/core/SwSpecificationType;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "collectSpecificationFiles", "Lkotlin/sequences/Sequence;", "Lcom/intellij/swagger/core/model/specification/SwSpecificationFile;", "project", "Lcom/intellij/openapi/project/Project;", "searchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "specificationFilter", "Lkotlin/Function1;", "", "getSpecificationFileFor", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "isLight", "isRemote", "createSpecificationFile", "psiFile", "Lcom/intellij/psi/PsiFile;", "computeSpecificationType", "getOrComputeSpecificationType", "getOrComputeSpecificationType$intellij_swagger_core", "getOrComputePrimarySpecificationType", "getOrComputePrimarySpecificationType$intellij_swagger_core", "getOrComputeSecondarySpecificationType", "specificationPart", "getOrComputeSecondarySpecificationType$intellij_swagger_core", "getUserDefinedSpecificationType", "fileUrl", "", "getUserDefinedSpecificationType$intellij_swagger_core", "isSuitableFileType", "isSuitableFileType$intellij_swagger_core", "isSuitableFile", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwaggerFileHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwaggerFileHelper.kt\ncom/intellij/swagger/core/model/specification/SwaggerFileHelper\n+ 2 SwTreeUtil.kt\ncom/intellij/swagger/core/traverser/SwTreeUtil\n+ 3 SwaggerCacheUtils.kt\ncom/intellij/swagger/core/SwaggerCacheUtilsKt\n+ 4 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,124:1\n35#2,2:125\n22#3,4:127\n13#3,4:131\n31#4,2:135\n*S KotlinDebug\n*F\n+ 1 SwaggerFileHelper.kt\ncom/intellij/swagger/core/model/specification/SwaggerFileHelper\n*L\n53#1:125,2\n91#1:127,4\n98#1:131,4\n104#1:135,2\n*E\n"})
public final class SwaggerFileHelper {
    @NotNull
    public static final SwaggerFileHelper INSTANCE = new SwaggerFileHelper();
    @NotNull
    private static final Key<CachedValue<SwSpecificationType>> SPECIFICATION_TYPE_KEY;

    private SwaggerFileHelper() {
    }

    @NotNull
    public final Sequence<SwSpecificationFile> collectSpecificationFiles(@NotNull Project project, @NotNull GlobalSearchScope searchScope, @NotNull Function1<? super SwSpecificationFile, Boolean> specificationFilter) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)searchScope, (String)"searchScope");
        Intrinsics.checkNotNullParameter(specificationFilter, (String)"specificationFilter");
        return SequencesKt.filter((Sequence)SequencesKt.mapNotNull(OpenapiSpecificationContentIndexKt.getAllOpenApiIndexedFiles(searchScope), arg_0 -> SwaggerFileHelper.collectSpecificationFiles$lambda$1(project, arg_0)), arg_0 -> SwaggerFileHelper.collectSpecificationFiles$lambda$2(specificationFilter, arg_0));
    }

    public static /* synthetic */ Sequence collectSpecificationFiles$default(SwaggerFileHelper swaggerFileHelper, Project project, GlobalSearchScope globalSearchScope, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = SwaggerFileHelper::collectSpecificationFiles$lambda$0;
        }
        return swaggerFileHelper.collectSpecificationFiles(project, globalSearchScope, (Function1<? super SwSpecificationFile, Boolean>)function1);
    }

    @Nullable
    public final SwSpecificationFile getSpecificationFileFor(@Nullable VirtualFile virtualFile, @Nullable Project project, boolean isLight, boolean isRemote) {
        if (virtualFile == null || project == null || !virtualFile.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        return this.createSpecificationFile(psiFile2, virtualFile, project, isLight, isRemote);
    }

    public static /* synthetic */ SwSpecificationFile getSpecificationFileFor$default(SwaggerFileHelper swaggerFileHelper, VirtualFile virtualFile, Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        return swaggerFileHelper.getSpecificationFileFor(virtualFile, project, bl, bl2);
    }

    @Nullable
    public final SwSpecificationFile createSpecificationFile(@NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile, @NotNull Project project, boolean isLight, boolean isRemote) {
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!isLight) {
            SwTreeUtil $this$iv = SwTreeUtil.INSTANCE;
            boolean withSelf$iv = true;
            boolean $i$f$getParentOfType = false;
            return $this$iv.getParentOfType((PsiElement)psiFile, SwSpecificationFile.class, withSelf$iv);
        }
        SmartPsiElementPointer<PsiElement> pointer = SwaggerUtilsKt.createPointer((PsiElement)psiFile);
        SwSpecificationType swSpecificationType = OpenapiSpecificationContentIndexKt.getIndexedSpecificationType(virtualFile, project);
        return swSpecificationType instanceof SwSpecificationType.Swagger2Family ? (SwSpecificationFile)new Swagger2LightSpecificationFile(pointer, isRemote) : (swSpecificationType instanceof SwSpecificationType.OpenAPI30Family ? (SwSpecificationFile)new Openapi3LightSpecificationFile(pointer, isRemote) : (swSpecificationType instanceof SwSpecificationType.OpenAPI31Family ? (SwSpecificationFile)new Openapi31LightSpecificationFile(pointer, isRemote) : (swSpecificationType instanceof SwSpecificationType.ASYNCAPI_2_6 ? (SwSpecificationFile)new AsyncapiSpecificationFile(pointer, SwSpecificationType.ASYNCAPI_2_6.INSTANCE) : (swSpecificationType instanceof SwSpecificationType.ASYNCAPI_3_0 ? (SwSpecificationFile)new AsyncapiSpecificationFile(pointer, SwSpecificationType.ASYNCAPI_3_0.INSTANCE) : null))));
    }

    public static /* synthetic */ SwSpecificationFile createSpecificationFile$default(SwaggerFileHelper swaggerFileHelper, PsiFile psiFile, VirtualFile virtualFile, Project project, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        return swaggerFileHelper.createSpecificationFile(psiFile, virtualFile, project, bl, bl2);
    }

    private final SwSpecificationType computeSpecificationType(PsiFile psiFile, VirtualFile virtualFile) {
        return !this.isSuitableFile(virtualFile) ? (SwSpecificationType)SwSpecificationType.UNKNOWN.INSTANCE : SwLexerBasedSpecificationRecognitionKt.getOrRecognizeSpecificationTypeWithLexer(psiFile);
    }

    @NotNull
    public final SwSpecificationType getOrComputeSpecificationType$intellij_swagger_core(@NotNull VirtualFile virtualFile, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        if (!this.isSuitableFileType$intellij_swagger_core(virtualFile)) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        Project project = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        String string = virtualFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        SwSpecificationType userDefinedSpecificationType = this.getUserDefinedSpecificationType$intellij_swagger_core(project, string);
        if (!(userDefinedSpecificationType instanceof SwSpecificationType.UNKNOWN)) {
            return userDefinedSpecificationType;
        }
        Project project2 = psiFile.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        SwSpecificationType primaryType = this.getOrComputePrimarySpecificationType$intellij_swagger_core(project2, psiFile, virtualFile);
        if (!(primaryType instanceof SwSpecificationType.UNKNOWN)) {
            return primaryType;
        }
        return this.getOrComputeSecondarySpecificationType$intellij_swagger_core(psiFile);
    }

    @NotNull
    public final SwSpecificationType getOrComputePrimarySpecificationType$intellij_swagger_core(@NotNull Project project, @NotNull PsiFile psiFile, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        SwSpecificationType precomputedSpecificationType = SwIndexUtilsKt.getPrecomputedSpecificationTypeFromUserData(psiFile);
        if (precomputedSpecificationType != null) {
            return precomputedSpecificationType;
        }
        Key<CachedValue<SwSpecificationType>> key$iv = SPECIFICATION_TYPE_KEY;
        boolean $i$f$cacheOnFileTypeTracker = false;
        return (SwSpecificationType)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)psiFile, key$iv, new CachedValueProvider(project, psiFile, virtualFile){
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiFile $psiFile$inlined;
            final /* synthetic */ VirtualFile $virtualFile$inlined;
            {
                this.$project = $project;
                this.$psiFile$inlined = psiFile;
                this.$virtualFile$inlined = virtualFile;
            }

            public final CachedValueProvider.Result<T> compute() {
                boolean bl = false;
                SwSpecificationType result2 = SwaggerFileHelper.access$computeSpecificationType(SwaggerFileHelper.INSTANCE, this.$psiFile$inlined, this.$virtualFile$inlined);
                Object[] objectArray = new Object[]{SwaggerUtilsKt.getYamlJsonModificationTracker(this.$project)};
                return new CachedValueProvider.Result((Object)result2, objectArray);
            }
        }, false);
    }

    @NotNull
    public final SwSpecificationType getOrComputeSecondarySpecificationType$intellij_swagger_core(@NotNull PsiFile specificationPart) {
        Intrinsics.checkNotNullParameter((Object)specificationPart, (String)"specificationPart");
        Project project = specificationPart.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (SwIndexUtilsKt.isIndexingRightNow(project)) {
            return SwSpecificationType.UNKNOWN.INSTANCE;
        }
        Project project2 = specificationPart.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getProject(...)");
        Project project$iv = project2;
        boolean $i$f$cacheOnFileTypeTracker = false;
        return (SwSpecificationType)CachedValuesManager.getManager((Project)project$iv).getCachedValue((UserDataHolder)specificationPart, new CachedValueProvider(project$iv, specificationPart){
            final /* synthetic */ Project $project;
            final /* synthetic */ PsiFile $specificationPart$inlined;
            {
                this.$project = $project;
                this.$specificationPart$inlined = psiFile;
            }

            public final CachedValueProvider.Result<T> compute() {
                boolean bl = false;
                SwSpecificationType result2 = SwSecondarySpecificationModelComputationKt.computeSecondarySpecificationType(this.$specificationPart$inlined);
                Object[] objectArray = new Object[]{SwaggerUtilsKt.getYamlJsonModificationTracker(this.$project)};
                return new CachedValueProvider.Result((Object)result2, objectArray);
            }
        });
    }

    @NotNull
    public final SwSpecificationType getUserDefinedSpecificationType$intellij_swagger_core(@NotNull Project project, @NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<SwUserDefinedSpecifications> serviceClass$iv = SwUserDefinedSpecifications.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        return ((SwUserDefinedSpecifications)object).getSpecificationType(fileUrl);
    }

    public final boolean isSuitableFileType$intellij_swagger_core(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        return virtualFile.getFileType() instanceof YAMLFileType ? true : (virtualFile.getFileType() instanceof JsonFileType ? true : (ScratchUtil.isScratch((VirtualFile)virtualFile) ? CollectionsKt.contains((Iterable)SwaggerFileHelperKt.access$getALLOWED_SCRATCH_EXTENSIONS$p(), (Object)virtualFile.getExtension()) : false));
    }

    private final boolean isSuitableFile(VirtualFile virtualFile) {
        return !virtualFile.isDirectory() && virtualFile.isValid() && this.isSuitableFileType$intellij_swagger_core(virtualFile) && !SingleRootFileViewProvider.isTooLargeForIntelligence((VirtualFile)virtualFile);
    }

    private static final boolean collectSpecificationFiles$lambda$0(SwSpecificationFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final SwSpecificationFile collectSpecificationFiles$lambda$1(Project $project, VirtualFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SwaggerFileHelper.getSpecificationFileFor$default(INSTANCE, it, $project, false, false, 12, null);
    }

    private static final boolean collectSpecificationFiles$lambda$2(Function1 $specificationFilter, SwSpecificationFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (Boolean)$specificationFilter.invoke((Object)it);
    }

    public static final /* synthetic */ SwSpecificationType access$computeSpecificationType(SwaggerFileHelper $this, PsiFile psiFile, VirtualFile virtualFile) {
        return $this.computeSpecificationType(psiFile, virtualFile);
    }

    static {
        Key key = Key.create((String)"swSpecificationType");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SPECIFICATION_TYPE_KEY = key;
    }
}

