/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.swagger.core.providers;

import com.intellij.ide.presentation.Presentation;
import com.intellij.microservices.url.Authority;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlResolveRequest;
import com.intellij.microservices.url.UrlResolver;
import com.intellij.microservices.url.UrlResolverFactory;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.swagger.core.SwaggerUtilsKt;
import com.intellij.swagger.core.model.SwaggerMergedModel;
import com.intellij.swagger.core.model.api.SwAuthority;
import com.intellij.swagger.core.model.api.SwModelBase;
import com.intellij.swagger.core.model.api.SwSchema;
import com.intellij.swagger.core.model.api.SwUrl;
import com.intellij.swagger.core.providers.SwUrlResolver;
import com.intellij.swagger.core.providers.resolve.SpecificationResolveHelperKt;
import com.intellij.swagger.core.providers.resolve.SwUrlTargetUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Presentation(icon="com.intellij.swagger.core.SwaggerCoreIcons.Endpoint", typeName="Swagger")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u00002\u00020\u0001:\u0001\u0019B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lcom/intellij/swagger/core/providers/SwUrlResolver;", "Lcom/intellij/microservices/url/UrlResolver;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "model", "Lcom/intellij/swagger/core/model/SwaggerMergedModel;", "projectSearchScope", "Lcom/intellij/psi/search/GlobalSearchScope;", "Lorg/jetbrains/annotations/NotNull;", "getAuthorityHints", "", "Lcom/intellij/microservices/url/Authority$Exact;", "schema", "", "supportedSchemes", "getSupportedSchemes", "()Ljava/util/List;", "resolve", "", "Lcom/intellij/microservices/url/UrlTargetInfo;", "request", "Lcom/intellij/microservices/url/UrlResolveRequest;", "getVariants", "Factory", "intellij.swagger.core"})
@SourceDebugExtension(value={"SMAP\nSwUrlResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwUrlResolver.kt\ncom/intellij/swagger/core/providers/SwUrlResolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,49:1\n1557#2:50\n1628#2,3:51\n1557#2:54\n1628#2,3:55\n1368#2:58\n1454#2,5:59\n*S KotlinDebug\n*F\n+ 1 SwUrlResolver.kt\ncom/intellij/swagger/core/providers/SwUrlResolver\n*L\n28#1:50\n28#1:51,3\n31#1:54\n31#1:55,3\n46#1:58\n46#1:59,5\n*E\n"})
public final class SwUrlResolver
implements UrlResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final SwaggerMergedModel model;
    @NotNull
    private final GlobalSearchScope projectSearchScope;

    public SwUrlResolver(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
        this.model = SwaggerMergedModel.Companion.getInstance(this.myProject);
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getProjectScope(...)");
        this.projectSearchScope = globalSearchScope;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Authority.Exact> getAuthorityHints(@Nullable String schema2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getAuthorities(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwAuthority swAuthority = (SwAuthority)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Authority.Exact(it.getAuthorityValue().getValue()));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<String> getSupportedSchemes() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.model.getSchemes(this.projectSearchScope);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            SwSchema swSchema = (SwSchema)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(SwaggerUtilsKt.withEndingSlash(it.getSchemaValue().getValue()));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public Iterable<UrlTargetInfo> resolve(@NotNull UrlResolveRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMap((Sequence)UrlPath.Companion.combinations(request.getPath()), arg_0 -> SwUrlResolver.resolve$lambda$3(this, request, arg_0)));
    }

    @NotNull
    public Iterable<UrlTargetInfo> getVariants() {
        return SequencesKt.asIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.model.getBaseModelElements(this.projectSearchScope)), arg_0 -> SwUrlResolver.getVariants$lambda$4(this, arg_0)), SwUrlResolver::getVariants$lambda$6));
    }

    private static final boolean resolve$lambda$3$lambda$2(UrlResolveRequest $request, UrlTargetInfo endpointTarget) {
        Intrinsics.checkNotNullParameter((Object)endpointTarget, (String)"endpointTarget");
        CharSequence charSequence = $request.getMethod();
        return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || CollectionsKt.contains((Iterable)endpointTarget.getMethods(), (Object)$request.getMethod());
    }

    private static final Sequence resolve$lambda$3(SwUrlResolver this$0, UrlResolveRequest $request, UrlPath it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return SequencesKt.filter((Sequence)SequencesKt.flatMapIterable(SpecificationResolveHelperKt.resolveUrl(it, this$0.projectSearchScope), (Function1)resolve.1.1.INSTANCE), arg_0 -> SwUrlResolver.resolve$lambda$3$lambda$2($request, arg_0));
    }

    private static final SwModelBase getVariants$lambda$4(SwUrlResolver this$0, SwModelBase it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.substitute(this$0.myProject);
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getVariants$lambda$6(SwModelBase model) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        Iterable $this$flatMap$iv = model.getUrls();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            SwUrl it = (SwUrl)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = SwUrlTargetUtilsKt.getOrComputeUrlOrEndpointTargets(it, model.isRemote());
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/swagger/core/providers/SwUrlResolver$Factory;", "Lcom/intellij/microservices/url/UrlResolverFactory;", "<init>", "()V", "forProject", "Lcom/intellij/microservices/url/UrlResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.swagger.core"})
    public static final class Factory
    implements UrlResolverFactory {
        @Nullable
        public UrlResolver forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            return SwaggerMergedModel.Companion.getInstance(project).hasSpecifications() ? (UrlResolver)new SwUrlResolver(project) : null;
        }
    }
}

