/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.ui;

import com.google.common.base.Objects;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.console.KeepAliveActionDescriptor;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DataSourceInfo;
import com.intellij.database.dataSource.DataSourceSessionTemplate;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseAuthProvider;
import com.intellij.database.dataSource.DatabaseConnection;
import com.intellij.database.dataSource.DatabaseConnectionConfig;
import com.intellij.database.dataSource.DatabaseConnectionManager;
import com.intellij.database.dataSource.DatabaseConnectionPoint;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverUtils;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.connection.statements.BarrenStatement;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dataSource.connection.statements.SmartStatements;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManager;
import com.intellij.database.dataSource.ui.DataSourceTestConnectionManagerKt;
import com.intellij.database.dataSource.validation.DatabaseDriverValidator;
import com.intellij.database.dataSource.validation.NamedProgressive;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.dialects.DatabaseErrorHandler;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.util.AsyncTask;
import com.intellij.database.util.AsyncUtil;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.Version;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.database.view.ui.DatabaseConfigSideTab;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.SearchWebAction;
import com.intellij.ide.nls.NlsMessages;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ThreeState;
import com.intellij.util.io.BlockingKt;
import com.intellij.util.io.ProcessKt;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.classpath.SimpleClasspathElement;
import java.awt.Color;
import java.lang.invoke.LambdaMetafactory;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.InterruptibleKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 H2\u00020\u0001:\u0006GHIJKLB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\f0\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\"\u0010\u0017\u001a\u0004\u0018\u00010\u00012\b\u0010\u0013\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0086@\u00a2\u0006\u0002\u0010\u0018J \u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\fH\u0082@\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J&\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$H\u0082@\u00a2\u0006\u0002\u0010%J4\u0010&\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\b\u0010'\u001a\u0004\u0018\u00010\u001f2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J,\u0010*\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\r2\b\u0010+\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010/\u001a\u00020\u0016H\u0002J\u0010\u00100\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\rH\u0002J\b\u00101\u001a\u00020\u0012H\u0002J\u0016\u00102\u001a\u00020\u00122\u0006\u00103\u001a\u0002042\u0006\u0010\"\u001a\u00020\rJ\u000e\u00105\u001a\u00020\u00102\u0006\u0010\"\u001a\u00020\rJ\u0015\u00106\u001a\u00070\f\u00a2\u0006\u0002\b72\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010\"\u001a\u00020\rH\u0002J\u0015\u0010:\u001a\u00070;\u00a2\u0006\u0002\b<2\u0006\u0010\"\u001a\u00020\rH\u0002J\u001d\u0010=\u001a\n >*\u0004\u0018\u000109092\u0006\u0010\"\u001a\u00020\rH\u0002\u00a2\u0006\u0002\u0010?J\u0018\u0010@\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020\r2\u0006\u0010(\u001a\u00020AH\u0002J\u0010\u0010B\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\rH\u0002J\u0018\u0010B\u001a\u00020\u00162\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\"\u001a\u00020CH\u0002J\u0010\u0010D\u001a\u00020\f2\u0006\u0010\"\u001a\u00020\rH\u0002J\u0010\u0010E\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\fJ\u0006\u0010F\u001a\u00020\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\n\u001a\"\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r0\u000bj\u0010\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager;", "", "configurable", "Lcom/intellij/database/dataSource/DataSourceConfigurable;", "<init>", "(Lcom/intellij/database/dataSource/DataSourceConfigurable;)V", "getConfigurable", "()Lcom/intellij/database/dataSource/DataSourceConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "cached", "Ljava/util/HashMap;", "", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;", "Lkotlin/collections/HashMap;", "balloon", "Lcom/intellij/openapi/ui/popup/Balloon;", "testConnectionAsync", "", "sessionTemplateId", "", "checkConfiguration", "", "testConnection", "(Ljava/lang/String;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleIncompleteConfiguration", "ds", "Lcom/intellij/database/dataSource/LocalDataSource;", "(Lcom/intellij/database/dataSource/LocalDataSource;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "areArtifactsValid", "performTestConnection", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "info", "handler", "Lcom/intellij/database/util/ErrorHandler;", "(Lcom/intellij/database/dataSource/DatabaseConnectionConfig;Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;Lcom/intellij/database/util/ErrorHandler;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "applyTestConnectionResult", "r", "e", "", "setStatus", "status", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "job", "Lkotlinx/coroutines/Job;", "cancel", "update", "hideDetails", "showDetails", "pt", "Lcom/intellij/ui/awt/RelativePoint;", "createBalloon", "detailsHtml", "Lcom/intellij/openapi/util/NlsContexts$PopupContent;", "detailsChunk", "Lcom/intellij/openapi/util/text/HtmlChunk;", "statusChunk", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "Lorg/jetbrains/annotations/NotNull;", "actionsChunk", "kotlin.jvm.PlatformType", "(Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;)Lcom/intellij/openapi/util/text/HtmlChunk;", "handleDetailsLink", "Ljavax/swing/event/HyperlinkEvent;", "manuallySpecifyDbVersion", "Lcom/intellij/database/dataSource/DataSourceInfo;", "description", "getInfo", "resetStatus", "Listener", "Companion", "TestInfo", "Status", "TestConnectionResult", "ProcessedTestConnectionResult", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,602:1\n1#2:603\n*E\n"})
public final class DataSourceTestConnectionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DataSourceConfigurable configurable;
    @NotNull
    private final Project project;
    @NotNull
    private final HashMap<String, TestInfo> cached;
    @Nullable
    private volatile Balloon balloon;
    @NotNull
    private static final Topic<Listener> TOPIC = new Topic("DataSourceTestConnectionManager.Listener", Listener.class);

    public DataSourceTestConnectionManager(@NotNull DataSourceConfigurable configurable) {
        Intrinsics.checkNotNullParameter((Object)configurable, (String)"configurable");
        this.configurable = configurable;
        Project project = this.configurable.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.project = project;
        this.cached = new HashMap();
    }

    @NotNull
    public final DataSourceConfigurable getConfigurable() {
        return this.configurable;
    }

    public final void testConnectionAsync(@NotNull List<String> sessionTemplateId, boolean checkConfiguration) {
        Intrinsics.checkNotNullParameter(sessionTemplateId, (String)"sessionTemplateId");
        CoroutineScope coroutineScope = this.configurable.getCoroutineScope();
        Intrinsics.checkNotNullExpressionValue((Object)coroutineScope, (String)"getCoroutineScope(...)");
        ModalityState modalityState = ModalityState.defaultModalityState();
        Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"defaultModalityState(...)");
        BuildersKt.launch$default((CoroutineScope)coroutineScope, (CoroutineContext)ModalityKt.asContextElement((ModalityState)modalityState), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(sessionTemplateId, this, checkConfiguration, null){
            Object L$0;
            Object L$1;
            boolean Z$0;
            int label;
            final /* synthetic */ List<String> $sessionTemplateId;
            final /* synthetic */ DataSourceTestConnectionManager this$0;
            final /* synthetic */ boolean $checkConfiguration;
            {
                this.$sessionTemplateId = $sessionTemplateId;
                this.this$0 = $receiver;
                this.$checkConfiguration = $checkConfiguration;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        var2_3 = this.$sessionTemplateId;
                        var3_4 = this.this$0;
                        var4_5 = this.$checkConfiguration;
                        $i$f$forEach = false;
                        var6_7 = $this$forEach$iv.iterator();
lbl10:
                        // 3 sources

                        while (var6_7.hasNext()) {
                            element$iv = var6_7.next();
                            it = (String)element$iv;
                            $i$a$-forEach-DataSourceTestConnectionManager$testConnectionAsync$1$1 = false;
                            this.L$0 = var3_4;
                            this.L$1 = var6_7;
                            this.Z$0 = var4_5;
                            this.label = 1;
                            v0 = var3_4.testConnection(it, var4_5 != false, (Continuation<Object>)this);
                            if (v0 != var10_2) continue;
                            return var10_2;
                        }
                        break;
                    }
                    case 1: {
                        $i$f$forEach = false;
                        $i$a$-forEach-DataSourceTestConnectionManager$testConnectionAsync$1$1 = false;
                        var4_5 = this.Z$0;
                        var6_7 = (Iterator<T>)this.L$1;
                        var3_4 = (DataSourceTestConnectionManager)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl10
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @Nullable
    public final Object testConnection(@Nullable String sessionTemplateId, boolean checkConfiguration, @NotNull Continuation<Object> $completion) {
        return BuildersKt.withContext((CoroutineContext)com.intellij.openapi.application.CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, sessionTemplateId, checkConfiguration, null){
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            Object L$6;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DataSourceTestConnectionManager this$0;
            final /* synthetic */ String $sessionTemplateId;
            final /* synthetic */ boolean $checkConfiguration;
            {
                this.this$0 = $receiver;
                this.$sessionTemplateId = $sessionTemplateId;
                this.$checkConfiguration = $checkConfiguration;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$withContext = (CoroutineScope)this.L$0;
                        v0 = DataSourceTestConnectionManager.access$getCached$p(this.this$0).computeIfAbsent(this.$sessionTemplateId, (Function<Object, TestInfo>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, invokeSuspend$lambda$0(kotlin.jvm.functions.Function1 java.lang.Object ), (Ljava/lang/Object;)Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;)((Function1)testConnection.info.1.INSTANCE));
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"computeIfAbsent(...)");
                        info = v0;
                        DataSourceTestConnectionManager.access$setStatus(this.this$0, info, null, null, true);
                        v1 = this.this$0.getConfigurable().getTempDataSourceForConnection();
                        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getTempDataSourceForConnection(...)");
                        tempDataSource = v1;
                        info.setInfo(tempDataSource.getInfo().copy());
                        if (!this.$checkConfiguration || DataSourceTestConnectionManager.access$areArtifactsValid(this.this$0, tempDataSource)) ** GOTO lbl31
                        this.L$0 = $this$withContext;
                        this.L$1 = info;
                        this.L$2 = tempDataSource;
                        this.label = 1;
                        v2 = DataSourceTestConnectionManager.access$handleIncompleteConfiguration(this.this$0, tempDataSource, this.$sessionTemplateId, (Continuation)this);
                        if (v2 == var15_2) {
                            return var15_2;
                        }
                        ** GOTO lbl29
                    }
                    case 1: {
                        tempDataSource = (LocalDataSource)this.L$2;
                        info = (TestInfo)this.L$1;
                        $this$withContext = (CoroutineScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl29:
                        // 2 sources

                        if (!((Boolean)v2).booleanValue()) {
                            return null;
                        }
lbl31:
                        // 3 sources

                        if ((var5_6 = (CharSequence)tempDataSource.getUrl()) == null || StringsKt.isBlank((CharSequence)var5_6) != false) {
                            Messages.showErrorDialog((String)DatabaseBundle.message("message.text.specify.database.url", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.connect", new Object[0]));
                            this.this$0.getConfigurable().getUrlEditor().requestUrlFocus();
                            return null;
                        }
                        if (this.$sessionTemplateId == null) ** GOTO lbl50
                        v3 = tempDataSource.getSessionTemplates();
                        Intrinsics.checkNotNullExpressionValue(v3, (String)"getSessionTemplates(...)");
                        var6_7 = v3;
                        var7_8 = this.$sessionTemplateId;
                        var8_9 = var6_7;
                        for (T var10_11 : var8_9) {
                            it = (DataSourceSessionTemplate)var10_11;
                            $i$a$-find-DataSourceTestConnectionManager$testConnection$2$config$1 = false;
                            if (!Intrinsics.areEqual((Object)it.getTemplateId(), (Object)var7_8)) continue;
                            v4 = var10_11;
                            ** GOTO lbl48
                        }
                        v4 = null;
lbl48:
                        // 2 sources

                        v5 = v4;
                        ** GOTO lbl51
lbl50:
                        // 1 sources

                        v5 = config = (DatabaseConnectionConfig)tempDataSource;
lbl51:
                        // 2 sources

                        if (config == null) {
                            return null;
                        }
                        this.this$0.getConfigurable().hidePasswords();
                        prevAuthProvider = DatabaseAuthProvider.Companion.get(config);
                        prevCredentials = prevAuthProvider.loadAuthConfig(config, this.this$0.getConfigurable().getSecretService(), true);
                        v6 = tempDataSource.copy(true);
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"copy(...)");
                        prevDs = v6;
                        handler = new ErrorHandler();
                        it = $this$withContext;
                        $i$a$-find-DataSourceTestConnectionManager$testConnection$2$config$1 = this.this$0;
                        $i$a$-runCatching-DataSourceTestConnectionManager$testConnection$2$testResult$1 = false;
                        this.L$0 = info;
                        this.L$1 = tempDataSource;
                        this.L$2 = config;
                        this.L$3 = prevAuthProvider;
                        this.L$4 = prevCredentials;
                        this.L$5 = prevDs;
                        this.L$6 = handler;
                        this.label = 2;
                        v7 = DataSourceTestConnectionManager.access$performTestConnection($i$a$-find-DataSourceTestConnectionManager$testConnection$2$config$1, config, info, handler, (Continuation)this);
                        ** if (v7 != var15_2) goto lbl77
lbl76:
                        // 1 sources

                        return var15_2;
lbl77:
                        // 1 sources

                        ** GOTO lbl91
                    }
                    case 2: {
                        $i$a$-runCatching-DataSourceTestConnectionManager$testConnection$2$testResult$1 = false;
                        handler = (ErrorHandler)this.L$6;
                        prevDs = (LocalDataSource)this.L$5;
                        prevCredentials = this.L$4;
                        prevAuthProvider = (DatabaseAuthProvider)this.L$3;
                        config = (DatabaseConnectionConfig)this.L$2;
                        tempDataSource = (LocalDataSource)this.L$1;
                        info = (TestInfo)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v7 = $result;
lbl91:
                            // 2 sources

                            var13_18 = Result.constructor-impl((Object)((TestConnectionResult)v7));
                        }
                        catch (Throwable $i$a$-runCatching-DataSourceTestConnectionManager$testConnection$2$testResult$1) {
                            var13_18 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-DataSourceTestConnectionManager$testConnection$2$testResult$1));
                        }
                        testResult = var13_18;
                        r = (TestConnectionResult)(Result.isFailure-impl((Object)testResult) != false ? null : testResult);
                        e = Result.exceptionOrNull-impl((Object)testResult);
                        AsyncUtil.addUnhandledError(handler, e, config.getDataSource());
                        if (!prevDs.equalConfiguration(tempDataSource)) {
                            this.this$0.getConfigurable().reset(tempDataSource, false);
                        }
                        if (eqCredentials = Intrinsics.areEqual((Object)DatabaseAuthProvider.Companion.get(config), (Object)prevAuthProvider)) {
                            curCredentials = prevAuthProvider.loadAuthConfig(config, this.this$0.getConfigurable().getSecretService(), true);
                            eqCredentials = Objects.equal((Object)curCredentials, (Object)prevCredentials);
                        }
                        if (!eqCredentials) {
                            this.this$0.getConfigurable().reloadCredentials();
                        }
                        DataSourceTestConnectionManager.access$applyTestConnectionResult(this.this$0, config, info, handler, r, e);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final TestInfo invokeSuspend$lambda$0(Function1 $tmp0, Object p0) {
                return (TestInfo)$tmp0.invoke(p0);
            }
        }), $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object handleIncompleteConfiguration(LocalDataSource var1_1, String var2_2, Continuation<? super Boolean> $completion) {
        if (!($completion instanceof handleIncompleteConfiguration.1)) ** GOTO lbl-1000
        var14_4 = $completion;
        if ((var14_4.label & -2147483648) != 0) {
            var14_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ DataSourceTestConnectionManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return DataSourceTestConnectionManager.access$handleIncompleteConfiguration(this.this$0, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var15_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var4_7 = (String[])ds.getUrl();
                if (var4_7 == null || StringsKt.isBlank((CharSequence)var4_7) != false) {
                    var4_7 = new String[]{Messages.getOkButton()};
                    Messages.showDialog((Project)this.project, (String)DatabaseBundle.message("DataSourceConfigurable.no.url", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String[])var4_7, (int)0, (Icon)Messages.getErrorIcon());
                    return Boxing.boxBoolean((boolean)false);
                }
                if (this.areArtifactsValid((LocalDataSource)ds)) break;
                driver = ds.getDatabaseDriver();
                v0 = driver;
                if (v0 == null || (v0 = v0.getArtifacts()) == null) {
                    v0 = CollectionsKt.emptyList();
                }
                if ((artifacts = v0).isEmpty()) {
                    res = Messages.showYesNoDialog((Project)this.project, (String)DatabaseBundle.message("DataSourceConfigurable.no.driver.files", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.configure.driver", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
                    if (driver != null && res == 0) {
                        this.configurable.getController().navigateTo(driver, true);
                    }
                    return Boxing.boxBoolean((boolean)false);
                }
                var8_11 = (Iterable)artifacts;
                for (Object var10_14 : var8_11) {
                    it = (DatabaseDriver.ArtifactRef)var10_14;
                    $i$a$-find-DataSourceTestConnectionManager$handleIncompleteConfiguration$invalidArtifact$1 = false;
                    if (!(DatabaseArtifactManager.resolveVersion(driver, it) == null)) continue;
                    v1 = var10_14;
                    ** GOTO lbl37
                }
                v1 = null;
lbl37:
                // 2 sources

                invalidArtifact = v1;
                if (invalidArtifact != null) {
                    res = Messages.showYesNoDialog((Project)this.project, (String)DatabaseBundle.message("DataSourceConfigurable.invalid.provided", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.configure.driver", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
                    if (res == 0) {
                        this.configurable.getController().navigateTo(driver, true);
                    }
                    return Boxing.boxBoolean((boolean)false);
                }
                v2 = DatabaseArtifactManager.getArtifacts();
                v3 = driver;
                Intrinsics.checkNotNull((Object)v3);
                downloaded = DatabaseDriverUtils.isDriverFilesUpToDate(v2, v3, (List<DatabaseDriver.ArtifactRef>)artifacts);
                res = Messages.showYesNoDialog((Project)this.project, (String)DatabaseBundle.message(downloaded != false ? "DataSourceConfigurable.drivers.not.configured" : "DataSourceConfigurable.drivers.not.downloaded", new Object[0]), (String)DatabaseBundle.message("DataSourceConfigurable.incomplete", new Object[0]), (String)DatabaseBundle.message(downloaded != false ? "DataSourceConfigurable.switch.to.latest" : "DataSourceConfigurable.download.driver", new Object[0]), (String)Messages.getCancelButton(), (Icon)Messages.getErrorIcon());
                if (res != 0) break;
                var10_14 = DatabaseDriverValidator.createDownloaderTask((LocalDataSource)ds, this.configurable.getController());
                Intrinsics.checkNotNullExpressionValue(var10_14, (String)"createDownloaderTask(...)");
                task = var10_14;
                v4 = task.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getName(...)");
                $continuation.L$0 = this;
                $continuation.L$1 = sessionTemplateId;
                $continuation.label = 1;
                v5 = TasksKt.withModalProgress((Project)this.project, (String)v4, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((NamedProgressive)task, null){
                    int label;
                    final /* synthetic */ NamedProgressive $task;
                    {
                        this.$task = $task;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = CoroutinesKt.coroutineToIndicator(() -> handleIncompleteConfiguration.2.invokeSuspend$lambda$0(this.$task), (Continuation)((Continuation)this));
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final Unit invokeSuspend$lambda$0(NamedProgressive $task) {
                        $task.run(ProgressManager.getGlobalProgressIndicator());
                        return Unit.INSTANCE;
                    }
                }), (Continuation)$continuation);
                if (v5 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl67
            }
            case 1: {
                sessionTemplateId = (String)$continuation.L$1;
                this = (DataSourceTestConnectionManager)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v5 = $result;
lbl67:
                // 2 sources

                $continuation.L$0 = null;
                $continuation.L$1 = null;
                $continuation.label = 2;
                v6 = this.testConnection(sessionTemplateId, true, (Continuation<Object>)$continuation);
                if (v6 == var15_6) {
                    return var15_6;
                }
                ** GOTO lbl77
            }
            case 2: {
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
lbl77:
                // 2 sources

                return Boxing.boxBoolean((boolean)false);
            }
        }
        return Boxing.boxBoolean((boolean)false);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final boolean areArtifactsValid(LocalDataSource ds) {
        DatabaseDriver driver = ds.getDatabaseDriver();
        return driver != null && DatabaseDriverUtils.isDriverFilesValid(DatabaseArtifactManager.getArtifacts(), driver.getArtifacts(), (Collection<SimpleClasspathElement>)ds.getOwnClasspath());
    }

    private final Object performTestConnection(DatabaseConnectionConfig config, TestInfo info2, ErrorHandler handler2, Continuation<? super TestConnectionResult> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TestConnectionResult>, Object>(this, info2, config, handler2, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ DataSourceTestConnectionManager this$0;
            final /* synthetic */ TestInfo $info;
            final /* synthetic */ DatabaseConnectionConfig $config;
            final /* synthetic */ ErrorHandler $handler;
            {
                this.this$0 = $receiver;
                this.$info = $info;
                this.$config = $config;
                this.$handler = $handler;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        Deferred tcJob2 = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TestConnectionResult>, Object>(this.this$0, this.$config, this.$handler, null){
                            int label;
                            final /* synthetic */ DataSourceTestConnectionManager this$0;
                            final /* synthetic */ DatabaseConnectionConfig $config;
                            final /* synthetic */ ErrorHandler $handler;
                            {
                                this.this$0 = $receiver;
                                this.$config = $config;
                                this.$handler = $handler;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object object) {
                                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        Project project = DataSourceTestConnectionManager.access$getProject$p(this.this$0);
                                        DatabaseCredentials databaseCredentials = this.this$0.getConfigurable().getSecretService();
                                        Intrinsics.checkNotNullExpressionValue((Object)databaseCredentials, (String)"getSecretService(...)");
                                        this.label = 1;
                                        Object object3 = DataSourceTestConnectionManager.Companion.performTestConnection(project, this.$config, databaseCredentials, this.$handler, true, (Continuation<? super TestConnectionResult>)((Continuation)this));
                                        if (object3 != object2) return object3;
                                        return object2;
                                    }
                                    case 1: {
                                        void $result;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object3 = $result;
                                        return object3;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super TestConnectionResult> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)3, null);
                        DataSourceTestConnectionManager.access$setStatus(this.this$0, this.$info, null, (Job)tcJob2, true);
                        this.label = 1;
                        Object object3 = tcJob2.await((Continuation)this);
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super TestConnectionResult> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    private final void applyTestConnectionResult(DatabaseConnectionConfig config, TestInfo info2, ErrorHandler handler2, TestConnectionResult r, Throwable e) {
        ProcessedTestConnectionResult processed;
        if (AsyncUtil.isCancellation(e) && !handler2.hasErrors()) {
            this.setStatus(info2, null, null, false);
            return;
        }
        ProcessedTestConnectionResult $this$applyTestConnectionResult_u24lambda_u241 = processed = Companion.processTestConnectionResult(r, config, handler2);
        boolean bl = false;
        boolean specifyVersion = $this$applyTestConnectionResult_u24lambda_u241.getState() == ThreeState.YES && Version.ZERO.eqCoarse(config.getDataSource().getVersion()) && $this$applyTestConnectionResult_u24lambda_u241.getFixes().isEmpty();
        ProcessedTestConnectionResult $this$applyTestConnectionResult_u24lambda_u242 = processed;
        boolean bl2 = false;
        Status status = new Status($this$applyTestConnectionResult_u24lambda_u242.getState(), $this$applyTestConnectionResult_u24lambda_u242.getDataSourceInfo(), $this$applyTestConnectionResult_u24lambda_u242.getStateText(), $this$applyTestConnectionResult_u24lambda_u242.getSummary(), $this$applyTestConnectionResult_u24lambda_u242.getFixes(), specifyVersion);
        this.setStatus(info2, status, null, false);
        info2.setInfo(config.getDataSource().getInfo().copy());
        this.configurable.updateDatabaseInfo(config.getDataSource());
        this.configurable.getController().refresh();
    }

    private final void setStatus(TestInfo info2, Status status, Job job2, boolean cancel) {
        info2.setStatus(status);
        if (cancel) {
            Job job3 = info2.getJob();
            if (job3 != null) {
                Job.DefaultImpls.cancel$default((Job)job3, null, (int)1, null);
            }
            info2.setJob(null);
        }
        if (job2 != null) {
            info2.setJob(job2);
        }
        this.update(info2);
    }

    private final void update(TestInfo info2) {
        Job it = info2.getJob();
        boolean bl = false;
        boolean bl2 = it != null && it.isCompleted();
        if (bl2) {
            info2.setJob(null);
        }
        this.configurable.onTestConnectionUpdate(info2);
    }

    private final void hideDetails() {
        block0: {
            Balloon prev2 = this.balloon;
            this.balloon = null;
            Balloon balloon = prev2;
            if (balloon == null) break block0;
            balloon.hide();
        }
    }

    public final void showDetails(@NotNull RelativePoint pt, @NotNull TestInfo info2) {
        Intrinsics.checkNotNullParameter((Object)pt, (String)"pt");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        this.hideDetails();
        Balloon tmp = this.createBalloon(info2);
        tmp.show(pt, Balloon.Position.above);
        this.balloon = tmp;
    }

    @NotNull
    public final Balloon createBalloon(@NotNull TestInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info");
        Balloon balloon = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(this.detailsHtml(info2), null, UIUtil.getLabelTextForeground(), UIUtil.getPanelBackground(), arg_0 -> DataSourceTestConnectionManager.createBalloon$lambda$4(this, info2, arg_0)).setDisposable((Disposable)this.configurable).createBalloon();
        Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
        Balloon tmp = balloon;
        return tmp;
    }

    private final String detailsHtml(TestInfo info2) {
        String string = HtmlChunk.tag((String)"table").child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.statusChunk(info2).wrapWith("td")).child((HtmlChunk)this.actionsChunk(info2).wrapWith("td").style("text-align: right"))).child((HtmlChunk)HtmlChunk.tag((String)"tr").child((HtmlChunk)this.detailsChunk(info2).wrapWith("td").attr("colspan", "2"))).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final HtmlChunk detailsChunk(TestInfo info2) {
        Status status = info2.getStatus();
        if (status == null) {
            String string = DataSourceUtil.formatDataSourceInfoString(this.configurable.getTempDataSource());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDataSourceInfoString(...)");
            status = new Status(ThreeState.NO, string, "", null, CollectionsKt.emptyList(), false, 32, null);
        }
        return status.asHtml();
    }

    private final HtmlChunk.Element statusChunk(TestInfo info2) {
        String string;
        if (info2.getStatus() != null) {
            Status status = info2.getStatus();
            Intrinsics.checkNotNull((Object)status);
            string = status.getStateText();
        } else if (info2.getJob() != null) {
            String string2 = DatabaseBundle.message("test.connection.status.in.progress", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        } else {
            String string3 = DatabaseBundle.message("test.connection.status.last.known", new Object[0]);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        }
        HtmlChunk.Element element = HtmlChunk.text((String)string).bold();
        Status status = info2.getStatus();
        Object object = status != null ? status.getFail() : null;
        HtmlChunk.Element element2 = element.style("color: " + ColorUtil.toHtmlColor((Color)(switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1 -> (Color)JBColor.RED;
            case 2 -> JBColor.ORANGE.getDarkVariant();
            case 3 -> (Color)DatabaseConfigSideTab.DIM_GREEN;
            default -> (Color)JBColor.GRAY;
        })));
        Intrinsics.checkNotNullExpressionValue((Object)element2, (String)"style(...)");
        return element2;
    }

    private final HtmlChunk actionsChunk(TestInfo info2) {
        HtmlBuilder htmlBuilder;
        HtmlBuilder $this$actionsChunk_u24lambda_u245 = htmlBuilder = new HtmlBuilder();
        boolean bl = false;
        $this$actionsChunk_u24lambda_u245.appendRaw("&emsp;&emsp;");
        if (info2.getJob() != null) {
            $this$actionsChunk_u24lambda_u245.appendLink("cancel", DatabaseBundle.message("test.connection.action.cancel", new Object[0]));
            $this$actionsChunk_u24lambda_u245.appendRaw("&emsp;");
        }
        $this$actionsChunk_u24lambda_u245.appendLink("copy", DatabaseBundle.message("test.connection.action.copy", new Object[0]));
        Status status = info2.getStatus();
        if ((status != null ? status.getFail() : null) == ThreeState.YES) {
            $this$actionsChunk_u24lambda_u245.appendRaw("&emsp;");
            $this$actionsChunk_u24lambda_u245.appendLink("search", DatabaseBundle.message("test.connection.action.search.error", new Object[0]));
            $this$actionsChunk_u24lambda_u245.appendRaw("&emsp;");
            $this$actionsChunk_u24lambda_u245.appendLink("troubleshooting", DatabaseBundle.message("DataSourceTestConnectionPanel.troubleshooting", new Object[0]));
        }
        return htmlBuilder.toFragment();
    }

    /*
     * Unable to fully structure code
     */
    private final boolean handleDetailsLink(TestInfo info, HyperlinkEvent e) {
        block18: {
            block14: {
                block16: {
                    block17: {
                        block15: {
                            if (!Intrinsics.areEqual((Object)e.getEventType(), (Object)HyperlinkEvent.EventType.ACTIVATED)) {
                                return false;
                            }
                            var3_3 = e.getDescription();
                            if (var3_3 == null) break block14;
                            switch (var3_3.hashCode()) {
                                case -1367724422: {
                                    if (!var3_3.equals("cancel")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                                case -906336856: {
                                    if (var3_3.equals("search")) break;
                                    ** break;
                                }
                                case -350764011: {
                                    if (!var3_3.equals("edit-version")) {
                                        ** break;
                                    }
                                    break block16;
                                }
                                case -1272712614: {
                                    if (!var3_3.equals("troubleshooting")) {
                                        ** break;
                                    }
                                    break block17;
                                }
                                case 3059573: {
                                    if (!var3_3.equals("copy")) ** break;
                                    CopyPasteManager.copyTextToClipboard((String)this.description(info));
                                    break block18;
                                }
                            }
                            SearchWebAction.search((String)this.description(info));
                            break block18;
                        }
                        v0 = info.getJob();
                        if (v0 != null) {
                            Job.DefaultImpls.cancel$default((Job)v0, null, (int)1, null);
                        }
                        break block18;
                    }
                    DataSourceUiUtil.showTroubleshooting();
                    break block18;
                }
                this.manuallySpecifyDbVersion(info);
                break block18;
            }
            v1 = info.getStatus();
            if (v1 != null) {
                v2 = e.getDescription();
                v3 = this.configurable.getController();
                Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"getController(...)");
                v4 = v1.handleLink(v2, this.project, v3);
            } else {
                v4 = false;
            }
            return v4;
        }
        return true;
    }

    private final void manuallySpecifyDbVersion(TestInfo info2) {
        DataSourceInfo dsInfo = this.configurable.getDatabaseInfo();
        info2.setInfo(dsInfo);
        Intrinsics.checkNotNull((Object)dsInfo);
        if (this.manuallySpecifyDbVersion(this.project, dsInfo)) {
            this.configurable.updateDatabaseInfo(dsInfo);
            this.configurable.onTestConnectionUpdate(info2);
            this.configurable.getController().refresh();
        }
    }

    private final boolean manuallySpecifyDbVersion(Project project, DataSourceInfo info2) {
        boolean bl;
        Version initial = info2.getExactVersion();
        if (Intrinsics.areEqual((Object)initial, (Object)Version.ZERO)) {
            initial = null;
        }
        Version version = initial;
        String string = Messages.showInputDialog((Project)project, (String)DatabaseBundle.message("dialog.message.enter.database.version", new Object[0]), (String)DatabaseBundle.message("dialog.title.database.version", new Object[0]), null, (String)(version != null ? version.toString() : null), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                boolean bl;
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                try {
                    Version.of(inputString);
                    bl = true;
                }
                catch (Exception e) {
                    bl = false;
                }
                return bl;
            }

            public boolean canClose(String inputString) {
                Intrinsics.checkNotNullParameter((Object)inputString, (String)"inputString");
                return true;
            }
        });
        if (string == null) {
            return false;
        }
        String verStr2 = string;
        try {
            Version ver = Version.of(verStr2);
            info2.setDatabaseVersion(ver);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    private final String description(TestInfo info2) {
        Object object = info2.getStatus();
        if (object == null || (object = ((Status)object).describe()) == null) {
            String string = DataSourceUtil.formatDataSourceInfoString((LocalDataSource)this.configurable.getDataSource());
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDataSourceInfoString(...)");
        }
        return object;
    }

    @NotNull
    public final TestInfo getInfo(@Nullable String sessionTemplateId) {
        TestInfo testInfo = this.cached.computeIfAbsent(sessionTemplateId, arg_0 -> DataSourceTestConnectionManager.getInfo$lambda$6(getInfo.1.INSTANCE, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)testInfo, (String)"computeIfAbsent(...)");
        return testInfo;
    }

    public final void resetStatus() {
        Iterator<TestInfo> iterator = this.cached.values().iterator();
        while (iterator.hasNext()) {
            TestInfo value;
            Intrinsics.checkNotNullExpressionValue((Object)iterator.next(), (String)"next(...)");
            this.setStatus(value, null, null, false);
        }
    }

    private static final void createBalloon$lambda$4(DataSourceTestConnectionManager this$0, TestInfo $info, HyperlinkEvent it) {
        Intrinsics.checkNotNull((Object)it);
        if (this$0.handleDetailsLink($info, it)) {
            this$0.hideDetails();
        }
    }

    private static final TestInfo getInfo$lambda$6(Function1 $tmp0, Object p0) {
        return (TestInfo)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ HashMap access$getCached$p(DataSourceTestConnectionManager $this) {
        return $this.cached;
    }

    public static final /* synthetic */ void access$setStatus(DataSourceTestConnectionManager $this, TestInfo info2, Status status, Job job2, boolean cancel) {
        $this.setStatus(info2, status, job2, cancel);
    }

    public static final /* synthetic */ boolean access$areArtifactsValid(DataSourceTestConnectionManager $this, LocalDataSource ds) {
        return $this.areArtifactsValid(ds);
    }

    public static final /* synthetic */ Object access$handleIncompleteConfiguration(DataSourceTestConnectionManager $this, LocalDataSource ds, String sessionTemplateId, Continuation $completion) {
        return $this.handleIncompleteConfiguration(ds, sessionTemplateId, (Continuation<? super Boolean>)$completion);
    }

    public static final /* synthetic */ void access$applyTestConnectionResult(DataSourceTestConnectionManager $this, DatabaseConnectionConfig config, TestInfo info2, ErrorHandler handler2, TestConnectionResult r, Throwable e) {
        $this.applyTestConnectionResult(config, info2, handler2, r, e);
    }

    public static final /* synthetic */ Object access$performTestConnection(DataSourceTestConnectionManager $this, DatabaseConnectionConfig config, TestInfo info2, ErrorHandler handler2, Continuation $completion) {
        return $this.performTestConnection(config, info2, handler2, (Continuation<? super TestConnectionResult>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(DataSourceTestConnectionManager $this) {
        return $this.project;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J6\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0086@\u00a2\u0006\u0002\u0010\u0019J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J'\u0010\u001c\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001f\u001a\u00020\u0018H\u0002J\u0015\u0010 \u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u0010\f\u001a\u00020\rH\u0002J\u001a\u0010!\u001a\u00020\"2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001f\u0010#\u001a\u00070\u001d\u00a2\u0006\u0002\b\u001e2\u0006\u0010$\u001a\u00020\"2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002J\u001e\u0010%\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'H\u0082@\u00a2\u0006\u0002\u0010(J\u0018\u0010)\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020\rH\u0002J&\u0010+\u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\rH\u0082@\u00a2\u0006\u0002\u0010-J:\u0010.\u001a\u00020\u001b2\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b002\u001c\u00101\u001a\u0018\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b03\u0012\u0006\u0012\u0004\u0018\u00010\u000102H\u0082@\u00a2\u0006\u0002\u00104R\u001f\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u00065"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Companion;", "", "<init>", "()V", "TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Listener;", "kotlin.jvm.PlatformType", "getTOPIC", "()Lcom/intellij/util/messages/Topic;", "processTestConnectionResult", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$ProcessedTestConnectionResult;", "testConnectionResult", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "config", "Lcom/intellij/database/dataSource/DatabaseConnectionConfig;", "handler", "Lcom/intellij/database/util/ErrorHandler;", "performTestConnection", "project", "Lcom/intellij/openapi/project/Project;", "credentials", "Lcom/intellij/database/access/DatabaseCredentials;", "askPassword", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnectionConfig;Lcom/intellij/database/access/DatabaseCredentials;Lcom/intellij/database/util/ErrorHandler;ZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "addWarningsAndErrors", "", "createSummary", "", "Lorg/jetbrains/annotations/Nls;", "failed", "createSuccessSummary", "getState", "Lcom/intellij/util/ThreeState;", "getTextForState", "state", "testConnection", "connection", "Lcom/intellij/database/dataSource/DatabaseConnection;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnection;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "handleWarnings", "r", "pingDatabase", "result", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/database/dataSource/DatabaseConnection;Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "computeDetachedAndCancel", "cancellation", "Lkotlin/Function0;", "action", "Lkotlin/Function1;", "Lkotlin/coroutines/Continuation;", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 StringFun.kt\ncom/intellij/database/util/common/StringFun\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,602:1\n1863#2,2:603\n1557#2:607\n1628#2,3:608\n137#3:605\n1#4:606\n*S KotlinDebug\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Companion\n*L\n253#1:603,2\n317#1:607\n317#1:608,3\n273#1:605\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Topic<Listener> getTOPIC() {
            return TOPIC;
        }

        @NotNull
        public final ProcessedTestConnectionResult processTestConnectionResult(@Nullable TestConnectionResult testConnectionResult, @NotNull DatabaseConnectionConfig config, @NotNull ErrorHandler handler2) {
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
            boolean failed = handler2.hasErrors();
            this.addWarningsAndErrors(handler2, testConnectionResult, config);
            String summary = this.createSummary(handler2, testConnectionResult, failed);
            ThreeState state = this.getState(handler2, testConnectionResult);
            String stateText = this.getTextForState(state, testConnectionResult);
            String string = DataSourceUtil.formatDataSourceInfoString(config.getDataSource());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatDataSourceInfoString(...)");
            String dataSourceInfo = string;
            List list = handler2.getFixes();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getFixes(...)");
            return new ProcessedTestConnectionResult(state, dataSourceInfo, stateText, summary, list);
        }

        @Nullable
        public final Object performTestConnection(@NotNull Project project, @NotNull DatabaseConnectionConfig config, @NotNull DatabaseCredentials credentials, @NotNull ErrorHandler handler2, boolean askPassword, @NotNull Continuation<? super TestConnectionResult> $completion) {
            Listener publisher = (Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(this.getTOPIC());
            publisher.started(project, config);
            String string = DatabaseBundle.message("message.text.connection.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            AsyncTask.Frame frame = AsyncTask.Companion.frame(string);
            return TasksKt.withBackgroundProgress((Project)project, (String)frame.getName(), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TestConnectionResult>, Object>(frame, publisher, project, config, askPassword, credentials, handler2, null){
                int label;
                final /* synthetic */ AsyncTask.Frame $frame;
                final /* synthetic */ Listener $publisher;
                final /* synthetic */ Project $project;
                final /* synthetic */ DatabaseConnectionConfig $config;
                final /* synthetic */ boolean $askPassword;
                final /* synthetic */ DatabaseCredentials $credentials;
                final /* synthetic */ ErrorHandler $handler;
                {
                    this.$frame = $frame;
                    this.$publisher = $publisher;
                    this.$project = $project;
                    this.$config = $config;
                    this.$askPassword = $askPassword;
                    this.$credentials = $credentials;
                    this.$handler = $handler;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = BuildersKt.withContext((CoroutineContext)Dispatchers.getIO().plus((CoroutineContext)this.$frame.getElement()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super TestConnectionResult>, Object>(this.$publisher, this.$project, this.$config, this.$askPassword, this.$credentials, this.$handler, null){
                                int label;
                                private /* synthetic */ Object L$0;
                                final /* synthetic */ Listener $publisher;
                                final /* synthetic */ Project $project;
                                final /* synthetic */ DatabaseConnectionConfig $config;
                                final /* synthetic */ boolean $askPassword;
                                final /* synthetic */ DatabaseCredentials $credentials;
                                final /* synthetic */ ErrorHandler $handler;
                                {
                                    this.$publisher = $publisher;
                                    this.$project = $project;
                                    this.$config = $config;
                                    this.$askPassword = $askPassword;
                                    this.$credentials = $credentials;
                                    this.$handler = $handler;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 * Could not resolve type clashes
                                 */
                                public final Object invokeSuspend(Object var1_1) {
                                    var12_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            var4_4 /* !! */  = $this$withContext = (CoroutineScope)this.L$0;
                                            var5_5 = this.$project;
                                            var6_6 = this.$config;
                                            var7_7 = this.$askPassword;
                                            var8_8 = this.$credentials;
                                            var9_9 = this.$handler;
                                            $i$a$-runCatching-DataSourceTestConnectionManager$Companion$performTestConnection$2$1$res$1 = false;
                                            this.label = 1;
                                            v0 = DatabaseConnectionManager.Companion.getInstance().build(var5_5, var6_6).setAskPassword(var7_7 != false).setCredentialsStore(var8_8).async(var9_9, (Function2)new Function2<DatabaseConnection, Continuation<? super TestConnectionResult>, Object>(var5_5, null){
                                                int label;
                                                /* synthetic */ Object L$0;
                                                final /* synthetic */ Project $project;
                                                {
                                                    this.$project = $project;
                                                    super(2, $completion);
                                                }

                                                /*
                                                 * WARNING - void declaration
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final Object invokeSuspend(Object object) {
                                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                    switch (this.label) {
                                                        case 0: {
                                                            ResultKt.throwOnFailure((Object)object);
                                                            DatabaseConnection it = (DatabaseConnection)this.L$0;
                                                            this.label = 1;
                                                            Object object3 = com.intellij.database.dataSource.ui.DataSourceTestConnectionManager$Companion.access$testConnection(DataSourceTestConnectionManager.Companion, this.$project, it, (Continuation)this);
                                                            if (object3 != object2) return object3;
                                                            return object2;
                                                        }
                                                        case 1: {
                                                            void $result;
                                                            ResultKt.throwOnFailure((Object)$result);
                                                            Object object3 = $result;
                                                            return object3;
                                                        }
                                                    }
                                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                                }

                                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                                    var3_3.L$0 = value;
                                                    return (Continuation)var3_3;
                                                }

                                                public final Object invoke(DatabaseConnection p1, Continuation<? super TestConnectionResult> p2) {
                                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                                }
                                            }, this);
                                            ** if (v0 != var12_2) goto lbl19
lbl18:
                                            // 1 sources

                                            return var12_2;
lbl19:
                                            // 1 sources

                                            ** GOTO lbl27
                                        }
                                        case 1: {
                                            $i$a$-runCatching-DataSourceTestConnectionManager$Companion$performTestConnection$2$1$res$1 = false;
                                            try {
                                                ResultKt.throwOnFailure((Object)$result);
                                                v0 = $result;
lbl27:
                                                // 2 sources

                                                var10_13 = Result.constructor-impl((Object)((TestConnectionResult)v0));
                                            }
                                            catch (Throwable var11_12) {
                                                var10_13 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var11_12));
                                            }
                                            res = var10_13;
                                            this.$publisher.finished(this.$project, this.$config, (TestConnectionResult)(Result.isFailure-impl((Object)res) != false ? null : res), Result.exceptionOrNull-impl((Object)res));
                                            var4_4 /* !! */  = res;
                                            ResultKt.throwOnFailure((Object)var4_4 /* !! */ );
                                            return var4_4 /* !! */ ;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                    var3_3.L$0 = value;
                                    return (Continuation)var3_3;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super TestConnectionResult> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super TestConnectionResult> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), $completion);
        }

        private final void addWarningsAndErrors(ErrorHandler handler2, TestConnectionResult testConnectionResult, DatabaseConnectionConfig config) {
            block3: {
                Object object;
                Object object2 = testConnectionResult;
                if (object2 != null && (object2 = ((TestConnectionResult)object2).getWarnings()) != null) {
                    Iterable $this$forEach$iv = (Iterable)object2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        ErrorInfo it = (ErrorInfo)element$iv;
                        boolean bl = false;
                        handler2.add(it);
                    }
                }
                if ((object = testConnectionResult) == null || (object = ((TestConnectionResult)object).getKeepAliveError()) == null) break block3;
                Object it = object;
                boolean bl = false;
                LocalDataSource localDataSource = config.getDataSource();
                Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
                handler2.add(DatabaseConnectionManager.Companion.getSpecialErrorInfo((Throwable)it, localDataSource));
                DatabaseFixFactory databaseFixFactory = DatabaseFixFactory.getInstance();
                if (databaseFixFactory != null) {
                    DatabaseFixFactory databaseFixFactory2;
                    DatabaseFixFactory $this$addWarningsAndErrors_u24lambda_u242_u24lambda_u241 = databaseFixFactory2 = databaseFixFactory;
                    boolean bl2 = false;
                    handler2.getFixes().add($this$addWarningsAndErrors_u24lambda_u242_u24lambda_u241.changeKeepAliveQuery(config.getDatabaseDriver()));
                }
            }
        }

        private final String createSummary(ErrorHandler handler2, TestConnectionResult testConnectionResult, boolean failed) {
            Object summary = "";
            if (!failed && testConnectionResult != null) {
                summary = (String)summary + this.createSuccessSummary(testConnectionResult);
            }
            if (handler2.hasErrors()) {
                CharSequence $this$isNotNullOrEmpty$iv = (CharSequence)summary;
                boolean $i$f$isNotNullOrEmpty = false;
                if ($this$isNotNullOrEmpty$iv != null && $this$isNotNullOrEmpty$iv.length() > 0) {
                    summary = (String)summary + "\n\n";
                }
                summary = (String)summary + handler2.getSummary();
            }
            return summary;
        }

        private final String createSuccessSummary(TestConnectionResult testConnectionResult) {
            Object[] objectArray = new Object[]{NlsMessages.formatDuration((long)testConnectionResult.getPing()), !testConnectionResult.getKeepAliveResult() ? 0 : 1, testConnectionResult.getSslState() == null ? "" : StringUtil.toLowerCase((String)String.valueOf(testConnectionResult.getSslState())), testConnectionResult.getSslState() != null && testConnectionResult.getSslState() != ThreeState.UNSURE ? 0 : 1};
            String string = DatabaseBundle.message("text.ping.choice.keep.alive.query.results.in.error.choice.ssl", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        private final ThreeState getState(ErrorHandler handler2, TestConnectionResult testConnectionResult) {
            ThreeState threeState;
            if (handler2.hasErrors()) {
                threeState = ThreeState.YES;
            } else {
                boolean bl;
                TestConnectionResult testConnectionResult2 = testConnectionResult;
                if (testConnectionResult2 != null) {
                    TestConnectionResult it = testConnectionResult2;
                    boolean bl2 = false;
                    boolean bl3 = it.getKeepAliveResult() && it.getWarnings().isEmpty();
                    bl = !bl3;
                } else {
                    bl = false;
                }
                threeState = bl ? ThreeState.UNSURE : ThreeState.NO;
            }
            return threeState;
        }

        private final String getTextForState(ThreeState state, TestConnectionResult testConnectionResult) {
            String string;
            switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
                case 1: {
                    String string2 = DatabaseBundle.message("test.connection.status.failed", new Object[0]);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    break;
                }
                case 2: {
                    String string3 = DatabaseBundle.message("test.connection.status.succeeded", new Object[0]);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                    break;
                }
                default: {
                    String string4;
                    Object[] objectArray = new String[2];
                    String string5 = string4 = DatabaseBundle.message("test.connection.status.keep.alive.fail", new Object[0]);
                    int n = 0;
                    Object[] objectArray2 = objectArray;
                    boolean bl = false;
                    TestConnectionResult testConnectionResult2 = testConnectionResult;
                    boolean bl2 = testConnectionResult2 != null ? !testConnectionResult2.getKeepAliveResult() : false;
                    objectArray2[n] = bl2 ? string4 : null;
                    String it = string4 = DatabaseBundle.message("test.connection.status.database.returned.warning", new Object[0]);
                    n = 1;
                    objectArray2 = objectArray;
                    boolean bl3 = false;
                    Object object = testConnectionResult;
                    bl2 = object != null && (object = ((TestConnectionResult)object).getWarnings()) != null ? !object.isEmpty() : false;
                    objectArray2[n] = bl2 ? string4 : null;
                    string = SequencesKt.joinToString$default((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object[])objectArray)), (CharSequence)" / ", null, null, (int)0, null, null, (int)62, null);
                }
            }
            return string;
        }

        /*
         * Unable to fully structure code
         */
        private final Object testConnection(Project var1_1, DatabaseConnection var2_2, Continuation<? super TestConnectionResult> $completion) {
            if (!($completion instanceof testConnection.1)) ** GOTO lbl-1000
            var8_4 = $completion;
            if ((var8_4.label & -2147483648) != 0) {
                var8_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.ui.DataSourceTestConnectionManager$Companion.access$testConnection(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var9_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    it = var4_7 = new TestConnectionResult();
                    $i$a$-also-DataSourceTestConnectionManager$Companion$testConnection$2 = false;
                    DataSourceTestConnectionManager.Companion.handleWarnings((DatabaseConnection)connection, it);
                    $continuation.L$0 = var4_7;
                    $continuation.label = 1;
                    v0 = DataSourceTestConnectionManager.Companion.pingDatabase((Project)project, (DatabaseConnection)connection, it, (Continuation<? super Unit>)$continuation);
                    if (v0 == var9_6) {
                        return var9_6;
                    }
                    ** GOTO lbl26
                }
                case 1: {
                    $i$a$-also-DataSourceTestConnectionManager$Companion$testConnection$2 = false;
                    var4_7 = (TestConnectionResult)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl26:
                    // 2 sources

                    return var4_7;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - void declaration
         */
        private final void handleWarnings(DatabaseConnection connection2, TestConnectionResult r) {
            void $this$mapTo$iv$iv;
            DatabaseErrorHandler eh = DatabaseErrorHandler.EP.forDbms(connection2.getDbms());
            LocalDataSource localDataSource = connection2.getConnectionPoint().getDataSource();
            Intrinsics.checkNotNullExpressionValue((Object)localDataSource, (String)"getDataSource(...)");
            LocalDataSource dataSource = localDataSource;
            Collection collection = r.getWarnings();
            List list = connection2.getRemoteConnection().getAllWarnings();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllWarnings(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SQLWarning sQLWarning = (SQLWarning)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                ErrorInfo errorInfo = eh.getErrorInfo(dataSource, (Throwable)it);
                Intrinsics.checkNotNullExpressionValue((Object)errorInfo, (String)"getErrorInfo(...)");
                collection2.add(errorInfo);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        }

        /*
         * Unable to fully structure code
         */
        private final Object pingDatabase(Project var1_1, DatabaseConnection var2_2, TestConnectionResult var3_3, Continuation<? super Unit> $completion) {
            if (!($completion instanceof pingDatabase.1)) ** GOTO lbl-1000
            var11_5 = $completion;
            if ((var11_5.label & -2147483648) != 0) {
                var11_5.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    Object L$1;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.ui.DataSourceTestConnectionManager$Companion.access$pingDatabase(this.this$0, null, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var12_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    var6_8 = KeepAliveActionDescriptor.getKeepAliveQuery((Project)project, connection.getConnectionPoint().getDataSource());
                    Intrinsics.checkNotNullExpressionValue((Object)var6_8, (String)"getKeepAliveQuery(...)");
                    query = var6_8;
                    stmt = SmartStatements.Companion.poweredBy(connection).simple(Configuration.Companion.sourced(SmartStatementSource.SYSTEM)).barren();
                    start = System.currentTimeMillis();
                    $continuation.L$0 = connection;
                    $continuation.L$1 = result;
                    $continuation.J$0 = start;
                    $continuation.label = 1;
                    v0 = this.computeDetachedAndCancel((Function0<Unit>)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, pingDatabase$lambda$8(com.intellij.database.dataSource.connection.statements.BarrenStatement ), ()Lkotlin/Unit;)(stmt), (Function1<? super Continuation<? super Unit>, ? extends Object>)((Function1)new Function1<Continuation<? super Unit>, Object>(stmt, query, null){
                        int label;
                        final /* synthetic */ BarrenStatement<String> $stmt;
                        final /* synthetic */ String $query;
                        {
                            this.$stmt = $stmt;
                            this.$query = $query;
                            super(1, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = InterruptibleKt.runInterruptible$default(null, () -> pingDatabase.3.invokeSuspend$lambda$0(this.$stmt, this.$query), (Continuation)((Continuation)this), (int)1, null);
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(Continuation<? super Unit> p1) {
                            return (this.create(p1)).invokeSuspend(Unit.INSTANCE);
                        }

                        private static final Unit invokeSuspend$lambda$0(BarrenStatement $stmt, String $query) {
                            $stmt.execute($query);
                            return Unit.INSTANCE;
                        }
                    }), (Continuation<? super Unit>)$continuation);
                    ** if (v0 != var12_7) goto lbl26
lbl25:
                    // 1 sources

                    return var12_7;
lbl26:
                    // 1 sources

                    ** GOTO lbl35
                }
                case 1: {
                    start = $continuation.J$0;
                    result = (TestConnectionResult)$continuation.L$1;
                    connection = (DatabaseConnection)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl35:
                        // 2 sources

                        result.setKeepAliveResult(true);
                    }
                    catch (Exception e) {
                        result.setKeepAliveResult(false);
                        result.setKeepAliveError(e);
                    }
                    result.setPing(System.currentTimeMillis() - start);
                    result.setSslState(ExecutionEnvironmentHelper.EP.forDbms(connection.getDbms()).getSslState(connection));
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        private final Object computeDetachedAndCancel(Function0<Unit> var1_1, Function1<? super Continuation<? super Unit>, ? extends Object> var2_2, Continuation<? super Unit> $completion) {
            if (!($completion instanceof computeDetachedAndCancel.1)) ** GOTO lbl-1000
            var6_4 = $completion;
            if ((var6_4.label & -2147483648) != 0) {
                var6_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Companion this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return com.intellij.database.dataSource.ui.DataSourceTestConnectionManager$Companion.access$computeDetachedAndCancel(this.this$0, null, null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var7_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = cancellation;
                    $continuation.label = 1;
                    v0 = ProcessKt.computeDetached$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function1<? super Continuation<? super Unit>, ? extends Object>)action, null){
                        int label;
                        final /* synthetic */ Function1<Continuation<? super Unit>, Object> $action;
                        {
                            this.$action = $action;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - void declaration
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object object) {
                            Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)object);
                                    this.label = 1;
                                    Object object3 = this.$action.invoke((Object)((Object)this));
                                    if (object3 != object2) return Unit.INSTANCE;
                                    return object2;
                                }
                                case 1: {
                                    void $result;
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object3 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation, (int)1, null);
                    ** if (v0 != var7_6) goto lbl19
lbl18:
                    // 1 sources

                    return var7_6;
lbl19:
                    // 1 sources

                    ** GOTO lbl26
                }
                case 1: {
                    cancellation = (Function0)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 2 sources

                        JobKt.ensureActive((CoroutineContext)$continuation.getContext());
                    }
                    catch (CancellationException var4_7) {
                        BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)BlockingKt.getBlockingDispatcher()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Function0<Unit>)cancellation, null){
                            int label;
                            final /* synthetic */ Function0<Unit> $cancellation;
                            {
                                this.$cancellation = $cancellation;
                                super(2, $completion);
                            }

                            public final Object invokeSuspend(Object object) {
                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)object);
                                        try {
                                            this.$cancellation.invoke();
                                        }
                                        catch (Throwable th) {
                                            DataSourceTestConnectionManagerKt.access$getLogger$p().debug(th);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        private static final Unit pingDatabase$lambda$8(BarrenStatement $stmt) {
            $stmt.cancel();
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$testConnection(Companion $this, Project project, DatabaseConnection connection2, Continuation $completion) {
            return $this.testConnection(project, connection2, (Continuation<? super TestConnectionResult>)$completion);
        }

        public static final /* synthetic */ Object access$pingDatabase(Companion $this, Project project, DatabaseConnection connection2, TestConnectionResult result2, Continuation $completion) {
            return $this.pingDatabase(project, connection2, result2, (Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ Object access$computeDetachedAndCancel(Companion $this, Function0 cancellation, Function1 action, Continuation $completion) {
            return $this.computeDetachedAndCancel((Function0<Unit>)cancellation, (Function1<? super Continuation<? super Unit>, ? extends Object>)action, (Continuation<? super Unit>)$completion);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ThreeState.values().length];
                try {
                    nArray[ThreeState.YES.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ThreeState.NO.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J,\u0010\b\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Listener;", "", "started", "", "project", "Lcom/intellij/openapi/project/Project;", "connectionPoint", "Lcom/intellij/database/dataSource/DatabaseConnectionPoint;", "finished", "result", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "th", "", "intellij.database.impl"})
    public static interface Listener {
        public void started(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2);

        public void finished(@NotNull Project var1, @NotNull DatabaseConnectionPoint var2, @Nullable TestConnectionResult var3, @Nullable Throwable var4);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001BI\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0010\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u001b\u0010\b\u001a\f0\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$ProcessedTestConnectionResult;", "", "state", "Lcom/intellij/util/ThreeState;", "dataSourceInfo", "", "Lorg/jetbrains/annotations/Nls;", "stateText", "summary", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "fixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "<init>", "(Lcom/intellij/util/ThreeState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getState", "()Lcom/intellij/util/ThreeState;", "getDataSourceInfo", "()Ljava/lang/String;", "getStateText", "getSummary", "getFixes", "()Ljava/util/List;", "intellij.database.impl"})
    public static final class ProcessedTestConnectionResult {
        @NotNull
        private final ThreeState state;
        @NotNull
        private final String dataSourceInfo;
        @NotNull
        private final String stateText;
        @NotNull
        private final String summary;
        @NotNull
        private final List<ErrorInfo.Fix> fixes;

        public ProcessedTestConnectionResult(@NotNull ThreeState state, @NotNull String dataSourceInfo, @NotNull String stateText, @NotNull String summary, @NotNull List<? extends ErrorInfo.Fix> fixes) {
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)dataSourceInfo, (String)"dataSourceInfo");
            Intrinsics.checkNotNullParameter((Object)stateText, (String)"stateText");
            Intrinsics.checkNotNullParameter((Object)summary, (String)"summary");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            this.state = state;
            this.dataSourceInfo = dataSourceInfo;
            this.stateText = stateText;
            this.summary = summary;
            this.fixes = fixes;
        }

        @NotNull
        public final ThreeState getState() {
            return this.state;
        }

        @NotNull
        public final String getDataSourceInfo() {
            return this.dataSourceInfo;
        }

        @NotNull
        public final String getStateText() {
            return this.stateText;
        }

        @NotNull
        public final String getSummary() {
            return this.summary;
        }

        @NotNull
        public final List<ErrorInfo.Fix> getFixes() {
            return this.fixes;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u0012\u0010\b\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\b\b\u0002\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0005J\r\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dH\u0002J\u0015\u0010\u001e\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J \u0010$\u001a\u00020\u000e2\b\u0010%\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\b\u001a\u000e\u0018\u00010\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "", "fail", "Lcom/intellij/util/ThreeState;", "dataSourceInfo", "", "Lorg/jetbrains/annotations/Nls;", "stateText", "details", "Lcom/intellij/openapi/util/NlsContexts$DetailedDescription;", "fixes", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo$Fix;", "specifyVersion", "", "<init>", "(Lcom/intellij/util/ThreeState;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Z)V", "getFail", "()Lcom/intellij/util/ThreeState;", "getStateText", "()Ljava/lang/String;", "getDetails", "getFixes", "()Ljava/util/List;", "asHtml", "Lcom/intellij/openapi/util/text/HtmlChunk;", "describe", "editIcon", "Lcom/intellij/openapi/util/text/HtmlChunk$Element;", "Lorg/jetbrains/annotations/NotNull;", "icon", "Ljavax/swing/Icon;", "appendFixes", "", "sb", "Lcom/intellij/openapi/util/text/HtmlBuilder;", "handleLink", "desc", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/database/view/ui/DatabaseConfigEditor;", "intellij.database.impl"})
    @SourceDebugExtension(value={"SMAP\nDataSourceTestConnectionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSourceTestConnectionManager.kt\ncom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,602:1\n1#2:603\n*E\n"})
    public static final class Status {
        @NotNull
        private final ThreeState fail;
        @NotNull
        private final String dataSourceInfo;
        @NotNull
        private final String stateText;
        @Nullable
        private final String details;
        @NotNull
        private final List<ErrorInfo.Fix> fixes;
        private final boolean specifyVersion;

        public Status(@NotNull ThreeState fail, @NotNull String dataSourceInfo, @NotNull String stateText, @Nullable String details, @NotNull List<? extends ErrorInfo.Fix> fixes, boolean specifyVersion) {
            Intrinsics.checkNotNullParameter((Object)fail, (String)"fail");
            Intrinsics.checkNotNullParameter((Object)dataSourceInfo, (String)"dataSourceInfo");
            Intrinsics.checkNotNullParameter((Object)stateText, (String)"stateText");
            Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
            this.fail = fail;
            this.dataSourceInfo = dataSourceInfo;
            this.stateText = stateText;
            this.details = details;
            this.fixes = fixes;
            this.specifyVersion = specifyVersion;
        }

        public /* synthetic */ Status(ThreeState threeState, String string, String string2, String string3, List list, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                bl = false;
            }
            this(threeState, string, string2, string3, list, bl);
        }

        @NotNull
        public final ThreeState getFail() {
            return this.fail;
        }

        @NotNull
        public final String getStateText() {
            return this.stateText;
        }

        @Nullable
        public final String getDetails() {
            return this.details;
        }

        @NotNull
        public final List<ErrorInfo.Fix> getFixes() {
            return this.fixes;
        }

        @NotNull
        public final HtmlChunk asHtml() {
            Integer idx;
            HtmlBuilder builder = new HtmlBuilder();
            Integer n = StringsKt.indexOf$default((CharSequence)this.dataSourceInfo, (char)'\n', (int)0, (boolean)false, (int)6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Integer n2 = idx = it != -1 ? n : null;
            String string = this.dataSourceInfo.substring(0, n2 != null ? n2.intValue() : this.dataSourceInfo.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            builder.append(string);
            builder.append((HtmlChunk)HtmlChunk.link((String)"edit-version", (HtmlChunk)((HtmlChunk)this.editIcon())));
            if (idx != null) {
                int n3 = idx;
                String string2 = this.dataSourceInfo.substring(n3);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                builder.append(string2);
            }
            if (this.fail == ThreeState.YES) {
                builder.clearAndAppend((HtmlChunk)builder.wrapWith("div").style("color: " + ColorUtil.toHtmlColor((Color)((Color)JBColor.gray))));
            }
            if (this.details != null || !((Collection)this.fixes).isEmpty()) {
                builder.br();
                String string3 = this.details;
                if (string3 == null) {
                    string3 = "";
                }
                builder.append(string3);
                this.appendFixes(builder);
            }
            if (this.specifyVersion) {
                builder.append((HtmlChunk)HtmlChunk.br());
                builder.appendRaw("&emsp;");
                builder.append((HtmlChunk)HtmlChunk.link((String)"edit-version", (String)DatabaseBundle.message("specify.version", new Object[0])));
            }
            HtmlChunk htmlChunk = builder.toFragment();
            Intrinsics.checkNotNullExpressionValue((Object)htmlChunk, (String)"toFragment(...)");
            return htmlChunk;
        }

        @NotNull
        public final String describe() {
            return this.details == null ? this.dataSourceInfo : this.dataSourceInfo + "\n" + this.details;
        }

        private final HtmlChunk.Element editIcon() {
            Icon icon = AllIcons.Actions.Edit;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Edit");
            return this.icon(icon);
        }

        private final HtmlChunk.Element icon(Icon icon) {
            HtmlChunk.Element element = HtmlChunk.tag((String)"icon").attr("src", GridUtil.getIconPath((Icon)icon));
            Intrinsics.checkNotNullExpressionValue((Object)element, (String)"attr(...)");
            return element;
        }

        private final void appendFixes(HtmlBuilder sb) {
            if (this.fixes.isEmpty()) {
                return;
            }
            sb.append((HtmlChunk)HtmlChunk.br());
            int n = ((Collection)this.fixes).size();
            for (int i2 = 0; i2 < n; ++i2) {
                sb.appendRaw("&emsp;");
                sb.append((HtmlChunk)HtmlChunk.link((String)("fix" + i2), (String)this.fixes.get(i2).getName()));
            }
        }

        public final boolean handleLink(@Nullable String desc, @NotNull Project project, @NotNull DatabaseConfigEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (desc == null || !StringsKt.startsWith$default((String)desc, (String)"fix", (boolean)false, (int)2, null)) {
                return false;
            }
            int idx = StringUtil.parseInt((String)StringsKt.removePrefix((String)desc, (CharSequence)"fix"), (int)-1);
            if (idx < 0 || idx >= this.fixes.size()) {
                return false;
            }
            DataSourceUiUtil.applyFix(project, this.fixes.get(idx), editor2);
            return true;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006!"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestConnectionResult;", "", "<init>", "()V", "ping", "", "getPing", "()J", "setPing", "(J)V", "keepAliveResult", "", "getKeepAliveResult", "()Z", "setKeepAliveResult", "(Z)V", "keepAliveError", "", "getKeepAliveError", "()Ljava/lang/Throwable;", "setKeepAliveError", "(Ljava/lang/Throwable;)V", "sslState", "Lcom/intellij/util/ThreeState;", "getSslState", "()Lcom/intellij/util/ThreeState;", "setSslState", "(Lcom/intellij/util/ThreeState;)V", "warnings", "", "Lcom/intellij/database/connection/throwable/info/ErrorInfo;", "getWarnings", "()Ljava/util/List;", "intellij.database.impl"})
    public static final class TestConnectionResult {
        private long ping;
        private boolean keepAliveResult;
        @Nullable
        private Throwable keepAliveError;
        @Nullable
        private ThreeState sslState = ThreeState.UNSURE;
        @NotNull
        private final List<ErrorInfo> warnings = new ArrayList();

        public final long getPing() {
            return this.ping;
        }

        public final void setPing(long l) {
            this.ping = l;
        }

        public final boolean getKeepAliveResult() {
            return this.keepAliveResult;
        }

        public final void setKeepAliveResult(boolean bl) {
            this.keepAliveResult = bl;
        }

        @Nullable
        public final Throwable getKeepAliveError() {
            return this.keepAliveError;
        }

        public final void setKeepAliveError(@Nullable Throwable throwable) {
            this.keepAliveError = throwable;
        }

        @Nullable
        public final ThreeState getSslState() {
            return this.sslState;
        }

        public final void setSslState(@Nullable ThreeState threeState) {
            this.sslState = threeState;
        }

        @NotNull
        public final List<ErrorInfo> getWarnings() {
            return this.warnings;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001d\u0010\u001a\u001a\u0014 \u001d*\t\u0018\u00010\u001b\u00a2\u0006\u0002\b\u001c0\u001b\u00a2\u0006\u0002\b\u001c\u00a2\u0006\u0002\u0010\u001eR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001c\u0010\b\u001a\u0004\u0018\u00010\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001f"}, d2={"Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$TestInfo;", "", "sessionTemplateId", "", "<init>", "(Ljava/lang/String;)V", "getSessionTemplateId", "()Ljava/lang/String;", "job", "Lkotlinx/coroutines/Job;", "getJob", "()Lkotlinx/coroutines/Job;", "setJob", "(Lkotlinx/coroutines/Job;)V", "status", "Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "getStatus", "()Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;", "setStatus", "(Lcom/intellij/database/dataSource/ui/DataSourceTestConnectionManager$Status;)V", "info", "Lcom/intellij/database/dataSource/DataSourceInfo;", "getInfo", "()Lcom/intellij/database/dataSource/DataSourceInfo;", "setInfo", "(Lcom/intellij/database/dataSource/DataSourceInfo;)V", "getIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm.PlatformType", "()Ljavax/swing/Icon;", "intellij.database.impl"})
    public static final class TestInfo {
        @Nullable
        private final String sessionTemplateId;
        @Nullable
        private Job job;
        @Nullable
        private Status status;
        @Nullable
        private DataSourceInfo info;

        public TestInfo(@Nullable String sessionTemplateId) {
            this.sessionTemplateId = sessionTemplateId;
        }

        @Nullable
        public final String getSessionTemplateId() {
            return this.sessionTemplateId;
        }

        @Nullable
        public final Job getJob() {
            return this.job;
        }

        public final void setJob(@Nullable Job job2) {
            this.job = job2;
        }

        @Nullable
        public final Status getStatus() {
            return this.status;
        }

        public final void setStatus(@Nullable Status status) {
            this.status = status;
        }

        @Nullable
        public final DataSourceInfo getInfo() {
            return this.info;
        }

        public final void setInfo(@Nullable DataSourceInfo dataSourceInfo) {
            this.info = dataSourceInfo;
        }

        public final Icon getIcon() {
            Icon icon;
            Status status = this.status;
            if ((status != null ? status.getFail() : null) == ThreeState.YES) {
                icon = AllIcons.General.Error;
            } else {
                Status status2 = this.status;
                if ((status2 != null ? status2.getFail() : null) == ThreeState.UNSURE) {
                    icon = AllIcons.General.BalloonWarning;
                } else {
                    Status status3 = this.status;
                    icon = (status3 != null ? status3.getFail() : null) == ThreeState.NO ? AllIcons.RunConfigurations.TestPassed : (this.job != null ? (Icon)AnimatedIcon.Default.INSTANCE : EmptyIcon.ICON_16);
                }
            }
            return icon;
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ThreeState.values().length];
            try {
                nArray[ThreeState.YES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.UNSURE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ThreeState.NO.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

