/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hivebase.generator.producers;

import com.intellij.database.dialects.base.generator.AbstractScriptGeneratorKt;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterTable;
import com.intellij.database.dialects.hivebase.generator.producers.HiveBaseTableProducersKt;
import com.intellij.database.dialects.hivebase.model.HiveBaseElementWithProperties;
import com.intellij.database.dialects.hivebase.model.HiveBaseTable;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.NameValue;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.properties.CompositeText;
import com.intellij.database.script.generator.ScriptingCapabilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000bH\u0002J\b\u0010\u0011\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0002J,\u0010\u0013\u001a\u00020\u000b2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\b\u0010\u001a\u001a\u00020\u000bH\u0002J\b\u0010\u001b\u001a\u00020\u000bH\u0002J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\b\u0010\u001d\u001a\u00020\u000bH\u0016J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\rH\u0016\u00a8\u0006\""}, d2={"Lcom/intellij/database/dialects/hivebase/generator/producers/HiveBaseAlterTable;", "T", "Lcom/intellij/database/dialects/hivebase/model/HiveBaseTable;", "Lcom/intellij/database/dialects/base/generator/producers/AlterTable;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/model/ElementAlteration;)V", "produceFlag", "", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "produced", "", "produceAlterSerdeProperties", "produceAlterRowFormat", "produceAlterTblProperties", "produceAlterProperties", "fromProperties", "", "Lcom/intellij/database/model/NameValue;", "toProperties", "term", "", "produceAlterLocation", "produceAlterClustered", "produceAlterComment", "produceRename", "canAlter", "Lcom/intellij/database/script/generator/ScriptingCapabilities$VersionedCapability;", "", "prop", "intellij.database.dialects.hivebase"})
@SourceDebugExtension(value={"SMAP\nHiveBaseTableProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiveBaseTableProducers.kt\ncom/intellij/database/dialects/hivebase/generator/producers/HiveBaseAlterTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ScriptingContext.kt\ncom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter\n*L\n1#1,241:1\n1628#2,3:242\n774#2:245\n865#2,2:246\n1202#2,2:248\n1230#2,4:250\n774#2:254\n865#2,2:255\n145#3,11:257\n254#3:268\n241#3,14:269\n*S KotlinDebug\n*F\n+ 1 HiveBaseTableProducers.kt\ncom/intellij/database/dialects/hivebase/generator/producers/HiveBaseAlterTable\n*L\n187#1:242,3\n188#1:245\n188#1:246,2\n195#1:248,2\n195#1:250,4\n196#1:254\n196#1:255,2\n192#1:257,11\n223#1:268\n223#1:269,14\n*E\n"})
public class HiveBaseAlterTable<T extends HiveBaseTable>
extends AlterTable<T> {
    public HiveBaseAlterTable(@NotNull ScriptingContext context, @NotNull ElementAlteration<? extends T> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        super(context, elements);
    }

    @Override
    public void produceFlag(@NotNull BasicMetaId id, @NotNull Set<BasicMetaId> produced) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(produced, (String)"produced");
        BasicMetaId basicMetaId = id;
        if (Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.BUCKETS_NUM)) {
            this.produceAlterClustered();
        } else if (Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.LOCATION)) {
            this.produceAlterLocation();
        } else if (Intrinsics.areEqual((Object)basicMetaId, (Object)HiveBaseTable.PROPERTIES)) {
            this.produceAlterTblProperties();
        } else if (Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.SERDE_PROPERTIES)) {
            this.produceAlterSerdeProperties();
        } else if (Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.ROW_FORMAT_SERDE)) {
            ((Collection)produced).add(HiveBaseTable.SERDE_PROPERTIES);
            this.produceAlterRowFormat();
        } else {
            super.produceFlag(id, produced);
        }
    }

    private final void produceAlterSerdeProperties() {
        List<NameValue> list = ((HiveBaseTable)this.getElement()).getSerdeProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSerdeProperties(...)");
        List<NameValue> list2 = ((HiveBaseTable)this.getTo()).getSerdeProperties();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getSerdeProperties(...)");
        this.produceAlterProperties(list, list2, "serdeproperties");
    }

    private final void produceAlterRowFormat() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> HiveBaseAlterTable.produceAlterRowFormat$lambda$0(this, arg_0)));
    }

    private final void produceAlterTblProperties() {
        List<NameValue> list = ((HiveBaseElementWithProperties)this.getElement()).getProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getProperties(...)");
        List<NameValue> list2 = ((HiveBaseElementWithProperties)this.getTo()).getProperties();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getProperties(...)");
        this.produceAlterProperties(list, list2, "tblproperties");
    }

    /*
     * WARNING - void declaration
     */
    private final void produceAlterProperties(List<? extends NameValue> fromProperties, List<? extends NameValue> toProperties, String term) {
        void $this$filterTo$iv$iv;
        void $this$associateByTo$iv$iv;
        void $this$filterTo$iv$iv2;
        Iterable it;
        Object object;
        void $this$mapTo$iv;
        Iterable iterable = toProperties;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            NameValue nameValue = (NameValue)item$iv;
            object = destination$iv;
            boolean bl = false;
            object.add(((NameValue)((Object)it)).getName());
        }
        HashSet existing2 = (HashSet)destination$iv;
        boolean bl = false;
        Iterable $this$filter$iv = fromProperties;
        boolean $i$f$filter22 = false;
        it = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
            NameValue it2 = (NameValue)element$iv$iv2;
            boolean bl2 = false;
            if (!(!existing2.contains(it2.getName()))) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List toUnset = (List)destination$iv$iv;
        if (!((Collection)toUnset).isEmpty()) {
            this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> HiveBaseAlterTable.produceAlterProperties$lambda$5(this, term, toUnset, arg_0)));
        }
        Iterable $this$associateBy$iv = fromProperties;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable $i$f$filter22 = $this$associateBy$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo22 = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it3;
            Object element$iv$iv2;
            element$iv$iv2 = (NameValue)element$iv$iv;
            object = destination$iv$iv2;
            boolean bl3 = false;
            object.put(it3.getName(), element$iv$iv);
        }
        Map prev2 = destination$iv$iv2;
        boolean bl4 = false;
        Iterable $this$filter$iv2 = toProperties;
        boolean $i$f$filter = false;
        Iterable $i$f$associateByTo22 = $this$filter$iv2;
        Collection destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            NameValue it4 = (NameValue)element$iv$iv;
            boolean bl5 = false;
            if (!(!Intrinsics.areEqual(prev2.get(it4.getName()), (Object)it4))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        List toSet = (List)destination$iv$iv3;
        if (!((Collection)toSet).isEmpty()) {
            this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> HiveBaseAlterTable.produceAlterProperties$lambda$9(this, toSet, term, arg_0)));
        }
    }

    private final void produceAlterLocation() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> HiveBaseAlterTable.produceAlterLocation$lambda$10(this, arg_0)));
    }

    private final void produceAlterClustered() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> HiveBaseAlterTable.produceAlterClustered$lambda$11(this, arg_0)));
    }

    @Override
    public void produceAlterComment() {
        HiveBaseTableProducersKt.hiveCommentStatement(this, "table", "tblproperties");
    }

    @Override
    public void produceRename() {
        this.newCoding((Function1<? super ScriptingContext.NewCodingAdapter, Unit>)((Function1)arg_0 -> HiveBaseAlterTable.produceRename$lambda$12(this, arg_0)));
    }

    @Override
    @NotNull
    public ScriptingCapabilities.VersionedCapability<Boolean> canAlter(@NotNull BasicMetaId prop) {
        Intrinsics.checkNotNullParameter((Object)prop, (String)"prop");
        BasicMetaId basicMetaId = prop;
        return Intrinsics.areEqual((Object)basicMetaId, (Object)HiveBaseTable.TEMPORARY) ? AbstractScriptGeneratorKt.getUNSUPPORTED() : (Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.INPUT_DRIVER) || Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.INPUT_FORMAT) || Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.OUTPUT_DRIVER) || Intrinsics.areEqual((Object)basicMetaId, HiveBaseTable.OUTPUT_FORMAT) ? AbstractScriptGeneratorKt.getUNSUPPORTED() : super.canAlter(prop));
    }

    private static final Unit produceAlterRowFormat$lambda$0(HiveBaseAlterTable this$0, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        $this$newCoding.plus(this$0.alterTable($this$newCoding), "set");
        String string = ((HiveBaseTable)this$0.getTo()).getRowFormatSerde();
        if (string == null) {
            string = "";
        }
        List<NameValue> list = ((HiveBaseTable)this$0.getTo()).getSerdeProperties();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getSerdeProperties(...)");
        HiveBaseTableProducersKt.access$produceSerdeDef($this$newCoding, string, list);
        return Unit.INSTANCE;
    }

    private static final Unit produceAlterProperties$lambda$5(HiveBaseAlterTable this$0, String $term, List $toUnset, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        String sep$iv = ", ";
        boolean $i$f$joined = false;
        $this$newCoding.minus($this$newCoding.minus($this$newCoding.plus($this$newCoding.plus($this$newCoding.plus(this$0.alterTable($this$newCoding), "unset"), $term), "("), (Function0<? extends Object>)((Function0)new Function0<Unit>((Iterable)$toUnset, $this$newCoding, sep$iv, $this$newCoding){
            final /* synthetic */ Iterable $this_joined;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            final /* synthetic */ String $sep;
            final /* synthetic */ ScriptingContext.NewCodingAdapter $this_newCoding$inlined;
            {
                this.$this_joined = $receiver;
                this.this$0 = $receiver2;
                this.$sep = $sep;
                this.$this_newCoding$inlined = newCodingAdapter;
            }

            public final void invoke() {
                Iterator<T> it = this.$this_joined.iterator();
                if (it.hasNext()) {
                    NameValue it2 = (NameValue)it.next();
                    boolean bl = false;
                    this.$this_newCoding$inlined.plus(this.$this_newCoding$inlined, HiveBaseTableProducersKt.getHiveSqlString(it2.getName()));
                    while (it.hasNext()) {
                        this.this$0.noSpace();
                        ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$sep, null, null, 6, null);
                        it2 = (NameValue)it.next();
                        bl = false;
                        this.$this_newCoding$inlined.plus(this.$this_newCoding$inlined, HiveBaseTableProducersKt.getHiveSqlString(it2.getName()));
                    }
                }
            }
        })), ")");
        return Unit.INSTANCE;
    }

    private static final Unit produceAlterProperties$lambda$9(HiveBaseAlterTable this$0, List $toSet, String $term, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        $this$newCoding.plus(this$0.alterTable($this$newCoding), "set");
        HiveBaseTableProducersKt.properties($this$newCoding, $toSet, $term);
        return Unit.INSTANCE;
    }

    private static final Unit produceAlterLocation$lambda$10(HiveBaseAlterTable this$0, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$newCoding.plus(this$0.alterTable($this$newCoding), "set location");
        String string = ((HiveBaseTable)this$0.getTo()).getLocation();
        if (string == null || (string = HiveBaseTableProducersKt.getHiveSqlString(string)) == null) {
            string = "null";
        }
        $this$newCoding.plus(newCodingAdapter, string);
        return Unit.INSTANCE;
    }

    private static final Unit produceAlterClustered$lambda$11(HiveBaseAlterTable this$0, ScriptingContext.NewCodingAdapter $this$newCoding) {
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        this$0.alterTable($this$newCoding);
        HiveBaseTableProducersKt.access$produceClusteredBy($this$newCoding, (HiveBaseTable)this$0.getTo());
        return Unit.INSTANCE;
    }

    private static final Unit produceRename$lambda$12(HiveBaseAlterTable this$0, ScriptingContext.NewCodingAdapter $this$newCoding) {
        ScriptingContext.NewCodingAdapter this_$iv;
        Intrinsics.checkNotNullParameter((Object)$this$newCoding, (String)"$this$newCoding");
        ScriptingContext.NewCodingAdapter newCodingAdapter = $this$newCoding;
        String quotedName$iv = this$0.fromNameScr();
        boolean $i$f$name = false;
        ScriptingContext.NewCodingAdapter this_$iv$iv = this_$iv;
        boolean $i$f$orError = false;
        Function0<Unit> function0 = new Function0<Unit>(quotedName$iv, this_$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        };
        this_$iv = $this$newCoding;
        quotedName$iv = this$0.toNameScr();
        $i$f$name = false;
        this_$iv$iv = this_$iv;
        $i$f$orError = false;
        $this$newCoding.plus($this$newCoding.plus($this$newCoding.plus($this$newCoding.unaryPlus("alter table"), (Function0<? extends Object>)((Function0)function0)), "rename to"), (Function0<? extends Object>)((Function0)new Function0<Unit>(quotedName$iv, this_$iv$iv){
            final /* synthetic */ String $text;
            final /* synthetic */ ScriptingContext.NewCodingAdapter this$0;
            {
                this.$text = $text;
                this.this$0 = $receiver;
            }

            public final void invoke() {
                if (this.$text != null) {
                    ScriptingContext.NewCodingAdapter.appendSimple$default(this.this$0, this.$text, null, null, 6, null);
                } else {
                    CompositeText.Kind kind = null;
                    CharSequence charSequence = "???";
                    ScriptingContext.NewCodingAdapter newCodingAdapter = this.this$0;
                    boolean bl = false;
                    String string = "unknown name";
                    ScriptingContext.NewCodingAdapter.appendSimple$default(newCodingAdapter, charSequence, kind, string, 2, null);
                }
            }
        }));
        return Unit.INSTANCE;
    }
}

