/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.postgresbase.plan;

import com.intellij.database.dialects.base.plan.AbstractPlanModelBuilder;
import com.intellij.database.dialects.postgresbase.plan.PgBaseRawPlanData;
import com.intellij.database.plan.PlanModel;
import com.intellij.database.plan.PlanRetrievalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PgBasePlanModelBuilder
extends AbstractPlanModelBuilder<PgBaseRawPlanData, PgBaseRawPlanData.MetaNode> {
    public static final Map<String, PlanModel.NodeType> TYPE_MAPPING = new HashMap<String, PlanModel.NodeType>();
    private static final String SUBQUERY_SCAN = "Subquery Scan";
    private static final Map<String, PlanModel.NodeType> TYPE_MAPPING_EXT = new HashMap<String, PlanModel.NodeType>();
    @Language(value="Regexp")
    private static final String NAME = "(?:\"(?:[^\"]|\"\")*\"|(\\w|_)+)";
    private static final Pattern TABLE_PATTERN;
    private static final Pattern INDEX_PATTERN;
    private static final Pattern ATTR_PATTERN;
    private static final Pattern ACT_PATTERN;
    private static final Pattern ROWS_PATTERN;

    protected PgBasePlanModelBuilder() {
        super(EnumSet.noneOf(PlanModel.Feature.class));
    }

    @Override
    @NotNull
    public PgBaseRawPlanData createData() {
        return new PgBaseRawPlanData();
    }

    @Override
    protected void parseData() {
        this.parseRoot();
    }

    private void parseRoot() throws PlanRetrievalException {
        if (((PgBaseRawPlanData)this.myData).lines.isEmpty()) {
            throw new PlanRetrievalException("Database returned empty plan");
        }
        this.openNode(null);
        this.parseStatement(new PgBaseRawPlanData.MetaNode(0, ((PgBaseRawPlanData)this.myData).lines.size(), 0));
        this.closeNode(new PlanModel.GenericNode(PlanModel.NodeType.ROOT, null));
    }

    @Override
    @NotNull
    protected String parseRawDescription(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(0);
        }
        return "";
    }

    @Override
    @Nullable
    protected String parseAccessRelation(@NotNull PgBaseRawPlanData.MetaNode state) {
        Matcher matcher;
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(1);
        }
        return (matcher = TABLE_PATTERN.matcher(((PgBaseRawPlanData)this.myData).lines.get(state.line))).find(state.indent) ? matcher.group(1) : null;
    }

    @Override
    @Nullable
    protected BigDecimal parsePlanNumRows(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    @Nullable
    protected String parseAccessIndex(@NotNull PgBaseRawPlanData.MetaNode state) {
        Matcher matcher;
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(3);
        }
        return (matcher = INDEX_PATTERN.matcher(((PgBaseRawPlanData)this.myData).lines.get(state.line))).find(state.indent) ? matcher.group(1) : null;
    }

    @Override
    protected void parseSubPlans(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(4);
        }
        int subIndent = state.indent + 6;
        int prev2 = -1;
        boolean prevSubPlan = false;
        for (int i2 = state.line + 1; i2 <= state.end; ++i2) {
            boolean childText;
            String line;
            String string = line = i2 == state.end ? null : ((PgBaseRawPlanData)this.myData).lines.get(i2);
            if (line != null && line.isEmpty()) continue;
            boolean newSubPlan = line != null && PgBasePlanModelBuilder.isSubPlan(state.indent, line);
            boolean newNode = newSubPlan || line == null || PgBasePlanModelBuilder.isSubNode(state.indent, line);
            boolean parentText = !newNode && !PgBasePlanModelBuilder.isDescendantText(state.indent, line);
            boolean bl = childText = !newNode && !parentText && line.charAt(state.indent + 2) == ' ';
            if (childText) continue;
            if (newNode) {
                state.firstChild = Math.min(state.firstChild, i2);
            }
            if (prev2 != -1) {
                this.parsePlan(new PgBaseRawPlanData.MetaNode(prev2, i2, prevSubPlan ? state.indent + 2 : subIndent));
            }
            prev2 = newNode ? i2 : -1;
            prevSubPlan = newSubPlan;
            if (!parentText) continue;
            state.prematureEnd = i2;
            break;
        }
    }

    @Override
    protected void parseStatement(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(5);
        }
        this.openNode(null);
        this.parsePlan(state);
        PlanModel.GenericNode node = new PlanModel.GenericNode(PlanModel.NodeType.SELECT, null);
        StringBuilder extra = new StringBuilder();
        for (int i2 = state.prematureEnd; i2 < state.end; ++i2) {
            String line = ((PgBaseRawPlanData)this.myData).lines.get(i2);
            if (this.isExecutionMarker(line)) {
                this.myActual = true;
            }
            extra.append(line).append(";\n");
        }
        node.setRawDescription(extra.toString());
        this.closeNode(node);
    }

    protected boolean isExecutionMarker(String line) {
        return line.startsWith("Total runtime");
    }

    @Override
    protected void parseNode(@NotNull PgBaseRawPlanData.MetaNode state, @NotNull PlanModel.GenericNode node) {
        Matcher actMatcher;
        String line;
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(6);
        }
        if (node == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(7);
        }
        if (PgBasePlanModelBuilder.isSubPlan(state.indent - 2, line = ((PgBaseRawPlanData)this.myData).lines.get(state.line))) {
            node.setRawDescription(line.trim());
            return;
        }
        Matcher matcher = ATTR_PATTERN.matcher(line);
        if (!matcher.find(state.indent)) {
            throw new PlanRetrievalException("Unable to find cost in: " + line);
        }
        ArrayList<String> infos = new ArrayList<String>(4);
        ContainerUtil.addIfNotNull(infos, (Object)state.tp);
        ContainerUtil.addIfNotNull(infos, (Object)matcher.group(1));
        ContainerUtil.addIfNotNull(infos, (Object)matcher.group(5));
        String tail = StringUtil.nullize((String)line.substring(matcher.end()).trim());
        if (tail != null && (actMatcher = ACT_PATTERN.matcher(tail)).find()) {
            node.setActualNumRows(new BigDecimal(actMatcher.group(3)));
            node.setActualTotalTime(Double.parseDouble(actMatcher.group(2)));
            node.setActualStartupTime(Double.parseDouble(actMatcher.group(1)));
            ContainerUtil.addIfNotNull(infos, (Object)actMatcher.group(4));
            tail = StringUtil.nullize((String)tail.substring(actMatcher.end()).trim());
        }
        ContainerUtil.addIfNotNull(infos, (Object)tail);
        for (int i2 = state.line + 1; i2 < state.firstChild; ++i2) {
            if (((PgBaseRawPlanData)this.myData).lines.get(i2).length() < state.indent + 2) continue;
            String extra = ((PgBaseRawPlanData)this.myData).lines.get(i2).substring(state.indent + 2);
            infos.add(extra);
            Matcher rows = ROWS_PATTERN.matcher(extra);
            if (!rows.matches()) continue;
            node.setActualNumRows(new BigDecimal(rows.group(1)));
            node.setActualTotalTime(Double.parseDouble(rows.group(2)));
        }
        node.setRawDescription(StringUtil.join(infos, (String)";\n"));
        node.setPlanNumRows(new BigDecimal(matcher.group(4)));
        node.setTotalCost(Double.parseDouble(matcher.group(3)));
        node.setStartupCost(Double.parseDouble(matcher.group(2)));
    }

    private static boolean isSubNode(int indent, String line) {
        return indent + 2 < line.length() && StringUtil.startsWith((CharSequence)line, (int)(indent + 2), (CharSequence)"->");
    }

    private static boolean isSubPlan(int indent, String line) {
        return indent + 2 < line.length() && StringUtil.startsWith((CharSequence)line, (int)(indent + 2), (CharSequence)"SubPlan");
    }

    private static boolean isDescendantText(int indent, String line) {
        if (indent + 2 >= line.length()) {
            return false;
        }
        for (int i2 = 0; i2 < indent + 2; ++i2) {
            if (line.charAt(i2) == ' ') continue;
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    protected Double parseTotalCost(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(8);
        }
        return null;
    }

    @Override
    @Nullable
    protected Double parseStartupCost(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(9);
        }
        return null;
    }

    @Override
    protected boolean parseSubqueryCorrelated(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(10);
        }
        return false;
    }

    @Override
    protected boolean parseSubqueryScalar(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(11);
        }
        return false;
    }

    @Override
    protected void parsePlan(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(12);
        }
        this.openNode(null);
        this.parseSubPlans(state);
        String nodeType = this.extractNodeType(state);
        PlanModel.NodeType type = this.mapNode(nodeType);
        if (type == null) {
            type = PlanModel.NodeType.UNKNOWN;
        }
        PlanModel.GenericNode node = this.createNode(state, type, nodeType);
        this.closeNode(node);
    }

    protected PlanModel.NodeType mapNode(String nodeType) {
        PlanModel.NodeType type = TYPE_MAPPING.get(nodeType);
        if (type == null) {
            type = TYPE_MAPPING_EXT.get(nodeType);
        }
        return type;
    }

    @NotNull
    protected String extractNodeType(@NotNull PgBaseRawPlanData.MetaNode state) {
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(13);
        }
        int s = this.parsePrefix(state);
        String line = ((PgBaseRawPlanData)this.myData).lines.get(state.line);
        int t = s;
        if (StringUtil.startsWith((CharSequence)line, (int)s, (CharSequence)SUBQUERY_SCAN)) {
            t = s + SUBQUERY_SCAN.length();
        } else {
            while ((t = line.indexOf(32, t + 1)) != -1 && !PgBasePlanModelBuilder.isEOType(line, t)) {
            }
        }
        String string = (t == -1 ? line.substring(s) : line.substring(s, t)).trim();
        if (string == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(14);
        }
        return string;
    }

    protected int parsePrefix(@NotNull PgBaseRawPlanData.MetaNode state) {
        int s;
        String line;
        int t1;
        if (state == null) {
            PgBasePlanModelBuilder.$$$reportNull$$$0(15);
        }
        if ((t1 = (line = ((PgBaseRawPlanData)this.myData).lines.get(state.line)).indexOf(32, s = state.indent)) == -1) {
            throw new PlanRetrievalException("Unable to parse line: " + line);
        }
        state.tp = line.substring(s, t1);
        s = ++t1;
        return s;
    }

    private static boolean isEOType(String line, int t) {
        if (t + 1 < line.length() && Character.isDigit(line.charAt(t + 1))) {
            return true;
        }
        return StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"on") || StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"using") || StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"DS_") || StringUtil.startsWith((CharSequence)line, (int)(t + 1), (CharSequence)"(");
    }

    static {
        TYPE_MAPPING.put("Result", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("ModifyTable", PlanModel.NodeType.STATEMENT);
        TYPE_MAPPING.put("Append", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("Merge Append", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("Recursive Union", PlanModel.NodeType.UNION);
        TYPE_MAPPING.put("Bitmap And", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("Bitmap Or", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("Nested Loop", PlanModel.NodeType.NESTED_LOOPS);
        TYPE_MAPPING.put("Merge Join", PlanModel.NodeType.MERGE_JOIN);
        TYPE_MAPPING.put("Hash Join", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("Hash Right Join", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING.put("Seq Scan", PlanModel.NodeType.SEQ_SCAN);
        TYPE_MAPPING.put("Index Scan", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("Index Only Scan", PlanModel.NodeType.INDEX_SCAN);
        TYPE_MAPPING.put("Bitmap Index Scan", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("Bitmap Heap Scan", PlanModel.NodeType.BITMAP_INDEX_SCAN);
        TYPE_MAPPING.put("Tid Scan", PlanModel.NodeType.ROWID_ACCESS);
        TYPE_MAPPING.put(SUBQUERY_SCAN, PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("Function Scan", PlanModel.NodeType.TABLE_FUNCTION);
        TYPE_MAPPING.put("Values Scan", PlanModel.NodeType.VALUE);
        TYPE_MAPPING.put("CTE Scan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("WorkTable Scan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("Foreign Scan", PlanModel.NodeType.ACCESS);
        TYPE_MAPPING.put("Materialize", PlanModel.NodeType.TEMPORARY);
        TYPE_MAPPING.put("Sort", PlanModel.NodeType.SORT);
        TYPE_MAPPING.put("Group", PlanModel.NodeType.GROUP_BY);
        TYPE_MAPPING.put("Aggregate", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("HashAggregate", PlanModel.NodeType.AGGREGATE);
        TYPE_MAPPING.put("WindowAgg", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("Unique", PlanModel.NodeType.UNIQUE);
        TYPE_MAPPING.put("SetOp", PlanModel.NodeType.SET_OP);
        TYPE_MAPPING.put("LockRows", PlanModel.NodeType.LOCK_ROWS);
        TYPE_MAPPING.put("Limit", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("Hash", PlanModel.NodeType.TRANSFORM);
        TYPE_MAPPING.put("SubPlan", PlanModel.NodeType.SUBPLAN);
        TYPE_MAPPING_EXT.put("Hash Left Join", PlanModel.NodeType.HASH_JOIN);
        TYPE_MAPPING_EXT.put("Network", PlanModel.NodeType.NETWORK);
        TABLE_PATTERN = Pattern.compile("\\s(?:on|Subquery Scan) ((?:\"(?:[^\"]|\"\")*\"|(\\w|_)+))\\s+(?:\"(?:[^\"]|\"\")*\"|(\\w|_)+)?\\s*\\(cost[^()]+\\)");
        INDEX_PATTERN = Pattern.compile("\\susing ((?:\"(?:[^\"]|\"\")*\"|(\\w|_)+))\\s+(?:on (?:\"(?:[^\"]|\"\")*\"|(\\w|_)+)\\s+)?\\(cost[^()]+\\)");
        ATTR_PATTERN = Pattern.compile("(\\bDS_\\S+)?\\s*\\(cost=(\\d+\\.\\d+)\\.\\.(\\d+\\.\\d+) rows=(\\d+) (.*?)\\)");
        ACT_PATTERN = Pattern.compile("\\(actual time=(\\d+\\.\\d+)\\.\\.(\\d+\\.\\d+) rows=(\\d+) (.*?)\\)");
        ROWS_PATTERN = Pattern.compile("Rows out:.*(\\d+) rows .* with ([0-9.]+) ms to end.");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/postgresbase/plan/PgBasePlanModelBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/postgresbase/plan/PgBasePlanModelBuilder";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "extractNodeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parseRawDescription";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessRelation";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parsePlanNumRows";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "parseAccessIndex";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "parseSubPlans";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseStatement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "parseTotalCost";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parseStartupCost";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryCorrelated";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "parseSubqueryScalar";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "parsePlan";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractNodeType";
                break;
            }
            case 14: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "parsePrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14 -> new IllegalStateException(string);
        };
    }
}

