/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.BinaryDisplayType;
import com.intellij.database.extractors.DatabaseFormatterCreator;
import com.intellij.database.extractors.DisplayType;
import com.intellij.database.remote.jdbc.GeoWrapper;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.FactoryWithDomainSupport;
import com.intellij.database.run.ui.grid.editors.FormatBasedGridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.Formatter;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.editors.GridCellEditorsUtil;
import com.intellij.database.run.ui.grid.editors.UnparsedValue;
import com.intellij.database.run.ui.grid.editors.UnparsedValueWithDomain;
import com.intellij.database.run.ui.grid.editors.ValueParserWrapper;
import com.intellij.openapi.util.text.StringUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001c\u0010\u0010\u001a\u00020\u00062\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\r0\nH\u0014J\u001a\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\rH\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!H\u0002\u00a8\u0006\""}, d2={"Lcom/intellij/database/run/ui/grid/editors/GeoTextEditorFactory;", "Lcom/intellij/database/run/ui/grid/editors/FormatBasedGridCellEditorFactory;", "Lcom/intellij/database/run/ui/grid/editors/FactoryWithDomainSupport;", "<init>", "()V", "getSuitability", "", "grid", "Lcom/intellij/database/datagrid/DataGrid;", "rowIndex", "Lcom/intellij/database/datagrid/ModelIndex;", "Lcom/intellij/database/datagrid/GridRow;", "columnIndex", "Lcom/intellij/database/datagrid/GridColumn;", "domain", "Lcom/intellij/database/data/types/domain/Domain;", "getSuitabilityInner", "displayType", "Lcom/intellij/database/extractors/DisplayType;", "getValueParser", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$ValueParser;", "createValueParser", "getFormatInner", "Lcom/intellij/database/run/ui/grid/editors/Formatter;", "rowIdx", "columnIdx", "createFormatter", "column", "getIsEditableChecker", "Lcom/intellij/database/run/ui/grid/editors/GridCellEditorFactory$IsEditableChecker;", "isEditableInner", "", "value", "", "intellij.database.impl"})
public final class GeoTextEditorFactory
extends FormatBasedGridCellEditorFactory
implements FactoryWithDomainSupport {
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIndex, @NotNull ModelIndex<GridColumn> columnIndex) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(rowIndex, (String)"rowIndex");
        Intrinsics.checkNotNullParameter(columnIndex, (String)"columnIndex");
        return this.getSuitabilityInner(grid.getDisplayType(columnIndex), GridCellEditorsUtil.guessDomainForEditing((CoreGrid<GridRow, GridColumn>)((CoreGrid)grid), rowIndex, columnIndex));
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return this.getSuitabilityInner(null, domain);
    }

    private final int getSuitabilityInner(DisplayType displayType, Domain domain) {
        return displayType == BinaryDisplayType.HEX && domain != null && StringUtil.equalsIgnoreCase((CharSequence)"GEOMETRY", (CharSequence)domain.getPoint().toString()) ? 10 : 0;
    }

    @Override
    @NotNull
    public GridCellEditorFactory.ValueParser getValueParser(@NotNull DataGrid grid, @NotNull Domain domain) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return this.createValueParser(grid, domain);
    }

    private final GridCellEditorFactory.ValueParser createValueParser(DataGrid grid, Domain domain) {
        return (GridCellEditorFactory.ValueParser)new ValueParserWrapper(this.createFormatter(grid, null), true, GridCellEditorHelper.get((CoreGrid)((CoreGrid)grid)).getDefaultNullValue((CoreGrid)grid, null), (arg_0, arg_1) -> GeoTextEditorFactory.createValueParser$lambda$0(domain, arg_0, arg_1));
    }

    @NotNull
    protected Formatter getFormatInner(@NotNull DataGrid grid, @NotNull ModelIndex<GridRow> rowIdx, @NotNull ModelIndex<GridColumn> columnIdx) {
        Intrinsics.checkNotNullParameter((Object)grid, (String)"grid");
        Intrinsics.checkNotNullParameter(rowIdx, (String)"rowIdx");
        Intrinsics.checkNotNullParameter(columnIdx, (String)"columnIdx");
        GridColumn column2 = (GridColumn)grid.getDataModel(DataAccessType.DATABASE_DATA).getColumn(columnIdx);
        return this.createFormatter(grid, column2);
    }

    private final Formatter createFormatter(DataGrid grid, GridColumn column2) {
        DatabaseFormatterCreator formatterCreator = new DatabaseFormatterCreator(DataGridUtil.getDbms(grid));
        Formatter formatter = formatterCreator.newGeoWrapperFormatter(column2, grid.getObjectFormatter());
        Intrinsics.checkNotNullExpressionValue((Object)formatter, (String)"newGeoWrapperFormatter(...)");
        return formatter;
    }

    @NotNull
    public GridCellEditorFactory.IsEditableChecker getIsEditableChecker() {
        return (arg_0, arg_1, arg_2) -> GeoTextEditorFactory.getIsEditableChecker$lambda$1(this, arg_0, arg_1, arg_2);
    }

    private final boolean isEditableInner(Object value) {
        return value == null || value instanceof GeoWrapper;
    }

    private static final UnparsedValue createValueParser$lambda$0(Domain $domain, String text2, UnparsedValue.ParsingError e) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        UnparsedValue unparsedValue = UnparsedValueWithDomain.create(text2, $domain, e);
        Intrinsics.checkNotNullExpressionValue((Object)unparsedValue, (String)"create(...)");
        return unparsedValue;
    }

    private static final boolean getIsEditableChecker$lambda$1(GeoTextEditorFactory this$0, Object value, DataGrid grid, ModelIndex column2) {
        return this$0.isEditableInner(value);
    }
}

