/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view;

import com.intellij.database.actions.DbDeleteProvider;
import com.intellij.database.dataSource.srcStorage.DbSrcFileSystemCore;
import com.intellij.database.dataSource.srcStorage.DbSrcUtilsCore;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridPomTarget;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.view.DatabaseNavBarService;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.DatabaseViewTreeComponent;
import com.intellij.database.view.DbNodeDescriptor;
import com.intellij.database.view.structure.DvErsatzFamilyNode;
import com.intellij.database.view.structure.DvHostNode;
import com.intellij.database.view.structure.DvTreeStructureService;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.awt.Component;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DatabaseNavBarExtension
extends AbstractNavBarModelExtension {
    @NotNull
    public DatabaseNavBarService getService(Project project) {
        DatabaseNavBarService databaseNavBarService = (DatabaseNavBarService)project.getService(DatabaseNavBarService.class);
        if (databaseNavBarService == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(0);
        }
        return databaseNavBarService;
    }

    public PsiElement getLeafElement(@NotNull DataContext dataContext) {
        Component contextComponent;
        if (dataContext == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(1);
        }
        if ((contextComponent = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(dataContext)) instanceof DatabaseViewTreeComponent) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return null;
            }
            DatabaseNavBarService service = this.getService(project);
            PsiElement leafElement = service.getLeafElement();
            return leafElement;
        }
        return null;
    }

    @Nullable
    public String getPopupMenuGroup(@NotNull DataProvider provider) {
        PsiElement object;
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(2);
        }
        if (!DatabaseNavBarExtension.isDatabaseObject(object = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider))) {
            return null;
        }
        return "DatabaseViewPopupMenu";
    }

    @Nullable
    public Object getData(@NotNull String dataId, @NotNull DataProvider provider) {
        BasicNode node;
        BasicNode bn;
        Object object;
        DbElement dbe;
        DbElement dbElement;
        PsiElement psiElement;
        if (dataId == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(3);
        }
        if (provider == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(4);
        }
        if ((psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(provider)) == null) {
            return provider.getData(dataId);
        }
        if (PlatformDataKeys.DELETE_ELEMENT_PROVIDER.is(dataId)) {
            return DatabaseNavBarExtension.isDatabaseObject(psiElement) ? DbDeleteProvider.getDeleteProvider(Collections.singletonList(psiElement)) : null;
        }
        if (CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return psiElement;
        }
        DbElement dbElement2 = dbElement = psiElement instanceof DbElement ? (dbe = (DbElement)psiElement) : null;
        if (DatabaseView.DB_ELEMENTS.is(dataId)) {
            DbElement[] dbElementArray;
            if (dbElement != null) {
                DbElement[] dbElementArray2 = new DbElement[1];
                dbElementArray = dbElementArray2;
                dbElementArray2[0] = dbElement;
            } else {
                dbElementArray = null;
            }
            return dbElementArray;
        }
        if (VcsDataKeys.VIRTUAL_FILES.is(dataId)) {
            if (dbElement != null) {
                List<VirtualFile> files2 = DbNodeDescriptor.getVirtualFiles(dbElement);
                return files2 != null && !files2.isEmpty() ? files2 : null;
            }
            return null;
        }
        BasicNode basicNode = dbElement != null ? ((object = dbElement.getDelegate()) instanceof BasicNode ? (bn = (BasicNode)object) : null) : (node = null);
        if (node == null) {
            return null;
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(provider);
        if (project == null) {
            return null;
        }
        return DbNodeDescriptor.getDatumSlow(dataId, project, () -> node);
    }

    @Nullable
    public String getPresentableText(Object object) {
        Project project;
        BasicNode node;
        Object delegate;
        Object object2 = delegate = object instanceof DbElement ? ((DbElement)object).getDelegate() : null;
        BasicNode basicNode = object instanceof BasicNode ? (BasicNode)object : (node = delegate instanceof BasicNode ? (BasicNode)delegate : null);
        Object object3 = object instanceof DbElement ? ((DbElement)object).getProject() : (project = object instanceof PsiNamedElement ? ((PsiNamedElement)object).getProject() : null);
        if (node != null && project != null) {
            DatabaseNavBarService service = this.getService(project);
            return service.getNodeDisplayText(node);
        }
        return object instanceof DbElement ? DbPresentationCore.getPresentableName((DbElement)object, true) : (object instanceof PsiNamedElement && !(object instanceof PsiFile) ? ((PsiNamedElement)object).getName() : null);
    }

    @Nullable
    public PsiElement getParent(PsiElement psiElement) {
        if (psiElement instanceof DatabaseNodeWrappingService.NodeWrapper) {
            return psiElement.getParent();
        }
        DatabaseNavBarService service = this.getService(psiElement.getProject());
        return service.getParent(psiElement);
    }

    @Nullable
    public PsiElement adjustElement(final @NotNull PsiElement psiElement) {
        if (psiElement == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(5);
        }
        if (psiElement instanceof DbElement || psiElement instanceof DatabaseNodeWrappingService.NodeWrapper) {
            return psiElement;
        }
        final VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)psiElement);
        if (DbImplUtil.isDatabaseVirtualFile(file)) {
            DbElement element = DbImplUtilCore.findElement(psiElement.getProject(), file);
            if (element != null) {
                return element;
            }
            if (DbSrcUtilsCore.isDbSrcFile(file)) {
                PsiElement group = DbSrcFileSystemCore.processPath(file.getPath(), new DbSrcFileSystemCore.ItemProcessor<PsiElement>(){

                    @Override
                    public PsiElement processFolder(@Nullable Project project, @NotNull String dataSourceId, @Nullable ObjectPath path, @Nullable ObjectKind group) {
                        DbElement parent;
                        if (dataSourceId == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        DbElement dbElement = parent = group == null ? null : DbImplUtilCore.findElement(psiElement.getProject(), file.getParent());
                        if (parent == null) {
                            return null;
                        }
                        DbDataSource dataSource = parent.getDataSource();
                        return null;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceId", "com/intellij/database/view/DatabaseNavBarExtension$1", "processFolder"));
                    }
                });
                if (group != null) {
                    return group;
                }
                return DbPsiFacade.getInstance(psiElement.getProject()).findDataSource(DbSrcUtilsCore.getDataSource(file));
            }
        } else {
            DataGrid dataGrid = DataGridPomTarget.unwrapDataGrid((PsiElement)psiElement);
            if (dataGrid != null) {
                VirtualFile virtualFile = GridUtil.getVirtualFile((CoreGrid)dataGrid);
                return virtualFile == null ? null : psiElement.getManager().findFile(virtualFile);
            }
        }
        return psiElement;
    }

    public boolean processChildren(Object object, Object rootElement, Processor<Object> processor2) {
        BasicNode node;
        Object adjusted2;
        if (object instanceof DatabaseNodeWrappingService.NodeWrapper) {
            DatabaseNodeWrappingService.NodeWrapper nw = (DatabaseNodeWrappingService.NodeWrapper)((Object)object);
            JBIterable<PsiElement> children2 = nw.iterateChildren();
            return ContainerUtil.process(children2, processor2);
        }
        if (!(object instanceof PsiElement) || !((PsiElement)object).isValid()) {
            return true;
        }
        Object object2 = adjusted2 = object instanceof DbElement && !(object instanceof DbDataSource) ? ((DbElement)object).getDelegate() : object;
        if (!DatabaseNavBarExtension.isDatabaseObject(adjusted2)) {
            return true;
        }
        if (DatabaseNavBarExtension.isAlwaysLeafImpl(adjusted2)) {
            return true;
        }
        Project project = ((PsiElement)object).getProject();
        DvTreeStructureService structure = (DvTreeStructureService)project.getService(DvTreeStructureService.class);
        DatabaseNavBarService service = this.getService(project);
        if (adjusted2 instanceof BasicNode) {
            node = (BasicNode)adjusted2;
        } else if (adjusted2 instanceof PsiElement) {
            node = service.unwrap((PsiElement)adjusted2);
        } else {
            return false;
        }
        if (node == null) {
            return true;
        }
        JBIterable children3 = structure.childrenOf(node).filterMap(o -> service.wrap(o));
        return ContainerUtil.process((Iterable)children3, processor2);
    }

    private static boolean isAlwaysLeafImpl(Object o) {
        BasicElement basic = o instanceof DasObject ? DbImplUtilCore.getMaybeBasicElement((DasObject)o) : null;
        List<ObjectKind> familyKinds = basic == null ? null : DatabaseNavBarExtension.getFamilyKinds(basic);
        return familyKinds != null && familyKinds.isEmpty() || o instanceof DasObject && (((DasObject)o).getKind() == ObjectKind.SEQUENCE || o instanceof DasTableChild && familyKinds == null || o instanceof DasRoutine || o instanceof DasSynonym);
    }

    @NotNull
    private static @NotNull List<@NotNull ObjectKind> getFamilyKinds(@NotNull BasicElement host) {
        if (host == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(6);
        }
        List list = ContainerUtil.map((Object[])host.getMetaObject().children, m -> m.kind);
        if (list == null) {
            DatabaseNavBarExtension.$$$reportNull$$$0(7);
        }
        return list;
    }

    public Boolean shouldExpandOnClick(PsiElement psiElement) {
        if (psiElement instanceof DatabaseNodeWrappingService.NodeWrapper) {
            return true;
        }
        if (!DatabaseNavBarExtension.isDatabaseObject(psiElement)) {
            return null;
        }
        return !DatabaseNavBarExtension.isAlwaysLeafImpl(psiElement);
    }

    private static boolean isDatabaseObject(Object element) {
        return element instanceof DasObject || element instanceof DvHostNode || element instanceof DvErsatzFamilyNode || element instanceof DatabaseNodeWrappingService.NodeWrapper;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/DatabaseNavBarExtension";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/DatabaseNavBarExtension";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyKinds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLeafElement";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPopupMenuGroup";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "adjustElement";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFamilyKinds";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

