/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake;

import com.intellij.database.Dbms;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlLanguageDialectBase;
import com.intellij.sql.dialects.base.TokensHelper;
import com.intellij.sql.dialects.base.psi.SqlCodeBlockElementTypeImpl;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.snowflake.SFlakeElementTypes;
import com.intellij.sql.dialects.snowflake.SFlakeTokens;
import com.intellij.sql.dialects.snowflake.dataFlow.SFlakeDFABuildingVisitor;
import com.intellij.sql.dialects.snowflake.refactoring.SFlakeExtractFunctionHelper;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.psi.SqlBlockStatement;
import com.intellij.sql.psi.SqlCreateProcedureStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDeleteStatement;
import com.intellij.sql.psi.SqlExceptionWhenClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlMergeStatement;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlUpdateStatement;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.util.ObjectUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SFlakeDialect
extends SqlLanguageDialectBase {
    public static final SFlakeDialect INSTANCE = new SFlakeDialect();

    private SFlakeDialect() {
        super("Snowflake");
    }

    @Override
    @NotNull
    protected TokensHelper createTokensHelper() {
        TokensHelper tokensHelper = this.createTokensHelper(SFlakeTokens.class);
        if (tokensHelper == null) {
            SFlakeDialect.$$$reportNull$$$0(0);
        }
        return tokensHelper;
    }

    @Override
    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        super.addTypes(myTypes);
        SqlFunctionsUtil.addSimpleType(myTypes, "variant", "variant", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "object", "object", (SqlLanguageDialectEx)this);
        SqlFunctionsUtil.addSimpleType(myTypes, "geography", "geography", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public Dbms getDbms() {
        Dbms dbms = Dbms.SNOWFLAKE;
        if (dbms == null) {
            SFlakeDialect.$$$reportNull$$$0(1);
        }
        return dbms;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        T types = super.getParentDbTypes(result2, type);
        if (type == SFlakeElementTypes.Kinds.SHARE) {
            types.add((ObjectKind)SFlakeElementTypes.Kinds.ACCOUNT);
        }
        if (this.unaliased(type) == ObjectKind.TABLE) {
            types.add((ObjectKind)ObjectKind.SCHEMA);
        }
        return types;
    }

    public boolean isOperatorSupported(@Nullable IElementType tokenType) {
        return tokenType != null && LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = Collections.emptySet();
        if (set == null) {
            SFlakeDialect.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SFlakeDialect.$$$reportNull$$$0(3);
        }
        return (type == ObjectKind.STREAM || this.unaliased(type) == ObjectKind.TABLE || type == ObjectKind.FOREIGN_TABLE) && expectedTypes.contains(ObjectKind.TABLE);
    }

    @NotNull
    public ObjectKind unaliased(@NotNull ObjectKind kind) {
        if (kind == null) {
            SFlakeDialect.$$$reportNull$$$0(4);
        }
        if (kind == ObjectKind.DYNAMIC_TABLE || kind == SFlakeElementTypes.Kinds.ICEBERG_TABLE || kind == SFlakeElementTypes.Kinds.EVENT_TABLE || kind == SFlakeElementTypes.Kinds.HYBRID_TABLE) {
            ObjectKind objectKind = ObjectKind.TABLE;
            if (objectKind == null) {
                SFlakeDialect.$$$reportNull$$$0(5);
            }
            return objectKind;
        }
        ObjectKind objectKind = super.unaliased(kind);
        if (objectKind == null) {
            SFlakeDialect.$$$reportNull$$$0(6);
        }
        return objectKind;
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public boolean shouldWrap(SqlDefinition o, ObjectKind kind) {
        return kind == SFlakeElementTypes.Kinds.ACCOUNT || super.shouldWrap(o, kind);
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        JdbcUrlParser params = SqlDialectImplUtilCore.getParsed(SqlImportUtil.getConnectionConfig(dataSource));
        ObjectName dbName = params == null ? null : ObjectName.plain(StringUtil.nullize((String)params.getParameter("database")));
        ObjectName scName = (ObjectName)ObjectUtils.chooseNotNull(params == null ? null : ObjectName.plain(StringUtil.nullize((String)params.getParameter("schema"))), (Object)LazyData.PUBLIC_NAME);
        DasNamespace curDb = SFlakeDialect.getDefaultTopNamespace(dataSource, dbName);
        DasNamespace curSc = SFlakeDialect.getDefaultSubNamespace(curDb, scName);
        if (curSc != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, curSc, new TreePatternNode.Group[0]);
            if (treePattern == null) {
                SFlakeDialect.$$$reportNull$$$0(7);
            }
            return treePattern;
        }
        if (curDb != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, curDb, TreePatternUtils.create(scName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SFlakeDialect.$$$reportNull$$$0(8);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbName, TreePatternUtils.create(scName, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
    }

    @Override
    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SFlakeDialect.$$$reportNull$$$0(9);
        }
        TreePattern treePattern = SqlImportUtil.addObjectsByPath(pattern, dsNames, Collections.singletonList(LazyData.PUBLIC_NAME), false, SqlImportUtil.DATA_SOURCE, ObjectKind.DATABASE, ObjectKind.SCHEMA);
        if (treePattern == null) {
            SFlakeDialect.$$$reportNull$$$0(10);
        }
        return treePattern;
    }

    @Override
    protected TreePattern createRefPattern(@NotNull TreePattern prev2, @NotNull SqlReferenceExpression ref2) {
        TreePattern dbPattern;
        ObjectKind refKind;
        if (prev2 == null) {
            SFlakeDialect.$$$reportNull$$$0(11);
        }
        if (ref2 == null) {
            SFlakeDialect.$$$reportNull$$$0(12);
        }
        boolean isDb = (refKind = ref2.getReferenceElementType().getTargetKind()) == ObjectKind.DATABASE;
        boolean isSc = refKind == ObjectKind.SCHEMA || refKind == SqlDbElementType.ANY && ref2.getQualifierExpression() != null;
        TreePattern scPattern = isDb ? null : SqlImportUtil.createRefPattern(ref2, ObjectKind.SCHEMA, this.getDbms());
        TreePattern treePattern = dbPattern = isSc ? null : this.createDbRefPattern(prev2, ref2);
        if (isSc) {
            return scPattern;
        }
        if (isDb) {
            return dbPattern;
        }
        return TreePatternUtils.union(dbPattern, scPattern);
    }

    @Override
    public boolean canContainDdl(@NotNull PsiElement e) {
        if (e == null) {
            SFlakeDialect.$$$reportNull$$$0(13);
        }
        return super.canContainDdl(e) || e instanceof SqlCreateProcedureStatement || e instanceof SqlCodeBlockElementTypeImpl.BodyElement || e instanceof SqlBlockStatement;
    }

    @Nullable
    private TreePattern createDbRefPattern(@NotNull TreePattern prev2, @NotNull SqlReferenceExpression ref2) {
        if (prev2 == null) {
            SFlakeDialect.$$$reportNull$$$0(14);
        }
        if (ref2 == null) {
            SFlakeDialect.$$$reportNull$$$0(15);
        }
        return SqlDialectImplUtilCore.refPatternExpandedToSchema(prev2, ref2, this);
    }

    @Override
    public boolean supportsNaturalJoin() {
        return true;
    }

    @Override
    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            SFlakeDialect.$$$reportNull$$$0(16);
        }
        return super.isTableAliasAllowedAt(element) || PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlDeleteStatement.class, SqlUpdateStatement.class, SqlMergeStatement.class}) != null;
    }

    @Override
    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, Version version) {
        if (identifier == null) {
            SFlakeDialect.$$$reportNull$$$0(17);
        }
        return 255;
    }

    @Override
    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return SFlakeExtractFunctionHelper.INSTANCE;
    }

    @Override
    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new SFlakeDFABuildingVisitor(this);
    }

    @Override
    public SqlCloseBlockProcessor[] getEnterHandlerBlockProcessors() {
        return SqlCloseBlockProcessor.EMPTY_ARRAY;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name2, @NotNull PsiElement place, boolean resolve2, @NotNull SqlScopeProcessor processor2) {
        boolean inPl;
        if (place == null) {
            SFlakeDialect.$$$reportNull$$$0(18);
        }
        if (processor2 == null) {
            SFlakeDialect.$$$reportNull$$$0(19);
        }
        boolean bl = inPl = PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{SqlBlockStatement.class}) != null;
        if (inPl && SqlImplUtil.getQualifier(place) == null) {
            for (ReservedEntity.Typed typed : LazyData.RE_DML_STATUS_VARS) {
                if (SFlakeDialect.processReservedEntitiesWithTypeSimple(typed, typed.type, name2, place, resolve2, processor2, false, false)) continue;
                return false;
            }
            if (PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])new Class[]{SqlExceptionWhenClause.class}) != null) {
                for (ReservedEntity.Typed typed : LazyData.RE_EXCEPTION_WHEN_VARS) {
                    if (SFlakeDialect.processReservedEntitiesWithTypeSimple(typed, typed.type, name2, place, resolve2, processor2, false, false)) continue;
                    return false;
                }
                for (ReservedEntity reservedEntity : LazyData.RE_EXCEPTIONS) {
                    if (SFlakeDialect.processReservedEntitiesWithTypeSimple(reservedEntity, null, name2, place, resolve2, processor2, false, false)) continue;
                    return false;
                }
            }
        }
        return super.processReservedEntitiesWithType(name2, place, resolve2, processor2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createTokensHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbms";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/snowflake/SFlakeDialect";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "unaliased";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "unaliased";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "canContainDdl";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createDbRefPattern";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 9, 11, 12, 13, 14, 15, 16, 17, 18, 19 -> new IllegalArgumentException(string);
        };
    }

    static final class LazyData {
        static final Set<IElementType> ourSupportedOperators = Set.of(SqlTokens.SQL_OP_PLUS, SqlTokens.SQL_OP_MINUS, SqlTokens.SQL_OP_MUL, SqlTokens.SQL_OP_DIV, SqlTokens.SQL_OP_NEQ, SqlTokens.SQL_OP_LE, SqlTokens.SQL_OP_LT, SqlTokens.SQL_OP_GE, SqlTokens.SQL_OP_EQ, SqlTokens.SQL_OP_GT, SqlTokens.SQL_OP_CONCAT, SqlTokens.SQL_AND, SqlTokens.SQL_NOT, SqlTokens.SQL_OR, SqlTokens.SQL_IS, SqlTokens.SQL_LIKE, SqlTokens.SQL_COLLATE, SqlTokens.SQL_IN, SqlTokens.SQL_OP_INVERT, SqlTokens.SQL_OP_BITWISE_AND, SqlTokens.SQL_OP_BITWISE_OR, SqlTokens.SQL_OP_LEFT_SHIFT, SqlTokens.SQL_OP_RIGHT_SHIFT, SqlTokens.SQL_OP_MODULO, SqlTokens.SQL_OP_NEQ2, SqlTokens.SQL_OP_EQEQ);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_OP_DIV})});
        static final ObjectName PUBLIC_NAME = ObjectName.quoted("PUBLIC");
        static final List<ReservedEntity.Typed> RE_DML_STATUS_VARS;
        static final List<ReservedEntity.Typed> RE_EXCEPTION_WHEN_VARS;
        static final List<ReservedEntity> RE_EXCEPTIONS;

        LazyData() {
        }

        static {
            DasTypeSystemBase typeSystem = DasTypeSystems.getTypeSystem(Dbms.SNOWFLAKE);
            RE_DML_STATUS_VARS = Arrays.asList(new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLROWCOUNT", ObjectKind.VARIABLE, typeSystem.getIntType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLFOUND", ObjectKind.VARIABLE, typeSystem.getBooleanType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLNOTFOUND", ObjectKind.VARIABLE, typeSystem.getBooleanType()));
            RE_EXCEPTION_WHEN_VARS = Arrays.asList(new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLCODE", ObjectKind.VARIABLE, typeSystem.getIntType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLERRM", ObjectKind.VARIABLE, typeSystem.getStringType()), new ReservedEntity.Typed(Dbms.SNOWFLAKE, "SQLSTATE", ObjectKind.VARIABLE, typeSystem.getStringType()));
            RE_EXCEPTIONS = Arrays.asList(new ReservedEntity(Dbms.SNOWFLAKE, "STATEMENT_ERROR", ObjectKind.EXCEPTION), new ReservedEntity(Dbms.SNOWFLAKE, "EXPRESSION_ERROR", ObjectKind.EXCEPTION));
        }
    }
}

