/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.inspections.dataflow.sql.inst;

import com.intellij.codeInspection.dataFlow.lang.DfaAnchor;
import com.intellij.codeInspection.dataFlow.lang.ir.EvalInstruction;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaTypeValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.codeInspection.dataFlow.value.VariableDescriptor;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.types.DasType;
import com.intellij.psi.PsiElement;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.inspections.dataflow.SqlDfaColumn;
import com.intellij.sql.inspections.dataflow.SqlDfaUtilKt;
import com.intellij.sql.inspections.dataflow.SqlTableDescriptor;
import com.intellij.sql.inspections.dataflow.SqlVariableDescriptor;
import com.intellij.sql.inspections.dataflow.sql.anchor.SqlExpressionAnchor;
import com.intellij.sql.inspections.dataflow.types.SqlDfTableType;
import com.intellij.sql.inspections.dataflow.types.SqlDfTypesKt;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\u0013\"\u00020\rH\u0016\u00a2\u0006\u0002\u0010\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/sql/inspections/dataflow/sql/inst/SqlReferenceAccessInstruction;", "Lcom/intellij/codeInspection/dataFlow/lang/ir/EvalInstruction;", "reference", "Lcom/intellij/sql/psi/SqlReferenceExpression;", "dialect", "Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "<init>", "(Lcom/intellij/sql/psi/SqlReferenceExpression;Lcom/intellij/sql/dialects/SqlLanguageDialectEx;)V", "getReference", "()Lcom/intellij/sql/psi/SqlReferenceExpression;", "getDialect", "()Lcom/intellij/sql/dialects/SqlLanguageDialectEx;", "eval", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "factory", "Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "arguments", "", "(Lcom/intellij/codeInspection/dataFlow/value/DfaValueFactory;Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;[Lcom/intellij/codeInspection/dataFlow/value/DfaValue;)Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "getQualifierValue", "toString", "", "intellij.database.sql.core.impl"})
@SourceDebugExtension(value={"SMAP\nSqlReferenceAccessInstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SqlReferenceAccessInstruction.kt\ncom/intellij/sql/inspections/dataflow/sql/inst/SqlReferenceAccessInstruction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,56:1\n1#2:57\n*E\n"})
public final class SqlReferenceAccessInstruction
extends EvalInstruction {
    @NotNull
    private final SqlReferenceExpression reference;
    @NotNull
    private final SqlLanguageDialectEx dialect;

    public SqlReferenceAccessInstruction(@NotNull SqlReferenceExpression reference, @NotNull SqlLanguageDialectEx dialect) {
        Intrinsics.checkNotNullParameter((Object)reference, (String)"reference");
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        super((DfaAnchor)SqlExpressionAnchor.Companion.getAnchor((SqlExpression)reference), 0);
        this.reference = reference;
        this.dialect = dialect;
    }

    @NotNull
    public final SqlReferenceExpression getReference() {
        return this.reference;
    }

    @NotNull
    public final SqlLanguageDialectEx getDialect() {
        return this.dialect;
    }

    @NotNull
    public DfaValue eval(@NotNull DfaValueFactory factory, @NotNull DfaMemoryState state, DfaValue ... arguments) {
        DfaValue result2;
        block4: {
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            DasType dasType = this.reference.getDasType();
            Intrinsics.checkNotNullExpressionValue((Object)dasType, (String)"getDasType(...)");
            DasType dasType2 = dasType;
            if (SqlImplUtil.isAsteriskRef((PsiElement)this.reference) && dasType2 instanceof SqlTableType) {
                DfaTypeValue dfaTypeValue = factory.fromDfType((DfType)SqlDfTypesKt.tableType((SqlTableType)dasType2, this.dialect));
                Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"fromDfType(...)");
                return (DfaValue)dfaTypeValue;
            }
            PsiElement psiElement = this.reference.resolve();
            if (psiElement == null) {
                DfaTypeValue dfaTypeValue = factory.getUnknown();
                Intrinsics.checkNotNullExpressionValue((Object)dfaTypeValue, (String)"getUnknown(...)");
                return (DfaValue)dfaTypeValue;
            }
            PsiElement target2 = psiElement;
            DfaValue dfaValue = this.getQualifierValue(factory);
            DfaVariableValue qualifier = dfaValue instanceof DfaVariableValue ? (DfaVariableValue)dfaValue : null;
            result2 = SqlDfaUtilKt.createValue$default(target2, (DfaValue)qualifier, factory, state, null, 16, null);
            if (qualifier == null) {
                return result2;
            }
            DfType dfType = state.getDfType((DfaValue)qualifier);
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"getDfType(...)");
            DfType qualifierType = dfType;
            if (!(qualifierType instanceof SqlDfTableType)) break block4;
            SqlDfaColumn sqlDfaColumn = ((SqlDfTableType)qualifierType).getColumn(target2);
            if (sqlDfaColumn != null) {
                SqlDfaColumn $this$eval_u24lambda_u240 = sqlDfaColumn;
                boolean bl = false;
                state.setDfType(result2, $this$eval_u24lambda_u240.getDfType());
            }
        }
        return result2;
    }

    private final DfaValue getQualifierValue(DfaValueFactory factory) {
        SqlExpression sqlExpression = this.reference.getQualifierExpression();
        PsiElement qualifier = sqlExpression != null ? (PsiElement)sqlExpression : SqlImplUtil.getQualifier(this.reference.resolveSingle());
        PsiElement psiElement = qualifier = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : qualifier;
        if (qualifier != null) {
            Object object;
            DfaVariableValue dfaVariableValue = factory.getVarFactory().getVariableValue((VariableDescriptor)new SqlTableDescriptor(qualifier, null, 2, null), null);
            if (dfaVariableValue != null) {
                object = (DfaValue)dfaVariableValue;
            } else {
                SqlVariableDescriptor sqlVariableDescriptor = SqlVariableDescriptor.Companion.createVariableDescriptor(qualifier);
                object = sqlVariableDescriptor != null ? sqlVariableDescriptor.createValue(factory, null) : null;
            }
            return object;
        }
        return null;
    }

    @NotNull
    public String toString() {
        ObjectKind objectKind = this.reference.getReferenceElementType().getTargetKind();
        return Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.COLUMN) ? "COLUMN_ACCESS " + this.reference.getText() : (Intrinsics.areEqual((Object)objectKind, (Object)ObjectKind.TABLE) ? "FROM_TABLE " + this.reference.getText() : "REFERENCE_ACCESS " + this.reference.getText());
    }
}

