/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jewel.bridge.theme;

import androidx.compose.foundation.layout.PaddingValues;
import androidx.compose.foundation.shape.CornerSize;
import androidx.compose.foundation.shape.CornerSizeKt;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Insets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jewel.bridge.BridgeUtilsKt;
import org.jetbrains.jewel.ui.component.styling.TooltipColors;
import org.jetbrains.jewel.ui.component.styling.TooltipMetrics;
import org.jetbrains.jewel.ui.component.styling.TooltipStyle;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u00a8\u0006\u0002"}, d2={"readTooltipStyle", "Lorg/jetbrains/jewel/ui/component/styling/TooltipStyle;", "intellij.platform.jewel.ideLafBridge"})
public final class IntUiBridgeTooltipKt {
    @NotNull
    public static final TooltipStyle readTooltipStyle() {
        Insets insets = JBUI.CurrentTheme.HelpTooltip.smallTextBorderInsets();
        Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"smallTextBorderInsets(...)");
        PaddingValues paddingValues = BridgeUtilsKt.toPaddingValues(insets);
        long l = DurationKt.toDuration((int)Registry.Companion.intValue("ide.tooltip.initialDelay"), (DurationUnit)DurationUnit.MILLISECONDS);
        JBValue jBValue = JBUI.CurrentTheme.Tooltip.CORNER_RADIUS;
        Intrinsics.checkNotNullExpressionValue((Object)jBValue, (String)"CORNER_RADIUS");
        TooltipMetrics tooltipMetrics = TooltipMetrics.Companion.defaults-8qf-r9M$default((TooltipMetrics.Companion)TooltipMetrics.Companion, (PaddingValues)paddingValues, (long)l, (CornerSize)CornerSizeKt.CornerSize-0680j_4((float)BridgeUtilsKt.getDp(jBValue)), (float)0.0f, (float)0.0f, null, (int)56, null);
        long l2 = BridgeUtilsKt.retrieveColorOrUnspecified("ToolTip.foreground");
        long l3 = BridgeUtilsKt.retrieveColorOrUnspecified("ToolTip.background");
        Color color = JBUI.CurrentTheme.Tooltip.borderColor();
        Intrinsics.checkNotNullExpressionValue((Object)color, (String)"borderColor(...)");
        long l4 = BridgeUtilsKt.toComposeColor(color);
        long l5 = BridgeUtilsKt.retrieveColorOrUnspecified("Notification.Shadow.bottom1Color");
        TooltipColors tooltipColors = new TooltipColors(l3, l2, l4, l5, null);
        return new TooltipStyle(tooltipColors, tooltipMetrics);
    }
}

