/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.state;

import com.intellij.concurrency.ThreadContext;
import com.intellij.diagnostic.Checks;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramNoteNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.diagram.state.DiagramContentSettingsSnapshot;
import com.intellij.diagram.state.DiagramEdgeIdentity;
import com.intellij.diagram.state.DiagramLayoutSnapshot;
import com.intellij.diagram.state.DiagramNodeIdentity;
import com.intellij.diagram.state.DiagramNotesSnapshot;
import com.intellij.diagram.state.DiagramSelectionSnapshot;
import com.intellij.diagram.state.DiagramSnapshot;
import com.intellij.diagram.state.DiagramSnapshotFactory;
import com.intellij.diagram.state.DiagramViewPointSnapshot;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramFullSnapshot
implements DiagramSnapshot {
    @NotNull
    private final DiagramProvider<?> myProvider;
    @Nullable
    private final Object myOriginalElement;
    @NotNull
    private final DiagramContentSettingsSnapshot myContentSettingsSnapshot;
    @NotNull
    private final DiagramNotesSnapshot myNotesSnapshot;
    @NotNull
    private final DiagramViewPointSnapshot myViewPointSnapshot;
    @NotNull
    private final GraphSettings myViewSettings;
    @NotNull
    private final DiagramSelectionSnapshot mySelectionSnapshot;
    @NotNull
    private final DiagramLayoutSnapshot myLayoutSnapshot;

    private DiagramFullSnapshot(@NotNull DiagramProvider<?> provider, @Nullable Object element, @NotNull DiagramContentSettingsSnapshot snapshot, @NotNull DiagramNotesSnapshot notesSnapshot, @NotNull DiagramViewPointSnapshot pointSnapshot, @NotNull GraphSettings settings, @NotNull DiagramSelectionSnapshot selectionSnapshot, @NotNull DiagramLayoutSnapshot layoutSnapshot) {
        if (provider == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(0);
        }
        if (snapshot == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(1);
        }
        if (notesSnapshot == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(2);
        }
        if (pointSnapshot == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(4);
        }
        if (selectionSnapshot == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(5);
        }
        if (layoutSnapshot == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(6);
        }
        this.myProvider = provider;
        this.myOriginalElement = element;
        this.myContentSettingsSnapshot = snapshot;
        this.myNotesSnapshot = notesSnapshot;
        this.myViewPointSnapshot = pointSnapshot;
        this.myViewSettings = settings;
        this.mySelectionSnapshot = selectionSnapshot;
        this.myLayoutSnapshot = layoutSnapshot;
    }

    @Override
    @NotNull
    public CompletableFuture<Void> restoreAsync(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(7);
        }
        Checks.require((boolean)this.myProvider.equals(builder.getProvider()));
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)builder.getGraphBuilder().getActionExecutor().runGraphActionAsync(() -> builder.getPresentationModel().getSettings().setFrom(this.myViewSettings)).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.myViewPointSnapshot.restoreAsync(builder)))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.myContentSettingsSnapshot.restoreAsync(builder)))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.restoreDataModelStateAsync(builder)))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.mySelectionSnapshot.restoreAsync(builder)))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.myLayoutSnapshot.restoreAsync(builder)));
        if (completionStage == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(8);
        }
        return completionStage;
    }

    @NotNull
    private CompletableFuture<Void> restoreDataModelStateAsync(@NotNull DiagramBuilder builder) {
        if (builder == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(9);
        }
        DiagramDataModel<?> dataModel = builder.getDataModel();
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)builder.getGraphBuilder().getActionExecutor().runWriteActionAsync(() -> {
            dataModel.setOriginalElement(this.myOriginalElement);
            if (this.myOriginalElement != null) {
                dataModel.rebuild(this.myOriginalElement);
            } else {
                dataModel.removeAll();
            }
            for (DiagramNodeIdentity<Object> nodeElement : this.myLayoutSnapshot.getRecordedNodeElements()) {
                dataModel.addElement(nodeElement.getIdentifyingElement());
            }
        }).thenComposeAsync(ThreadContext.captureThreadContext(__ -> this.myNotesSnapshot.restoreAsync(builder)))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> dataModel.refreshDataModelAsync((ProgressIndicator)new EmptyProgressIndicator())))).thenRunAsync(() -> this.removeElementsNotPresentInThisState(dataModel), builder.getGraphBuilder().getActionExecutor().getWriteExecutor())).thenComposeAsync(ThreadContext.captureThreadContext(__ -> dataModel.refreshDataModelAsync((ProgressIndicator)new EmptyProgressIndicator())))).thenComposeAsync(ThreadContext.captureThreadContext(__ -> builder.queryUpdate().withDataReload().withPresentationUpdate().runAsync()));
        if (completionStage == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(10);
        }
        return completionStage;
    }

    private void removeElementsNotPresentInThisState(@NotNull DiagramDataModel<Object> dataModel) {
        if (dataModel == null) {
            DiagramFullSnapshot.$$$reportNull$$$0(11);
        }
        Set<DiagramNodeIdentity<Object>> allowedNodes = this.myLayoutSnapshot.getRecordedNodeElements();
        Set<DiagramNodeIdentity<Object>> allowedNotes = this.myNotesSnapshot.getRecordedNoteElements();
        Set<DiagramEdgeIdentity<Object>> allowedEdges = this.myLayoutSnapshot.getRecordedEdgeElements();
        for (DiagramNode<Object> diagramNode : new ArrayList<DiagramNode<Object>>(dataModel.getNodes())) {
            if (allowedNodes.contains(DiagramNodeIdentity.of(diagramNode))) continue;
            dataModel.removeNode(diagramNode);
        }
        for (DiagramNoteNode diagramNoteNode : new ArrayList<DiagramNoteNode>(dataModel.getNotes().values())) {
            if (allowedNotes.contains(DiagramNodeIdentity.of(diagramNoteNode))) continue;
            dataModel.removeNote(diagramNoteNode);
        }
        for (DiagramEdge diagramEdge : new ArrayList<DiagramEdge<Object>>(dataModel.getEdges())) {
            if (allowedEdges.contains(DiagramEdgeIdentity.of(diagramEdge))) continue;
            dataModel.removeEdge(diagramEdge);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshot";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notesSnapshot";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointSnapshot";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionSnapshot";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layoutSnapshot";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/diagram/state/DiagramFullSnapshot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/diagram/state/DiagramFullSnapshot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreAsync";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "restoreDataModelStateAsync";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "restoreAsync";
                break;
            }
            case 8: 
            case 10: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "restoreDataModelStateAsync";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removeElementsNotPresentInThisState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 10 -> new IllegalStateException(string);
        };
    }

    public static final class Factory
    implements DiagramSnapshotFactory<DiagramFullSnapshot> {
        @NotNull
        private static final Factory INSTANCE = new Factory();

        @NotNull
        public static Factory getInstance() {
            Factory factory = INSTANCE;
            if (factory == null) {
                Factory.$$$reportNull$$$0(0);
            }
            return factory;
        }

        @Override
        @NotNull
        public DiagramFullSnapshot makeSnapshot(@NotNull DiagramBuilder builder) {
            if (builder == null) {
                Factory.$$$reportNull$$$0(1);
            }
            DiagramFullSnapshot diagramFullSnapshot = this.makeSnapshot(builder, false);
            if (diagramFullSnapshot == null) {
                Factory.$$$reportNull$$$0(2);
            }
            return diagramFullSnapshot;
        }

        @NotNull
        public DiagramFullSnapshot makeSnapshot(@NotNull DiagramBuilder builder, boolean doIncludeViewPoint) {
            if (builder == null) {
                Factory.$$$reportNull$$$0(3);
            }
            return new DiagramFullSnapshot(builder.getProvider(), builder.getDataModel().getOriginalElement(), DiagramContentSettingsSnapshot.Factory.getInstance().makeSnapshot(builder), DiagramNotesSnapshot.Factory.getInstance().makeSnapshot(builder), doIncludeViewPoint ? DiagramViewPointSnapshot.Factory.getInstance().makeSnapshot(builder) : DiagramViewPointSnapshot.Factory.getInstance().getEmptySnapshot(), builder.getPresentationModel().getSettings().copy(), DiagramSelectionSnapshot.Factory.getInstance().makeSnapshot(builder), DiagramLayoutSnapshot.Factory.getInstance().makeSnapshot(builder));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/diagram/state/DiagramFullSnapshot$Factory";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getInstance";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/diagram/state/DiagramFullSnapshot$Factory";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "makeSnapshot";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "makeSnapshot";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 3 -> new IllegalArgumentException(string);
            };
        }
    }
}

