/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.kotlin.ExtensionsKt;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.util.registry.Registry;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\b\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0001H\u0002\u001a3\u0010\t\u001a\u0002H\n\"\u0006\b\u0000\u0010\n\u0018\u0001*\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u0010"}, d2={"jackson", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "getJackson", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "makeJsonFactoryWithMaxStringLength", "Lcom/fasterxml/jackson/core/JsonFactory;", "getStringLength", "", "setVisibility", "readValueWrappingError", "T", "json", "", "errorMessage", "Lkotlin/Function0;", "(Lcom/fasterxml/jackson/databind/ObjectMapper;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.jupyter.core"})
public final class JupyterJsonKt {
    @NotNull
    private static final ObjectMapper jackson = JupyterJsonKt.setVisibility(ExtensionsKt.registerKotlinModule((ObjectMapper)new ObjectMapper(JupyterJsonKt.makeJsonFactoryWithMaxStringLength())));

    @NotNull
    public static final ObjectMapper getJackson() {
        return jackson;
    }

    private static final JsonFactory makeJsonFactoryWithMaxStringLength() {
        int maxStringLength = JupyterJsonKt.getStringLength();
        StreamReadConstraints constraints = StreamReadConstraints.defaults().rebuild().maxStringLength(maxStringLength).build();
        JsonFactory jsonFactory = ((JsonFactoryBuilder)new JsonFactoryBuilder().streamReadConstraints(constraints)).build();
        Intrinsics.checkNotNullExpressionValue((Object)jsonFactory, (String)"build(...)");
        return jsonFactory;
    }

    private static final int getStringLength() {
        int n;
        try {
            n = Registry.Companion.get("jupyter.notebook.json.maxStringLength").asInteger();
        }
        catch (Throwable throwable) {
            n = 10000000;
        }
        return n;
    }

    private static final ObjectMapper setVisibility(ObjectMapper $this$setVisibility) {
        ObjectMapper objectMapper = $this$setVisibility.setVisibility($this$setVisibility.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        Intrinsics.checkNotNullExpressionValue((Object)objectMapper, (String)"setVisibility(...)");
        return objectMapper;
    }

    public static final /* synthetic */ <T> T readValueWrappingError(ObjectMapper $this$readValueWrappingError, String json, Function0<String> errorMessage) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$readValueWrappingError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(errorMessage, (String)"errorMessage");
        boolean $i$f$readValueWrappingError = false;
        try {
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            object = $this$readValueWrappingError.readValue(json, Object.class);
        }
        catch (JsonProcessingException err) {
            Attachment[] attachmentArray = new Attachment[]{new Attachment("response.json", json)};
            throw new RuntimeExceptionWithAttachments((String)errorMessage.invoke(), (Throwable)err, attachmentArray);
        }
        return (T)object;
    }
}

