/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.file;

import com.intellij.jupyter.core.core.impl.file.singleFile.JupyterFileModelCache;
import com.intellij.jupyter.core.core.impl.file.singleFile.SingleFileBackedNotebookVirtualFile;
import com.intellij.jupyter.core.jupyter.helper.JupyterFileUtils;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebook;
import com.intellij.jupyter.core.jupyter.nbformat.JupyterNotebookBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012J\b\u0010\u0010\u001a\u00020\u0011H&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\tR\u0012\u0010\u000e\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0005\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0013\u00c0\u0006\u0001"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "notebookOrNull", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getNotebookOrNull", "()Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "setNotebookOrNull", "(Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;)V", "notebook", "getNotebook", "originFile", "getOriginFile", "flush", "", "Companion", "intellij.jupyter.core"})
public interface BackedNotebookVirtualFile {
    @NotNull
    public static final Companion Companion = com.intellij.jupyter.core.core.impl.file.BackedNotebookVirtualFile$Companion.$$INSTANCE;

    @NotNull
    public VirtualFile getFile();

    @Nullable
    public JupyterNotebook getNotebookOrNull();

    public void setNotebookOrNull(@Nullable JupyterNotebook var1);

    @NotNull
    default public JupyterNotebook getNotebook() {
        JupyterNotebook jupyterNotebook = this.getNotebookOrNull();
        if (jupyterNotebook == null) {
            throw new IllegalStateException(("Notebook is not set up for " + this.getFile().getPath()).toString());
        }
        return jupyterNotebook;
    }

    @NotNull
    public VirtualFile getOriginFile();

    public void flush();

    @JvmStatic
    @NotNull
    public static BackedNotebookVirtualFile takeBackend(@NotNull VirtualFile file) {
        return Companion.takeBackend(file);
    }

    @JvmStatic
    @Nullable
    public static BackedNotebookVirtualFile takeIfBacked(@NotNull VirtualFile file) {
        return Companion.takeIfBacked(file);
    }

    @JvmStatic
    @Deprecated(message="Use takeIfBacked instead")
    @ApiStatus.ScheduledForRemoval
    @Nullable
    public static BackedNotebookVirtualFile find(@NotNull VirtualFile file) {
        return Companion.find(file);
    }

    @JvmStatic
    public static boolean isBacked(@Nullable VirtualFile file) {
        return Companion.isBacked(file);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile$Companion;", "", "<init>", "()V", "createWithNotebook", "Lcom/intellij/jupyter/core/core/impl/file/BackedNotebookVirtualFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "notebook", "Lcom/intellij/jupyter/core/jupyter/nbformat/JupyterNotebook;", "getOrLoadForDisposable", "disposable", "Lcom/intellij/openapi/Disposable;", "create", "takeBackend", "takeIfBacked", "find", "isBacked", "", "intellij.jupyter.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final BackedNotebookVirtualFile createWithNotebook(@NotNull VirtualFile file, @NotNull JupyterNotebook notebook) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)notebook, (String)"notebook");
            return SingleFileBackedNotebookVirtualFile.box-impl(SingleFileBackedNotebookVirtualFile.Companion.create-wH7Fbuo(file, notebook));
        }

        @Nullable
        public final BackedNotebookVirtualFile getOrLoadForDisposable(@NotNull VirtualFile file, @NotNull Disposable disposable) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
            BackedNotebookVirtualFile notebookVirtualFile = this.create(file);
            JupyterNotebook cachedNotebook = notebookVirtualFile.getNotebookOrNull();
            if (cachedNotebook == null) {
                JupyterNotebookBase jupyterNotebookBase = JupyterFileUtils.INSTANCE.readNotebookOrNull(file);
                if (jupyterNotebookBase == null) {
                    return null;
                }
                JupyterNotebookBase readNotebookOrNull = jupyterNotebookBase;
                notebookVirtualFile.setNotebookOrNull(readNotebookOrNull);
            }
            JupyterFileModelCache.Companion.registryForDisposable(notebookVirtualFile, disposable);
            return notebookVirtualFile;
        }

        @Deprecated(message="Use takeBackend instead")
        @ApiStatus.ScheduledForRemoval
        @NotNull
        public final BackedNotebookVirtualFile create(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return SingleFileBackedNotebookVirtualFile.box-impl(SingleFileBackedNotebookVirtualFile.constructor-impl(file));
        }

        @JvmStatic
        @NotNull
        public final BackedNotebookVirtualFile takeBackend(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return SingleFileBackedNotebookVirtualFile.box-impl(SingleFileBackedNotebookVirtualFile.constructor-impl(file));
        }

        @JvmStatic
        @Nullable
        public final BackedNotebookVirtualFile takeIfBacked(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.isBacked(file) ? this.takeBackend(file) : null;
        }

        @JvmStatic
        @Deprecated(message="Use takeIfBacked instead")
        @ApiStatus.ScheduledForRemoval
        @Nullable
        public final BackedNotebookVirtualFile find(@NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return this.takeIfBacked(file);
        }

        @JvmStatic
        public final boolean isBacked(@Nullable VirtualFile file) {
            return SingleFileBackedNotebookVirtualFile.Companion.isBacked(file);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

