/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.data.input;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.data.input.InputCellFileAction;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputFileName;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputUtil;
import com.intellij.jupyter.core.jupyter.data.input.JupyterDataInputValuesContributorExtensionPoint;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 (2\u00020\u00012\u00020\u0002:\u0001(B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u001a\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\n2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\u00020%8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006)"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction;", "Lcom/intellij/openapi/actionSystem/ex/CustomComponentAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "editor", "Lcom/intellij/openapi/editor/Editor;", "fileName", "Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;", "<init>", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputFileName;)V", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "createCustomComponent", "Ljavax/swing/JComponent;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "place", "", "createLabel", "Ljavax/swing/JLabel;", "text", "font", "Ljava/awt/Font;", "createPopup", "Lcom/intellij/openapi/ui/popup/JBPopup;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "project", "Lcom/intellij/openapi/project/Project;", "createAttachNewFileAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "attachNewFile", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "tableDataFileChooserDescriptor", "Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "getTableDataFileChooserDescriptor", "()Lcom/intellij/openapi/fileChooser/FileChooserDescriptor;", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterDataInputSelectPopupAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,207:1\n1368#2:208\n1454#2,5:209\n*S KotlinDebug\n*F\n+ 1 JupyterDataInputSelectPopupAction.kt\ncom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction\n*L\n108#1:208\n108#1:209,5\n*E\n"})
public final class JupyterDataInputSelectPopupAction
extends DumbAwareAction
implements CustomComponentAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Editor editor;
    @NotNull
    private final JupyterDataInputFileName fileName;
    @NotNull
    private static final List<String> SUPPORTED_EXTENSIONS;
    @NotNull
    private static final Key<Boolean> IS_FILE_SET;

    public JupyterDataInputSelectPopupAction(@NotNull Editor editor, @NotNull JupyterDataInputFileName fileName) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.editor = editor;
        this.fileName = fileName;
        Presentation it = presentation = this.getTemplatePresentation();
        boolean bl = false;
        it.putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
        it.putClientProperty(ActionUtil.USE_SMALL_FONT_IN_TOOLBAR, (Object)true);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        String name = this.fileName.get();
        if (name != null) {
            e.getPresentation().setText(JupyterDataInputUtil.INSTANCE.escapeActionUnderscore(name));
            e.getPresentation().putClientProperty(IS_FILE_SET, (Object)true);
        } else {
            e.getPresentation().setText(JupyterBundle.message("jupyter.data.input.toolbar.dnd.text.no.file", new Object[0]));
            e.getPresentation().putClientProperty(IS_FILE_SET, (Object)false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        JComponent component2 = jComponent;
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        JBPopup popup = this.createPopup(dataContext, project2);
        if (popup == null) {
            this.attachNewFile(project2);
        } else {
            popup.showUnderneathOf((Component)component2);
        }
    }

    @NotNull
    public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        Dimension dimension = ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE;
        ActionButtonWithText button2 = new ActionButtonWithText(this, presentation, place, dimension){

            public Insets getInsets() {
                JBInsets jBInsets = JBInsets.emptyInsets();
                Intrinsics.checkNotNullExpressionValue((Object)jBInsets, (String)"emptyInsets(...)");
                return (Insets)jBInsets;
            }

            protected boolean shallPaintDownArrow() {
                return true;
            }
        };
        button2.setHorizontalTextAlignment(2);
        button2.setFont((Font)JBFont.small());
        String string = JupyterBundle.message("jupyter.data.input.toolbar.file", new Object[0]);
        Font font = button2.getFont();
        Intrinsics.checkNotNullExpressionValue((Object)font, (String)"getFont(...)");
        JLabel textLabel = this.createLabel(string, font);
        textLabel.setVisible(this.fileName.get() != null);
        presentation.addPropertyChangeListener(arg_0 -> JupyterDataInputSelectPopupAction.createCustomComponent$lambda$1(textLabel, this, arg_0));
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(textLabel);
        panel.add((Component)button2);
        return panel;
    }

    private final JLabel createLabel(@Nls String text, Font font) {
        JLabel label = new JLabel(text);
        label.setFont(font);
        label.setForeground(UIUtil.getLabelInfoForeground());
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)2));
        return label;
    }

    /*
     * WARNING - void declaration
     */
    private final JBPopup createPopup(DataContext dataContext, Project project) {
        void $this$flatMapTo$iv$iv;
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        Iterable $this$flatMap$iv = JupyterDataInputValuesContributorExtensionPoint.Companion.getEP_NAME$intellij_jupyter_core().getExtensionList();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            JupyterDataInputValuesContributorExtensionPoint it = (JupyterDataInputValuesContributorExtensionPoint)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getFiles(project);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List files = (List)destination$iv$iv;
        if (files.isEmpty()) {
            return null;
        }
        actionGroup.add((AnAction)Separator.create((String)JupyterBundle.message("jupyter.data.input.toolbar.text.files", new Object[0])));
        for (VirtualFile file : files) {
            actionGroup.add((AnAction)new InputCellFileAction(file, this.editor, this.fileName));
        }
        actionGroup.add((AnAction)Separator.getInstance());
        actionGroup.add(this.createAttachNewFileAction());
        Condition preselectCondition = arg_0 -> JupyterDataInputSelectPopupAction.createPopup$lambda$3(this, arg_0);
        ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)actionGroup, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, -1, preselectCondition, null);
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createActionGroupPopup(...)");
        ListPopup popup = listPopup;
        return (JBPopup)popup;
    }

    private final AnAction createAttachNewFileAction() {
        String attachNewFileText = JupyterBundle.message("jupyter.data.input.toolbar.attach.new.file", new Object[0]);
        Icon icon = AllIcons.Actions.Upload;
        return (AnAction)new DumbAwareAction(attachNewFileText, this, icon){
            final /* synthetic */ JupyterDataInputSelectPopupAction this$0;
            {
                this.this$0 = $receiver;
                super($attachNewFileText, null, $super_call_param$1);
            }

            public void actionPerformed(AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Project project = e.getProject();
                if (project == null) {
                    return;
                }
                Project project2 = project;
                JupyterDataInputSelectPopupAction.access$attachNewFile(this.this$0, project2);
            }
        };
    }

    private final void attachNewFile(Project project) {
        FileChooser.chooseFiles((FileChooserDescriptor)this.getTableDataFileChooserDescriptor(), (Project)project, null, arg_0 -> JupyterDataInputSelectPopupAction.attachNewFile$lambda$5(arg_0 -> JupyterDataInputSelectPopupAction.attachNewFile$lambda$4(this, arg_0), arg_0));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    private final FileChooserDescriptor getTableDataFileChooserDescriptor() {
        return new FileChooserDescriptor(){

            public boolean isFileSelectable(VirtualFile file) {
                String string;
                if (file == null) {
                    return false;
                }
                try {
                    file.toNioPath();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    return false;
                }
                Iterable iterable = JupyterDataInputSelectPopupAction.access$getSUPPORTED_EXTENSIONS$cp();
                String string2 = file.getExtension();
                if (string2 != null) {
                    String string3 = string2.toLowerCase(Locale.ROOT);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                } else {
                    string = null;
                }
                return CollectionsKt.contains((Iterable)iterable, (Object)string);
            }
        };
    }

    private static final void createCustomComponent$lambda$1(JLabel $textLabel, JupyterDataInputSelectPopupAction this$0, PropertyChangeEvent event) {
        if (Intrinsics.areEqual((Object)event.getPropertyName(), (Object)IS_FILE_SET.toString())) {
            $textLabel.setVisible(this$0.fileName.get() != null);
        }
    }

    private static final boolean createPopup$lambda$3(JupyterDataInputSelectPopupAction this$0, AnAction it) {
        return it instanceof InputCellFileAction && Intrinsics.areEqual((Object)((Object)((InputCellFileAction)it).getRelativePath()).toString(), (Object)this$0.fileName.get());
    }

    private static final Unit attachNewFile$lambda$4(JupyterDataInputSelectPopupAction this$0, List files) {
        if (files.size() != 1) {
            return Unit.INSTANCE;
        }
        Path path = ((VirtualFile)files.get(0)).toNioPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toNioPath(...)");
        Path file = path;
        Path relativePath = this$0.editor.getVirtualFile().getParent().toNioPath().toAbsolutePath().relativize(file.toAbsolutePath());
        this$0.fileName.set(((Object)relativePath).toString());
        return Unit.INSTANCE;
    }

    private static final void attachNewFile$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$attachNewFile(JupyterDataInputSelectPopupAction $this, Project project) {
        $this.attachNewFile(project);
    }

    public static final /* synthetic */ List access$getSUPPORTED_EXTENSIONS$cp() {
        return SUPPORTED_EXTENSIONS;
    }

    static {
        Object[] objectArray = new String[]{"csv", "tsv", "xls", "xlsx", "xlsm"};
        SUPPORTED_EXTENSIONS = CollectionsKt.listOf((Object[])objectArray);
        Key key = Key.create((String)"IS_FILE_SET");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        IS_FILE_SET = key;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/jupyter/core/jupyter/data/input/JupyterDataInputSelectPopupAction$Companion;", "", "<init>", "()V", "SUPPORTED_EXTENSIONS", "", "", "IS_FILE_SET", "Lcom/intellij/openapi/util/Key;", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

