/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster;

import com.intellij.codeInsight.codeVision.ui.popup.layouter.RectangleUtilsKt;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookGraphicsConfigurationManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.NotebookOffScreenManager;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffScreenComponentController;
import com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.offscreen.raster.JcefOffscreenViewPort;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 92\u00020\u0001:\u00019B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020\u0003H\u0002J9\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00150%2\u0006\u0010&\u001a\u00020'2\u000e\u0010(\u001a\n\u0012\u0006\b\u0001\u0012\u00020*0)2\u0006\u0010+\u001a\u00020\u00032\u0006\u0010,\u001a\u00020\u0003\u00a2\u0006\u0002\u0010-J\u0006\u0010.\u001a\u00020!J\u001e\u0010/\u001a\u00020\u00152\u0006\u00100\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u00101\u001a\u000202J\u000e\u00103\u001a\u00020!2\u0006\u00104\u001a\u00020\u0015J\u000e\u00105\u001a\u00020!2\u0006\u00106\u001a\u00020\u0003J\u0006\u00107\u001a\u00020!J\b\u00108\u001a\u00020!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\u0004\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR$\u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006:"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster;", "Lcom/intellij/openapi/Disposable;", "width", "", "height", "offscreenManager", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffScreenManager;", "<init>", "(IILcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/NotebookOffScreenManager;)V", "value", "getWidth", "()I", "getHeight", "Ljava/awt/Color;", "backgroundColor", "getBackgroundColor", "()Ljava/awt/Color;", "setBackgroundColor", "(Ljava/awt/Color;)V", "viewPorts", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffscreenViewPort;", "cefScrollY", "getCefScrollY", "setCefScrollY", "(I)V", "scheduledImageUpdateFuture", "Ljava/util/concurrent/ScheduledFuture;", "imageUpdateRequestDelay", "", "skipViewportHashCheck", "", "requestImageUpdate", "", "cancelImageUpdate", "getViewportsHash", "updateImageFromCef", "", "buffer", "Ljava/nio/ByteBuffer;", "dirtyRects", "", "Ljava/awt/Rectangle;", "bufferWidth", "bufferHeight", "(Ljava/nio/ByteBuffer;[Ljava/awt/Rectangle;II)Ljava/util/Set;", "updateViewports", "addViewPort", "top", "viewPortController", "Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenComponentController;", "removeViewPort", "viewPort", "changeRasterWidth", "newWidth", "updateTotalHeightIfNeeded", "dispose", "Companion", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJcefOffScreenRaster.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JcefOffScreenRaster.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,231:1\n1863#2,2:232\n774#2:234\n865#2,2:235\n1053#2:237\n1863#2,2:238\n295#2,2:240\n1863#2,2:243\n1863#2,2:246\n25#3:242\n1#4:245\n*S KotlinDebug\n*F\n+ 1 JcefOffScreenRaster.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster\n*L\n47#1:232,2\n84#1:234\n84#1:235,2\n84#1:237\n85#1:238,2\n103#1:240,2\n193#1:243,2\n214#1:246,2\n136#1:242\n*E\n"})
public final class JcefOffScreenRaster
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NotebookOffScreenManager offscreenManager;
    private int width;
    private int height;
    @NotNull
    private Color backgroundColor;
    @NotNull
    private final ConcurrentLinkedQueue<JcefOffscreenViewPort> viewPorts;
    private int cefScrollY;
    @Nullable
    private ScheduledFuture<?> scheduledImageUpdateFuture;
    private long imageUpdateRequestDelay;
    private boolean skipViewportHashCheck;
    private static boolean loggedFailUpdateImage;

    public JcefOffScreenRaster(int width, int height, @NotNull NotebookOffScreenManager offscreenManager) {
        Intrinsics.checkNotNullParameter((Object)offscreenManager, (String)"offscreenManager");
        this.offscreenManager = offscreenManager;
        this.width = width;
        this.height = height;
        JBColor jBColor = JBColor.BLACK;
        Intrinsics.checkNotNullExpressionValue((Object)jBColor, (String)"BLACK");
        this.backgroundColor = (Color)jBColor;
        this.viewPorts = new ConcurrentLinkedQueue();
        this.imageUpdateRequestDelay = 200L;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    @NotNull
    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final void setBackgroundColor(@NotNull Color value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.backgroundColor = value;
        Iterable $this$forEach$iv = this.viewPorts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl = false;
            it.setBackgroundColor(value);
        }
    }

    public final int getCefScrollY() {
        return this.cefScrollY;
    }

    public final void setCefScrollY(int n) {
        this.cefScrollY = n;
    }

    private final void requestImageUpdate() {
        if (this.scheduledImageUpdateFuture != null) {
            return;
        }
        this.scheduledImageUpdateFuture = AppExecutorUtil.getAppScheduledExecutorService().schedule(() -> JcefOffScreenRaster.requestImageUpdate$lambda$1(this), this.imageUpdateRequestDelay, TimeUnit.MILLISECONDS);
    }

    private final void cancelImageUpdate() {
        block0: {
            ScheduledFuture<?> scheduledFuture = this.scheduledImageUpdateFuture;
            if (scheduledFuture == null) break block0;
            ScheduledFuture<?> it = scheduledFuture;
            boolean bl = false;
            it.cancel(false);
            this.scheduledImageUpdateFuture = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int getViewportsHash() {
        void $this$filterTo$iv$iv;
        int viewportHash = 0;
        Iterable $this$filter$iv = this.viewPorts;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv$iv;
            boolean bl = false;
            if (!(it.getBounds().height != 0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        List viewPortsCopy = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                JcefOffscreenViewPort it = (JcefOffscreenViewPort)a;
                boolean bl = false;
                it = (JcefOffscreenViewPort)b;
                Comparable comparable = Integer.valueOf(it.getBounds().y);
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(it.getBounds().y));
            }
        });
        Iterable $this$forEach$iv = viewPortsCopy;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl = false;
            viewportHash = 31 * viewportHash + it.getBounds().y;
            viewportHash = 31 * viewportHash + it.getBounds().height;
        }
        return viewportHash & 0xFFFFFF;
    }

    @NotNull
    public final Set<JcefOffscreenViewPort> updateImageFromCef(@NotNull ByteBuffer buffer, @NotNull Rectangle[] dirtyRects, int bufferWidth, int bufferHeight) {
        Rectangle[] rectangleArray;
        block16: {
            block15: {
                Object v0;
                block14: {
                    Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
                    Intrinsics.checkNotNullParameter((Object)dirtyRects, (String)"dirtyRects");
                    if (bufferWidth < 2 || bufferHeight < 1) break block15;
                    Iterable $this$firstOrNull$iv = this.viewPorts;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
                        boolean bl = false;
                        if (!(!it.getBounds().isEmpty())) continue;
                        v0 = element$iv;
                        break block14;
                    }
                    v0 = null;
                }
                if (v0 != null) break block16;
            }
            return SetsKt.emptySet();
        }
        ArrayList allPorts = new ArrayList(this.viewPorts);
        LinkedHashSet affectedPorts = new LinkedHashSet(this.viewPorts.size());
        IntBuffer source = buffer.order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        int cefRealScrollY = source.get(source.limit() - 1) & 0xFFFFFF;
        if (this.cefScrollY == cefRealScrollY) {
            rectangleArray = dirtyRects;
        } else {
            Rectangle[] bl = new Rectangle[]{new Rectangle(0, 0, bufferWidth, bufferHeight)};
            rectangleArray = bl;
        }
        Rectangle[] correctedDirtyRects = rectangleArray;
        this.cefScrollY = cefRealScrollY;
        NotebookGraphicsConfigurationManager graphicsConfigurationManager = this.offscreenManager.getGraphicsConfigurationManager();
        int realViewportHash = source.get(0) & 0xFFFFFF;
        int viewportHash = this.getViewportsHash();
        if (!this.skipViewportHashCheck && viewportHash != realViewportHash) {
            this.imageUpdateRequestDelay += (long)100;
            if (this.imageUpdateRequestDelay > 5000L) {
                this.imageUpdateRequestDelay = 5000L;
                if (!loggedFailUpdateImage) {
                    loggedFailUpdateImage = true;
                    this.skipViewportHashCheck = true;
                    JupyterFeaturesCollector.Companion.onCefOutputUpdateError(graphicsConfigurationManager.getHiDpi(), graphicsConfigurationManager.getScreenScale());
                    JcefOffScreenRaster $this$thisLogger$iv = this;
                    boolean $i$f$thisLogger = false;
                    Logger logger = Logger.getInstance(JcefOffScreenRaster.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("JupyterCEF failed to get updated image, hashes does not match. Swing: " + viewportHash + " cef: " + realViewportHash + " size: " + graphicsConfigurationManager.getScreenSize() + "hidpi: " + graphicsConfigurationManager.getHiDpi() + " scale: " + graphicsConfigurationManager.getScreenScale());
                }
            }
            this.requestImageUpdate();
            return SetsKt.emptySet();
        }
        this.imageUpdateRequestDelay = 200L;
        this.cancelImageUpdate();
        for (Rectangle originalRect : correctedDirtyRects) {
            Iterator iterator;
            Intrinsics.checkNotNullExpressionValue(allPorts.iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                DataBufferInt dest;
                BufferedImage destBuffer;
                Rectangle targetBounds;
                Rectangle targetRect;
                Rectangle rect;
                JcefOffscreenViewPort targetPort = (JcefOffscreenViewPort)iterator.next();
                if (!targetPort.getShown() || (rect = originalRect.intersection(targetRect = graphicsConfigurationManager.scaleUpRect(targetBounds = new Rectangle(targetPort.getBounds().x, targetPort.getBounds().y - this.cefScrollY, targetPort.getBounds().width, targetPort.getBounds().height - 1)))).isEmpty()) continue;
                ((Collection)affectedPorts).add(targetPort);
                if (targetPort.getOrCreateBuffer() == null) continue;
                WritableRaster writableRaster = destBuffer.getRaster();
                DataBuffer dataBuffer = writableRaster != null ? writableRaster.getDataBuffer() : null;
                if ((dataBuffer instanceof DataBufferInt ? (DataBufferInt)dataBuffer : null) == null) continue;
                dest = dest;
                int n = rect.y;
                int n2 = rect.y + rect.height;
                int n3 = 0;
                while (n < n2) {
                    int index = n3++;
                    int y = n++;
                    int sourceOffset = y * bufferWidth + rect.x;
                    int targetOffset = (index + rect.y - targetRect.y) * targetRect.width + rect.x;
                    source.position(sourceOffset).get(dest.getData(), targetOffset, rect.width);
                }
                if (!rect.contains(0, 0)) continue;
                int pixelSize = graphicsConfigurationManager.getHiDpi() ? MathKt.roundToInt((float)graphicsConfigurationManager.getScreenScale()) : 1;
                int pixelOffset = -targetRect.y;
                if (pixelSize >= destBuffer.getWidth() || pixelOffset + pixelSize >= destBuffer.getHeight()) continue;
                for (int i = 0; i < pixelSize; ++i) {
                    int n4 = pixelOffset + pixelSize;
                    for (int j = pixelOffset; j < n4; ++j) {
                        destBuffer.setRGB(i, j, this.backgroundColor.getRGB());
                    }
                }
            }
        }
        return affectedPorts;
    }

    public final void updateViewports() {
        Iterable $this$forEach$iv = this.viewPorts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl = false;
            it.recreateBufferIfNeeded();
        }
    }

    @NotNull
    public final JcefOffscreenViewPort addViewPort(int top, int height, @NotNull JcefOffScreenComponentController viewPortController) {
        Intrinsics.checkNotNullParameter((Object)viewPortController, (String)"viewPortController");
        JcefOffscreenViewPort result = new JcefOffscreenViewPort(new Rectangle(0, top, this.width, height), viewPortController, this.offscreenManager.getGraphicsConfigurationManager());
        result.setBackgroundColor(this.backgroundColor);
        this.viewPorts.add(result);
        this.updateTotalHeightIfNeeded();
        return result;
    }

    public final void removeViewPort(@NotNull JcefOffscreenViewPort viewPort) {
        Intrinsics.checkNotNullParameter((Object)viewPort, (String)"viewPort");
        boolean bl = this.viewPorts.remove(viewPort);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "View port " + viewPort + " doesn't exist";
            throw new AssertionError((Object)string);
        }
        this.updateTotalHeightIfNeeded();
    }

    public final void changeRasterWidth(int newWidth) {
        boolean bl;
        if (newWidth == this.width) {
            return;
        }
        boolean bl2 = bl = newWidth > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-JcefOffScreenRaster$changeRasterWidth$22 = false;
            String $i$a$-assert-JcefOffScreenRaster$changeRasterWidth$22 = newWidth + " <= 0";
            throw new AssertionError((Object)$i$a$-assert-JcefOffScreenRaster$changeRasterWidth$22);
        }
        Iterable $this$forEach$iv = this.viewPorts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)element$iv;
            boolean bl3 = false;
            it.setBounds(new Rectangle(it.getBounds().x, it.getBounds().y, newWidth, it.getBounds().height));
        }
        this.width = newWidth;
    }

    public final void updateTotalHeightIfNeeded() {
        Comparable comparable;
        Iterator iterator = ((Iterable)this.viewPorts).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            JcefOffscreenViewPort it = (JcefOffscreenViewPort)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Integer.valueOf(RectangleUtilsKt.getBottom((Rectangle)it.getBounds()));
            while (iterator.hasNext()) {
                JcefOffscreenViewPort it2 = (JcefOffscreenViewPort)iterator.next();
                $i$a$-maxOfOrNull-JcefOffScreenRaster$updateTotalHeightIfNeeded$requiredHeight$1 = false;
                Comparable comparable3 = Integer.valueOf(RectangleUtilsKt.getBottom((Rectangle)it2.getBounds()));
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Integer n = (Integer)comparable;
        if (n == null) {
            return;
        }
        int requiredHeight = n;
        if (this.height == requiredHeight) {
            return;
        }
        this.height = requiredHeight;
    }

    public void dispose() {
    }

    private static final void requestImageUpdate$lambda$1(JcefOffScreenRaster this$0) {
        this$0.offscreenManager.updateVisibleViewportsOnScroll();
        this$0.scheduledImageUpdateFuture = null;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/offscreen/raster/JcefOffScreenRaster$Companion;", "", "<init>", "()V", "loggedFailUpdateImage", "", "intellij.jupyter.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

