/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodeJs;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.debugger.wip.EventLoopGroupProviderKt;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 \u001a2\u00020\u0001:\u0004\u0017\u0018\u0019\u001aB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\fJ\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0006\u0010\u0016\u001a\u00020\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u000fR\u00020\u00000\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway;", "", "<init>", "()V", "gatewayServerChannel", "Lio/netty/channel/Channel;", "serverPort", "", "getServerPort", "()I", "listeners", "", "Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$DebugSessionAddressListener;", "proxyByChannelMap", "", "Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$SingleClientProxy;", "addListener", "", "listener", "fireNewDebugSessionAddress", "debugSessionAddress", "Ljava/net/InetSocketAddress;", "shutdown", "RemoteDebugHandler", "SingleClientProxy", "DebugSessionAddressListener", "Companion", "intellij.javascript.chrome.connector"})
@SourceDebugExtension(value={"SMAP\nNodeDebugConnectionGateway.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeDebugConnectionGateway.kt\ncom/jetbrains/nodeJs/NodeDebugConnectionGateway\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,200:1\n15#2:201\n*S KotlinDebug\n*F\n+ 1 NodeDebugConnectionGateway.kt\ncom/jetbrains/nodeJs/NodeDebugConnectionGateway\n*L\n185#1:201\n*E\n"})
public final class NodeDebugConnectionGateway {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Channel gatewayServerChannel;
    private final int serverPort;
    @NotNull
    private final List<DebugSessionAddressListener> listeners = new CopyOnWriteArrayList();
    @NotNull
    private final Map<Channel, SingleClientProxy> proxyByChannelMap = new ConcurrentHashMap();
    @NotNull
    private static final EventLoopGroup eventLoopGroup = EventLoopGroupProviderKt.createEventLoopGroup("NodeDebugConnectionGateway");
    @NotNull
    private static final Logger LOG;

    public NodeDebugConnectionGateway() {
        ServerBootstrap b2 = ((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
            final /* synthetic */ NodeDebugConnectionGateway this$0;
            {
                this.this$0 = $receiver;
            }

            protected void initChannel(SocketChannel ch) {
                Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                ChannelHandler[] channelHandlerArray = new ChannelHandler[]{this.this$0.new RemoteDebugHandler()};
                ch.pipeline().addLast(channelHandlerArray);
            }
        }).childOption(ChannelOption.AUTO_READ, (Object)false);
        this.gatewayServerChannel = b2.bind(0).sync().channel();
        SocketAddress socketAddress = this.gatewayServerChannel.localAddress();
        Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
        this.serverPort = ((InetSocketAddress)socketAddress).getPort();
        LOG.info("Gateway server is listening on " + this.gatewayServerChannel.localAddress());
    }

    public final int getServerPort() {
        return this.serverPort;
    }

    public final void addListener(@NotNull DebugSessionAddressListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    private final void fireNewDebugSessionAddress(InetSocketAddress debugSessionAddress) {
        for (DebugSessionAddressListener listener2 : this.listeners) {
            listener2.newDebugSessionAddress(debugSessionAddress);
        }
    }

    public final void shutdown() {
        this.gatewayServerChannel.close();
        for (SingleClientProxy proxy : this.proxyByChannelMap.values()) {
            proxy.shutdown();
        }
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(NodeDebugConnectionGateway.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$Companion;", "", "<init>", "()V", "eventLoopGroup", "Lio/netty/channel/EventLoopGroup;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "flushAndClose", "Lio/netty/channel/ChannelFuture;", "channel", "Lio/netty/channel/Channel;", "intellij.javascript.chrome.connector"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ChannelFuture flushAndClose(@NotNull Channel channel) {
            Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
            if (channel.isActive()) {
                ChannelFuture channelFuture = channel.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"addListener(...)");
                return channelFuture;
            }
            ChannelFuture channelFuture = channel.close();
            Intrinsics.checkNotNullExpressionValue((Object)channelFuture, (String)"close(...)");
            return channelFuture;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$DebugSessionAddressListener;", "", "newDebugSessionAddress", "", "debugSessionAddress", "Ljava/net/InetSocketAddress;", "intellij.javascript.chrome.connector"})
    public static interface DebugSessionAddressListener {
        public void newDebugSessionAddress(@NotNull InetSocketAddress var1);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$RemoteDebugHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "<init>", "(Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway;)V", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead", "msg", "", "exceptionCaught", "cause", "", "channelInactive", "intellij.javascript.chrome.connector"})
    private final class RemoteDebugHandler
    extends ChannelInboundHandlerAdapter {
        public void channelActive(@NotNull ChannelHandlerContext ctx) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Map map = NodeDebugConnectionGateway.this.proxyByChannelMap;
            Channel channel = ctx.channel();
            Channel channel2 = ctx.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel2, (String)"channel(...)");
            SingleClientProxy singleClientProxy = new SingleClientProxy(channel2);
            map.put(channel, singleClientProxy);
        }

        public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            SingleClientProxy proxy = (SingleClientProxy)NodeDebugConnectionGateway.this.proxyByChannelMap.get(ctx.channel());
            if (proxy == null) {
                LOG.error("Proxy not found, closing");
                NodeDebugConnectionGateway.this.shutdown();
                return;
            }
            Channel outboundChannel = proxy.getOutboundChannel();
            if (outboundChannel == null) {
                LOG.error("Outbound channel not initialized, closing");
                NodeDebugConnectionGateway.this.shutdown();
                return;
            }
            if (outboundChannel.isActive()) {
                outboundChannel.writeAndFlush(msg).addListener(arg_0 -> RemoteDebugHandler.channelRead$lambda$0(ctx, outboundChannel, arg_0));
            } else {
                LOG.info("Outbound channel is not active");
            }
        }

        public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
            Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
            Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
            LOG.error("Exception when reading/writing remote debug session channel", cause);
            Channel channel = ctx.channel();
            Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
            Companion.flushAndClose(channel);
        }

        public void channelInactive(@NotNull ChannelHandlerContext ctx) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                SingleClientProxy singleClientProxy = (SingleClientProxy)NodeDebugConnectionGateway.this.proxyByChannelMap.remove(ctx.channel());
                if (singleClientProxy == null) break block0;
                singleClientProxy.inboundChannelInactive();
            }
        }

        private static final void channelRead$lambda$0(ChannelHandlerContext $ctx, Channel $outboundChannel, Future it) {
            Object object = it.isSuccess() ? $ctx.channel().read() : $outboundChannel.close();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\f\u001a\u00020\rJ\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$SingleClientProxy;", "", "inboundChannel", "Lio/netty/channel/Channel;", "<init>", "(Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway;Lio/netty/channel/Channel;)V", "proxyServerChannel", "outboundChannel", "getOutboundChannel", "()Lio/netty/channel/Channel;", "setOutboundChannel", "(Lio/netty/channel/Channel;)V", "inboundChannelInactive", "", "shutdown", "SingleClientChannelHandler", "intellij.javascript.chrome.connector"})
    @SourceDebugExtension(value={"SMAP\nNodeDebugConnectionGateway.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NodeDebugConnectionGateway.kt\ncom/jetbrains/nodeJs/NodeDebugConnectionGateway$SingleClientProxy\n+ 2 netty.kt\ncom/intellij/util/io/NettyKt\n*L\n1#1,200:1\n66#2,2:201\n*S KotlinDebug\n*F\n+ 1 NodeDebugConnectionGateway.kt\ncom/jetbrains/nodeJs/NodeDebugConnectionGateway$SingleClientProxy\n*L\n134#1:201,2\n*E\n"})
    private final class SingleClientProxy {
        @NotNull
        private final Channel inboundChannel;
        @NotNull
        private final Channel proxyServerChannel;
        @Nullable
        private Channel outboundChannel;

        public SingleClientProxy(Channel inboundChannel) {
            Intrinsics.checkNotNullParameter((Object)inboundChannel, (String)"inboundChannel");
            this.inboundChannel = inboundChannel;
            ServerBootstrap bootstrap2 = ((ServerBootstrap)new ServerBootstrap().group(eventLoopGroup).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)false).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(this){
                final /* synthetic */ SingleClientProxy this$0;
                {
                    this.this$0 = $receiver;
                }

                public void initChannel(SocketChannel ch) throws Exception {
                    Intrinsics.checkNotNullParameter((Object)ch, (String)"ch");
                    ChannelHandler[] channelHandlerArray = new ChannelHandler[]{this.this$0.new SingleClientChannelHandler()};
                    ch.pipeline().addLast(channelHandlerArray);
                }
            });
            this.proxyServerChannel = bootstrap2.bind(InetAddress.getLoopbackAddress(), 0).sync().channel();
            SocketAddress socketAddress = this.proxyServerChannel.localAddress();
            Intrinsics.checkNotNull((Object)socketAddress, (String)"null cannot be cast to non-null type java.net.InetSocketAddress");
            InetSocketAddress localAddress = (InetSocketAddress)socketAddress;
            LOG.info("Single client proxy is listening on " + localAddress);
            NodeDebugConnectionGateway.this.fireNewDebugSessionAddress(localAddress);
        }

        @Nullable
        public final Channel getOutboundChannel() {
            return this.outboundChannel;
        }

        public final void setOutboundChannel(@Nullable Channel channel) {
            this.outboundChannel = channel;
        }

        public final void inboundChannelInactive() {
            block0: {
                Channel channel = this.outboundChannel;
                if (channel == null) break block0;
                Channel it = channel;
                boolean bl = false;
                ChannelFuture $this$addChannelListener$iv = Companion.flushAndClose(it);
                boolean $i$f$addChannelListener = false;
                $this$addChannelListener$iv.addListener(new GenericFutureListener(this){
                    final /* synthetic */ SingleClientProxy this$0;
                    {
                        this.this$0 = singleClientProxy;
                    }

                    public final void operationComplete(ChannelFuture it) {
                        Intrinsics.checkNotNull((Object)it);
                        ChannelFuture it2 = it;
                        boolean bl = false;
                        this.this$0.shutdown();
                    }
                });
            }
        }

        public final void shutdown() {
            this.proxyServerChannel.close();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\u0012\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016J\u0018\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$SingleClientProxy$SingleClientChannelHandler;", "Lio/netty/channel/ChannelInboundHandlerAdapter;", "<init>", "(Lcom/jetbrains/nodeJs/NodeDebugConnectionGateway$SingleClientProxy;)V", "channelActive", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "channelRead", "msg", "", "channelInactive", "exceptionCaught", "cause", "", "intellij.javascript.chrome.connector"})
        private final class SingleClientChannelHandler
        extends ChannelInboundHandlerAdapter {
            public void channelActive(@NotNull ChannelHandlerContext ctx) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                if (SingleClientProxy.this.getOutboundChannel() != null) {
                    LOG.error("Too many channels, skipping all except the first one");
                    ctx.channel().close();
                    return;
                }
                SingleClientProxy.this.setOutboundChannel(ctx.channel());
                SingleClientProxy.this.inboundChannel.read();
                ctx.channel().read();
            }

            public void channelRead(@NotNull ChannelHandlerContext ctx, @NotNull Object msg) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                SingleClientProxy.this.inboundChannel.writeAndFlush(msg).addListener(arg_0 -> SingleClientChannelHandler.channelRead$lambda$0(ctx, SingleClientProxy.this, arg_0));
            }

            public void channelInactive(@Nullable ChannelHandlerContext ctx) {
                Companion.flushAndClose(SingleClientProxy.this.inboundChannel);
            }

            public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                LOG.error("Exception when reading/writing IDE channel", cause);
                Channel channel = ctx.channel();
                Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel(...)");
                Companion.flushAndClose(channel);
            }

            private static final void channelRead$lambda$0(ChannelHandlerContext $ctx, SingleClientProxy this$0, Future it) {
                Object object = it.isSuccess() ? $ctx.channel().read() : this$0.inboundChannel.close();
            }
        }
    }
}

