/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.fileTypes.UnknownFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.terminal.TerminalShellCommandHandler;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\tH\u0016J2\u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00052\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001a\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J8\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0014\u0010\u0014\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0004\u0012\u00020\u00050\u0015H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/terminal/OpenFileShellCommandHandler;", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "<init>", "()V", "matches", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "", "localSession", "command", "execute", "executor", "Lcom/intellij/execution/Executor;", "checkRegisteredFileType", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "openFileEditor", "handleCommand", "block", "Lkotlin/Function1;", "intellij.terminal"})
@SourceDebugExtension(value={"SMAP\nOpenFileShellCommandHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenFileShellCommandHandler.kt\norg/jetbrains/plugins/terminal/OpenFileShellCommandHandler\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,44:1\n1#2:45\n*E\n"})
final class OpenFileShellCommandHandler
implements TerminalShellCommandHandler {
    public boolean matches(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        return this.handleCommand(command2, localSession, workingDirectory, (Function1<? super VirtualFile, Boolean>)((Function1)arg_0 -> OpenFileShellCommandHandler.matches$lambda$0(this, arg_0)));
    }

    public boolean execute(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command2, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)command2, (String)"command");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        return this.handleCommand(command2, localSession, workingDirectory, (Function1<? super VirtualFile, Boolean>)((Function1)arg_0 -> OpenFileShellCommandHandler.execute$lambda$1(this, project, arg_0)));
    }

    private final boolean checkRegisteredFileType(VirtualFile file) {
        return file != null && !Intrinsics.areEqual((Object)FileTypeRegistry.getInstance().getFileTypeByFile(file), (Object)UnknownFileType.INSTANCE);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean openFileEditor(Project project, VirtualFile file) {
        if (file == null) return false;
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).openFile(file, true);
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"openFile(...)");
        if (((Object[])fileEditorArray).length != 0) return true;
        return false;
    }

    private final boolean handleCommand(String command2, boolean localSession, String workingDirectory, Function1<? super VirtualFile, Boolean> block) {
        String prefix = "open ";
        if (!StringsKt.startsWith$default((String)command2, (String)prefix, (boolean)false, (int)2, null)) {
            return false;
        }
        String string = command2.substring(prefix.length());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        String path = string;
        if (!localSession) {
            return false;
        }
        path = ((Object)StringsKt.trim((CharSequence)path)).toString();
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(path));
        if (file != null && !file.isDirectory() && file.exists()) {
            return (Boolean)block.invoke((Object)file);
        }
        if (workingDirectory != null) {
            Object object;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByIoFile(new File(workingDirectory, path));
            if (virtualFile != null) {
                VirtualFile virtualFile2;
                VirtualFile it = virtualFile2 = virtualFile;
                boolean bl = false;
                object = it.exists() && !it.isDirectory() ? virtualFile2 : null;
            } else {
                object = null;
            }
            VirtualFile it = object;
            boolean bl = false;
            return (Boolean)block.invoke(it);
        }
        return false;
    }

    private static final boolean matches$lambda$0(OpenFileShellCommandHandler this$0, VirtualFile file) {
        return this$0.checkRegisteredFileType(file);
    }

    private static final boolean execute$lambda$1(OpenFileShellCommandHandler this$0, Project $project, VirtualFile file) {
        return this$0.openFileEditor($project, file);
    }
}

