/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.remote.jdbc.helpers;

import com.intellij.database.remote.jdbc.helpers.JdbcHelperImpl;
import com.intellij.database.remote.jdbc.helpers.JdbcNativeUtil;
import com.intellij.database.remote.jdbc.impl.UnparsedValueKind;
import com.intellij.openapi.util.text.StringUtilRt;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.util.Properties;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class GenericJdbcHelperBase
extends JdbcHelperImpl {
    public GenericJdbcHelperBase(@Nullable String dbmsName, @Nullable String version, @Nullable Connection connection) {
        super(dbmsName == null ? "UNKNOWN" : dbmsName, version, connection);
    }

    @Override
    @Nullable
    public String parseVersion(@Nullable String version) {
        return JdbcNativeUtil.findVersion(version, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
    }

    @Override
    @Nullable
    public GenericJdbcHelperBase detect(@Nullable Connection delegate, @Nullable String product, @Nullable String productVer, @Nullable JdbcHelperImpl connectHelper) throws Exception {
        DatabaseMetaData md = delegate == null ? null : delegate.getMetaData();
        String version = null;
        if (md != null) {
            try {
                version = md.getDatabaseMajorVersion() + "." + md.getDatabaseMinorVersion();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (version == null) {
            version = JdbcNativeUtil.findVersion(productVer, JdbcNativeUtil.DEFAULT_VERSION_PATTERN);
        }
        JdbcNativeUtil.logInfo("getDatabaseProductName: " + product + "\ngetDatabaseMajorVersion.getDatabaseMinorVersion: " + version);
        return this.create(delegate, product, version);
    }

    @NotNull
    protected abstract GenericJdbcHelperBase create(@Nullable Connection var1, @Nullable String var2, String var3);

    @Override
    protected void setDriverLogLevel(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        super.setDriverLogLevel(driver, properties, level, logPath);
        this.configureSimba(driver, properties, level, logPath);
    }

    protected void configureSimba(Driver driver, Properties properties, @Nullable Level level, @Nullable String logPath) {
        GenericJdbcHelperBase.configureSimbaLogging(properties, level, logPath);
    }

    @Override
    @Nullable
    public UnparsedValueKind detectUnparsedValueKind(@Nullable String typeName, int jdbcType) {
        if (typeName != null) {
            if (StringUtilRt.startsWithIgnoreCase((String)typeName, (String)"time with time zone")) {
                return UnparsedValueKind.ZONED_TIME;
            }
            if (StringUtilRt.startsWithIgnoreCase((String)typeName, (String)"timestamp with time zone")) {
                return UnparsedValueKind.ZONED_TIMESTAMP;
            }
        }
        return super.detectUnparsedValueKind(typeName, jdbcType);
    }
}

