/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.python.django.codeInsight.DjangoClassMembersProvider;
import com.intellij.python.django.codeInsight.RelationMethodInfo;
import com.intellij.python.django.lang.template.inspection.DjangoLocalInspectionTool;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class DjangoOrmInspection
extends DjangoLocalInspectionTool {
    private static final Key<Set<PyCallExpression>> ALREADY_CHECKED_KEY = Key.create((String)"DjangoOrmInspection.checkedFunctions");

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        PyFile file;
        if (holder == null) {
            DjangoOrmInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            DjangoOrmInspection.$$$reportNull$$$0(1);
        }
        if ((file = (PyFile)PyUtil.as((Object)holder.getFile(), PyFile.class)) == null) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DjangoOrmInspection.$$$reportNull$$$0(2);
            }
            return psiElementVisitor;
        }
        if (DjangoModelApi.notDjangoModule((PsiElement)file)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                DjangoOrmInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        return new DjangoOrmInspectionVisitor(holder, PyInspectionVisitor.getContext((LocalInspectionToolSession)session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/lang/DjangoOrmInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/lang/DjangoOrmInspection";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static final class DjangoOrmInspectionVisitor
    extends PyInspectionVisitor {
        @NotNull
        private final ProblemsHolder myHolder;
        private final Set<PsiElement> myAlreadyChecked;

        private DjangoOrmInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (holder == null) {
                DjangoOrmInspectionVisitor.$$$reportNull$$$0(0);
            }
            if (context == null) {
                DjangoOrmInspectionVisitor.$$$reportNull$$$0(1);
            }
            super(holder, context);
            this.myHolder = holder;
            this.myAlreadyChecked = new HashSet<PsiElement>();
        }

        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            if (node == null) {
                DjangoOrmInspectionVisitor.$$$reportNull$$$0(2);
            }
            if (this.isAlreadyChecked(node)) {
                return;
            }
            PyQualifiedExpression function = (PyQualifiedExpression)PyUtil.as((Object)node.getCallee(), PyQualifiedExpression.class);
            if (function == null) {
                return;
            }
            String functionName = function.getName();
            if (functionName == null) {
                return;
            }
            if (!DjangoClassMembersProvider.isMethodMayBeRelated(functionName)) {
                return;
            }
            PyExpression functionQualifier = function.getQualifier();
            if (functionQualifier == null) {
                return;
            }
            PyType classType = TypeEvalContext.deepCodeInsight((Project)functionQualifier.getProject()).getType((PyTypedElement)functionQualifier);
            if (classType == null) {
                return;
            }
            RelationMethodInfo methodInfo = DjangoClassMembersProvider.getRelatedMethodsInfo(classType);
            if (methodInfo == null) {
                return;
            }
            String error = null;
            if (methodInfo.getDisabledDueToM2MMethods().contains(functionName) && node.getKeywordArgument("through_defaults") == null) {
                error = DjangoBundle.message((String)"inspection.django-orm-inspection.disabled-m2m-interm", (Object[])new Object[]{functionName});
            }
            if (methodInfo.getNonExistenceDueToFKNotNullMethods().contains(functionName)) {
                error = DjangoBundle.message((String)"inspection.django-orm-inspection.non-existence-due-to-foreign-key-not-null-method", (Object[])new Object[]{functionName});
            }
            if (error != null) {
                this.myHolder.registerProblem((PsiElement)function, error, new LocalQuickFix[0]);
                return;
            }
            super.visitPyCallExpression(node);
        }

        private boolean isAlreadyChecked(@NotNull PyCallExpression node) {
            if (node == null) {
                DjangoOrmInspectionVisitor.$$$reportNull$$$0(3);
            }
            Set<PsiElement> data = this.myAlreadyChecked;
            assert (data != null) : "Data is null, set it first";
            boolean result = data.contains(node);
            if (!result) {
                data.add((PsiElement)node);
            }
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "holder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/python/django/lang/DjangoOrmInspection$DjangoOrmInspectionVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitPyCallExpression";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAlreadyChecked";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

