/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.branch;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.branch.DvcsBranchSyncPolicyUpdateNotifier;
import com.intellij.dvcs.branch.DvcsMultiRootBranchConfig;
import com.intellij.dvcs.branch.DvcsSyncSettings;
import com.intellij.dvcs.branch.TrackReposSynchronouslyAction;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.BranchActionGroupPopup;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.dvcs.ui.LightActionGroup;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class DvcsBranchPopup<Repo extends Repository> {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final AbstractRepositoryManager<Repo> myRepositoryManager;
    @NotNull
    protected final DvcsSyncSettings myVcsSettings;
    @NotNull
    protected final AbstractVcs myVcs;
    @NotNull
    protected final DvcsMultiRootBranchConfig<Repo> myMultiRootBranchConfig;
    @NotNull
    protected final Repo myCurrentRepository;
    @NotNull
    protected final BranchActionGroupPopup myPopup;
    protected final boolean myInSpecificRepository;

    protected DvcsBranchPopup(@NotNull Repo currentRepository, @NotNull AbstractRepositoryManager<Repo> repositoryManager, @NotNull DvcsMultiRootBranchConfig<Repo> multiRootBranchConfig, @NotNull DvcsSyncSettings vcsSettings, @NotNull Condition<AnAction> preselectActionCondition, @Nullable String dimensionKey, @NotNull DataContext dataContext) {
        if (currentRepository == null) {
            DvcsBranchPopup.$$$reportNull$$$0(0);
        }
        if (repositoryManager == null) {
            DvcsBranchPopup.$$$reportNull$$$0(1);
        }
        if (multiRootBranchConfig == null) {
            DvcsBranchPopup.$$$reportNull$$$0(2);
        }
        if (vcsSettings == null) {
            DvcsBranchPopup.$$$reportNull$$$0(3);
        }
        if (preselectActionCondition == null) {
            DvcsBranchPopup.$$$reportNull$$$0(4);
        }
        if (dataContext == null) {
            DvcsBranchPopup.$$$reportNull$$$0(5);
        }
        this.myProject = currentRepository.getProject();
        this.myCurrentRepository = currentRepository;
        this.myRepositoryManager = repositoryManager;
        this.myVcs = currentRepository.getVcs();
        this.myVcsSettings = vcsSettings;
        this.myMultiRootBranchConfig = multiRootBranchConfig;
        this.myInSpecificRepository = this.myRepositoryManager.moreThanOneRoot() && this.myVcsSettings.getSyncSetting() == DvcsSyncSettings.Value.DONT_SYNC;
        String title = this.buildTitle(currentRepository);
        this.myPopup = new BranchActionGroupPopup(title, this.myProject, preselectActionCondition, this.createActions(), dimensionKey, dataContext);
        new DvcsBranchSyncPolicyUpdateNotifier<Repo>(this.myProject, this.myVcs, this.myVcsSettings, this.myRepositoryManager).initBranchSyncPolicyIfNotInitialized();
        this.warnThatBranchesDivergedIfNeeded();
        if (this.myRepositoryManager.moreThanOneRoot()) {
            this.myPopup.addToolbarAction((AnAction)new DefaultTrackReposSynchronouslyAction(this.myVcsSettings), true);
        }
    }

    @Nullable
    @Nls
    private String buildTitle(@NotNull Repo currentRepository) {
        if (currentRepository == null) {
            DvcsBranchPopup.$$$reportNull$$$0(6);
        }
        if (ExperimentalUI.isNewUI()) {
            return null;
        }
        String vcsName = this.myVcs.getDisplayName();
        return this.myInSpecificRepository ? DvcsBundle.message("branch.popup.vcs.name.branches", vcsName) : DvcsBundle.message("branch.popup.vcs.name.branches.in.repo", vcsName, DvcsUtil.getShortRepositoryName(currentRepository));
    }

    @NotNull
    public ListPopup asListPopup() {
        BranchActionGroupPopup branchActionGroupPopup = this.myPopup;
        if (branchActionGroupPopup == null) {
            DvcsBranchPopup.$$$reportNull$$$0(7);
        }
        return branchActionGroupPopup;
    }

    @NotNull
    private ActionGroup createActions() {
        LightActionGroup popupGroup = new LightActionGroup(false);
        AbstractRepositoryManager<Repo> repositoryManager = this.myRepositoryManager;
        if (repositoryManager.moreThanOneRoot()) {
            if (this.userWantsSyncControl()) {
                this.fillWithCommonRepositoryActions(popupGroup, repositoryManager);
            } else {
                this.fillPopupWithCurrentRepositoryActions(popupGroup, this.createRepositoriesActions());
            }
        } else {
            this.fillPopupWithCurrentRepositoryActions(popupGroup, null);
        }
        popupGroup.addSeparator();
        LightActionGroup lightActionGroup = popupGroup;
        if (lightActionGroup == null) {
            DvcsBranchPopup.$$$reportNull$$$0(8);
        }
        return lightActionGroup;
    }

    protected boolean userWantsSyncControl() {
        return this.myVcsSettings.getSyncSetting() != DvcsSyncSettings.Value.DONT_SYNC;
    }

    protected abstract void fillWithCommonRepositoryActions(@NotNull LightActionGroup var1, @NotNull AbstractRepositoryManager<Repo> var2);

    @NotNull
    protected @Unmodifiable List<Repo> filterRepositoriesNotOnThisBranch(@NotNull String branch, @NotNull List<? extends Repo> allRepositories) {
        if (branch == null) {
            DvcsBranchPopup.$$$reportNull$$$0(9);
        }
        if (allRepositories == null) {
            DvcsBranchPopup.$$$reportNull$$$0(10);
        }
        List list = ContainerUtil.filter(allRepositories, repository -> !branch.equals(repository.getCurrentBranchName()));
        if (list == null) {
            DvcsBranchPopup.$$$reportNull$$$0(11);
        }
        return list;
    }

    private void warnThatBranchesDivergedIfNeeded() {
        if (this.isBranchesDiverged()) {
            this.myPopup.setWarning(DvcsBundle.message("branch.popup.warning.branches.have.diverged", new Object[0]));
        }
    }

    private boolean isBranchesDiverged() {
        return this.myRepositoryManager.moreThanOneRoot() && this.myMultiRootBranchConfig.diverged() && this.userWantsSyncControl();
    }

    @NotNull
    protected abstract LightActionGroup createRepositoriesActions();

    protected abstract void fillPopupWithCurrentRepositoryActions(@NotNull LightActionGroup var1, @Nullable LightActionGroup var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "multiRootBranchConfig";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcsSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preselectActionCondition";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchPopup";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allRepositories";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchPopup";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "asListPopup";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterRepositoriesNotOnThisBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "buildTitle";
                break;
            }
            case 7: 
            case 8: 
            case 11: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterRepositoriesNotOnThisBranch";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 11 -> new IllegalStateException(string);
        };
    }

    private static class DefaultTrackReposSynchronouslyAction
    extends TrackReposSynchronouslyAction {
        private final DvcsSyncSettings myVcsSettings;

        protected DefaultTrackReposSynchronouslyAction(@NotNull DvcsSyncSettings vcsSettings) {
            if (vcsSettings == null) {
                DefaultTrackReposSynchronouslyAction.$$$reportNull$$$0(0);
            }
            this.myVcsSettings = vcsSettings;
        }

        @Override
        @NotNull
        protected DvcsSyncSettings getSettings(@NotNull AnActionEvent e) {
            if (e == null) {
                DefaultTrackReposSynchronouslyAction.$$$reportNull$$$0(1);
            }
            DvcsSyncSettings dvcsSyncSettings = this.myVcsSettings;
            if (dvcsSyncSettings == null) {
                DefaultTrackReposSynchronouslyAction.$$$reportNull$$$0(2);
            }
            return dvcsSyncSettings;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsSettings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/branch/DvcsBranchPopup$DefaultTrackReposSynchronouslyAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/branch/DvcsBranchPopup$DefaultTrackReposSynchronouslyAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getSettings";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class MyMoreIndex {
        public static final int MAX_NUM = 8;
        public static final int DEFAULT_NUM = 5;
    }
}

