/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.attributes;

import com.intellij.rml.dfa.attributes.Attribute;
import java.io.DataInput;
import java.io.DataOutput;
import java.math.BigInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\n\u00a2\u0006\u0004\b\u0006\u0010\u000bB\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\fJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/rml/dfa/attributes/IntAttribute;", "Lcom/intellij/rml/dfa/attributes/Attribute;", "value", "Ljava/math/BigInteger;", "key", "", "<init>", "(Ljava/math/BigInteger;Ljava/lang/String;)V", "", "(I)V", "", "(J)V", "(Ljava/math/BigInteger;)V", "getValue", "()Ljava/math/BigInteger;", "save", "", "stream", "Ljava/io/DataOutput;", "Companion", "intellij.rml.dfa"})
public final class IntAttribute
extends Attribute {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BigInteger value;
    @NotNull
    private static final IntAttribute positiveInf;
    @NotNull
    private static final IntAttribute negativeInf;

    private IntAttribute(BigInteger value, String key) {
        super(key);
        this.value = value;
    }

    @NotNull
    public final BigInteger getValue() {
        return this.value;
    }

    public IntAttribute(int value) {
        BigInteger bigInteger = BigInteger.valueOf(value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger, String.valueOf(value));
    }

    public IntAttribute(long value) {
        BigInteger bigInteger = BigInteger.valueOf(value);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        this(bigInteger, String.valueOf(value));
    }

    public IntAttribute(@NotNull BigInteger value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string = value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        this(value, string);
    }

    @Override
    public void save(@NotNull DataOutput stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        stream.writeByte(2);
        byte[] byteArray = this.value.toByteArray();
        stream.writeInt(byteArray.length);
        stream.write(byteArray);
        stream.writeUTF(this.getKey());
    }

    public /* synthetic */ IntAttribute(BigInteger value, String key, DefaultConstructorMarker $constructor_marker) {
        this(value, key);
    }

    static {
        BigInteger bigInteger = BigInteger.valueOf(0L);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger, (String)"valueOf(...)");
        positiveInf = new IntAttribute(bigInteger, "+inf");
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(...)");
        negativeInf = new IntAttribute(bigInteger2, "-inf");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lcom/intellij/rml/dfa/attributes/IntAttribute$Companion;", "", "<init>", "()V", "positiveInf", "Lcom/intellij/rml/dfa/attributes/IntAttribute;", "getPositiveInf", "()Lcom/intellij/rml/dfa/attributes/IntAttribute;", "negativeInf", "getNegativeInf", "load", "Lcom/intellij/rml/dfa/attributes/Attribute;", "stream", "Ljava/io/DataInput;", "intellij.rml.dfa"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IntAttribute getPositiveInf() {
            return positiveInf;
        }

        @NotNull
        public final IntAttribute getNegativeInf() {
            return negativeInf;
        }

        @NotNull
        public final Attribute load(@NotNull DataInput stream) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            int length = stream.readInt();
            byte[] bytes = new byte[length];
            stream.readFully(bytes);
            BigInteger bigInteger = new BigInteger(bytes);
            String string = stream.readUTF();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readUTF(...)");
            return new IntAttribute(bigInteger, string, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

