/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.cellsDnD;

import com.intellij.notebooks.visualization.NotebookBelowLastCellPanel;
import com.intellij.notebooks.visualization.NotebookCellInlayManager;
import com.intellij.notebooks.visualization.NotebookVisualizationUiUtilKt;
import com.intellij.notebooks.visualization.ui.EditorCell;
import com.intellij.notebooks.visualization.ui.EditorCellInput;
import com.intellij.notebooks.visualization.ui.EditorCellOutputView;
import com.intellij.notebooks.visualization.ui.EditorCellOutputsView;
import com.intellij.notebooks.visualization.ui.EditorCellView;
import com.intellij.notebooks.visualization.ui.cellsDnD.CellDragCellPreviewWindow;
import com.intellij.notebooks.visualization.ui.cellsDnD.CellDropEvent;
import com.intellij.notebooks.visualization.ui.cellsDnD.CellDropNotifier;
import com.intellij.notebooks.visualization.ui.cellsDnD.CellDropTarget;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.RectangularShape;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\b2\u0006\u0010 \u001a\u00020!J\u000e\u0010#\u001a\u00020\b2\u0006\u0010 \u001a\u00020!J\u0010\u0010$\u001a\u00020\u00152\u0006\u0010%\u001a\u00020\u0013H\u0002J\u0010\u0010&\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\u0013H\u0002J\b\u0010)\u001a\u00020\bH\u0002J\b\u0010*\u001a\u00020\bH\u0002J\u0010\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020\u0015H\u0002J\u000f\u0010-\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010.J\u000f\u0010/\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010.J\b\u00100\u001a\u00020\bH\u0002J\b\u00101\u001a\u00020\bH\u0002J\u000f\u00102\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010.J\b\u00103\u001a\u00020\bH\u0016J\b\u00104\u001a\u000205H\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000f0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/notebooks/visualization/ui/cellsDnD/EditorCellDragAssistant;", "Lcom/intellij/openapi/Disposable;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "cellInput", "Lcom/intellij/notebooks/visualization/ui/EditorCellInput;", "foldInput", "Lkotlin/Function0;", "", "unfoldInput", "<init>", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lcom/intellij/notebooks/visualization/ui/EditorCellInput;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "currentComponent", "Ljavax/swing/JComponent;", "value", "", "isDragging", "()Z", "dragStartPoint", "Ljava/awt/Point;", "currentlyHighlightedCell", "Lcom/intellij/notebooks/visualization/ui/cellsDnD/CellDropTarget;", "dragPreview", "Lcom/intellij/notebooks/visualization/ui/cellsDnD/CellDragCellPreviewWindow;", "wasFolded", "inputFoldedState", "outputInitialStates", "", "", "inlayManager", "Lcom/intellij/notebooks/visualization/NotebookCellInlayManager;", "initDrag", "e", "Ljava/awt/event/MouseEvent;", "updateDragOperation", "finishDrag", "getCellUnderCursor", "editorPoint", "retrieveTargetCell", "updateDragVisuals", "currentLocationOnScreen", "foldDraggedCell", "unfoldCellIfNeeded", "updateDropIndicator", "targetCell", "addHighlightAfterLastCell", "()Lkotlin/Unit;", "removeHighlightAfterLastCell", "clearDragState", "deleteDragPreview", "deleteDropIndicator", "dispose", "getPlaceholderText", "", "Companion", "intellij.notebooks.visualization"})
@SourceDebugExtension(value={"SMAP\nEditorCellDragAssistant.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorCellDragAssistant.kt\ncom/intellij/notebooks/visualization/ui/cellsDnD/EditorCellDragAssistant\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1#2:185\n1872#3,3:186\n1872#3,3:189\n295#3,2:192\n*S KotlinDebug\n*F\n+ 1 EditorCellDragAssistant.kt\ncom/intellij/notebooks/visualization/ui/cellsDnD/EditorCellDragAssistant\n*L\n117#1:186,3\n128#1:189,3\n176#1:192,2\n*E\n"})
public final class EditorCellDragAssistant
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private final EditorCellInput cellInput;
    @NotNull
    private final Function0<Unit> foldInput;
    @NotNull
    private final Function0<Unit> unfoldInput;
    @Nullable
    private JComponent currentComponent;
    private boolean isDragging;
    @Nullable
    private Point dragStartPoint;
    @NotNull
    private CellDropTarget currentlyHighlightedCell;
    @Nullable
    private CellDragCellPreviewWindow dragPreview;
    private boolean wasFolded;
    private boolean inputFoldedState;
    @NotNull
    private Map<Integer, Boolean> outputInitialStates;
    @Nullable
    private final NotebookCellInlayManager inlayManager;
    private static final int MINIMAL_DRAG_DISTANCE = 8;
    private static final int MAX_PREVIEW_TEXT_LENGTH = 20;

    public EditorCellDragAssistant(@NotNull EditorImpl editor, @NotNull EditorCellInput cellInput, @NotNull Function0<Unit> foldInput, @NotNull Function0<Unit> unfoldInput) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)cellInput, (String)"cellInput");
        Intrinsics.checkNotNullParameter(foldInput, (String)"foldInput");
        Intrinsics.checkNotNullParameter(unfoldInput, (String)"unfoldInput");
        this.editor = editor;
        this.cellInput = cellInput;
        this.foldInput = foldInput;
        this.unfoldInput = unfoldInput;
        this.currentlyHighlightedCell = CellDropTarget.NoCell.INSTANCE;
        this.outputInitialStates = new LinkedHashMap();
        this.inlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
    }

    public final boolean isDragging() {
        return this.isDragging;
    }

    public final void initDrag(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.isDragging = true;
        this.dragStartPoint = e.getLocationOnScreen();
    }

    public final void updateDragOperation(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (!this.isDragging) {
            return;
        }
        if (this.dragPreview == null) {
            CellDragCellPreviewWindow cellDragCellPreviewWindow = this.dragPreview = new CellDragCellPreviewWindow(this.getPlaceholderText(), this.editor);
            if (cellDragCellPreviewWindow != null) {
                cellDragCellPreviewWindow.setVisible(true);
            }
            this.foldDraggedCell();
        }
        CellDragCellPreviewWindow cellDragCellPreviewWindow = this.dragPreview;
        if (cellDragCellPreviewWindow != null) {
            Point point = e.getLocationOnScreen();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
            cellDragCellPreviewWindow.followCursor(point);
        }
        Point currentLocation = e.getLocationOnScreen();
        Intrinsics.checkNotNull((Object)currentLocation);
        this.updateDragVisuals(currentLocation);
    }

    public final void finishDrag(@NotNull MouseEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.deleteDragPreview();
        if (!this.isDragging || this.dragStartPoint == null) {
            this.isDragging = false;
            return;
        }
        Point point = e.getLocationOnScreen();
        Point point2 = this.dragStartPoint;
        Intrinsics.checkNotNull((Object)point2);
        double dragDistance = point.distance(point2);
        if (dragDistance < 8.0) {
            this.clearDragState();
            this.unfoldCellIfNeeded();
            return;
        }
        this.clearDragState();
        CellDropTarget targetCell = this.retrieveTargetCell(e);
        this.unfoldCellIfNeeded();
        ((CellDropNotifier)ApplicationManager.getApplication().getMessageBus().syncPublisher(CellDropNotifier.Companion.getTopicForEditor((Editor)this.editor))).cellDropped(new CellDropEvent(this.cellInput.getCell(), targetCell));
    }

    /*
     * WARNING - void declaration
     */
    private final CellDropTarget getCellUnderCursor(Point editorPoint) {
        void p0;
        Object lastCellBounds;
        NotebookCellInlayManager notebookCellInlayManager = NotebookCellInlayManager.Companion.get((Editor)this.editor);
        if (notebookCellInlayManager == null) {
            return CellDropTarget.NoCell.INSTANCE;
        }
        NotebookCellInlayManager notebookCellManager = notebookCellInlayManager;
        Object object = notebookCellManager.getCell(CollectionsKt.getLastIndex(notebookCellManager.getCells())).getView();
        if (object != null && (object = ((EditorCellView)object).calculateBounds()) != null) {
            lastCellBounds = object;
            boolean bl = false;
            if ((double)editorPoint.y > ((RectangularShape)lastCellBounds).getMaxY()) {
                return CellDropTarget.BelowLastCell.INSTANCE;
            }
        }
        LogicalPosition logicalPosition = this.editor.xyToLogicalPosition(editorPoint);
        EditorImpl editorImpl = this.editor;
        lastCellBounds = logicalPosition;
        DocumentEx documentEx = this.editor.getDocument();
        boolean bl = false;
        int n = editorImpl.logicalPositionToOffset((LogicalPosition)p0);
        int line = documentEx.getLineNumber(n);
        EditorCell realCell = notebookCellManager.getCell(NotebookVisualizationUiUtilKt.getCell((Editor)this.editor, line).getOrdinal());
        return new CellDropTarget.TargetCell(realCell);
    }

    private final CellDropTarget retrieveTargetCell(MouseEvent e) {
        Point dropLocation = e.getLocationOnScreen();
        Point editorLocationOnScreen = this.editor.getContentComponent().getLocationOnScreen();
        int x = dropLocation.x - editorLocationOnScreen.x;
        int y = dropLocation.y - editorLocationOnScreen.y;
        Point editorPoint = new Point(x, y);
        return this.getCellUnderCursor(editorPoint);
    }

    private final void updateDragVisuals(Point currentLocationOnScreen) {
        Point editorLocationOnScreen = this.editor.getContentComponent().getLocationOnScreen();
        int x = currentLocationOnScreen.x - editorLocationOnScreen.x;
        int y = currentLocationOnScreen.y - editorLocationOnScreen.y;
        CellDropTarget cellUnderCursor = this.getCellUnderCursor(new Point(x, y));
        this.updateDropIndicator(cellUnderCursor);
    }

    /*
     * WARNING - void declaration
     */
    private final void foldDraggedCell() {
        Object object;
        this.inputFoldedState = this.cellInput.getFolded();
        if (!this.inputFoldedState) {
            this.foldInput.invoke();
        }
        if ((object = this.cellInput.getCell().getView()) != null && (object = ((EditorCellView)object).getOutputs()) != null && (object = ((EditorCellOutputsView)object).getOutputs()) != null) {
            Iterable $this$forEachIndexed$iv = (Iterable)object;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void output;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EditorCellOutputView editorCellOutputView = (EditorCellOutputView)item$iv;
                int index = n;
                boolean bl = false;
                Integer n2 = index;
                this.outputInitialStates.put(n2, output.getCollapsed());
                output.setCollapsed(true);
            }
        }
        this.wasFolded = true;
    }

    /*
     * WARNING - void declaration
     */
    private final void unfoldCellIfNeeded() {
        Object object;
        if (!this.wasFolded) {
            return;
        }
        if (!this.inputFoldedState) {
            this.unfoldInput.invoke();
        }
        if ((object = this.cellInput.getCell().getView()) != null && (object = ((EditorCellView)object).getOutputs()) != null && (object = ((EditorCellOutputsView)object).getOutputs()) != null) {
            Iterable $this$forEachIndexed$iv = (Iterable)object;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void output;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                EditorCellOutputView editorCellOutputView = (EditorCellOutputView)item$iv;
                int index = n;
                boolean bl = false;
                output.setCollapsed(Intrinsics.areEqual((Object)this.outputInitialStates.get(index), (Object)true));
            }
        }
        this.outputInitialStates.clear();
        this.wasFolded = false;
    }

    private final void updateDropIndicator(CellDropTarget targetCell) {
        this.deleteDropIndicator();
        this.currentlyHighlightedCell = targetCell;
        CellDropTarget cellDropTarget = targetCell;
        if (cellDropTarget instanceof CellDropTarget.TargetCell) {
            EditorCellView editorCellView = ((CellDropTarget.TargetCell)targetCell).getCell().getView();
            if (editorCellView != null) {
                editorCellView.addDropHighlightIfApplicable();
            }
        } else if (Intrinsics.areEqual((Object)cellDropTarget, (Object)CellDropTarget.BelowLastCell.INSTANCE)) {
            this.addHighlightAfterLastCell();
        }
    }

    private final Unit addHighlightAfterLastCell() {
        Unit unit;
        Object object = this.inlayManager;
        if (object != null && (object = ((NotebookCellInlayManager)object).getBelowLastCellPanel()) != null) {
            ((NotebookBelowLastCellPanel)object).addDropHighlight();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final Unit removeHighlightAfterLastCell() {
        Unit unit;
        Object object = this.inlayManager;
        if (object != null && (object = ((NotebookCellInlayManager)object).getBelowLastCellPanel()) != null) {
            ((NotebookBelowLastCellPanel)object).removeDropHighlight();
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private final void clearDragState() {
        this.isDragging = false;
        this.deleteDropIndicator();
    }

    private final void deleteDragPreview() {
        CellDragCellPreviewWindow cellDragCellPreviewWindow = this.dragPreview;
        if (cellDragCellPreviewWindow != null) {
            cellDragCellPreviewWindow.dispose();
        }
        this.dragPreview = null;
    }

    private final Unit deleteDropIndicator() {
        Object object;
        CellDropTarget cellDropTarget = this.currentlyHighlightedCell;
        if (cellDropTarget instanceof CellDropTarget.TargetCell) {
            CellDropTarget cellDropTarget2 = this.currentlyHighlightedCell;
            Intrinsics.checkNotNull((Object)cellDropTarget2, (String)"null cannot be cast to non-null type com.intellij.notebooks.visualization.ui.cellsDnD.CellDropTarget.TargetCell");
            EditorCellView editorCellView = ((CellDropTarget.TargetCell)cellDropTarget2).getCell().getView();
            object = editorCellView != null ? editorCellView.removeDropHighlightIfPresent() : null;
        } else {
            object = Intrinsics.areEqual((Object)cellDropTarget, (Object)CellDropTarget.BelowLastCell.INSTANCE) ? this.removeHighlightAfterLastCell() : Unit.INSTANCE;
        }
        return object;
    }

    public void dispose() {
        this.deleteDropIndicator();
        this.deleteDragPreview();
        this.unfoldCellIfNeeded();
        this.clearDragState();
        this.currentComponent = null;
    }

    @Nls
    private final String getPlaceholderText() {
        String firstNotEmptyString;
        String string;
        Object v1;
        block2: {
            Iterable $this$firstOrNull$iv = StringsKt.lines((CharSequence)((CharSequence)this.cellInput.getCell().getSource().get()));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                boolean bl2 = ((CharSequence)((Object)StringsKt.trim((CharSequence)it)).toString()).length() > 0;
                if (!bl2) continue;
                v1 = element$iv;
                break block2;
            }
            v1 = null;
        }
        if ((string = (firstNotEmptyString = (String)v1)) == null) {
            string = "\u2026";
        }
        String string2 = StringUtil.shortenTextWithEllipsis((String)string, (int)20, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortenTextWithEllipsis(...)");
        return string2;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/notebooks/visualization/ui/cellsDnD/EditorCellDragAssistant$Companion;", "", "<init>", "()V", "MINIMAL_DRAG_DISTANCE", "", "MAX_PREVIEW_TEXT_LENGTH", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

