/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.notebooks.visualization.ui.jupyterToolbars;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.ui.JBColor;
import com.intellij.ui.NewUiValue;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b'\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\b\u0010\u0013\u001a\u00020\u0010H\u0016J\b\u0010\u0014\u001a\u00020\u0010H\u0016J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\f\u0010\u0016\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H$J\b\u0010\u001a\u001a\u00020\u0019H$J\b\u0010\u001b\u001a\u00020\u0019H\u0014R\u001a\u0010\n\u001a\u00020\u000bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u001d"}, d2={"Lcom/intellij/notebooks/visualization/ui/jupyterToolbars/JupyterAbstractAboveCellToolbar;", "Lcom/intellij/openapi/actionSystem/impl/ActionToolbarImpl;", "actionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "toolbarTargetComponent", "Ljavax/swing/JComponent;", "place", "", "<init>", "(Lcom/intellij/openapi/actionSystem/ActionGroup;Ljavax/swing/JComponent;Ljava/lang/String;)V", "isBeingRemoved", "", "()Z", "setBeingRemoved", "(Z)V", "paintComponent", "", "g", "Ljava/awt/Graphics;", "updateUI", "addNotify", "removeNotify", "updateActionsAsync", "Ljava/util/concurrent/Future;", "getArcSize", "", "getHorizontalPadding", "getVerticalPadding", "Companion", "intellij.notebooks.visualization"})
@ApiStatus.Internal
public abstract class JupyterAbstractAboveCellToolbar
extends ActionToolbarImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean isBeingRemoved;
    private static final float ALPHA = 1.0f;
    private static final int TOOLBAR_BORDER_THICKNESS = JBUI.scale((int)1);

    public JupyterAbstractAboveCellToolbar(@NotNull ActionGroup actionGroup, @NotNull JComponent toolbarTargetComponent, @NotNull String place) {
        Intrinsics.checkNotNullParameter((Object)actionGroup, (String)"actionGroup");
        Intrinsics.checkNotNullParameter((Object)toolbarTargetComponent, (String)"toolbarTargetComponent");
        Intrinsics.checkNotNullParameter((Object)place, (String)"place");
        super(place, actionGroup, true);
        JBColor borderColor = NewUiValue.isEnabled() ? JBColor.namedColor((String)"Editor.Toolbar.borderColor", (Color)JBColor.border()) : JBColor.GRAY;
        this.setBorder(BorderFactory.createCompoundBorder((Border)new RoundedLineBorder((Color)borderColor, this.getArcSize(), TOOLBAR_BORDER_THICKNESS), BorderFactory.createEmptyBorder(this.getVerticalPadding(), this.getHorizontalPadding(), this.getVerticalPadding(), this.getHorizontalPadding())));
        this.setOpaque(false);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setTargetComponent(toolbarTargetComponent);
        this.putClientProperty("SkipClickProcessingForCellSelection", true);
    }

    public /* synthetic */ JupyterAbstractAboveCellToolbar(ActionGroup actionGroup, JComponent jComponent, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = "EditorInlay";
        }
        this(actionGroup, jComponent, string);
    }

    protected final boolean isBeingRemoved() {
        return this.isBeingRemoved;
    }

    protected final void setBeingRemoved(boolean bl) {
        this.isBeingRemoved = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            g2.setComposite(AlphaComposite.getInstance(3, 1.0f));
            g2.setColor(this.getBackground());
            g2.fillRoundRect(0, 0, this.getWidth(), this.getHeight(), this.getArcSize(), this.getArcSize());
        }
        finally {
            g2.dispose();
        }
    }

    public void updateUI() {
        super.updateUI();
        if (!StartupUiUtil.INSTANCE.isDarkTheme()) {
            this.setBackground((Color)JBColor.WHITE);
        }
    }

    public void addNotify() {
        super.addNotify();
        this.updateActionsImmediately(true);
    }

    public void removeNotify() {
        this.isBeingRemoved = true;
        super.removeNotify();
    }

    @NotNull
    public Future<?> updateActionsAsync() {
        Future future;
        if (this.isBeingRemoved) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(...)");
            future = completableFuture;
        } else {
            Future future2 = super.updateActionsAsync();
            future = future2;
            Intrinsics.checkNotNullExpressionValue((Object)future2, (String)"updateActionsAsync(...)");
        }
        return future;
    }

    protected abstract int getArcSize();

    protected abstract int getHorizontalPadding();

    protected int getVerticalPadding() {
        return this.getHorizontalPadding();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/intellij/notebooks/visualization/ui/jupyterToolbars/JupyterAbstractAboveCellToolbar$Companion;", "", "<init>", "()V", "ALPHA", "", "TOOLBAR_BORDER_THICKNESS", "", "intellij.notebooks.visualization"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

