/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.community.impl.huggingFace.annotation;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.python.community.impl.huggingFace.HuggingFaceEntityKind;
import com.intellij.python.community.impl.huggingFace.HuggingFaceUtil;
import com.intellij.python.community.impl.huggingFace.annotation.HuggingFaceReference;
import com.intellij.python.community.impl.huggingFace.service.HuggingFacePluginManager;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lcom/intellij/python/community/impl/huggingFace/annotation/HuggingFaceIdentifierReferenceProvider;", "Lcom/intellij/psi/PsiReferenceProvider;", "<init>", "()V", "getReferencesByElement", "", "Lcom/intellij/psi/PsiReference;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lcom/intellij/util/ProcessingContext;", "(Lcom/intellij/psi/PsiElement;Lcom/intellij/util/ProcessingContext;)[Lcom/intellij/psi/PsiReference;", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "text", "", "Companion", "intellij.python.community.impl.huggingFace"})
@ApiStatus.Internal
public final class HuggingFaceIdentifierReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex HF_WORTHY_STRING_REGEX = new Regex("[\\w.-]+/[\\w.-]+");

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PyStringLiteralExpression pyStringLiteralExpression = element instanceof PyStringLiteralExpression ? (PyStringLiteralExpression)element : null;
        if (pyStringLiteralExpression == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        PyStringLiteralExpression pyStringLiteralExpression2 = pyStringLiteralExpression;
        String string = pyStringLiteralExpression2.getStringValue();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStringValue(...)");
        String text = string;
        if (!HF_WORTHY_STRING_REGEX.matches((CharSequence)text)) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        Project project = ((PyStringLiteralExpression)element).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        HuggingFacePluginManager pluginManager = (HuggingFacePluginManager)project2.getService(HuggingFacePluginManager.class);
        if (!pluginManager.isActive()) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HuggingFaceEntityKind huggingFaceEntityKind = HuggingFaceUtil.INSTANCE.isWhatHuggingFaceEntity(text);
        if (huggingFaceEntityKind == null) {
            Intrinsics.checkNotNullExpressionValue((Object)PsiReference.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            return PsiReference.EMPTY_ARRAY;
        }
        HuggingFaceEntityKind entityKind = huggingFaceEntityKind;
        TextRange textRange = this.getTextRange(element, text);
        PsiReference[] psiReferenceArray = new PsiReference[]{new HuggingFaceReference(element, textRange, text, entityKind)};
        return psiReferenceArray;
    }

    private final TextRange getTextRange(PsiElement element, String text) {
        TextRange textRange;
        String string = element.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        int startOffset = StringsKt.indexOf$default((CharSequence)string, (String)text, (int)0, (boolean)false, (int)6, null);
        if (startOffset >= 0) {
            textRange = new TextRange(startOffset, startOffset + text.length());
        } else {
            TextRange textRange2 = TextRange.EMPTY_RANGE;
            Intrinsics.checkNotNull((Object)textRange2);
            textRange = textRange2;
        }
        return textRange;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/python/community/impl/huggingFace/annotation/HuggingFaceIdentifierReferenceProvider$Companion;", "", "<init>", "()V", "HF_WORTHY_STRING_REGEX", "Lkotlin/text/Regex;", "intellij.python.community.impl.huggingFace"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

