/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Processor;
import com.intellij.util.containers.UtilKt;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.ast.PyAstParameterList;
import com.jetbrains.python.codeInsight.PyDataclassFieldParameters;
import com.jetbrains.python.codeInsight.PyDataclassNames;
import com.jetbrains.python.codeInsight.PyDataclassParameters;
import com.jetbrains.python.codeInsight.PyDataclassesKt;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.PythonDocumentationProvider;
import com.jetbrains.python.inspections.PyDataclassInspection$Visitor$visitPyDelStatement$;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.PyNamedTupleInspection;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyCallSiteExpression;
import com.jetbrains.python.psi.PyCallable;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyDelStatement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.ParamHelper;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0002\f\rB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection;", "Lcom/jetbrains/python/inspections/PyInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "Companion", "Visitor", "intellij.python.psi.impl"})
public final class PyDataclassInspection
extends PyInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Set<String> ORDER_OPERATORS;

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        TypeEvalContext typeEvalContext = PyInspectionVisitor.getContext(session);
        Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"getContext(...)");
        return new Visitor(holder, typeEvalContext);
    }

    static {
        Object[] objectArray = new String[]{"__lt__", "__le__", "__gt__", "__ge__"};
        ORDER_OPERATORS = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0007B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Companion;", "", "<init>", "()V", "ORDER_OPERATORS", "", "", "ClassOrder", "intellij.python.psi.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Companion$ClassOrder;", "", "<init>", "(Ljava/lang/String;I)V", "MANUALLY", "DC_ORDERED", "DC_UNORDERED", "UNKNOWN", "intellij.python.psi.impl"})
        private static final class ClassOrder
        extends Enum<ClassOrder> {
            public static final /* enum */ ClassOrder MANUALLY = new ClassOrder();
            public static final /* enum */ ClassOrder DC_ORDERED = new ClassOrder();
            public static final /* enum */ ClassOrder DC_UNORDERED = new ClassOrder();
            public static final /* enum */ ClassOrder UNKNOWN = new ClassOrder();
            private static final /* synthetic */ ClassOrder[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ClassOrder[] values() {
                return (ClassOrder[])$VALUES.clone();
            }

            public static ClassOrder valueOf(String value) {
                return Enum.valueOf(ClassOrder.class, value);
            }

            @NotNull
            public static EnumEntries<ClassOrder> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = classOrderArray = new ClassOrder[]{ClassOrder.MANUALLY, ClassOrder.DC_ORDERED, ClassOrder.DC_UNORDERED, ClassOrder.UNKNOWN};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001:\u0001IB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J(\u0010\u0019\u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J(\u0010 \u001a\u0010\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u001a2\u0006\u0010\u001d\u001a\u00020\u000f2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0002J\u0014\u0010!\u001a\u0004\u0018\u00010\u000f2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0002J\u0018\u0010$\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0018\u0010*\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0010\u0010+\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0018\u0010,\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010-\u001a\u00020\t2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020\u000fH\u0002J\u001c\u0010/\u001a\u0004\u0018\u0001002\u0006\u0010)\u001a\u00020\u000b2\b\u00101\u001a\u0004\u0018\u000102H\u0002J \u00103\u001a\u00020\t2\u0006\u0010.\u001a\u00020\u000f2\u0006\u0010%\u001a\u00020&2\u0006\u0010)\u001a\u00020\u000bH\u0002J0\u00104\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u00101\u001a\u0002022\u0006\u0010%\u001a\u00020&2\u000e\u00105\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010706H\u0002J\u0018\u00108\u001a\u00020\t2\u0006\u00101\u001a\u0002022\u0006\u0010%\u001a\u00020&H\u0002J\u001a\u00109\u001a\u00020\t2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u001fH\u0002J\u001a\u0010=\u001a\u00020\t2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u001fH\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010)\u001a\u00020\u000bH\u0002J\u0012\u0010>\u001a\u00020?2\b\u0010@\u001a\u0004\u0018\u000107H\u0002J\u0014\u0010A\u001a\u0004\u0018\u0001072\b\u0010@\u001a\u0004\u0018\u000107H\u0002J4\u0010B\u001a\u00020?2\b\u0010C\u001a\u0004\u0018\u0001072\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010F\u001a\u00020?2\u0006\u0010G\u001a\u00020?2\u0006\u0010H\u001a\u00020?H\u0002\u00a8\u0006J"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Visitor;", "Lcom/jetbrains/python/inspections/PyInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "context", "Lcom/jetbrains/python/psi/types/TypeEvalContext;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/jetbrains/python/psi/types/TypeEvalContext;)V", "visitPyTargetExpression", "", "node", "Lcom/jetbrains/python/psi/PyTargetExpression;", "visitPyDelStatement", "Lcom/jetbrains/python/psi/PyDelStatement;", "visitPyClass", "Lcom/jetbrains/python/psi/PyClass;", "visitPyBinaryExpression", "Lcom/jetbrains/python/psi/PyBinaryExpression;", "visitPyCallExpression", "Lcom/jetbrains/python/psi/PyCallExpression;", "visitPyReferenceExpression", "Lcom/jetbrains/python/psi/PyReferenceExpression;", "checkMutatingFrozenAttribute", "expression", "Lcom/jetbrains/python/psi/PyQualifiedExpression;", "getDataclassHierarchyOrder", "Lkotlin/Pair;", "Lcom/jetbrains/python/inspections/PyDataclassInspection$Companion$ClassOrder;", "Lcom/jetbrains/python/codeInsight/PyDataclassParameters$Type;", "cls", "operator", "", "getDataclassOrder", "getInstancePyClass", "element", "Lcom/jetbrains/python/psi/PyTypedElement;", "processDataclassParameters", "dataclassParameters", "Lcom/jetbrains/python/codeInsight/PyDataclassParameters;", "processAttrsParameters", "processDefaultFieldValue", "field", "processAttrsDefaultThroughDecorator", "processAttrsInitializersAndValidators", "processAnnotationsExistence", "processAttrIbFunctionCalls", "dataclass", "processAsInitVar", "Lcom/jetbrains/python/inspections/PyDataclassInspection$Visitor$InitVarField;", "postInit", "Lcom/jetbrains/python/psi/PyFunction;", "processFieldFunctionCall", "processPostInitDefinition", "localInitVars", "", "Lcom/jetbrains/python/psi/types/PyType;", "processAttrsPostInitDefinition", "processHelperDataclassArgument", "argument", "Lcom/jetbrains/python/psi/PyExpression;", "calleeQName", "processHelperAttrsArgument", "isInitVar", "", "fieldType", "getInitVarType", "isExpectedDataclass", "type", "dataclassType", "Lcom/jetbrains/python/codeInsight/PyDataclassParameters$PredefinedType;", "allowDefinition", "allowInstance", "allowSubclass", "InitVarField", "intellij.python.psi.impl"})
    @SourceDebugExtension(value={"SMAP\nPyDataclassInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PyDataclassInspection.kt\ncom/jetbrains/python/inspections/PyDataclassInspection$Visitor\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,748:1\n477#2:749\n1317#2,2:750\n1228#2,2:760\n1317#2,2:802\n1317#2,2:813\n1#3:752\n1#3:755\n1#3:772\n1619#4:753\n1863#4:754\n1864#4:756\n1620#4:757\n295#4,2:758\n1611#4,9:762\n1863#4:771\n1864#4:773\n1620#4:774\n1755#4,3:775\n1863#4,2:780\n1863#4,2:784\n1863#4,2:786\n1863#4,2:788\n774#4:790\n865#4,2:791\n1755#4,2:793\n1755#4,3:795\n1757#4:798\n1863#4:801\n1864#4:804\n1755#4,3:805\n1755#4,3:808\n13402#5,2:778\n13402#5,2:782\n13402#5,2:799\n12567#5,2:811\n*S KotlinDebug\n*F\n+ 1 PyDataclassInspection.kt\ncom/jetbrains/python/inspections/PyDataclassInspection$Visitor\n*L\n54#1:749\n55#1:750,2\n216#1:760,2\n477#1:802,2\n494#1:813,2\n185#1:755\n229#1:772\n185#1:753\n185#1:754\n185#1:756\n185#1:757\n198#1:758,2\n229#1:762,9\n229#1:771\n229#1:773\n229#1:774\n230#1:775,3\n309#1:780,2\n386#1:784,2\n390#1:786,2\n397#1:788,2\n420#1:790\n420#1:791,2\n421#1:793,2\n422#1:795,3\n421#1:798\n471#1:801\n471#1:804\n732#1:805,3\n741#1:808,3\n281#1:778,2\n356#1:782,2\n445#1:799,2\n136#1:811,2\n*E\n"})
    private static final class Visitor
    extends PyInspectionVisitor {
        public Visitor(@NotNull ProblemsHolder holder, @NotNull TypeEvalContext context) {
            Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(holder, context);
        }

        @Override
        public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyTargetExpression(node);
            this.checkMutatingFrozenAttribute(node);
        }

        @Override
        public void visitPyDelStatement(@NotNull PyDelStatement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyDelStatement(node);
            PyExpression[] pyExpressionArray = node.getTargets();
            Intrinsics.checkNotNullExpressionValue((Object)pyExpressionArray, (String)"getTargets(...)");
            Sequence $this$filterIsInstance$iv = ArraysKt.asSequence((Object[])pyExpressionArray);
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)Visitor$visitPyDelStatement$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            Sequence $this$forEach$iv = sequence;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PyReferenceExpression it = (PyReferenceExpression)element$iv;
                boolean bl = false;
                this.checkMutatingFrozenAttribute(it);
            }
        }

        @Override
        public void visitPyClass(@NotNull PyClass node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyClass(node);
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters dataclassParameters = PyDataclassesKt.parseDataclassParameters(node, typeEvalContext);
            if (dataclassParameters != null) {
                if (dataclassParameters.getType().getAsPredefinedType() == PyDataclassParameters.PredefinedType.DATACLASS_TRANSFORM) {
                    this.processDataclassParameters(node, dataclassParameters);
                    node.processClassLevelDeclarations((arg_0, arg_1) -> Visitor.visitPyClass$lambda$1(this, node, dataclassParameters, arg_0, arg_1));
                } else if (dataclassParameters.getType().getAsPredefinedType() == PyDataclassParameters.PredefinedType.STD) {
                    this.processDataclassParameters(node, dataclassParameters);
                    PyFunction postInit = node.findMethodByName("__post_init__", false, this.myTypeEvalContext);
                    List localInitVars = new ArrayList();
                    node.processClassLevelDeclarations((arg_0, arg_1) -> Visitor.visitPyClass$lambda$3(this, postInit, node, dataclassParameters, localInitVars, arg_0, arg_1));
                    if (postInit != null) {
                        this.processPostInitDefinition(node, postInit, dataclassParameters, localInitVars);
                    }
                } else if (dataclassParameters.getType().getAsPredefinedType() == PyDataclassParameters.PredefinedType.ATTRS) {
                    this.processAttrsParameters(node, dataclassParameters);
                    PyFunction pyFunction = node.findMethodByName("__attrs_post_init__", false, this.myTypeEvalContext);
                    if (pyFunction != null) {
                        PyFunction pyFunction2;
                        PyFunction it = pyFunction2 = pyFunction;
                        boolean bl = false;
                        this.processAttrsPostInitDefinition(it, dataclassParameters);
                    }
                    this.processAttrsDefaultThroughDecorator(dataclassParameters, node);
                    this.processAttrsInitializersAndValidators(node);
                    this.processAttrIbFunctionCalls(dataclassParameters, node);
                }
                this.processAnnotationsExistence(node, dataclassParameters);
                Function1 function1 = arg_0 -> Visitor.visitPyClass$lambda$5(this, arg_0);
                boolean bl = dataclassParameters.getType().getAsPredefinedType() == PyDataclassParameters.PredefinedType.STD || dataclassParameters.getType().getAsPredefinedType() == PyDataclassParameters.PredefinedType.DATACLASS_TRANSFORM;
                TypeEvalContext typeEvalContext2 = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
                PyNamedTupleInspection.Companion.inspectFieldsOrder(node, (Function1<? super PyClass, Boolean>)function1, bl, typeEvalContext2, (Function3<? super PsiElement, ? super String, ? super ProblemHighlightType, Unit>)((Function3)new Function3<PsiElement, String, ProblemHighlightType, Unit>((Object)this){

                    public final void invoke(PsiElement p0, String p1, ProblemHighlightType p2) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
                        ((Visitor)((Object)this.receiver)).registerProblem(p0, p1, p2);
                    }
                }), (Function1<? super PyTargetExpression, Boolean>)((Function1)arg_0 -> Visitor.visitPyClass$lambda$6(this, arg_0)), (Function1<? super PyTargetExpression, Boolean>)((Function1)arg_0 -> Visitor.visitPyClass$lambda$8(this, dataclassParameters, node, arg_0)));
            }
        }

        @Override
        public void visitPyBinaryExpression(@NotNull PyBinaryExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyBinaryExpression(node);
            String leftOperator = node.getReferencedName();
            if (leftOperator != null && ORDER_OPERATORS.contains(leftOperator)) {
                PyClass pyClass = this.getInstancePyClass(node.getLeftExpression());
                if (pyClass == null) {
                    return;
                }
                PyClass leftClass = pyClass;
                PyClass pyClass2 = this.getInstancePyClass(node.getRightExpression());
                if (pyClass2 == null) {
                    return;
                }
                PyClass rightClass = pyClass2;
                Pair<Companion.ClassOrder, PyDataclassParameters.Type> pair = this.getDataclassHierarchyOrder(leftClass, leftOperator);
                Companion.ClassOrder leftOrder = (Companion.ClassOrder)((Object)pair.component1());
                PyDataclassParameters.Type leftType = (PyDataclassParameters.Type)pair.component2();
                if (leftOrder == Companion.ClassOrder.MANUALLY) {
                    return;
                }
                Companion.ClassOrder rightOrder = (Companion.ClassOrder)((Object)this.getDataclassHierarchyOrder(rightClass, PyNames.leftToRightOperatorName((String)leftOperator)).component1());
                if (Intrinsics.areEqual((Object)leftClass, (Object)rightClass)) {
                    if (leftOrder == Companion.ClassOrder.DC_UNORDERED && rightOrder != Companion.ClassOrder.MANUALLY) {
                        Object[] objectArray = new Object[]{leftOperator, leftClass.getName()};
                        this.registerProblem(node.getPsiOperator(), PyPsiBundle.message("INSP.dataclasses.operator.not.supported.between.instances.of.class", objectArray), ProblemHighlightType.GENERIC_ERROR);
                    }
                } else if (leftOrder == Companion.ClassOrder.DC_ORDERED || leftOrder == Companion.ClassOrder.DC_UNORDERED || rightOrder == Companion.ClassOrder.DC_ORDERED || rightOrder == Companion.ClassOrder.DC_UNORDERED) {
                    if (leftOrder == Companion.ClassOrder.DC_ORDERED) {
                        PyDataclassParameters.Type type2 = leftType;
                        if ((type2 != null ? type2.getAsPredefinedType() : null) == PyDataclassParameters.PredefinedType.ATTRS && rightClass.isSubclass(leftClass, this.myTypeEvalContext)) {
                            return;
                        }
                    }
                    Object[] objectArray = new Object[]{leftOperator, leftClass.getName(), rightClass.getName()};
                    this.registerProblem(node.getPsiOperator(), PyPsiBundle.message("INSP.dataclasses.operator.not.supported.between.instances.of.classes", objectArray), ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void visitPyCallExpression(@NotNull PyCallExpression node) {
            String destination$iv;
            void $this$mapNotNullTo$iv;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            List<PyCallableType> list = node.multiResolveCallee(this.getResolveContext());
            Intrinsics.checkNotNullExpressionValue(list, (String)"multiResolveCallee(...)");
            List<PyCallableType> callees = list;
            Iterable iterable = callees;
            Collection collection = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv;
                Object element$iv$iv;
                Object element$iv = element$iv$iv = iterator.next();
                boolean bl = false;
                PyCallableType it = (PyCallableType)element$iv;
                boolean bl2 = false;
                PyCallable pyCallable = it.getCallable();
                if ((pyCallable != null ? pyCallable.getQualifiedName() : null) == null) continue;
                it$iv = it$iv;
                boolean bl3 = false;
                destination$iv.add(it$iv);
            }
            String calleeQName = (String)CollectionsKt.singleOrNull((Iterable)((Iterable)((Object)destination$iv)));
            if (calleeQName != null) {
                PyExpression dataclassArgument;
                Object v6;
                PyDataclassParameters.PredefinedType dataclassType;
                block10: {
                    PyDataclassParameters.PredefinedType predefinedType;
                    destination$iv = calleeQName;
                    if (PyDataclassNames.Dataclasses.INSTANCE.getHELPER_FUNCTIONS().contains(destination$iv)) {
                        predefinedType = PyDataclassParameters.PredefinedType.STD;
                    } else if (PyDataclassNames.Attrs.INSTANCE.getCLASS_HELPERS_FUNCTIONS().contains(destination$iv) || PyDataclassNames.Attrs.INSTANCE.getINSTANCE_HELPER_FUNCTIONS().contains(destination$iv)) {
                        predefinedType = PyDataclassParameters.PredefinedType.ATTRS;
                    } else {
                        return;
                    }
                    dataclassType = predefinedType;
                    Object object = CollectionsKt.first(callees);
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"first(...)");
                    PyCallableType callableType = (PyCallableType)object;
                    PyCallExpression.PyArgumentsMapping pyArgumentsMapping = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)node, callableType, this.myTypeEvalContext);
                    Intrinsics.checkNotNullExpressionValue((Object)pyArgumentsMapping, (String)"mapArguments(...)");
                    PyCallExpression.PyArgumentsMapping mapping = pyArgumentsMapping;
                    List<PyCallableParameter> list2 = callableType.getParameters(this.myTypeEvalContext);
                    PyCallableParameter dataclassParameter = list2 != null ? (PyCallableParameter)CollectionsKt.firstOrNull(list2) : null;
                    Iterable $this$firstOrNull$iv = mapping.getMappedParameters().entrySet();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        Map.Entry it = (Map.Entry)element$iv;
                        boolean bl = false;
                        if (!Intrinsics.areEqual(it.getValue(), (Object)dataclassParameter)) continue;
                        v6 = element$iv;
                        break block10;
                    }
                    v6 = null;
                }
                Map.Entry entry = v6;
                PyExpression pyExpression = dataclassArgument = entry != null ? (PyExpression)entry.getKey() : null;
                if (dataclassType.getAsPredefinedType() == PyDataclassParameters.PredefinedType.STD) {
                    this.processHelperDataclassArgument(dataclassArgument, calleeQName);
                } else if (dataclassType.getAsPredefinedType() == PyDataclassParameters.PredefinedType.ATTRS) {
                    this.processHelperAttrsArgument(dataclassArgument, calleeQName);
                }
            }
        }

        @Override
        public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            super.visitPyReferenceExpression(node);
            if (node.isQualified()) {
                PyClass pyClass = this.getInstancePyClass(node.getQualifier());
                if (pyClass == null) {
                    return;
                }
                PyClass cls = pyClass;
                Object[] objectArray = node.getReference(this.getResolveContext()).multiResolve(false);
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"multiResolve(...)");
                Object[] resolved = objectArray;
                if (!(resolved.length == 0)) {
                    boolean bl;
                    block5: {
                        Sequence $this$all$iv = SequencesKt.map((Sequence)ArraysKt.asSequence((Object[])resolved), Visitor::visitPyReferenceExpression$lambda$11);
                        boolean $i$f$all = false;
                        for (Object element$iv : $this$all$iv) {
                            PsiElement it = (PsiElement)element$iv;
                            boolean bl2 = false;
                            if (it instanceof PyTargetExpression && this.isInitVar((PyTargetExpression)it)) continue;
                            bl = false;
                            break block5;
                        }
                        bl = true;
                    }
                    if (bl) {
                        Object[] objectArray2 = new Object[]{cls.getName(), node.getName()};
                        this.registerProblem(node.getLastChild(), PyPsiBundle.message("INSP.dataclasses.object.could.have.no.attribute.because.it.declared.as.init.only", objectArray2), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                    }
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void checkMutatingFrozenAttribute(PyQualifiedExpression expression) {
            boolean bl;
            PyClass cls;
            block6: {
                void $this$mapNotNullTo$iv$iv;
                PyClass pyClass = this.getInstancePyClass(expression.getQualifier());
                if (pyClass == null) {
                    return;
                }
                cls = pyClass;
                StreamEx streamEx = StreamEx.of((Object)cls).append((Collection)cls.getAncestorClasses(this.myTypeEvalContext));
                Intrinsics.checkNotNullExpressionValue((Object)streamEx, (String)"append(...)");
                Iterable $this$mapNotNull$iv = (Iterable)streamEx;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PyDataclassParameters it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl2 = false;
                    PyClass it = (PyClass)element$iv$iv;
                    boolean bl3 = false;
                    Intrinsics.checkNotNull((Object)it);
                    TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                    Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                    if (PyDataclassesKt.parseDataclassParameters(it, typeEvalContext) == null) continue;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PyDataclassParameters it = (PyDataclassParameters)element$iv;
                        boolean bl5 = false;
                        if (!it.getFrozen()) continue;
                        bl = true;
                        break block6;
                    }
                    bl = false;
                }
            }
            if (bl) {
                Object[] objectArray = new Object[]{cls.getName(), expression.getName()};
                this.registerProblem((PsiElement)expression, PyPsiBundle.message("INSP.dataclasses.object.attribute.read.only", objectArray), ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final Pair<Companion.ClassOrder, PyDataclassParameters.Type> getDataclassHierarchyOrder(PyClass cls, String operator) {
            Pair<Companion.ClassOrder, PyDataclassParameters.Type> seenUnordered = null;
            Iterator iterator = StreamEx.of((Object)cls).append((Collection)cls.getAncestorClasses(this.myTypeEvalContext)).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                PyClass current = (PyClass)iterator2.next();
                Intrinsics.checkNotNull((Object)current);
                Pair<Companion.ClassOrder, PyDataclassParameters.Type> order = this.getDataclassOrder(current, operator);
                if (order.getFirst() == Companion.ClassOrder.DC_UNORDERED) {
                    seenUnordered = order;
                    continue;
                }
                if (order.getFirst() == Companion.ClassOrder.UNKNOWN) continue;
                return order;
            }
            Pair<Companion.ClassOrder, PyDataclassParameters.Type> pair = seenUnordered;
            if (pair == null) {
                pair = TuplesKt.to((Object)((Object)Companion.ClassOrder.UNKNOWN), null);
            }
            return pair;
        }

        private final Pair<Companion.ClassOrder, PyDataclassParameters.Type> getDataclassOrder(PyClass cls, String operator) {
            Collection collection;
            PyClassLikeType type2 = cls.getType(this.myTypeEvalContext);
            if (operator != null && type2 != null && !((collection = (Collection)type2.resolveMember(operator, null, AccessDirection.READ, this.getResolveContext(), false)) == null || collection.isEmpty())) {
                return TuplesKt.to((Object)((Object)Companion.ClassOrder.MANUALLY), null);
            }
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters(cls, typeEvalContext);
            if (pyDataclassParameters == null) {
                return TuplesKt.to((Object)((Object)Companion.ClassOrder.UNKNOWN), null);
            }
            PyDataclassParameters parameters = pyDataclassParameters;
            return parameters.getOrder() ? TuplesKt.to((Object)((Object)Companion.ClassOrder.DC_ORDERED), (Object)parameters.getType()) : TuplesKt.to((Object)((Object)Companion.ClassOrder.DC_UNORDERED), (Object)parameters.getType());
        }

        private final PyClass getInstancePyClass(PyTypedElement element) {
            PyType pyType;
            PyTypedElement pyTypedElement = element;
            if (pyTypedElement != null) {
                PyTypedElement it = pyTypedElement;
                boolean bl = false;
                pyType = this.myTypeEvalContext.getType(it);
            } else {
                pyType = null;
            }
            PyType pyType2 = pyType;
            PyClassType type2 = pyType2 instanceof PyClassType ? (PyClassType)pyType2 : null;
            return type2 != null && !type2.isDefinition() ? type2.getPyClass() : null;
        }

        private final void processDataclassParameters(PyClass cls, PyDataclassParameters dataclassParameters) {
            Object[] objectArray;
            PyFunction it;
            if (!dataclassParameters.getEq() && dataclassParameters.getOrder()) {
                this.registerProblem((PsiElement)dataclassParameters.getEqArgument(), PyPsiBundle.message("INSP.dataclasses.eq.must.be.true.if.order.true", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
            }
            boolean initMethodExists = false;
            boolean reprMethodExists = false;
            boolean eqMethodExists = false;
            boolean orderMethodsExist = false;
            boolean mutatingMethodsExist = false;
            boolean hashMethodExists = false;
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)pyFunctionArray, (String)"getMethods(...)");
            Object[] $this$forEach$iv = pyFunctionArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PyFunction)element$iv;
                boolean bl = false;
                objectArray = it.getName();
                if (Intrinsics.areEqual((Object)objectArray, (Object)"__init__")) {
                    initMethodExists = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)objectArray, (Object)"__repr__")) {
                    reprMethodExists = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)objectArray, (Object)"__eq__")) {
                    eqMethodExists = true;
                    continue;
                }
                if (CollectionsKt.contains((Iterable)ORDER_OPERATORS, (Object)objectArray)) {
                    orderMethodsExist = true;
                    continue;
                }
                if (Intrinsics.areEqual((Object)objectArray, (Object)"__setattr__") || Intrinsics.areEqual((Object)objectArray, (Object)"__delattr__")) {
                    mutatingMethodsExist = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)objectArray, (Object)"__hash__")) continue;
                hashMethodExists = true;
            }
            hashMethodExists = hashMethodExists || cls.findClassAttribute("__hash__", false, this.myTypeEvalContext) != null;
            List useless = new ArrayList();
            if (dataclassParameters.getInit() && initMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getInitArgument(), (Object)"init", (Object)"__init__"));
            }
            if (dataclassParameters.getRepr() && reprMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getReprArgument(), (Object)"repr", (Object)"__repr__"));
            }
            if (dataclassParameters.getEq() && eqMethodExists) {
                useless.add(new Triple((Object)dataclassParameters.getEqArgument(), (Object)"eq", (Object)"__eq__"));
            }
            Iterable $this$forEach$iv2 = useless;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv2) {
                it = (Triple)element$iv;
                boolean bl = false;
                objectArray = new Object[]{it.getSecond(), it.getThird()};
                this.registerProblem((PsiElement)it.getFirst(), PyPsiBundle.message("INSP.dataclasses.argument.ignored.if.class.already.defines.method", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            if (dataclassParameters.getOrder() && orderMethodsExist) {
                this.registerProblem((PsiElement)dataclassParameters.getOrderArgument(), PyPsiBundle.message("INSP.dataclasses.order.argument.should.be.false.if.class.defines.one.of.order.methods", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
            }
            if (dataclassParameters.getFrozen() && mutatingMethodsExist) {
                this.registerProblem((PsiElement)dataclassParameters.getFrozenArgument(), PyPsiBundle.message("INSP.dataclasses.frozen.attribute.should.be.false.if.class.defines.setattr.or.delattr", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
            }
            if (dataclassParameters.getUnsafeHash() && hashMethodExists) {
                this.registerProblem((PsiElement)dataclassParameters.getUnsafeHashArgument(), PyPsiBundle.message("INSP.dataclasses.unsafe.hash.attribute.should.be.false.if.class.defines.hash", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
            }
            Boolean frozenInHierarchy = null;
            Iterator iterator = StreamEx.of((Object)cls).append((Collection)cls.getAncestorClasses(this.myTypeEvalContext)).iterator();
            Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                PyClass current = (PyClass)iterator2.next();
                Intrinsics.checkNotNull((Object)current);
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseStdOrDataclassTransformDataclassParameters(current, typeEvalContext);
                if (pyDataclassParameters == null) {
                    continue;
                }
                boolean currentFrozen = pyDataclassParameters.getFrozen();
                if (frozenInHierarchy == null) {
                    frozenInHierarchy = currentFrozen;
                    continue;
                }
                if (Intrinsics.areEqual((Object)frozenInHierarchy, (Object)currentFrozen)) continue;
                PyExpression pyExpression = dataclassParameters.getFrozenArgument();
                this.registerProblem(pyExpression != null ? (PsiElement)pyExpression : cls.getNameIdentifier(), PyPsiBundle.message("INSP.dataclasses.frozen.dataclasses.can.not.inherit.non.frozen.one", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processAttrsParameters(PyClass cls, PyDataclassParameters dataclassParameters) {
            boolean $i$f$forEach;
            String string;
            PyFunction it;
            PyFunction initMethod = null;
            PyFunction reprMethod = null;
            PyFunction strMethod = null;
            List cmpMethods = new ArrayList();
            List mutatingMethods = new ArrayList();
            PsiNameIdentifierOwner hashMethod = null;
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)pyFunctionArray, (String)"getMethods(...)");
            Object[] $this$forEach$iv = pyFunctionArray;
            boolean $i$f$forEach2 = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (PyFunction)element$iv;
                boolean bl = false;
                string = it.getName();
                if (Intrinsics.areEqual((Object)string, (Object)"__init__")) {
                    initMethod = it;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__repr__")) {
                    reprMethod = it;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__str__")) {
                    strMethod = it;
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__eq__") || CollectionsKt.contains((Iterable)ORDER_OPERATORS, (Object)string)) {
                    Intrinsics.checkNotNull((Object)it);
                    cmpMethods.add(it);
                    continue;
                }
                if (Intrinsics.areEqual((Object)string, (Object)"__setattr__") || Intrinsics.areEqual((Object)string, (Object)"__delattr__")) {
                    Intrinsics.checkNotNull((Object)it);
                    mutatingMethods.add(it);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)string, (Object)"__hash__")) continue;
                hashMethod = it;
            }
            PsiNameIdentifierOwner psiNameIdentifierOwner = hashMethod;
            if (psiNameIdentifierOwner == null) {
                psiNameIdentifierOwner = cls.findClassAttribute("__hash__", false, this.myTypeEvalContext);
            }
            hashMethod = psiNameIdentifierOwner;
            List problems = new ArrayList();
            if (dataclassParameters.getInit() && initMethod != null) {
                problems.add(TuplesKt.to((Object)initMethod, (Object)"init"));
            }
            if (dataclassParameters.getRepr() && reprMethod != null) {
                problems.add(TuplesKt.to((Object)reprMethod, (Object)"repr"));
            }
            if (PyEvaluator.evaluateAsBoolean(PyUtil.peelArgument(dataclassParameters.getOthers().get("str")), false) && strMethod != null) {
                problems.add(TuplesKt.to((Object)strMethod, (Object)"str"));
            }
            if (dataclassParameters.getOrder() && !((Collection)cmpMethods).isEmpty()) {
                Iterable $this$forEach$iv2 = cmpMethods;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    it = (PyFunction)element$iv;
                    boolean bl = false;
                    problems.add(TuplesKt.to((Object)it, (Object)"cmp/order"));
                }
            }
            if (dataclassParameters.getFrozen() && !((Collection)mutatingMethods).isEmpty()) {
                Iterable $this$forEach$iv3 = mutatingMethods;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv3) {
                    it = (PyFunction)element$iv;
                    boolean bl = false;
                    problems.add(TuplesKt.to((Object)it, (Object)"frozen"));
                }
            }
            if (dataclassParameters.getUnsafeHash() && hashMethod != null) {
                problems.add(TuplesKt.to((Object)hashMethod, (Object)"hash"));
            }
            Iterable $this$forEach$iv4 = problems;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv4) {
                it = (Pair)element$iv;
                boolean bl = false;
                if ((PsiNameIdentifierOwner)it.getFirst() == null) continue;
                String $this$processAttrsParameters_u24lambda_u2422_u24lambda_u2421 = string;
                boolean bl2 = false;
                Object[] objectArray = new Object[]{$this$processAttrsParameters_u24lambda_u2422_u24lambda_u2421.getName(), it.getSecond()};
                this.registerProblem($this$processAttrsParameters_u24lambda_u2422_u24lambda_u2421.getNameIdentifier(), PyPsiBundle.message("INSP.dataclasses.method.is.ignored.if.class.already.defines.parameter", objectArray), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
            if (dataclassParameters.getOrder() && dataclassParameters.getFrozen() && hashMethod != null) {
                this.registerProblem(hashMethod.getNameIdentifier(), PyPsiBundle.message("INSP.dataclasses.hash.ignored.if.class.already.defines.cmp.or.order.or.frozen.parameters", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processDefaultFieldValue(PyTargetExpression field) {
            if (field.getAnnotationValue() == null) {
                return;
            }
            PyExpression value = field.findAssignedValue();
            if (value instanceof PyCallExpression) {
                boolean fieldWithDefaultFactory;
                block12: {
                    void $this$any$iv;
                    void $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    Iterable<PyCallableType> iterable = ((PyCallExpression)value).multiResolveCallee(this.getResolveContext());
                    Intrinsics.checkNotNullExpressionValue(iterable, (String)"multiResolveCallee(...)");
                    iterable = iterable;
                    boolean $i$f$filter = false;
                    Iterator iterator = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        PyCallableType it = (PyCallableType)element$iv$iv;
                        boolean bl = false;
                        PyCallable pyCallable = it.getCallable();
                        if (!Intrinsics.areEqual((Object)(pyCallable != null ? pyCallable.getQualifiedName() : null), (Object)"dataclasses.field")) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v1 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl;
                            block11: {
                                PyCallableType it = (PyCallableType)element$iv;
                                boolean bl2 = false;
                                Iterable $this$any$iv2 = PyCallExpressionHelper.mapArguments((PyCallSiteExpression)value, it, this.myTypeEvalContext).getMappedParameters().values();
                                boolean $i$f$any2 = false;
                                if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                    bl = false;
                                } else {
                                    for (Object element$iv2 : $this$any$iv2) {
                                        PyCallableParameter p = (PyCallableParameter)element$iv2;
                                        boolean bl3 = false;
                                        if (!Intrinsics.areEqual((Object)p.getName(), (Object)"default_factory")) continue;
                                        bl = true;
                                        break block11;
                                    }
                                    bl = false;
                                }
                            }
                            if (!bl) continue;
                            v1 = true;
                            break block12;
                        }
                        v1 = fieldWithDefaultFactory = false;
                    }
                }
                if (fieldWithDefaultFactory) {
                    return;
                }
            }
            if (PyUtil.isForbiddenMutableDefault(value, this.myTypeEvalContext)) {
                Object[] objectArray = new Object[1];
                PyExpression pyExpression = value;
                objectArray[0] = pyExpression != null ? pyExpression.getText() : null;
                this.registerProblem((PsiElement)value, PyPsiBundle.message("INSP.dataclasses.mutable.attribute.default.not.allowed.use.default.factory", objectArray), ProblemHighlightType.GENERIC_ERROR);
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void processAttrsDefaultThroughDecorator(PyDataclassParameters dataclassParameters, PyClass cls) {
            Sequence decorators;
            Map initializers = new LinkedHashMap();
            PyFunction[] pyFunctionArray = cls.getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)pyFunctionArray, (String)"getMethods(...)");
            Object $this$forEach$iv = pyFunctionArray;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String string;
                PyFunction method = (PyFunction)element$iv;
                boolean bl = false;
                PyDecoratorList pyDecoratorList = (PyDecoratorList)method.getDecoratorList();
                Object object = decorators = pyDecoratorList != null ? pyDecoratorList.getDecorators() : null;
                if (decorators == null || (string = (String)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])decorators), Visitor::processAttrsDefaultThroughDecorator$lambda$32$lambda$26), Visitor::processAttrsDefaultThroughDecorator$lambda$32$lambda$27), Visitor::processAttrsDefaultThroughDecorator$lambda$32$lambda$28))) == null) continue;
                String string2 = string;
                String name2 = string2;
                boolean bl2 = false;
                PyTargetExpression attribute = cls.findClassAttribute(name2, false, this.myTypeEvalContext);
                if (attribute == null) continue;
                Intrinsics.checkNotNull((Object)method);
                initializers.computeIfAbsent(name2, arg_0 -> Visitor.processAttrsDefaultThroughDecorator$lambda$32$lambda$31$lambda$30(Visitor::processAttrsDefaultThroughDecorator$lambda$32$lambda$31$lambda$29, arg_0)).add(method);
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyDataclassFieldParameters fieldParams = PyDataclassesKt.resolveDataclassFieldParameters(cls, dataclassParameters, attribute, typeEvalContext);
                if (fieldParams == null || !fieldParams.getHasDefault() && !fieldParams.getHasDefaultFactory()) continue;
                Object[] objectArray = new Object[]{attribute.getCalleeName() + "()"};
                this.registerProblem(method.getNameIdentifier(), PyPsiBundle.message("INSP.dataclasses.attribute.default.set.using.method", objectArray), ProblemHighlightType.GENERIC_ERROR);
            }
            $this$forEach$iv = initializers.values();
            $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                void $this$forEach$iv2;
                Object element$iv = iterator.next();
                List sameAttrInitializers = (List)element$iv;
                boolean bl = false;
                PyFunction first = (PyFunction)sameAttrInitializers.get(0);
                decorators = SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)sameAttrInitializers), (int)1);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    PyFunction it = (PyFunction)element$iv2;
                    boolean bl3 = false;
                    Object[] objectArray = new Object[]{first.getName()};
                    this.registerProblem(it.getNameIdentifier(), PyPsiBundle.message("INSP.dataclasses.attribute.default.set.using.method", objectArray), ProblemHighlightType.GENERIC_ERROR);
                }
            }
        }

        private final void processAttrsInitializersAndValidators(PyClass cls) {
            cls.visitMethods((Processor<? super PyFunction>)((Processor)arg_0 -> Visitor.processAttrsInitializersAndValidators$lambda$40(arg_0 -> Visitor.processAttrsInitializersAndValidators$lambda$39(this, arg_0), arg_0)), false, this.myTypeEvalContext);
        }

        private final void processAnnotationsExistence(PyClass cls, PyDataclassParameters dataclassParameters) {
            if (dataclassParameters.getType().getAsPredefinedType() == PyDataclassParameters.PredefinedType.STD || dataclassParameters.getType().getAsPredefinedType() == PyDataclassParameters.PredefinedType.DATACLASS_TRANSFORM || PyEvaluator.evaluateAsBoolean(PyUtil.peelArgument(dataclassParameters.getOthers().get("auto_attribs")), false)) {
                cls.processClassLevelDeclarations((arg_0, arg_1) -> Visitor.processAnnotationsExistence$lambda$41(cls, dataclassParameters, this, arg_0, arg_1));
            }
        }

        private final void processAttrIbFunctionCalls(PyDataclassParameters dataclassParameters, PyClass dataclass) {
            dataclass.processClassLevelDeclarations((arg_0, arg_1) -> Visitor.processAttrIbFunctionCalls$lambda$42(dataclass, dataclassParameters, this, arg_0, arg_1));
        }

        private final InitVarField processAsInitVar(PyTargetExpression field, PyFunction postInit) {
            PyType fieldType = this.myTypeEvalContext.getType(field);
            if (this.isInitVar(fieldType)) {
                if (postInit == null) {
                    Object[] objectArray = new Object[]{field.getName()};
                    this.registerProblem((PsiElement)field, PyPsiBundle.message("INSP.dataclasses.attribute.useless.until.post.init.declared", objectArray), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                }
                return new InitVarField(this.getInitVarType(fieldType));
            }
            return null;
        }

        private final void processFieldFunctionCall(PyClass dataclass, PyDataclassParameters dataclassParameters, PyTargetExpression field) {
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassFieldParameters pyDataclassFieldParameters = PyDataclassesKt.resolveDataclassFieldParameters(dataclass, dataclassParameters, field, typeEvalContext);
            if (pyDataclassFieldParameters == null) {
                return;
            }
            PyDataclassFieldParameters fieldStub = pyDataclassFieldParameters;
            PyExpression pyExpression = field.findAssignedValue();
            PyCallExpression pyCallExpression = pyExpression instanceof PyCallExpression ? (PyCallExpression)pyExpression : null;
            if (pyCallExpression == null) {
                return;
            }
            PyCallExpression call = pyCallExpression;
            if (PyTypingTypeProvider.isClassVar((PyAnnotationOwner)field, this.myTypeEvalContext) || this.isInitVar(field)) {
                if (fieldStub.getHasDefaultFactory()) {
                    this.registerProblem((PsiElement)call.getKeywordArgument("default_factory"), PyPsiBundle.message("INSP.dataclasses.field.cannot.have.default.factory", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                }
            } else if (fieldStub.getHasDefault() && fieldStub.getHasDefaultFactory()) {
                this.registerProblem((PsiElement)call.getArgumentList(), PyPsiBundle.message("INSP.dataclasses.cannot.specify.both.default.and.default.factory", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processPostInitDefinition(PyClass cls, PyFunction postInit, PyDataclassParameters dataclassParameters, List<? extends PyType> localInitVars) {
            if (!dataclassParameters.getInit()) {
                this.registerProblem(postInit.getNameIdentifier(), PyPsiBundle.message("INSP.dataclasses.post.init.would.not.be.called.until.init.parameter.set.to.true", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
                return;
            }
            if (ParamHelper.isSelfArgsKwargsCallable(postInit, this.myTypeEvalContext)) {
                return;
            }
            List allInitVars = new ArrayList();
            List<PyClass> list = cls.getAncestorClasses(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAncestorClasses(...)");
            for (PyClass ancestor : CollectionsKt.asReversedMutable(list)) {
                Intrinsics.checkNotNull((Object)ancestor);
                TypeEvalContext typeEvalContext = this.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyDataclassesKt.parseStdDataclassParameters(ancestor, typeEvalContext) == null) continue;
                ancestor.processClassLevelDeclarations((arg_0, arg_1) -> Visitor.processPostInitDefinition$lambda$43(this, allInitVars, arg_0, arg_1));
            }
            allInitVars.addAll((Collection)localInitVars);
            List list2 = postInit.getParameters(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getParameters(...)");
            List parameters = UtilKt.tailOrEmpty((List)list2);
            if (parameters.size() != allInitVars.size()) {
                String string = allInitVars.size() != localInitVars.size() ? PyPsiBundle.message("INSP.dataclasses.post.init.should.take.all.init.only.variables.including.inherited.in.same.order.they.defined", new Object[0]) : PyPsiBundle.message("INSP.dataclasses.post.init.should.take.all.init.only.variables.in.same.order.they.defined", new Object[0]);
                Intrinsics.checkNotNull((Object)string);
                String message = string;
                this.registerProblem((PsiElement)postInit.getParameterList(), message, ProblemHighlightType.GENERIC_ERROR);
            } else {
                Iterator iterator = ((Iterable)parameters).iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    String parameterTypeName;
                    String initVarTypeName;
                    Ref<PyType> typeFromAnnotation;
                    PyExpression annotation;
                    int index = n++;
                    PyCallableParameter callableParameter = (PyCallableParameter)iterator.next();
                    PyParameter parameter = callableParameter.getParameter();
                    if (!(parameter instanceof PyNamedParameter) || PyTypingTypeProvider.getAnnotationValue((PyAnnotationOwner)((Object)parameter), this.myTypeEvalContext) == null || PyTypingTypeProvider.getType(annotation, this.myTypeEvalContext) == null) continue;
                    PyType initVarType = (PyType)allInitVars.get(index);
                    if (PyTypeChecker.match((PyType)typeFromAnnotation.get(), initVarType, this.myTypeEvalContext)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getTypeName(initVarType, this.myTypeEvalContext), (String)"getTypeName(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)PythonDocumentationProvider.getVerboseTypeName((PyType)typeFromAnnotation.get(), this.myTypeEvalContext), (String)"getVerboseTypeName(...)");
                    Object[] objectArray = new Object[]{initVarTypeName, parameterTypeName};
                    this.registerProblem((PsiElement)annotation, PyPsiBundle.message("INSP.dataclasses.expected.type.got.type.instead", objectArray));
                }
            }
        }

        private final void processAttrsPostInitDefinition(PyFunction postInit, PyDataclassParameters dataclassParameters) {
            if (!dataclassParameters.getInit()) {
                this.registerProblem(postInit.getNameIdentifier(), PyPsiBundle.message("INSP.dataclasses.attrs.post.init.would.not.be.called.until.init.parameter.set.to.true", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL);
            }
            if (postInit.getParameters(this.myTypeEvalContext).size() != 1) {
                this.registerProblem((PsiElement)postInit.getParameterList(), PyPsiBundle.message("INSP.dataclasses.attrs.post.init.should.not.take.any.parameters.except.self", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
            }
        }

        private final void processHelperDataclassArgument(PyExpression argument, String calleeQName) {
            boolean allowSubclass;
            if (argument == null) {
                return;
            }
            boolean allowDefinition = Intrinsics.areEqual((Object)calleeQName, (Object)"dataclasses.fields");
            PyType type2 = this.myTypeEvalContext.getType(argument);
            boolean bl = allowSubclass = !Intrinsics.areEqual((Object)calleeQName, (Object)"dataclasses.asdict");
            if (!this.isExpectedDataclass(type2, PyDataclassParameters.PredefinedType.STD, allowDefinition, true, allowSubclass)) {
                String string;
                if (allowDefinition) {
                    var8_6 = new Object[]{calleeQName};
                    string = PyPsiBundle.message("INSP.dataclasses.method.should.be.called.on.dataclass.instances.or.types", var8_6);
                } else {
                    var8_6 = new Object[]{calleeQName};
                    string = PyPsiBundle.message("INSP.dataclasses.method.should.be.called.on.dataclass.instances", var8_6);
                }
                String string2 = string;
                Intrinsics.checkNotNull((Object)string2);
                String message = string2;
                this.registerProblem((PsiElement)argument, message);
            }
        }

        private final void processHelperAttrsArgument(PyExpression argument, String calleeQName) {
            if (argument == null) {
                return;
            }
            boolean instance = PyDataclassNames.Attrs.INSTANCE.getINSTANCE_HELPER_FUNCTIONS().contains(calleeQName);
            PyType type2 = this.myTypeEvalContext.getType(argument);
            if (!this.isExpectedDataclass(type2, PyDataclassParameters.PredefinedType.ATTRS, !instance, instance, true)) {
                String string;
                if (instance) {
                    var7_5 = new Object[]{calleeQName};
                    string = PyPsiBundle.message("INSP.dataclasses.method.should.be.called.on.attrs.instances", var7_5);
                } else {
                    var7_5 = new Object[]{calleeQName};
                    string = PyPsiBundle.message("INSP.dataclasses.method.should.be.called.on.attrs.types", var7_5);
                }
                String string2 = string;
                Intrinsics.checkNotNull((Object)string2);
                String message = string2;
                this.registerProblem((PsiElement)argument, message);
            }
        }

        private final boolean isInitVar(PyTargetExpression field) {
            return this.isInitVar(this.myTypeEvalContext.getType(field));
        }

        private final boolean isInitVar(PyType fieldType) {
            return fieldType instanceof PyCollectionType && Intrinsics.areEqual((Object)((PyCollectionType)fieldType).getClassQName(), (Object)"dataclasses.InitVar");
        }

        private final PyType getInitVarType(PyType fieldType) {
            if (!(fieldType instanceof PyCollectionType) || !Intrinsics.areEqual((Object)((PyCollectionType)fieldType).getClassQName(), (Object)"dataclasses.InitVar")) {
                throw new IllegalArgumentException();
            }
            List<PyType> list = ((PyCollectionType)fieldType).getElementTypes();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getElementTypes(...)");
            return (PyType)CollectionsKt.singleOrNull(list);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isExpectedDataclass(PyType type2, PyDataclassParameters.PredefinedType dataclassType, boolean allowDefinition, boolean allowInstance, boolean allowSubclass) {
            PyClassLikeType it;
            if (type2 instanceof PyStructuralType) return true;
            if (PyTypeChecker.isUnknown(type2, this.myTypeEvalContext)) {
                return true;
            }
            if (type2 instanceof PyUnionType) {
                PyType it2;
                Collection<PyType> collection = ((PyUnionType)type2).getMembers();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"getMembers(...)");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    return false;
                }
                Iterator iterator = $this$any$iv.iterator();
                do {
                    if (!iterator.hasNext()) return false;
                    Object element$iv = iterator.next();
                    it2 = (PyType)element$iv;
                    boolean bl = false;
                } while (!this.isExpectedDataclass(it2, dataclassType, allowDefinition, allowInstance, allowSubclass));
                return true;
            }
            if (!(type2 instanceof PyClassType)) return false;
            if (!allowDefinition) {
                if (((PyClassType)type2).isDefinition()) return false;
            }
            if (!allowInstance) {
                if (!((PyClassType)type2).isDefinition()) return false;
            }
            PyClass pyClass = ((PyClassType)type2).getPyClass();
            Intrinsics.checkNotNullExpressionValue((Object)pyClass, (String)"getPyClass(...)");
            TypeEvalContext typeEvalContext = this.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            Object object = PyDataclassesKt.parseDataclassParameters(pyClass, typeEvalContext);
            if ((object != null && (object = ((PyDataclassParameters)object).getType()) != null ? object.getAsPredefinedType() : null) == dataclassType) return true;
            if (!allowSubclass) return false;
            List<PyClassLikeType> list = ((PyClassType)type2).getAncestorTypes(this.myTypeEvalContext);
            Intrinsics.checkNotNullExpressionValue(list, (String)"getAncestorTypes(...)");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (PyClassLikeType)element$iv;
                boolean bl = false;
            } while (!this.isExpectedDataclass(it, dataclassType, true, false, false));
            return true;
        }

        private static final boolean visitPyClass$lambda$1(Visitor this$0, PyClass $node, PyDataclassParameters $dataclassParameters, PsiElement element, ResolveState resolveState) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)resolveState, (String)"<unused var>");
            if (element instanceof PyTargetExpression) {
                this$0.processFieldFunctionCall($node, $dataclassParameters, (PyTargetExpression)element);
            }
            return true;
        }

        private static final boolean visitPyClass$lambda$3(Visitor this$0, PyFunction $postInit, PyClass $node, PyDataclassParameters $dataclassParameters, List $localInitVars, PsiElement element, ResolveState resolveState) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)resolveState, (String)"<unused var>");
            if (element instanceof PyTargetExpression) {
                if (!PyTypingTypeProvider.isClassVar((PyAnnotationOwner)element, this$0.myTypeEvalContext)) {
                    this$0.processDefaultFieldValue((PyTargetExpression)element);
                    InitVarField initVarField = this$0.processAsInitVar((PyTargetExpression)element, $postInit);
                    if (initVarField != null) {
                        InitVarField it = initVarField;
                        boolean bl = false;
                        $localInitVars.add(it.getType());
                    }
                }
                this$0.processFieldFunctionCall($node, $dataclassParameters, (PyTargetExpression)element);
            }
            return true;
        }

        private static final boolean visitPyClass$lambda$5(Visitor this$0, PyClass it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            TypeEvalContext typeEvalContext = this$0.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters parameters = PyDataclassesKt.parseDataclassParameters(it, typeEvalContext);
            return parameters != null && !parameters.getKwOnly();
        }

        private static final boolean visitPyClass$lambda$6(Visitor this$0, PyTargetExpression it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            PyClass pyClass = it.getContainingClass();
            Intrinsics.checkNotNull((Object)pyClass);
            TypeEvalContext typeEvalContext = this$0.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters(pyClass, typeEvalContext);
            Intrinsics.checkNotNull((Object)pyDataclassParameters);
            PyDataclassParameters dataclassParams = pyDataclassParameters;
            PyClass pyClass2 = it.getContainingClass();
            Intrinsics.checkNotNull((Object)pyClass2);
            TypeEvalContext typeEvalContext2 = this$0.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
            PyDataclassFieldParameters fieldParams = PyDataclassesKt.resolveDataclassFieldParameters(pyClass2, dataclassParams, it, typeEvalContext2);
            return (fieldParams == null || fieldParams.getInitValue() && !fieldParams.getKwOnly()) && (fieldParams != null || it.getAnnotationValue() != null) && !PyTypingTypeProvider.isClassVar((PyAnnotationOwner)it, this$0.myTypeEvalContext);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private static final boolean visitPyClass$lambda$8(Visitor this$0, PyDataclassParameters $dataclassParameters, PyClass $node, PyTargetExpression it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            PyClass pyClass = it.getContainingClass();
            Intrinsics.checkNotNull((Object)pyClass);
            TypeEvalContext typeEvalContext = this$0.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
            PyDataclassParameters pyDataclassParameters = PyDataclassesKt.parseDataclassParameters(pyClass, typeEvalContext);
            Intrinsics.checkNotNull((Object)pyDataclassParameters);
            PyDataclassParameters dataclassParams = pyDataclassParameters;
            PyClass pyClass2 = it.getContainingClass();
            Intrinsics.checkNotNull((Object)pyClass2);
            TypeEvalContext typeEvalContext2 = this$0.myTypeEvalContext;
            Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext2, (String)"myTypeEvalContext");
            PyDataclassFieldParameters fieldParams = PyDataclassesKt.resolveDataclassFieldParameters(pyClass2, dataclassParams, it, typeEvalContext2);
            if (fieldParams != null) {
                if (fieldParams.getHasDefault()) return true;
                if (fieldParams.getHasDefaultFactory()) return true;
                if ($dataclassParameters.getType().getAsPredefinedType() != PyDataclassParameters.PredefinedType.ATTRS) return false;
                PyFunction[] pyFunctionArray = $node.getMethods();
                Intrinsics.checkNotNullExpressionValue((Object)pyFunctionArray, (String)"getMethods(...)");
                Object[] $this$any$iv = pyFunctionArray;
                boolean $i$f$any = false;
                int n = 0;
                int n2 = $this$any$iv.length;
                while (n < n2) {
                    Object element$iv = $this$any$iv[n];
                    PyFunction m = (PyFunction)element$iv;
                    boolean bl = false;
                    PyDecoratorList pyDecoratorList = (PyDecoratorList)m.getDecoratorList();
                    if ((pyDecoratorList != null ? pyDecoratorList.findDecorator(it.getName() + ".default") : null) != null) {
                        return true;
                    }
                    boolean bl2 = false;
                    if (bl2) {
                        return true;
                    }
                    ++n;
                }
                return false;
            }
            boolean bl = it.hasAssignedValue();
            return bl;
        }

        private static final PsiElement visitPyReferenceExpression$lambda$11(ResolveResult it) {
            return it.getElement();
        }

        private static final QualifiedName processAttrsDefaultThroughDecorator$lambda$32$lambda$26(PyDecorator it) {
            return it.getQualifiedName();
        }

        private static final boolean processAttrsDefaultThroughDecorator$lambda$32$lambda$27(QualifiedName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getComponentCount() == 2 && it.endsWith("default");
        }

        private static final String processAttrsDefaultThroughDecorator$lambda$32$lambda$28(QualifiedName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getFirstComponent();
        }

        private static final List processAttrsDefaultThroughDecorator$lambda$32$lambda$31$lambda$29(String it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ArrayList();
        }

        private static final List processAttrsDefaultThroughDecorator$lambda$32$lambda$31$lambda$30(Function1 $tmp0, Object p0) {
            return (List)$tmp0.invoke(p0);
        }

        private static final QualifiedName processAttrsInitializersAndValidators$lambda$39$lambda$35(PyDecorator it) {
            return it.getQualifiedName();
        }

        private static final boolean processAttrsInitializersAndValidators$lambda$39$lambda$36(QualifiedName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getComponentCount() == 2;
        }

        private static final String processAttrsInitializersAndValidators$lambda$39$lambda$37(QualifiedName it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getLastComponent();
        }

        private static final boolean processAttrsInitializersAndValidators$lambda$39(Visitor this$0, PyFunction method) {
            Object[] decorators;
            PyDecoratorList pyDecoratorList = (PyDecoratorList)method.getDecoratorList();
            Object object = decorators = pyDecoratorList != null ? pyDecoratorList.getDecorators() : null;
            if (decorators != null) {
                Sequence $this$forEach$iv = SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)SequencesKt.mapNotNull((Sequence)ArraysKt.asSequence((Object[])decorators), Visitor::processAttrsInitializersAndValidators$lambda$39$lambda$35), Visitor::processAttrsInitializersAndValidators$lambda$39$lambda$36), Visitor::processAttrsInitializersAndValidators$lambda$39$lambda$37);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String message;
                    int n;
                    String it = (String)element$iv;
                    boolean bl = false;
                    String string = it;
                    if (Intrinsics.areEqual((Object)string, (Object)"default")) {
                        n = 1;
                    } else {
                        if (!Intrinsics.areEqual((Object)string, (Object)"validator")) continue;
                        n = 3;
                    }
                    int expectedParameters = n;
                    PyAstParameterList pyAstParameterList = method.getParameterList();
                    Intrinsics.checkNotNullExpressionValue((Object)pyAstParameterList, (String)"getParameterList(...)");
                    PyParameterList actualParameters = (PyParameterList)pyAstParameterList;
                    if (actualParameters.getParameters().length == expectedParameters) continue;
                    Object[] objectArray = new Object[]{method.getName(), expectedParameters};
                    Intrinsics.checkNotNullExpressionValue((Object)PyPsiBundle.message("INSP.dataclasses.method.should.take.only.n.parameter", objectArray), (String)"message(...)");
                    this$0.registerProblem((PsiElement)actualParameters, message, ProblemHighlightType.GENERIC_ERROR);
                }
            }
            return true;
        }

        private static final boolean processAttrsInitializersAndValidators$lambda$40(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }

        private static final boolean processAnnotationsExistence$lambda$41(PyClass $cls, PyDataclassParameters $dataclassParameters, Visitor this$0, PsiElement element, ResolveState resolveState) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)resolveState, (String)"<unused var>");
            if (element instanceof PyTargetExpression && ((PyTargetExpression)element).getAnnotation() == null) {
                PyTargetExpression pyTargetExpression = (PyTargetExpression)element;
                TypeEvalContext typeEvalContext = this$0.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                if (PyDataclassesKt.resolveDataclassFieldParameters($cls, $dataclassParameters, pyTargetExpression, typeEvalContext) != null) {
                    Object[] objectArray = new Object[]{((PyTargetExpression)element).getName()};
                    this$0.registerProblem(element, PyPsiBundle.message("INSP.dataclasses.attribute.lacks.type.annotation", objectArray), ProblemHighlightType.GENERIC_ERROR);
                }
            }
            return true;
        }

        private static final boolean processAttrIbFunctionCalls$lambda$42(PyClass $dataclass, PyDataclassParameters $dataclassParameters, Visitor this$0, PsiElement element, ResolveState resolveState) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)resolveState, (String)"<unused var>");
            if (element instanceof PyTargetExpression) {
                PyCallExpression call;
                PyTargetExpression pyTargetExpression = (PyTargetExpression)element;
                TypeEvalContext typeEvalContext = this$0.myTypeEvalContext;
                Intrinsics.checkNotNullExpressionValue((Object)typeEvalContext, (String)"myTypeEvalContext");
                PyDataclassFieldParameters fieldParams = PyDataclassesKt.resolveDataclassFieldParameters($dataclass, $dataclassParameters, pyTargetExpression, typeEvalContext);
                PyExpression pyExpression = ((PyTargetExpression)element).findAssignedValue();
                PyCallExpression pyCallExpression = call = pyExpression instanceof PyCallExpression ? (PyCallExpression)pyExpression : null;
                if (call != null && fieldParams != null && fieldParams.getHasDefaultFactory()) {
                    if (fieldParams.getHasDefault()) {
                        this$0.registerProblem((PsiElement)call.getArgumentList(), PyPsiBundle.message("INSP.dataclasses.cannot.specify.both.default.and.factory", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                    } else {
                        PyExpression pyExpression2 = call.getKeywordArgument("default");
                        PyExpression factory = call.getKeywordArgument("factory");
                        if (pyExpression2 != null && factory != null && !PyDataclassesKt.resolvesToOmittedDefault(pyExpression2, PyDataclassParameters.PredefinedType.ATTRS)) {
                            this$0.registerProblem((PsiElement)call.getArgumentList(), PyPsiBundle.message("INSP.dataclasses.cannot.specify.both.default.and.factory", new Object[0]), ProblemHighlightType.GENERIC_ERROR);
                        }
                    }
                }
            }
            return true;
        }

        private static final boolean processPostInitDefinition$lambda$43(Visitor this$0, List $allInitVars, PsiElement element, ResolveState resolveState) {
            PyType fieldType;
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)resolveState, (String)"<unused var>");
            if (element instanceof PyTargetExpression && this$0.isInitVar(fieldType = this$0.myTypeEvalContext.getType((PyTypedElement)element))) {
                $allInitVars.add(this$0.getInitVarType(fieldType));
            }
            return true;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/python/inspections/PyDataclassInspection$Visitor$InitVarField;", "", "type", "Lcom/jetbrains/python/psi/types/PyType;", "<init>", "(Lcom/jetbrains/python/psi/types/PyType;)V", "getType", "()Lcom/jetbrains/python/psi/types/PyType;", "intellij.python.psi.impl"})
        private static final class InitVarField {
            @Nullable
            private final PyType type;

            public InitVarField(@Nullable PyType type2) {
                this.type = type2;
            }

            @Nullable
            public final PyType getType() {
                return this.type;
            }
        }
    }
}

