/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.requirements;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.packaging.PyPackageNameNormalizeUtilKt;
import com.jetbrains.python.packaging.management.PythonPackageManager;
import com.jetbrains.python.requirements.InstallAllRequirementsQuickFix;
import com.jetbrains.python.requirements.InstallProjectAsEditableQuickfix;
import com.jetbrains.python.requirements.InstallRequirementQuickFix;
import com.jetbrains.python.requirements.PackageUtilsKt;
import com.jetbrains.python.requirements.PyGenerateRequirementsFileQuickFix;
import com.jetbrains.python.requirements.RequirementsFile;
import com.jetbrains.python.requirements.RequirementsInspectionVisitor;
import com.jetbrains.python.requirements.psi.Requirement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/python/requirements/UnsatisfiedRequirementInspectionVisitor;", "Lcom/jetbrains/python/requirements/RequirementsInspectionVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "session", "Lcom/intellij/codeInspection/LocalInspectionToolSession;", "<init>", "(Lcom/intellij/codeInspection/ProblemsHolder;Lcom/intellij/codeInspection/LocalInspectionToolSession;)V", "visitRequirementsFile", "", "element", "Lcom/jetbrains/python/requirements/RequirementsFile;", "intellij.python.community.impl"})
@SourceDebugExtension(value={"SMAP\nUnsatisfiedRequirementInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UnsatisfiedRequirementInspection.kt\ncom/jetbrains/python/requirements/UnsatisfiedRequirementInspectionVisitor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,247:1\n1557#2:248\n1628#2,3:249\n774#2:252\n865#2,2:253\n1863#2,2:255\n*S KotlinDebug\n*F\n+ 1 UnsatisfiedRequirementInspection.kt\ncom/jetbrains/python/requirements/UnsatisfiedRequirementInspectionVisitor\n*L\n60#1:248\n60#1:249,3\n61#1:252\n61#1:253,2\n62#1:255,2\n*E\n"})
final class UnsatisfiedRequirementInspectionVisitor
extends RequirementsInspectionVisitor {
    public UnsatisfiedRequirementInspectionVisitor(@NotNull ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        super(holder, session);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitRequirementsFile(@NotNull RequirementsFile element) {
        void $this$filterTo$iv$iv;
        Object[] objectArray;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        Sdk sdk2 = PackageUtilsKt.getPythonSdk((PsiFile)element);
        if (sdk2 == null) {
            return;
        }
        Sdk sdk3 = sdk2;
        CharSequence charSequence = element.getText();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            PyGenerateRequirementsFileQuickFix[] pyGenerateRequirementsFileQuickFixArray;
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)((PsiElement)element));
            if (module != null) {
                Module module2 = module;
                boolean bl = false;
                PyGenerateRequirementsFileQuickFix[] pyGenerateRequirementsFileQuickFixArray2 = new PyGenerateRequirementsFileQuickFix[]{new PyGenerateRequirementsFileQuickFix(module2)};
                pyGenerateRequirementsFileQuickFixArray = pyGenerateRequirementsFileQuickFixArray2;
            } else {
                pyGenerateRequirementsFileQuickFixArray = new PyGenerateRequirementsFileQuickFix[]{};
            }
            PyGenerateRequirementsFileQuickFix[] fixes = pyGenerateRequirementsFileQuickFixArray;
            this.getHolder().registerProblem((PsiElement)element, PyPsiBundle.message("INSP.package.requirements.requirements.file.empty", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, (LocalQuickFix[])Arrays.copyOf(fixes, fixes.length));
            return;
        }
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        PythonPackageManager packageManager = PythonPackageManager.Companion.forSdk(project, sdk3);
        Iterable $this$map$iv = packageManager.getInstalledPackages();
        boolean $i$f$map = false;
        Iterable module2 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            objectArray = (LocalQuickFix[])item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PyPackageNameNormalizeUtilKt.normalizePackageName(it.getName()));
        }
        List packages2 = (List)destination$iv$iv;
        Iterable $this$filter$iv = element.requirements();
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Requirement requirement = (Requirement)element$iv$iv;
            boolean bl = false;
            if (!(!packages2.contains(PyPackageNameNormalizeUtilKt.normalizePackageName(requirement.getDisplayName())))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List unsatisfiedRequirements = (List)destination$iv$iv2;
        Iterable $this$forEach$iv = unsatisfiedRequirements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Requirement requirement = (Requirement)element$iv;
            boolean bl = false;
            objectArray = new LocalQuickFix[]{new InstallRequirementQuickFix(requirement), new InstallAllRequirementsQuickFix(unsatisfiedRequirements), new InstallProjectAsEditableQuickfix()};
            LocalQuickFix[] fixes = objectArray;
            objectArray = new Object[]{requirement.getDisplayName()};
            this.getHolder().registerProblem((PsiElement)requirement, PyBundle.message("INSP.requirements.package.not.installed", objectArray), ProblemHighlightType.WARNING, Arrays.copyOf(fixes, fixes.length));
        }
    }
}

