/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.target.TargetBasedSdks;
import com.intellij.execution.target.TargetEnvironmentConfiguration;
import com.intellij.ide.DataManager;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.KeyWithDefaultValue;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.reference.SoftReference;
import com.intellij.remote.ExceptionFix;
import com.intellij.remote.VagrantNotStartedException;
import com.intellij.remote.ext.CredentialsCase;
import com.intellij.remote.ext.LanguageCaseCollector;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.icons.PythonPsiApiIcons;
import com.jetbrains.python.remote.PyCredentialsContribution;
import com.jetbrains.python.remote.PyRemoteInterpreterUtil;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PythonRemoteInterpreterManager;
import com.jetbrains.python.sdk.CustomSdkHomePattern;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PreferredSdkComparator;
import com.jetbrains.python.sdk.PyDetectedSdk;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PySdkProvider;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonEnvUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkUpdater;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.add.PyAddSdkDialog;
import com.jetbrains.python.sdk.add.v1.PyDetectedSdkAdditionalData;
import com.jetbrains.python.sdk.flavors.CPythonSdkFlavor;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import com.jetbrains.python.target.PyInterpreterVersionUtil;
import com.jetbrains.python.target.PyTargetAwareAdditionalData;
import java.awt.Component;
import java.io.File;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import javax.swing.JComponent;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonSdkType
extends SdkType {
    @ApiStatus.Internal
    @NotNull
    public static final Key<List<String>> MOCK_SYS_PATH_KEY = Key.create((String)"PY_MOCK_SYS_PATH_KEY");
    @ApiStatus.Internal
    @NotNull
    public static final Key<String> MOCK_PY_VERSION_KEY = Key.create((String)"PY_MOCK_PY_VERSION_KEY");
    @ApiStatus.Internal
    @NotNull
    public static final Key<Boolean> MOCK_PY_MARKER_KEY = KeyWithDefaultValue.create((String)"MOCK_PY_MARKER_KEY", (Object)true);
    private static final Logger LOG = Logger.getInstance(PythonSdkType.class);
    private static final int MINUTE = 60000;
    @NonNls
    private static final String SKELETONS_TOPIC = "Skeletons";
    private static final Key<WeakReference<Component>> SDK_CREATOR_COMPONENT_KEY = Key.create((String)"#com.jetbrains.python.sdk.creatorComponent");
    @NotNull
    private static final String LEGACY_TARGET_PREFIX = "target://";

    public static PythonSdkType getInstance() {
        return (PythonSdkType)SdkType.findInstance(PythonSdkType.class);
    }

    private PythonSdkType() {
        super("Python SDK");
    }

    public Icon getIcon() {
        return PythonPsiApiIcons.Python;
    }

    @NotNull
    public String getHelpTopic() {
        return "reference.project.structure.sdk.python";
    }

    @NonNls
    @Nullable
    public String suggestHomePath() {
        return null;
    }

    @NotNull
    public Collection<String> suggestHomePaths() {
        Sdk[] existingSdks = (Sdk[])ReadAction.compute(() -> ProjectJdkTable.getInstance().getAllJdks());
        List<PyDetectedSdk> sdks2 = PySdkExtKt.detectSystemWideSdks(null, Arrays.asList(existingSdks));
        PyDetectedSdk latest = StreamEx.of(sdks2).findFirst().orElse(null);
        if (latest != null) {
            Set<String> set = Collections.singleton(latest.getHomePath());
            if (set == null) {
                PythonSdkType.$$$reportNull$$$0(0);
            }
            return set;
        }
        List<String> list = Collections.emptyList();
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Deprecated
    @RequiresBackgroundThread(generateAssertion=false)
    public boolean isValidSdkHome(@NotNull String localPath) {
        if (localPath == null) {
            PythonSdkType.$$$reportNull$$$0(2);
        }
        try {
            return PythonSdkType.isLocalPathValid(Paths.get(localPath, new String[0]));
        }
        catch (InvalidPathException e) {
            return false;
        }
    }

    @RequiresBackgroundThread(generateAssertion=false)
    private static boolean isLocalPathValid(@NotNull Path path2) {
        if (path2 == null) {
            PythonSdkType.$$$reportNull$$$0(3);
        }
        return PythonSdkFlavor.getFlavor(path2.toString()) != null;
    }

    @NotNull
    public FileChooserDescriptor getHomeChooserDescriptor() {
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(true, false, false, false, false, false){

            public void validateSelectedFiles(VirtualFile @NotNull [] files) throws Exception {
                VirtualFile file;
                if (files == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (files.length != 0 && !PythonSdkType.isLocatedInWsl(file = files[0]) && !PythonSdkType.isLocalPathValid(file.toNioPath())) {
                    throw new Exception(PyBundle.message("python.sdk.error.invalid.interpreter.selected", file.getName()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/jetbrains/python/sdk/PythonSdkType$1", "validateSelectedFiles"));
            }
        }.withTitle(PyBundle.message("sdk.select.path", new Object[0])).withShowHiddenFiles(SystemInfo.isUnix);
        if (SystemInfo.isMac) {
            descriptor2.setForcedToUseIdeaFileChooser(true);
        }
        FileChooserDescriptor fileChooserDescriptor = descriptor2;
        if (fileChooserDescriptor == null) {
            PythonSdkType.$$$reportNull$$$0(4);
        }
        return fileChooserDescriptor;
    }

    private static boolean isLocatedInWsl(@NotNull VirtualFile file) {
        if (file == null) {
            PythonSdkType.$$$reportNull$$$0(5);
        }
        return SystemInfo.isWindows && PythonSdkType.isCustomPythonSdkHomePath(file.getPath());
    }

    public boolean supportsCustomCreateUI() {
        return true;
    }

    public void showCustomCreateUI(@NotNull SdkModel sdkModel, @NotNull JComponent parentComponent, @Nullable Sdk selectedSdk, @NotNull Consumer<? super Sdk> sdkCreatedCallback) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(6);
        }
        if (parentComponent == null) {
            PythonSdkType.$$$reportNull$$$0(7);
        }
        if (sdkCreatedCallback == null) {
            PythonSdkType.$$$reportNull$$$0(8);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)parentComponent));
        PyAddSdkDialog.show(project, null, Arrays.asList(sdkModel.getSdks()), sdk2 -> {
            if (sdk2 != null) {
                sdk2.putUserData(SDK_CREATOR_COMPONENT_KEY, new WeakReference<JComponent>(parentComponent));
                sdkCreatedCallback.consume(sdk2);
            }
        });
    }

    public static void patchCommandLineForVirtualenv(@NotNull GeneralCommandLine commandLine, @NotNull Sdk sdk2) {
        if (commandLine == null) {
            PythonSdkType.$$$reportNull$$$0(9);
        }
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(10);
        }
        PythonSdkType.patchEnvironmentVariablesForVirtualenv(commandLine.getEnvironment(), sdk2);
    }

    public static void patchEnvironmentVariablesForVirtualenv(@NotNull Map<String, String> environment, @NotNull Sdk sdk2) {
        Map<String, String> virtualEnv;
        if (environment == null) {
            PythonSdkType.$$$reportNull$$$0(11);
        }
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(12);
        }
        if (!(virtualEnv = PySdkUtil.activateVirtualEnv(sdk2)).isEmpty()) {
            for (Map.Entry<String, String> entry : virtualEnv.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (environment.containsKey(key)) {
                    if (!key.equalsIgnoreCase("PATH")) continue;
                    PythonEnvUtil.addToPathEnvVar(environment.get(key), value, false);
                    continue;
                }
                environment.put(key, value);
            }
        }
    }

    @NotNull
    public String suggestSdkName(@Nullable String currentSdkName, @NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(13);
        }
        String name2 = StringUtil.notNullize((String)PythonSdkType.suggestBaseSdkName(sdkHome), (String)"Unknown");
        File virtualEnvRoot = PythonSdkUtil.getVirtualEnvRoot(sdkHome);
        if (virtualEnvRoot != null) {
            String path2 = FileUtil.getLocationRelativeToUserHome((String)virtualEnvRoot.getAbsolutePath());
            String string = name2 + " virtualenv at " + path2;
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = name2;
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(15);
        }
        return string;
    }

    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static String suggestBaseSdkName(@NotNull String sdkHome) {
        PythonSdkFlavor<?> flavor;
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(16);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(sdkHome)) == null) {
            return null;
        }
        return flavor.getName() + " " + String.valueOf(flavor.getLanguageLevel(sdkHome));
    }

    @Nullable
    public AdditionalDataConfigurable createAdditionalDataConfigurable(@NotNull SdkModel sdkModel, @NotNull SdkModificator sdkModificator) {
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(17);
        }
        if (sdkModificator == null) {
            PythonSdkType.$$$reportNull$$$0(18);
        }
        return null;
    }

    public void saveAdditionalData(@NotNull SdkAdditionalData additionalData, @NotNull Element additional) {
        if (additionalData == null) {
            PythonSdkType.$$$reportNull$$$0(19);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(20);
        }
        if (additionalData instanceof PythonSdkAdditionalData) {
            ((PythonSdkAdditionalData)additionalData).save(additional);
        }
    }

    public SdkAdditionalData loadAdditionalData(@NotNull Sdk currentSdk, @NotNull Element additional) {
        String homePath;
        if (currentSdk == null) {
            PythonSdkType.$$$reportNull$$$0(21);
        }
        if (additional == null) {
            PythonSdkType.$$$reportNull$$$0(22);
        }
        if ((homePath = currentSdk.getHomePath()) != null) {
            PythonRemoteInterpreterManager manager;
            if (homePath.startsWith(LEGACY_TARGET_PREFIX)) {
                ((SdkModificator)currentSdk).setHomePath(homePath.substring(LEGACY_TARGET_PREFIX.length()));
            }
            if (additional.getAttributeBooleanValue("IS_DETECTED")) {
                PyDetectedSdkAdditionalData data2 = new PyDetectedSdkAdditionalData(null, null);
                data2.load(additional);
                TargetEnvironmentConfiguration targetEnvironmentConfiguration = TargetBasedSdks.loadTargetConfiguration((Element)additional);
                if (targetEnvironmentConfiguration != null) {
                    data2.setTargetEnvironmentConfiguration(targetEnvironmentConfiguration);
                }
                return data2;
            }
            PyTargetAwareAdditionalData targetAdditionalData = PyTargetAwareAdditionalData.loadTargetAwareData(currentSdk, additional);
            if (targetAdditionalData != null) {
                return targetAdditionalData;
            }
            if (PythonSdkType.isCustomPythonSdkHomePath(homePath) && (manager = PythonRemoteInterpreterManager.getInstance()) != null) {
                return manager.loadRemoteSdkData(currentSdk, additional);
            }
        }
        SdkAdditionalData additionalData = PySdkProvider.EP_NAME.getExtensionList().stream().map(ext -> ext.loadAdditionalDataForSdk(additional)).filter(data -> data != null).findFirst().orElseGet(() -> PythonSdkAdditionalData.loadFromElement(additional));
        return additionalData;
    }

    @Contract(pure=true)
    static boolean isCustomPythonSdkHomePath(@NotNull String homePath) {
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(23);
        }
        return CustomSdkHomePattern.isCustomPythonSdkHomePath(homePath);
    }

    public static boolean isSkeletonsPath(String path2) {
        return path2.contains("python_stubs");
    }

    @NotNull
    @NonNls
    public String getPresentableName() {
        return "Python SDK";
    }

    @NotNull
    public String sdkPath(@NotNull VirtualFile homePath) {
        VirtualFile sdkPath;
        String path2;
        PythonSdkFlavor<?> flavor;
        if (homePath == null) {
            PythonSdkType.$$$reportNull$$$0(24);
        }
        if ((flavor = PythonSdkFlavor.getFlavor(path2 = super.sdkPath(homePath))) != null && (sdkPath = flavor.getSdkPath(homePath)) != null) {
            String string = FileUtil.toSystemDependentName((String)sdkPath.getPath());
            if (string == null) {
                PythonSdkType.$$$reportNull$$$0(25);
            }
            return string;
        }
        String string = FileUtil.toSystemDependentName((String)path2);
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(26);
        }
        return string;
    }

    public void setupSdkPaths(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(27);
        }
        if (PlatformUtils.isFleetBackend()) {
            return;
        }
        WeakReference ownerComponentRef = (WeakReference)sdk2.getUserData(SDK_CREATOR_COMPONENT_KEY);
        Component ownerComponent = (Component)SoftReference.dereference((Reference)ownerComponentRef);
        AtomicReference projectRef = new AtomicReference();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            if (ownerComponent != null) {
                projectRef.set((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext(ownerComponent)));
            } else {
                projectRef.set((Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext()));
            }
        });
        PythonSdkUpdater.updateOrShowError(sdk2, (Project)projectRef.get(), ownerComponent);
    }

    public boolean setupSdkPaths(@NotNull Sdk sdk2, @NotNull SdkModel sdkModel) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(28);
        }
        if (sdkModel == null) {
            PythonSdkType.$$$reportNull$$$0(29);
        }
        return true;
    }

    public static void notifyRemoteSdkSkeletonsFail(InvalidSdkException e, @Nullable Runnable restartAction) {
        String notificationMessage;
        NotificationListener notificationListener;
        if (e.getCause() instanceof VagrantNotStartedException) {
            notificationListener = (notification2, event) -> {
                PythonRemoteInterpreterManager manager = PythonRemoteInterpreterManager.getInstance();
                if (manager != null) {
                    try {
                        VagrantNotStartedException cause = (VagrantNotStartedException)e.getCause();
                        manager.runVagrant(cause.getVagrantFolder(), cause.getMachineName());
                    }
                    catch (ExecutionException e1) {
                        throw new RuntimeException(e1);
                    }
                }
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = new HtmlBuilder().append(e.getMessage()).appendLink("#", PyBundle.message("python.vagrant.refresh.skeletons", new Object[0])).toString();
        } else if (ExceptionUtil.causedBy((Throwable)e, ExceptionFix.class)) {
            ExceptionFix fix = (ExceptionFix)ExceptionUtil.findCause((Throwable)e, ExceptionFix.class);
            notificationListener = (notification2, event) -> {
                fix.apply();
                if (restartAction != null) {
                    restartAction.run();
                }
            };
            notificationMessage = fix.getNotificationMessage(e.getMessage());
        } else {
            notificationListener = null;
            notificationMessage = e.getMessage();
        }
        Notification notification3 = new Notification("Python SDK Updater", PyBundle.message("sdk.gen.failed.notification.title", new Object[0]), notificationMessage, NotificationType.WARNING);
        if (notificationListener != null) {
            notification3.setListener(notificationListener);
        }
        notification3.notify(null);
    }

    @NotNull
    public static VirtualFile getSdkRootVirtualFile(@NotNull VirtualFile path2) {
        VirtualFile jar;
        String suffix;
        if (path2 == null) {
            PythonSdkType.$$$reportNull$$$0(30);
        }
        if ((suffix = path2.getExtension()) != null) {
            suffix = StringUtil.toLowerCase((String)suffix);
        }
        if (!path2.isDirectory() && ("zip".equals(suffix) || "egg".equals(suffix)) && (jar = JarFileSystem.getInstance().getJarRootForLocalFile(path2)) != null) {
            VirtualFile virtualFile = jar;
            if (virtualFile == null) {
                PythonSdkType.$$$reportNull$$$0(31);
            }
            return virtualFile;
        }
        VirtualFile virtualFile = path2;
        if (virtualFile == null) {
            PythonSdkType.$$$reportNull$$$0(32);
        }
        return virtualFile;
    }

    public String getVersionString(@NotNull Sdk sdk2) {
        String version2;
        SdkAdditionalData sdkAdditionalData;
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(33);
        }
        if ((sdkAdditionalData = sdk2.getSdkAdditionalData()) instanceof PyTargetAwareAdditionalData) {
            String versionString;
            try {
                versionString = PyInterpreterVersionUtil.getInterpreterVersion((PyTargetAwareAdditionalData)sdkAdditionalData, null, true);
            }
            catch (Exception e) {
                versionString = "undefined";
            }
            return versionString;
        }
        if (sdkAdditionalData instanceof PyRemoteSdkAdditionalDataBase) {
            PyRemoteSdkAdditionalDataBase data = (PyRemoteSdkAdditionalDataBase)sdkAdditionalData;
            assert (data != null);
            String versionString = data.getVersionString();
            if (StringUtil.isEmpty((String)versionString)) {
                try {
                    versionString = PyRemoteInterpreterUtil.getInterpreterVersion(null, data, true);
                }
                catch (Exception e) {
                    LOG.warn("Couldn't get interpreter version:" + e.getMessage(), (Throwable)e);
                    versionString = "undefined";
                }
                data.setVersionString(versionString);
            }
            return versionString;
        }
        if (ApplicationManager.getApplication().isUnitTestMode() && (version2 = (String)sdk2.getUserData(MOCK_PY_VERSION_KEY)) != null) {
            return version2;
        }
        String homePath = sdk2.getHomePath();
        return homePath == null ? null : this.getVersionString(homePath);
    }

    @Nullable
    public String getVersionString(@NotNull String sdkHome) {
        if (sdkHome == null) {
            PythonSdkType.$$$reportNull$$$0(34);
        }
        if (PythonSdkType.isCustomPythonSdkHomePath(sdkHome)) {
            return null;
        }
        PythonSdkFlavor<?> flavor = PythonSdkFlavor.getFlavor(sdkHome);
        return flavor != null ? PythonSdkFlavor.getVersionStringStatic(sdkHome) : null;
    }

    public boolean isRootTypeApplicable(@NotNull OrderRootType type2) {
        if (type2 == null) {
            PythonSdkType.$$$reportNull$$$0(35);
        }
        return type2 == OrderRootType.CLASSES;
    }

    public boolean sdkHasValidPath(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(36);
        }
        if (PythonSdkUtil.isRemote(sdk2)) {
            return true;
        }
        VirtualFile homeDir = sdk2.getHomeDirectory();
        return homeDir != null && homeDir.isValid();
    }

    public static boolean isIncompleteRemote(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(37);
        }
        return sdk2.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase && !((PyRemoteSdkAdditionalDataBase)sdk2.getSdkAdditionalData()).isValid();
    }

    public static boolean isRunAsRootViaSudo(@NotNull Sdk sdk2) {
        PyTargetAwareAdditionalData pyTargetAwareAdditionalData;
        PyRemoteSdkAdditionalDataBase pyRemoteSdkAdditionalData;
        SdkAdditionalData data;
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(38);
        }
        return (data = sdk2.getSdkAdditionalData()) instanceof PyRemoteSdkAdditionalDataBase && (pyRemoteSdkAdditionalData = (PyRemoteSdkAdditionalDataBase)data).isRunAsRootViaSudo() || data instanceof PyTargetAwareAdditionalData && (pyTargetAwareAdditionalData = (PyTargetAwareAdditionalData)data).isRunAsRootViaSudo();
    }

    public static boolean hasInvalidRemoteCredentials(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(39);
        }
        if (sdk2.getSdkAdditionalData() instanceof PyRemoteSdkAdditionalDataBase) {
            final Ref result2 = Ref.create((Object)false);
            ((PyRemoteSdkAdditionalDataBase)sdk2.getSdkAdditionalData()).switchOnConnectionType(new LanguageCaseCollector<PyCredentialsContribution>(){

                protected void processLanguageContribution(PyCredentialsContribution languageContribution, Object credentials) {
                    result2.set((Object)(!languageContribution.isValid(credentials) ? 1 : 0));
                }
            }.collectCases(PyCredentialsContribution.class, new CredentialsCase[0]));
            return (Boolean)result2.get();
        }
        return false;
    }

    @NotNull
    public static String getSdkKey(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(40);
        }
        String string = sdk2.getName();
        if (string == null) {
            PythonSdkType.$$$reportNull$$$0(41);
        }
        return string;
    }

    public boolean isLocalSdk(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(42);
        }
        return !PythonSdkUtil.isRemote(sdk2);
    }

    @Nullable
    public static Sdk findLocalCPython(@Nullable Module module) {
        Sdk moduleSDK = PythonSdkUtil.findPythonSdk(module);
        return PythonSdkType.findLocalCPythonForSdk(moduleSDK);
    }

    @Nullable
    public static Sdk findLocalCPythonForSdk(@Nullable Sdk existingSdk) {
        if (existingSdk != null && !PythonSdkUtil.isRemote(existingSdk) && PythonSdkFlavor.getFlavor(existingSdk) instanceof CPythonSdkFlavor) {
            return existingSdk;
        }
        for (Sdk sdk2 : ContainerUtil.sorted(PythonSdkUtil.getAllSdks(), (Comparator)PreferredSdkComparator.INSTANCE)) {
            if (PythonSdkUtil.isRemote(sdk2)) continue;
            return sdk2;
        }
        return null;
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public static LanguageLevel getLanguageLevelForSdk(@Nullable Sdk sdk2) {
        LanguageLevel languageLevel = PySdkUtil.getLanguageLevelForSdk(sdk2);
        if (languageLevel == null) {
            PythonSdkType.$$$reportNull$$$0(43);
        }
        return languageLevel;
    }

    public boolean allowWslSdkForLocalProject() {
        return true;
    }

    public static boolean isMock(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(44);
        }
        return sdk2.getUserData(MOCK_PY_VERSION_KEY) != null || sdk2.getUserData(MOCK_SYS_PATH_KEY) != null || sdk2.getUserData(MOCK_PY_MARKER_KEY) != null;
    }

    @NotNull
    public static List<String> getMockPath(@NotNull Sdk sdk2) {
        if (sdk2 == null) {
            PythonSdkType.$$$reportNull$$$0(45);
        }
        String workDir = Paths.get(Objects.requireNonNull(sdk2.getHomePath()), new String[0]).getParent().toString();
        List mockPaths = (List)sdk2.getUserData(MOCK_SYS_PATH_KEY);
        List<Object> list = mockPaths != null ? Collections.unmodifiableList(mockPaths) : Collections.singletonList(workDir);
        if (list == null) {
            PythonSdkType.$$$reportNull$$$0(46);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 33, 34, 35, 36, 37, 38, 39, 40, 42, 44, 45 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localPath";
                break;
            }
            case 3: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 17: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentComponent";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkCreatedCallback";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLine";
                break;
            }
            case 10: 
            case 12: 
            case 27: 
            case 28: 
            case 33: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 13: 
            case 16: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHome";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkModificator";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalData";
                break;
            }
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additional";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSdk";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "homePath";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestHomePaths";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/PythonSdkType";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHomeChooserDescriptor";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestSdkName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "sdkPath";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkRootVirtualFile";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkKey";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguageLevelForSdk";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "getMockPath";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isValidSdkHome";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isLocalPathValid";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isLocatedInWsl";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showCustomCreateUI";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "patchCommandLineForVirtualenv";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "patchEnvironmentVariablesForVirtualenv";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestSdkName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "suggestBaseSdkName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createAdditionalDataConfigurable";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveAdditionalData";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "loadAdditionalData";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isCustomPythonSdkHomePath";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "sdkPath";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "setupSdkPaths";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getSdkRootVirtualFile";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getVersionString";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isRootTypeApplicable";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "sdkHasValidPath";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isIncompleteRemote";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isRunAsRootViaSudo";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "hasInvalidRemoteCredentials";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getSdkKey";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isLocalSdk";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "isMock";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getMockPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 17, 18, 19, 20, 21, 22, 23, 24, 27, 28, 29, 30, 33, 34, 35, 36, 37, 38, 39, 40, 42, 44, 45 -> new IllegalArgumentException(string);
        };
    }
}

