/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.fix;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.DockerObjectAccessor;
import java.io.IOException;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B#\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\u0003H\u0014J\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/agent/fix/DockerObjectDeserializerCopy;", "Lcom/fasterxml/jackson/databind/deser/std/DelegatingDeserializer;", "delegate", "Lcom/fasterxml/jackson/databind/JsonDeserializer;", "beanDescription", "Lcom/fasterxml/jackson/databind/BeanDescription;", "originalMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "<init>", "(Lcom/fasterxml/jackson/databind/JsonDeserializer;Lcom/fasterxml/jackson/databind/BeanDescription;Lcom/fasterxml/jackson/databind/ObjectMapper;)V", "newDelegatingInstance", "newDelegatee", "deserialize", "", "p", "Lcom/fasterxml/jackson/core/JsonParser;", "ctxt", "Lcom/fasterxml/jackson/databind/DeserializationContext;", "intellij.clouds.docker.agent"})
final class DockerObjectDeserializerCopy
extends DelegatingDeserializer {
    @NotNull
    private final BeanDescription beanDescription;
    @NotNull
    private final ObjectMapper originalMapper;

    public DockerObjectDeserializerCopy(@NotNull JsonDeserializer<?> delegate, @NotNull BeanDescription beanDescription, @NotNull ObjectMapper originalMapper) {
        Intrinsics.checkNotNullParameter(delegate, (String)"delegate");
        Intrinsics.checkNotNullParameter((Object)beanDescription, (String)"beanDescription");
        Intrinsics.checkNotNullParameter((Object)originalMapper, (String)"originalMapper");
        super(delegate);
        this.beanDescription = beanDescription;
        this.originalMapper = originalMapper;
    }

    @NotNull
    protected JsonDeserializer<?> newDelegatingInstance(@NotNull JsonDeserializer<?> newDelegatee) {
        Intrinsics.checkNotNullParameter(newDelegatee, (String)"newDelegatee");
        return (JsonDeserializer)new DockerObjectDeserializerCopy(newDelegatee, this.beanDescription, this.originalMapper);
    }

    @Nullable
    public Object deserialize(@NotNull JsonParser p, @Nullable DeserializationContext ctxt) throws IOException {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        JsonNode jsonNode = (JsonNode)p.readValueAsTree();
        Object deserializedObject = this.originalMapper.treeToValue((TreeNode)jsonNode, this.beanDescription.getBeanClass());
        if (deserializedObject instanceof DockerObject) {
            DockerObject dockerObject = (DockerObject)deserializedObject;
            Object object = this.originalMapper.convertValue((Object)jsonNode, HashMap.class);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.util.HashMap<kotlin.String, kotlin.Any>");
            DockerObjectAccessor.overrideRawValues(dockerObject, (HashMap)object);
        }
        return deserializedObject;
    }
}

