// noinspection ES6UnusedImports
import type from "./tsserverlibrary.shim"

export function throwIdeError(kind: ErrorKind): never {
  let error = new Error(kind)
  error.ideKind = kind
  throw error
}

export function equalOwnPropertiesDeep<T>(left: Record<string, T> | undefined, right: Record<string, T> | undefined, compared: Set<any> = new Set<any>()): boolean {
  if (left === right) return true;
  if (!left || !right) return false;
  for (const key in left) {
    if (left.hasOwnProperty(key)) {
      if (!right.hasOwnProperty(key)) return false;
      if (!equalsDeep(left[key], right[key], compared)) return false;
    }
  }

  for (const key in right) {
    if (right.hasOwnProperty(key)) {
      if (!left.hasOwnProperty(key)) return false;
    }
  }

  return true;
}

function equalsDeep(left: any, right: any, compared: Set<any>): boolean {
  if (typeof left === "object" && typeof right === "object") {
    if (compared.has(left) || compared.has(right)) return false;
    compared.add(left);
    compared.add(right);
    try {
      return equalOwnPropertiesDeep(left, right, compared);
    } finally {
      compared.delete(left);
      compared.delete(right);
    }
  }
  return left === right;
}