/* Copyright (C) 2022 Alif Semiconductor - All Rights Reserved.
 * Use, distribution and modification of this code is permitted under the
 * terms stated in the Alif Semiconductor Software License Agreement
 *
 * You should have received a copy of the Alif Semiconductor Software
 * License Agreement with this file. If not, please write to:
 * contact@alifsemi.com, or visit: https://alifsemi.com/license
 *
 */

#ifndef GLOBAL_MAP_H
#define GLOBAL_MAP_H


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define CLKCTL_SYS_BASE             0x1A010000UL
#define WDT_AP_CTRL_BASE            0x1A300000UL
#define WDT_AP_REFRESH_BASE         0x1A310000UL
#define WDT_AP_S_CTRL_BASE          0x1A320000UL
#define WDT_AP_S_REFRESH_BASE       0x1A330000UL
#define S32K_CNTControl_BASE        0x1A400000UL
#define S32K_CNTRead_BASE           0x1A410000UL
#define IRQRTR_BASE                 0x1A500000UL
#define CGU_BASE                    0x1A602000UL
#define PINMUX_BASE                 0x1A603000UL
#define AON_BASE                    0x1A604000UL
#define AONEXP_SECENC__internal_BASE 0x1A605000UL
#define AONEXP_MODEM__internal_BASE 0x1A606000UL
#define SECENC_EWIC__internal_BASE  0x1A607000UL
#define VBAT_BASE                   0x1A609000UL
#define ANA_BASE                    0x1A60A000UL
#define VBATMDM__internal_BASE      0x1A60B000UL
#define STOP_MODE_BASE              0x1A60F000UL
#define FCTLR_BASE                  0x1A800000UL
#define FC1_BASE                    0x1A810000UL
#define FC2_BASE                    0x1A820000UL
#define FC3_BASE                    0x1A830000UL
#define FC4_BASE                    0x1A840000UL
#define FC5_BASE                    0x1A850000UL
#define FC6_BASE                    0x1A860000UL
#define FC7_BASE                    0x1A870000UL
#define FC8_BASE                    0x1A880000UL
#define FC9_BASE                    0x1A890000UL
#define FC10_BASE                   0x1A8A0000UL
#define FC11_BASE                   0x1A8B0000UL
#define FC12_BASE                   0x1A8C0000UL
#define FC13_BASE                   0x1A8D0000UL
#define FC14_BASE                   0x1A8E0000UL
#define LPRTC_BASE                  0x42000000UL
#define LPTIMER_BASE                0x42001000UL
#define LPGPIO_BASE                 0x42002000UL
#define LPGPIO_CTRL_BASE            0x42007000UL
#define LPSPI_BASE                  0x43000000UL
#define LPI2S_BASE                  0x43001000UL
#define LPPDM_BASE                  0x43002000UL
#define LPCPI_BASE                  0x43003000UL
#define M55HE_CFG_BASE              0x43007000UL
#define LPUART_BASE                 0x43008000UL
#define LPI2C_BASE                  0x43009000UL
#define UTIMER_BASE                 0x48000000UL
#define ETH_BASE                    0x48100000UL
#define SDMMC_BASE                  0x48102000UL
#define SPI0_BASE                   0x48103000UL
#define SPI1_BASE                   0x48104000UL
#define SPI2_BASE                   0x48105000UL
#define SPI3_BASE                   0x48106000UL
#define CRC0_BASE                   0x48107000UL
#define CRC1_BASE                   0x48108000UL
#define USB_BASE                    0x48200000UL
#define GPIO0_BASE                  0x49000000UL
#define GPIO1_BASE                  0x49001000UL
#define GPIO2_BASE                  0x49002000UL
#define GPIO3_BASE                  0x49003000UL
#define GPIO4_BASE                  0x49004000UL
#define GPIO5_BASE                  0x49005000UL
#define GPIO6_BASE                  0x49006000UL
#define GPIO7_BASE                  0x49007000UL
#define GPIO8_BASE                  0x49008000UL
#define GPIO9_BASE                  0x49009000UL
#define GPIO10_BASE                 0x4900A000UL
#define GPIO11_BASE                 0x4900B000UL
#define GPIO12_BASE                 0x4900C000UL
#define GPIO13_BASE                 0x4900D000UL
#define GPIO14_BASE                 0x4900E000UL
#define I2C0_BASE                   0x49010000UL
#define I2C1_BASE                   0x49011000UL
#define I2C2_BASE                   0x49012000UL
#define I2C3_BASE                   0x49013000UL
#define I2S0_BASE                   0x49014000UL
#define I2S1_BASE                   0x49015000UL
#define I2S2_BASE                   0x49016000UL
#define I2S3_BASE                   0x49017000UL
#define UART0_BASE                  0x49018000UL
#define UART1_BASE                  0x49019000UL
#define UART2_BASE                  0x4901A000UL
#define UART3_BASE                  0x4901B000UL
#define UART4_BASE                  0x4901C000UL
#define UART5_BASE                  0x4901D000UL
#define UART6_BASE                  0x4901E000UL
#define UART7_BASE                  0x4901F000UL
#define ADC120_BASE                 0x49020000UL
#define ADC121_BASE                 0x49021000UL
#define ADC122_BASE                 0x49022000UL
#define CMP0_BASE                   0x49023000UL
#define CMP1_BASE                   0x49024000UL
#define CMP2_BASE                   0x49025000UL
#define CMP3_BASE                   0x49026000UL
#define ADC24_BASE                  0x49027000UL
#define DAC120_BASE                 0x49028000UL
#define DAC121_BASE                 0x49029000UL
#define PDM_BASE                    0x4902D000UL
#define HWSEM0_BASE                 0x4902E000UL
#define HWSEM1_BASE                 0x4902E010UL
#define HWSEM2_BASE                 0x4902E020UL
#define HWSEM3_BASE                 0x4902E030UL
#define HWSEM4_BASE                 0x4902E040UL
#define HWSEM5_BASE                 0x4902E050UL
#define HWSEM6_BASE                 0x4902E060UL
#define HWSEM7_BASE                 0x4902E070UL
#define HWSEM8_BASE                 0x4902E080UL
#define HWSEM9_BASE                 0x4902E090UL
#define HWSEM10_BASE                0x4902E0A0UL
#define HWSEM11_BASE                0x4902E0B0UL
#define HWSEM12_BASE                0x4902E0C0UL
#define HWSEM13_BASE                0x4902E0D0UL
#define HWSEM14_BASE                0x4902E0E0UL
#define HWSEM15_BASE                0x4902E0F0UL
#define CLKCTL_PER_SLV_BASE         0x4902F000UL
#define CPI_BASE                    0x49030000UL
#define CDC_BASE                    0x49031000UL
#define DSI_BASE                    0x49032000UL
#define CSI_BASE                    0x49033000UL
#define I3C_BASE                    0x49034000UL
#define EVTRTR0_BASE                0x49035000UL
#define CANFD_BASE                  0x49036000UL
#define INTGEN_0__internal_BASE     0x49038000UL
#define INTGEN_1__internal_BASE     0x49039000UL
#define INTGEN_2__internal_BASE     0x4903A000UL
#define INTGEN_3__internal_BASE     0x4903B000UL
#define INTGEN_4__internal_BASE     0x4903C000UL
#define INTGEN_5__internal_BASE     0x4903D000UL
#define CLKCTL_PER_MST_BASE         0x4903F000UL
#define GPU2D_BASE                  0x49040000UL
#define DMA0_SEC_BASE               0x49080000UL
#define DMA0_NS_BASE                0x490A0000UL
#define OSPI0_BASE                  0x83000000UL
#define AES0_BASE                   0x83001000UL
#define OSPI1_BASE                  0x83002000UL
#define AES1_BASE                   0x83003000UL
#define M55HP_NVIC_S_BASE           0xE000E100UL
#define M55HP_NVIC_NS_BASE          0xE002E100UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/******************************************************************************/
/*                         Global memory map                              */
/******************************************************************************/

/*On chip RAM Regions */
#define SRAM0_BASE                0x02000000
#define SRAM0_SIZE                0x00400000		/* 4M */
#define SRAM1_BASE                0x08000000
#define SRAM1_SIZE                0x00280000		/* 2.5M */
#define SRAM2_BASE                0x50000000
#define SRAM2_SIZE                0x00040000		/* 256K */
#define SRAM3_BASE                0x50800000
#define SRAM3_SIZE                0x00100000		/* 1M */
#define SRAM4_BASE                0x58000000
#define SRAM4_SIZE                0x00040000		/* 256K */
#define SRAM5_BASE                0x58800000
#define SRAM5_SIZE                0x00040000		/* 256K */
#define SRAM6_A_BASE              0x62000000
#define SRAM6_A_SIZE              0x00100000		/* 1M */
#define SRAM6_B_BASE              0x62400000
#define SRAM6_B_SIZE              0x00100000		/* 1M */
#define SRAM7_BASE                0x63000000
#define SRAM7_SIZE                0x00080000		/* 512K */
#define SRAM8_BASE                0x63200000
#define SRAM8_SIZE                0x00200000		/* 2M */
#define SRAM9_A_BASE              0x60000000
#define SRAM9_A_SIZE              0x00040000		/* 256K */
#define SRAM9_B_BASE              0x60040000
#define SRAM9_B_SIZE              0x00080000		/* 512K */

/* Backwards compatibility */
#define SRAM6_BASE                SRAM6_A_BASE
#define SRAM6_SIZE                SRAM6_A_SIZE
#define SRAM9_BASE                SRAM9_A_BASE
#define SRAM9_SIZE                0x000C0000            /* 768K */

/* On Chip NVM */
#define MRAM_BASE                 0x80000000
#define MRAM_SIZE                 0x00580000		/* 5.5M */

/* OSPI XIP regions */
#define OSPI0_XIP_BASE            0xA0000000
#define OSPI0_XIP_SIZE            0x20000000
#define OSPI1_XIP_BASE            0xC0000000
#define OSPI1_XIP_SIZE            0x20000000

#endif /* GLOBAL_MAP_H */
