// XavanteTray.cpp : Defines the entry point for the application.
//

#define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers


// Windows Header Files:
#include <windows.h>

// C RunTime Header Files
#include <stdlib.h>
#include <malloc.h>
#include <memory.h>
#include <tchar.h>
#include <stdio.h>
#include <io.h>
#include <errno.h>
#include <process.h>
#include "resource.h"
#include "SystemTraySDK.h"
extern "C" {
#include "lua.h"
#include "lualib.h"
#include "lauxlib.h"
}

#define MAX_LOADSTRING 100
#define	WM_ICON_NOTIFY WM_APP+10
#define SELECT_TIMEOUT 1

// Global Variables:
HINSTANCE hInst;								// current instance
HANDLE hStopSemaphore;
CSystemTray TrayIcon;
lua_State *L;
int xavante_started;
long exit_thread;
char* xavante_log;
FILE *log;
FILE *aux;

// Foward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

/* code automatically generated by bin2c -- DO NOT EDIT */
static const unsigned char xavante_start[]={
 27, 76,117, 97, 80,  1,  4,  4,  4,  6,  8,  9,  9,  8,182,  9,147,104,231,245,
125, 65, 19,  0,  0,  0, 64,120, 97,118, 97,110,116,101, 95,115,116, 97,114,116,
 46,108,117, 97,  0,  0,  0,  0,  0,  0,  0,  0,  8, 74,  0,  0,  0, 13,  0,  0,
  0, 13,  0,  0,  0, 13,  0,  0,  0, 13,  0,  0,  0, 13,  0,  0,  0, 13,  0,  0,
  0, 13,  0,  0,  0, 13,  0,  0,  0, 13,  0,  0,  0, 14,  0,  0,  0, 14,  0,  0,
  0, 15,  0,  0,  0, 15,  0,  0,  0, 15,  0,  0,  0, 17,  0,  0,  0, 17,  0,  0,
  0, 17,  0,  0,  0, 17,  0,  0,  0, 17,  0,  0,  0, 17,  0,  0,  0, 17,  0,  0,
  0, 18,  0,  0,  0, 18,  0,  0,  0, 21,  0,  0,  0, 21,  0,  0,  0, 21,  0,  0,
  0, 22,  0,  0,  0, 22,  0,  0,  0, 25,  0,  0,  0, 25,  0,  0,  0, 25,  0,  0,
  0, 27,  0,  0,  0, 27,  0,  0,  0, 27,  0,  0,  0, 27,  0,  0,  0, 29,  0,  0,
  0, 29,  0,  0,  0, 30,  0,  0,  0, 30,  0,  0,  0, 30,  0,  0,  0, 30,  0,  0,
  0, 30,  0,  0,  0, 30,  0,  0,  0, 30,  0,  0,  0, 30,  0,  0,  0, 40,  0,  0,
  0, 40,  0,  0,  0, 40,  0,  0,  0, 40,  0,  0,  0, 40,  0,  0,  0, 41,  0,  0,
  0, 41,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,  0, 41,  0,  0,
  0, 41,  0,  0,  0, 41,  0,  0,  0, 42,  0,  0,  0, 42,  0,  0,  0, 43,  0,  0,
  0, 43,  0,  0,  0, 43,  0,  0,  0, 43,  0,  0,  0, 43,  0,  0,  0, 43,  0,  0,
  0, 43,  0,  0,  0, 43,  0,  0,  0, 45,  0,  0,  0, 45,  0,  0,  0, 45,  0,  0,
  0, 45,  0,  0,  0, 45,  0,  0,  0, 47,  0,  0,  0,  4,  0,  0,  0, 10,  0,  0,
  0, 98,111,111,116,115,116,114, 97,112,  0,  9,  0,  0,  0, 73,  0,  0,  0,  4,
  0,  0,  0,101,114,114,  0,  9,  0,  0,  0, 73,  0,  0,  0,  4,  0,  0,  0,114,
101,115,  0, 35,  0,  0,  0, 73,  0,  0,  0,  4,  0,  0,  0,101,114,114,  0, 35,
  0,  0,  0, 73,  0,  0,  0,  0,  0,  0,  0, 21,  0,  0,  0,  4,  9,  0,  0,  0,
108,111, 97,100,102,105,108,101,  0,  4,  3,  0,  0,  0,111,115,  0,  4,  7,  0,
  0,  0,103,101,116,101,110,118,  0,  4, 12,  0,  0,  0, 75, 69, 80, 76, 69, 82,
 95, 73, 78, 73, 84,  0,  4, 26,  0,  0,  0, 99, 58, 92,107,101,112,108,101,114,
 92,107,101,112,108,101,114, 95,105,110,105,116, 46,108,117, 97,  0,  4,  3,  0,
  0,  0,105,111,  0,  4,  7,  0,  0,  0,115,116,100,101,114,114,  0,  4,  6,  0,
  0,  0,119,114,105,116,101,  0,  4,  9,  0,  0,  0,116,111,115,116,114,105,110,
103,  0,  4, 16,  0,  0,  0, 82, 69, 68, 73, 82, 69, 67, 84, 95, 79, 85, 84, 80,
 85, 84,  0,  4, 12,  0,  0,  0, 88, 65, 86, 65, 78, 84, 69, 95, 76, 79, 71,  0,
  4,  6,  0,  0,  0,112, 99, 97,108,108,  0,  4,  8,  0,  0,  0,114,101,113,117,
105,114,101,  0,  4,  8,  0,  0,  0,120, 97,118, 97,110,116,101,  0,  4,  2,  0,
  0,  0, 10,  0,  4,  7,  0,  0,  0,115,116,100,111,117,116,  0,  4, 40,  0,  0,
  0, 91,120, 97,118, 97,110,116,101, 32,108, 97,117,110, 99,104,101,114, 93, 32,
 83,116, 97,114,116,105,110,103, 32, 88, 97,118, 97,110,116,101, 46, 46, 46, 10,
  0,  4,  6,  0,  0,  0,115,116, 97,114,116,  0,  4, 19,  0,  0,  0, 88, 65, 86,
 65, 78, 84, 69, 95, 73, 83, 70, 73, 78, 73, 83, 72, 69, 68,  0,  4, 16,  0,  0,
  0, 88, 65, 86, 65, 78, 84, 69, 95, 84, 73, 77, 69, 79, 85, 84,  0,  4, 36,  0,
  0,  0, 91,120, 97,118, 97,110,116,101, 32,108, 97,117,110, 99,104,101,114, 93,
 32, 88, 97,118, 97,110,116,101, 32,115,116,111,112,112,101,100, 10,  0,  1,  0,
  0,  0,  0,  0,  0,  0, 22,  0,  0,  0,  0,  1,  0,  2,  1,  0,  0,  0, 22,  0,
  0,  0,  1,  0,  0,  0,  2,  0,  0,  0,120,  0,  0,  0,  0,  0,  0,  0,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  0,  0,  0, 27,128,  0,  0,
 74,  0,  0,  0,  5,  0,  0,  0, 69,  0,  0,  1,  6,191,  0,  1,193,  0,  0,  2,
153,  0,  1,  1, 88,128,  0,  1, 20,  0,128,  0,  1,  1,  0,  1,217,  0,  1,  0,
 24,  0,  0,  0,148,  0,128,  0,  0,  0,  0,  2, 89,128,  0,  2, 20,  2,128,  0,
 69,  1,  0,  2,  6, 64,  1,  2, 75, 64,  1,  2,  5,  2,  0,  4,  0,128,  0,  5,
 25,  0,  1,  4, 89,  0,  0,  2,  3,  0,  1,  2, 27,  0,  1,  2, 69,  2,  0,  2,
 88,  0,  1,  2, 84,  0,128,  0, 34,  0,  0,  2, 71,  2,  0,  2, 69,  2,  0,  2,
133,  2,  0,  3, 89,  0,  1,  2,197,  2,  0,  2,  5,  3,  0,  3, 65,  3,  0,  4,
217,128,  1,  2, 88,  0,  1,  2,212,  1,128,  0, 69,  1,  0,  4,  6, 64,  2,  4,
 75, 64,  2,  4,  0,128,  1,  6,129,  3,  0,  7,211,  1,  3,  6, 89,128,  1,  4,
212,  6,128,  0, 69,  1,  0,  4, 70, 66,  2,  4, 75, 64,  2,  4,  1,  4,  0,  6,
 89,128,  1,  4,197,  2,  0,  4, 69,  3,  0,  5,198,194,  2,  5,133,  4,  0,  6,
197,  4,  0,  7,217,  0,  2,  4,  0,128,  2,  3,  0,  0,  2,  2, 88,  0,  1,  2,
212,  1,128,  0, 69,  1,  0,  4,  6, 64,  2,  4, 75, 64,  2,  4,  0,128,  1,  6,
129,  3,  0,  7,211,  1,  3,  6, 89,128,  1,  4, 20,  1,128,  0, 69,  1,  0,  4,
  6, 64,  2,  4, 75, 64,  2,  4,  1,  5,  0,  6, 89,128,  1,  4, 27,128,  0,  0,

};

int Alert(lua_State *L) {
	const char *errmsg;
	errmsg = lua_tostring(L, 1);
	return 1;
}	

int RedirectOutput(lua_State *L) {
	if(xavante_log) free(xavante_log);
	lua_getglobal(L, "XAVANTE_LOG");
	xavante_log = (char*)malloc(lua_strlen(L, -1)+1);
	strcpy(xavante_log, lua_tostring(L, -1));

	log = freopen(xavante_log,"a+", stdout);
	setbuf(stdout, NULL);	
	aux = freopen(xavante_log,"a+", stderr);
	setbuf(stderr, NULL);
	dup2(_fileno(stdout), _fileno(stderr));
	return 0;
}

int CheckExit(lua_State *L) {
	if(InterlockedExchange(&exit_thread, 0))
		lua_pushboolean(L, 1);
	else
		lua_pushboolean(L, 0);
	return 1;
}

void LuaThread(void*) {
	exit_thread = 0;
	size_t size;

	size = sizeof(xavante_start);

	// Initialize Lua
	L = lua_open();
	luaopen_base(L);
	luaopen_table(L);
	luaopen_io(L);
	luaopen_string(L);
	luaopen_math(L);
	luaopen_debug(L);
	luaopen_loadlib(L);

	lua_pushcfunction(L, (lua_CFunction)Alert);
	lua_setglobal(L, "_ALERT");
	
	// Set finish function
	lua_pushcfunction(L, (lua_CFunction)CheckExit);
	lua_setglobal(L, "XAVANTE_ISFINISHED");

	// Set redirect function
	lua_pushcfunction(L, (lua_CFunction)RedirectOutput);
	lua_setglobal(L, "REDIRECT_OUTPUT");

	// Set select timeout
	lua_pushnumber(L, SELECT_TIMEOUT);
	lua_setglobal(L, "XAVANTE_TIMEOUT");

	// Start Xavante
    lua_dobuffer(L,(const char*)xavante_start,size,"=stdin");
	xavante_started = 0;

	lua_close(L);

	if(aux) fclose(aux);
	if(log) fclose(log);

	ReleaseSemaphore(hStopSemaphore, 1, NULL);

	_endthread();
}

void StartXavante() {
	xavante_started = 1;
	hStopSemaphore = CreateSemaphore(NULL, 0, 1, NULL);
	_beginthread(LuaThread, 0, NULL);
}

void StopXavante() {
	InterlockedExchange(&exit_thread, 1);
	WaitForSingleObject(hStopSemaphore, INFINITE);
	CloseHandle(hStopSemaphore);
}

int APIENTRY WinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPSTR     lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	MSG msg;
	HACCEL hAccelTable;
	HANDLE singleton_mutex;

	singleton_mutex = CreateMutex(NULL, TRUE, "XavanteTray");
	xavante_log = NULL;

	if(GetLastError() == ERROR_ALREADY_EXISTS) return 1;

	// Initialize global strings
	MyRegisterClass(hInstance);

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_XAVANTETRAY);

	if(strcmp(lpCmdLine, "--start") == 0) {
		StartXavante();
		TrayIcon.SetIcon(IDI_XAVANTESTART);
		TrayIcon.SetMenuID(IDR_POPUP_CLOSE);
	}

	// Main message loop:
	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return msg.wParam;
}



//
//  FUNCTION: MyRegisterClass()
//
//  PURPOSE: Registers the window class.
//
//  COMMENTS:
//
//    This function and its usage is only necessary if you want this code
//    to be compatible with Win32 systems prior to the 'RegisterClassEx'
//    function that was added to Windows 95. It is important to call this function
//    so that the application will get 'well formed' small icons associated
//    with it.
//
ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;

	wcex.cbSize = sizeof(WNDCLASSEX); 

	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= (HICON) LoadImage(hInstance, 
											(LPCTSTR)IDI_XAVANTETRAY,
											IMAGE_ICON, 
											32, 32,
											LR_DEFAULTCOLOR);
	wcex.hCursor		= LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wcex.lpszMenuName	= NULL;
	wcex.lpszClassName	= _T("XavanteWndClass");
	wcex.hIconSm		= (HICON) LoadImage(hInstance, 
											(LPCTSTR)IDI_XAVANTETRAY,
											IMAGE_ICON, 
											16, 16,
											LR_DEFAULTCOLOR);

	return RegisterClassEx(&wcex);
}

//
//   FUNCTION: InitInstance(HANDLE, int)
//
//   PURPOSE: Saves instance handle and creates main window
//
//   COMMENTS:
//
//        In this function, we save the instance handle in a global variable and
//        create and display the main program window.
//
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; // Store instance handle in our global variable

   hWnd = CreateWindow(_T("XavanteWndClass"), _T("Xavante Launcher"), WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

	// Create the tray icon
	if (!TrayIcon.Create(hInstance,
                         hWnd,                            // Parent window
                         WM_ICON_NOTIFY,                  // Icon notify message to use
                         _T("Xavante Launcher - Right click for options"),  // tooltip
                         (HICON) LoadImage(hInstance, 
											(LPCTSTR)IDI_XAVANTESTOP,
											IMAGE_ICON, 
											16, 16,
											LR_DEFAULTCOLOR),
                         IDR_POPUP_MENU)) 
        return FALSE;

//   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);

   return TRUE;
}

//
//  FUNCTION: WndProc(HWND, unsigned, WORD, LONG)
//
//  PURPOSE:  Processes messages for the main window.
//
//  WM_COMMAND	- process the application menu
//  WM_PAINT	- Paint the main window
//  WM_DESTROY	- post a quit message and return
//
//
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent;

	switch (message) 
	{
        case WM_ICON_NOTIFY:
            return TrayIcon.OnTrayNotification(wParam, lParam);

		case WM_COMMAND:
			wmId    = LOWORD(wParam); 
			wmEvent = HIWORD(wParam); 
			// Parse the menu selections:
			switch (wmId)
			{
				case IDM_CYCLE:
					if(xavante_started) {
						StopXavante();
						TrayIcon.SetIcon(IDI_XAVANTESTOP);
						TrayIcon.SetMenuID(IDR_POPUP_MENU);
					} else {
						StartXavante();
						TrayIcon.SetIcon(IDI_XAVANTESTART);
						TrayIcon.SetMenuID(IDR_POPUP_CLOSE);
					}
					break;
				case IDM_ABOUT:
				   DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
				   break;
				case IDM_SHOWLOG:
				   if(xavante_log) _spawnlp(_P_NOWAIT, "notepad.exe", "notepad.exe", xavante_log, NULL);
				   break;
				case IDM_EXIT:
				   if(xavante_started)
					   StopXavante();
				   DestroyWindow(hWnd);
				   break;
				default:
				   return DefWindowProc(hWnd, message, wParam, lParam);
			}
			break;
		case WM_DESTROY:
			PostQuitMessage(0);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
   }
   return 0;
}

// Mesage handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
		case WM_INITDIALOG:
				return TRUE;

		case WM_COMMAND:
			if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
			{
				EndDialog(hDlg, LOWORD(wParam));
				return TRUE;
			}
			break;
	}
    return FALSE;
}
