#include <cassert>              // for assert
#include <qabstractitemmodel.h>  // for QModelIndex
#include <qapplication.h>        // for QApplication, qApp
#include <qrect.h>               // for QRect
#include <qstring.h>             // for QString, operator+
#include <qstyle.h>              // for QStyle, QStyle::CE_ProgressBar
#include <qthread.h>             // for QThread

#include "queuelistdelegate.h"
#include "queuelistitem.h"       // for QueueListItem

class QPainter;

#define MIN(x,y)	(x) > (y) ? (y) : (x)

void QueueListDelegate::paint(QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index) const
{
	assert(QThread::currentThread() == qApp->thread());
	auto *item = static_cast<QueueListItem*>(index.internalPointer());
	if (item && index.column() == 5 && item->pretended())
	{
		int progress = 0;
		if (item->duration() > 0)
			progress = MIN((item->steps()/item->duration())*100, 100);
		else
			progress = item->steps();

	 	QStyleOptionProgressBar progressBarOption;
	 	progressBarOption.rect = option.rect;
	 	progressBarOption.minimum = 0;
		progressBarOption.state |= QStyle::State_Horizontal;

		if (item->isComplete())
		{
	 		progressBarOption.maximum = 100;
	 		progressBarOption.progress = 100;
	 		progressBarOption.textVisible = true;
		}
		else if (!item->hasStarted())
		{
	 		progressBarOption.maximum = 100;
	 		progressBarOption.progress = 0;
	 		progressBarOption.textVisible = true;
		}
		else
		{
			progressBarOption.maximum = item->duration() > 0 ? 100 : 0;
	 		progressBarOption.progress = progress;
	 		progressBarOption.textVisible = item->duration() > 0;
		}
	 	
		progressBarOption.text = QString::number(progressBarOption.progress) + QStringLiteral(" %");
		
		QApplication::style()->drawControl(QStyle::CE_ProgressBar, &progressBarOption, painter);

	}
	else
		QStyledItemDelegate::paint(painter, option, index);
}
