type token =
  | STRING of (string)
  | IDENT of (string)
  | BOOL of (bool)
  | EOF
  | LBRACKET
  | RBRACKET
  | LPAR
  | RPAR
  | LBRACE
  | RBRACE
  | COLON
  | INT of (int)
  | RELOP of (OpamParserTypes.FullPos.relop_kind)
  | AND
  | OR
  | PFXOP of (OpamParserTypes.FullPos.pfxop_kind)
  | ENVOP of (OpamParserTypes.FullPos.env_update_op_kind)

val main :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> string -> OpamParserTypes.FullPos.opamfile
val value :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf -> OpamParserTypes.FullPos.value
