#!/bin/sh 

# Copyright (C) 2004, 2005 Valery Reznic
# This file is part of the Elf Statifier project
# 
# This project is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License.
# See LICENSE file in the doc directory.

[ $# -ne 2 -o "x$1" = "x" -o "x$2" = "x" ] && {
	echo "Usage: $0 <input_file> <output_file>" 1>&2
	exit 1
}

Input=$1
Output=$2
TmpFile=$Output.S
D=`dirname $0` || exit

#
# File (processed by awk) generated by gdb with 
# combination of command:
# info register reg
# and
# x $reg + offset
#
# 'info register reg' produce output
# register hex-value dec-value
#
# 'x $reg + offset' produce output
# address: value
# or 
# address <symbol_name>: value
#
# Awk's algorithm is following:
# If there is ':' in the string I assume it's a 'x' type line
# and use last field ($NF).
# Othewise I assume it's 'info register' and use second field ($2)
rm -f $TmpFile || exit
awk '
	BEGIN {
		i = 1;
		P[i++] = "SYSCALL_NUM";
		P[i++] = "ENTRY_NUMBER";
		P[i++] = "BASE";
		P[i++] = "LIMIT";
		P[i++] = "FLAGS";
	}
	{
		value = (index($0, ":") == 0) ? $2 : $NF;	
		printf("%s:\t.long %s\n", P[NR], value);
	}
' < $Input > $TmpFile || exit
Data="`awk '{print $3}' < $TmpFile`" || exit
rm -f $Output || exit
$D/strtoul $Data > $Output || exit

# For gcc / strtoul cross-check 
#gcc $TmpFile -o $Output.1 -Wl,--oformat,binary,--entry,0x0 -nostdlib || exit

exit 0
