/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NGlobal
extends NNode {
    static final long serialVersionUID = 5978320165592263568L;
    public List<NName> names;

    public NGlobal(List<NName> names) {
        this(names, 0, 1);
    }

    public NGlobal(List<NName> names, int start, int end) {
        super(start, end);
        this.names = names;
        this.addChildren(names);
    }

    @Override
    public NType resolve(Scope s) throws Exception {
        Scope moduleTable = s.getGlobalTable();
        for (NName name : this.names) {
            if (s.isGlobalName(name.id)) continue;
            s.addGlobalName(name.id);
            NBinding b = moduleTable.lookup(name);
            if (b == null) {
                b = moduleTable.put(name.id, null, new NUnknownType(), NBinding.Kind.SCOPE);
            }
            Indexer.idx.putLocation(name, b);
        }
        return this.getType();
    }

    public String toString() {
        return "<Global:" + this.names + ">";
    }

    @Override
    public void visit(NNodeVisitor v) {
        if (v.visit(this)) {
            this.visitNodeList(this.names, v);
        }
    }
}

